/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBeamFrequency;
import cr0s.warpdrive.block.forcefield.TileEntityForceFieldRelay;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.GlobalPosition;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class ForceFieldRegistry {
    private static final TIntObjectHashMap<CopyOnWriteArraySet<RegistryEntry>> registry = new TIntObjectHashMap(16);
    private static int countAdd = 0;
    private static int countRemove = 0;
    private static int countRead = 0;

    @Nonnull
    public static Set<TileEntity> getTileEntities(int beamFrequency, @Nullable WorldServer world, @Nonnull BlockPos blockPos) {
        int range2;
        if (WarpDriveConfig.LOGGING_FORCE_FIELD_REGISTRY && ++countRead % 1000 == 0) {
            WarpDrive.logger.info(String.format("ForceFieldRegistry stats: read %d add %d remove %d => %.1f", countRead, countAdd, countRemove, Float.valueOf((float)countRead / (float)(countRemove + countRead + countAdd))));
        }
        if (world == null) {
            WarpDrive.logger.warn(String.format("ForceFieldRegistry:getTileEntities called with no world for beam frequency %d %s", beamFrequency, Commons.format(null, blockPos)));
            return new CopyOnWriteArraySet<TileEntity>();
        }
        CopyOnWriteArraySet setRegistryEntries = (CopyOnWriteArraySet)registry.get(beamFrequency);
        if (setRegistryEntries == null) {
            return new CopyOnWriteArraySet<TileEntity>();
        }
        int maxRange2 = 400;
        HashSet<RegistryEntry> setRegistryEntryNonRelays = new HashSet<RegistryEntry>();
        HashSet<RegistryEntry> setRegistryEntryRelays = new HashSet<RegistryEntry>();
        HashSet<RegistryEntry> setRegistryEntryToIterate = new HashSet<RegistryEntry>();
        for (RegistryEntry registryEntry : setRegistryEntries) {
            if (registryEntry.globalPosition.dimensionId != world.field_73011_w.getDimension()) continue;
            if (registryEntry.isRelay) {
                range2 = (registryEntry.globalPosition.x - blockPos.func_177958_n()) * (registryEntry.globalPosition.x - blockPos.func_177958_n()) + (registryEntry.globalPosition.y - blockPos.func_177956_o()) * (registryEntry.globalPosition.y - blockPos.func_177956_o()) + (registryEntry.globalPosition.z - blockPos.func_177952_p()) * (registryEntry.globalPosition.z - blockPos.func_177952_p());
                if (range2 <= 400) {
                    setRegistryEntryToIterate.add(registryEntry);
                    continue;
                }
                setRegistryEntryRelays.add(registryEntry);
                continue;
            }
            setRegistryEntryNonRelays.add(registryEntry);
        }
        if (setRegistryEntryToIterate.isEmpty()) {
            HashSet<TileEntity> setResult = new HashSet<TileEntity>(1);
            setResult.add(world.func_175625_s(blockPos));
            return setResult;
        }
        HashSet<RegistryEntry> setRegistryEntryRelaysInRange = new HashSet<RegistryEntry>();
        HashSet<TileEntity> setTileEntityRelaysInRange = new HashSet<TileEntity>();
        while (!setRegistryEntryToIterate.isEmpty()) {
            HashSet<RegistryEntry> setRegistryEntryToIterateNext = new HashSet<RegistryEntry>();
            for (RegistryEntry registryEntryCurrent : setRegistryEntryToIterate) {
                TileEntity tileEntityCurrent = world.func_175625_s(registryEntryCurrent.globalPosition.getBlockPos());
                if (!(tileEntityCurrent instanceof IBeamFrequency) || ((IBeamFrequency)tileEntityCurrent).getBeamFrequency() != beamFrequency || !(tileEntityCurrent instanceof TileEntityForceFieldRelay)) {
                    WarpDrive.logger.info(String.format("Removing invalid ForceFieldRegistry relay entry for beam frequency %d %s: %s", beamFrequency, Commons.format((World)world, registryEntryCurrent.globalPosition.getBlockPos()), tileEntityCurrent));
                    ++countRemove;
                    setRegistryEntries.remove(registryEntryCurrent);
                    if (!WarpDriveConfig.LOGGING_FORCE_FIELD_REGISTRY) continue;
                    ForceFieldRegistry.printRegistry("removed");
                    continue;
                }
                setRegistryEntryRelaysInRange.add(registryEntryCurrent);
                setTileEntityRelaysInRange.add(tileEntityCurrent);
                for (RegistryEntry registryEntryRelay : setRegistryEntryRelays) {
                    if (setRegistryEntryRelaysInRange.contains(registryEntryRelay) || setRegistryEntryToIterate.contains(registryEntryRelay) || setRegistryEntryToIterateNext.contains(registryEntryRelay) || (range2 = (tileEntityCurrent.func_174877_v().func_177958_n() - registryEntryRelay.globalPosition.x) * (tileEntityCurrent.func_174877_v().func_177958_n() - registryEntryRelay.globalPosition.x) + (tileEntityCurrent.func_174877_v().func_177956_o() - registryEntryRelay.globalPosition.y) * (tileEntityCurrent.func_174877_v().func_177956_o() - registryEntryRelay.globalPosition.y) + (tileEntityCurrent.func_174877_v().func_177952_p() - registryEntryRelay.globalPosition.z) * (tileEntityCurrent.func_174877_v().func_177952_p() - registryEntryRelay.globalPosition.z)) > 400) continue;
                    setRegistryEntryToIterateNext.add(registryEntryRelay);
                }
            }
            setRegistryEntryToIterate = setRegistryEntryToIterateNext;
        }
        HashSet<RegistryEntry> setRegistryEntryResults = new HashSet<RegistryEntry>(setTileEntityRelaysInRange.size() + 5);
        HashSet<TileEntity> setTileEntityResults = new HashSet<TileEntity>(setTileEntityRelaysInRange.size() + 5);
        for (TileEntity tileEntityRelayInRange : setTileEntityRelaysInRange) {
            for (RegistryEntry registryEntryNonRelay : setRegistryEntryNonRelays) {
                if (setRegistryEntryResults.contains(registryEntryNonRelay) || (range2 = (tileEntityRelayInRange.func_174877_v().func_177958_n() - registryEntryNonRelay.globalPosition.x) * (tileEntityRelayInRange.func_174877_v().func_177958_n() - registryEntryNonRelay.globalPosition.x) + (tileEntityRelayInRange.func_174877_v().func_177956_o() - registryEntryNonRelay.globalPosition.y) * (tileEntityRelayInRange.func_174877_v().func_177956_o() - registryEntryNonRelay.globalPosition.y) + (tileEntityRelayInRange.func_174877_v().func_177952_p() - registryEntryNonRelay.globalPosition.z) * (tileEntityRelayInRange.func_174877_v().func_177952_p() - registryEntryNonRelay.globalPosition.z)) > 400) continue;
                TileEntity tileEntity = world.func_175625_s(registryEntryNonRelay.globalPosition.getBlockPos());
                if (tileEntity instanceof IBeamFrequency && ((IBeamFrequency)tileEntity).getBeamFrequency() == beamFrequency) {
                    setRegistryEntryResults.add(registryEntryNonRelay);
                    setTileEntityResults.add(tileEntity);
                    continue;
                }
                WarpDrive.logger.info(String.format("Removing invalid ForceFieldRegistry non-relay entry for beam frequency %d %s: %s", beamFrequency, Commons.format((World)world, registryEntryNonRelay.globalPosition.getBlockPos()), tileEntity));
                ++countRemove;
                setRegistryEntries.remove(registryEntryNonRelay);
                if (!WarpDriveConfig.LOGGING_FORCE_FIELD_REGISTRY) continue;
                ForceFieldRegistry.printRegistry("removed");
            }
        }
        setTileEntityResults.addAll(setTileEntityRelaysInRange);
        return setTileEntityResults;
    }

    public static void updateInRegistry(@Nonnull IBeamFrequency tileEntity) {
        assert (tileEntity instanceof TileEntity);
        ++countRead;
        CopyOnWriteArraySet<RegistryEntry> setRegistryEntries = (CopyOnWriteArraySet<RegistryEntry>)registry.get(tileEntity.getBeamFrequency());
        if (setRegistryEntries == null) {
            setRegistryEntries = new CopyOnWriteArraySet<RegistryEntry>();
        }
        for (RegistryEntry registryEntry : setRegistryEntries) {
            if (!registryEntry.equals(tileEntity)) continue;
            return;
        }
        ++countAdd;
        setRegistryEntries.add(new RegistryEntry((TileEntity)tileEntity));
        registry.put(tileEntity.getBeamFrequency(), setRegistryEntries);
        if (WarpDriveConfig.LOGGING_FORCE_FIELD_REGISTRY) {
            ForceFieldRegistry.printRegistry("added");
        }
    }

    public static void removeFromRegistry(@Nonnull IBeamFrequency tileEntity) {
        assert (tileEntity instanceof TileEntity);
        ++countRead;
        CopyOnWriteArraySet setRegistryEntries = (CopyOnWriteArraySet)registry.get(tileEntity.getBeamFrequency());
        if (setRegistryEntries == null) {
            return;
        }
        for (RegistryEntry registryEntry : setRegistryEntries) {
            if (!registryEntry.equals(tileEntity)) continue;
            ++countRemove;
            setRegistryEntries.remove(registryEntry);
            return;
        }
    }

    public static void printRegistry(String trigger) {
        WarpDrive.logger.info(String.format("Force field registry (%d entries after %s):", registry.size(), trigger));
        registry.forEachEntry((beamFrequency, relayOrProjectors) -> {
            StringBuilder message = new StringBuilder();
            for (RegistryEntry registryEntry : relayOrProjectors) {
                if (message.length() > 0) {
                    message.append(", ");
                }
                message.append(Commons.format(registryEntry.globalPosition));
            }
            WarpDrive.logger.info(String.format("- %d entries at beam frequency %d : %s", relayOrProjectors.size(), beamFrequency, message));
            return true;
        });
    }

    private static final class RegistryEntry {
        public final GlobalPosition globalPosition;
        public final boolean isRelay;

        RegistryEntry(@Nonnull GlobalPosition globalPosition, boolean isRelay) {
            this.globalPosition = globalPosition;
            this.isRelay = isRelay;
        }

        RegistryEntry(@Nonnull TileEntity tileEntity) {
            this(new GlobalPosition(tileEntity), tileEntity instanceof TileEntityForceFieldRelay);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (object instanceof TileEntity) {
                TileEntity tileEntity = (TileEntity)object;
                return this.globalPosition.equals(tileEntity) && this.isRelay == tileEntity instanceof TileEntityForceFieldRelay;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            RegistryEntry that = (RegistryEntry)object;
            return this.isRelay == that.isRelay && this.globalPosition.equals(that.globalPosition);
        }

        public int hashCode() {
            return this.globalPosition.hashCode();
        }
    }
}

