/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IForceFieldShape;
import cr0s.warpdrive.api.IForceFieldUpgrade;
import cr0s.warpdrive.api.IForceFieldUpgradeEffector;
import cr0s.warpdrive.block.TileEntityAbstractBase;
import cr0s.warpdrive.block.forcefield.TileEntityForceFieldProjector;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnumForceFieldUpgrade;
import cr0s.warpdrive.data.EnumPermissionNode;
import cr0s.warpdrive.data.EnumTier;
import cr0s.warpdrive.data.ForceFieldRegistry;
import cr0s.warpdrive.data.GlobalPosition;
import cr0s.warpdrive.data.InventoryWrapper;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.data.VectorI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ForceFieldSetup
extends GlobalPosition {
    private static final float FORCEFIELD_BASE_SCAN_SPEED_BLOCKS_PER_SECOND = 100.0f;
    private static final float FORCEFIELD_BASE_PLACE_SPEED_BLOCKS_PER_SECOND = 20.0f;
    private static final float FORCEFIELD_MAX_SCAN_SPEED_BLOCKS_PER_SECOND = 10000.0f;
    private static final float FORCEFIELD_MAX_PLACE_SPEED_BLOCKS_PER_SECOND = 4000.0f;
    private static final float FORCEFIELD_UPGRADE_BOOST_FACTOR_PER_PROJECTOR_TIER = 0.5f;
    public static final float FORCEFIELD_UPGRADE_BOOST_FACTOR_PER_RELAY_TIER = 0.25f;
    public static final double FORCEFIELD_ACCELERATION_FACTOR = 0.16;
    public static final int FORCEFIELD_RELAY_RANGE = 20;
    private static final int FORCEFIELD_MAX_FACTOR_ENTITY_COST = 5;
    private static final double FORCEFIELD_TAU_FACTOR_ENTITY_COST = -Math.log(5.0);
    public final int beamFrequency;
    public final EnumTier enumTier;
    public final Set<TileEntityForceFieldProjector> projectors = new HashSet<TileEntityForceFieldProjector>();
    private IBlockState blockStateCamouflage;
    private int colorMultiplierCamouflage;
    private int lightCamouflage;
    private final HashMap<IForceFieldUpgradeEffector, Float> upgrades = new HashMap(EnumForceFieldUpgrade.length);
    public final Collection<Object> inventories = new ArrayList<Object>(12);
    public float scanSpeed;
    public float placeSpeed;
    public double startupEnergyCost;
    public double scanEnergyCost;
    public double placeEnergyCost;
    private double entityEnergyCost;
    public float breaking_maxHardness;
    public float temperatureLevel;
    public float accelerationLevel;
    public boolean hasCollection;
    public boolean hasFusion;
    public boolean isInverted;
    public boolean hasStabilize;
    public float thickness;
    public float pumping_maxViscosity;
    public float rotationYaw;
    public float rotationPitch;
    public float rotationRoll;
    public VectorI vTranslation = new VectorI(0, 0, 0);
    public final VectorI vMin = new VectorI(-8, -8, -8);
    public final VectorI vMax = new VectorI(8, 8, 8);
    public IForceFieldShape shapeProvider;
    public boolean isDoubleSided = true;

    public ForceFieldSetup(int dimensionId, BlockPos blockPos, EnumTier enumTier, int beamFrequency) {
        super(dimensionId, blockPos);
        this.enumTier = enumTier;
        this.beamFrequency = beamFrequency;
        this.refresh();
        if (WarpDriveConfig.LOGGING_FORCE_FIELD) {
            WarpDrive.logger.info(String.format("Force field projector energy costs: startup %.3f / %d scan %.3f place %.3f entity %.3f speeds: scan %.3f place %.3f sustain cost: scan %.3f place %.3f", this.startupEnergyCost, Math.round(this.startupEnergyCost + this.placeEnergyCost * (double)this.placeSpeed * 8.0 / 20.0), this.scanEnergyCost, this.placeEnergyCost, this.entityEnergyCost, Float.valueOf(this.scanSpeed), Float.valueOf(this.placeSpeed), this.scanEnergyCost * (double)this.scanSpeed, this.placeEnergyCost * (double)this.placeSpeed));
        }
    }

    public boolean isAccessGranted(EntityPlayer entityPlayer, EnumPermissionNode enumPermissionNode) {
        return false;
    }

    @Nullable
    public IBlockState getCamouflageBlockState() {
        if (Commons.isValidCamouflage(this.blockStateCamouflage)) {
            return this.blockStateCamouflage;
        }
        return null;
    }

    public int getCamouflageColorMultiplier() {
        if (Commons.isValidCamouflage(this.blockStateCamouflage)) {
            return this.colorMultiplierCamouflage;
        }
        return 0;
    }

    public int getCamouflageLight() {
        if (Commons.isValidCamouflage(this.blockStateCamouflage)) {
            return this.lightCamouflage;
        }
        return 0;
    }

    private float getScaledUpgrade(IForceFieldUpgradeEffector effector) {
        Float scaledValue = this.upgrades.get(effector);
        return scaledValue == null ? 0.0f : scaledValue.floatValue();
    }

    private void refresh() {
        Set<TileEntity> tileEntities = ForceFieldRegistry.getTileEntities(this.beamFrequency, this.getWorldServerIfLoaded(), this.getBlockPos());
        HashMap<IForceFieldUpgradeEffector, Float> upgradeValues = new HashMap<IForceFieldUpgradeEffector, Float>(EnumForceFieldUpgrade.length);
        Vector3 v3Min = new Vector3(-1.0, -1.0, -1.0);
        Vector3 v3Max = new Vector3(1.0, 1.0, 1.0);
        Vector3 v3Translation = new Vector3(0.0, 0.0, 0.0);
        for (TileEntity tileEntity : tileEntities) {
            IForceFieldUpgradeEffector iForceFieldUpgradeEffector;
            if (tileEntity == null) {
                WarpDrive.logger.error(String.format("Invalid tile entity returned from ForgeFieldRegistry at %s", this));
                continue;
            }
            if (!tileEntity.func_145830_o() || tileEntity.func_145831_w().field_73011_w.getDimension() != this.dimensionId) continue;
            if (tileEntity instanceof TileEntityAbstractBase) {
                ((TileEntityAbstractBase)tileEntity).finishConstruction();
            }
            if (tileEntity instanceof TileEntityForceFieldProjector) {
                TileEntityForceFieldProjector tileEntityForceFieldProjector = (TileEntityForceFieldProjector)tileEntity;
                if (tileEntity.func_174877_v().func_177958_n() == this.x && tileEntity.func_174877_v().func_177956_o() == this.y && tileEntity.func_174877_v().func_177952_p() == this.z) {
                    this.shapeProvider = tileEntityForceFieldProjector.getShapeProvider();
                    this.isDoubleSided = tileEntityForceFieldProjector.isDoubleSided;
                    this.vTranslation = new VectorI(tileEntityForceFieldProjector);
                    this.rotationYaw = tileEntityForceFieldProjector.getRotationYaw();
                    this.rotationPitch = tileEntityForceFieldProjector.getRotationPitch();
                    this.rotationRoll = tileEntityForceFieldProjector.getRotationRoll();
                    v3Min = tileEntityForceFieldProjector.getMin();
                    v3Max = tileEntityForceFieldProjector.getMax();
                    v3Translation = tileEntityForceFieldProjector.getTranslation();
                    for (Map.Entry<TileEntityAbstractBase.UpgradeSlot, Integer> entry : tileEntityForceFieldProjector.getUpgradesOfType(null).entrySet()) {
                        IForceFieldUpgrade forceFieldUpgrade;
                        IForceFieldUpgradeEffector upgradeEffector2;
                        if (!(entry.getKey().itemStack.func_77973_b() instanceof IForceFieldUpgrade) || (upgradeEffector2 = (forceFieldUpgrade = (IForceFieldUpgrade)entry.getKey().itemStack.func_77973_b()).getUpgradeEffector(entry.getKey().itemStack)) == null) continue;
                        Float currentValue = (Float)upgradeValues.get(upgradeEffector2);
                        if (currentValue == null) {
                            currentValue = Float.valueOf(0.0f);
                        }
                        float addedValue = forceFieldUpgrade.getUpgradeValue(entry.getKey().itemStack) * (float)entry.getValue().intValue();
                        upgradeValues.put(upgradeEffector2, Float.valueOf(currentValue.floatValue() + (addedValue *= 1.0f + (float)(this.enumTier.getIndex() - 1) * 0.5f)));
                    }
                } else if (((TileEntityForceFieldProjector)tileEntity).getIsEnabled() && ((TileEntityForceFieldProjector)tileEntity).isCalculated() && ((TileEntityForceFieldProjector)tileEntity).isAssemblyValid()) {
                    this.projectors.add((TileEntityForceFieldProjector)tileEntity);
                }
            }
            if (!(tileEntity instanceof IForceFieldUpgrade) || (iForceFieldUpgradeEffector = ((IForceFieldUpgrade)tileEntity).getUpgradeEffector(tileEntity)) == null) continue;
            Float currentValue = (Float)upgradeValues.get(iForceFieldUpgradeEffector);
            if (currentValue == null) {
                currentValue = Float.valueOf(0.0f);
            }
            upgradeValues.put(iForceFieldUpgradeEffector, Float.valueOf(currentValue.floatValue() + ((IForceFieldUpgrade)tileEntity).getUpgradeValue(tileEntity)));
            if (iForceFieldUpgradeEffector == EnumForceFieldUpgrade.CAMOUFLAGE) {
                BlockPos blockPosCamouflage = tileEntity.func_174877_v().func_177972_a(EnumFacing.UP);
                IBlockState blockStateCandidate = tileEntity.func_145831_w().func_180495_p(blockPosCamouflage);
                if (Commons.isValidCamouflage(blockStateCandidate)) {
                    this.blockStateCamouflage = blockStateCandidate;
                    this.colorMultiplierCamouflage = 0x808080;
                    this.lightCamouflage = blockStateCandidate.getLightValue((IBlockAccess)tileEntity.func_145831_w(), blockPosCamouflage);
                }
            }
            if (iForceFieldUpgradeEffector != EnumForceFieldUpgrade.ITEM_PORT) continue;
            this.inventories.addAll(InventoryWrapper.getConnectedInventories(tileEntity.func_145831_w(), tileEntity.func_174877_v()));
        }
        if (this.shapeProvider == null) {
            WarpDrive.logger.error(String.format("ForceFieldSetup without a projector or null shape returned @ (%d %d %d), while #%d has %d registered tile entities", this.x, this.y, this.z, this.beamFrequency, tileEntities.size()));
        }
        this.scanSpeed = 100.0f * (this.isDoubleSided ? 2.1f : 1.0f);
        this.placeSpeed = 20.0f * (this.isDoubleSided ? 2.1f : 1.0f);
        this.startupEnergyCost = 60.0f + 20.0f * (float)(this.enumTier.getIndex() - 1);
        this.scanEnergyCost = 0.4f + 0.4f * (float)(this.enumTier.getIndex() - 1);
        this.placeEnergyCost = 3.0f + 3.0f * (float)(this.enumTier.getIndex() - 1);
        this.entityEnergyCost = 2.0;
        if (this.isDoubleSided) {
            this.scanSpeed *= 2.1f;
            this.placeSpeed *= 2.1f;
            this.startupEnergyCost += (double)(20.0f * (float)(this.enumTier.getIndex() - 1));
            this.scanEnergyCost *= (double)0.45f;
            this.placeEnergyCost *= (double)0.45f;
            this.entityEnergyCost *= (double)0.45f;
        }
        for (Map.Entry entry : upgradeValues.entrySet()) {
            float scaledValue = ((IForceFieldUpgradeEffector)entry.getKey()).getScaledValue(1.0f, ((Float)entry.getValue()).floatValue());
            if (scaledValue == 0.0f) continue;
            this.upgrades.put((IForceFieldUpgradeEffector)entry.getKey(), Float.valueOf(scaledValue));
            float speedRatio = ((IForceFieldUpgradeEffector)entry.getKey()).getScanSpeedFactor(scaledValue);
            if (speedRatio > 0.0f) {
                this.scanSpeed *= speedRatio;
            }
            if ((speedRatio = ((IForceFieldUpgradeEffector)entry.getKey()).getPlaceSpeedFactor(scaledValue)) > 0.0f) {
                this.placeSpeed *= speedRatio;
            }
            this.startupEnergyCost += (double)((IForceFieldUpgradeEffector)entry.getKey()).getStartupEnergyCost(scaledValue);
            this.scanEnergyCost += (double)((IForceFieldUpgradeEffector)entry.getKey()).getScanEnergyCost(scaledValue);
            this.placeEnergyCost += (double)((IForceFieldUpgradeEffector)entry.getKey()).getPlaceEnergyCost(scaledValue);
            this.entityEnergyCost += (double)((IForceFieldUpgradeEffector)entry.getKey()).getEntityEffectEnergyCost(scaledValue);
        }
        this.scanSpeed = Math.min(10000.0f, this.scanSpeed);
        this.placeSpeed = Math.min(4000.0f, this.placeSpeed);
        this.accelerationLevel = this.getScaledUpgrade(EnumForceFieldUpgrade.ATTRACTION) - this.getScaledUpgrade(EnumForceFieldUpgrade.REPULSION);
        this.hasCollection = this.getScaledUpgrade(EnumForceFieldUpgrade.ITEM_PORT) > 0.0f && this.accelerationLevel > 1.0f;
        this.hasFusion = this.getScaledUpgrade(EnumForceFieldUpgrade.FUSION) > 0.0f;
        this.isInverted = this.getScaledUpgrade(EnumForceFieldUpgrade.INVERSION) > 0.0f;
        this.hasStabilize = this.getScaledUpgrade(EnumForceFieldUpgrade.STABILIZATION) > 0.0f && this.accelerationLevel < 1.0f;
        this.temperatureLevel = Math.max(0.1f, 300.0f + this.getScaledUpgrade(EnumForceFieldUpgrade.HEATING) - this.getScaledUpgrade(EnumForceFieldUpgrade.COOLING));
        this.breaking_maxHardness = this.getScaledUpgrade(EnumForceFieldUpgrade.BREAKING);
        this.pumping_maxViscosity = this.getScaledUpgrade(EnumForceFieldUpgrade.PUMPING);
        this.thickness = 1.0f + this.getScaledUpgrade(EnumForceFieldUpgrade.THICKNESS);
        double d = this.getScaledUpgrade(EnumForceFieldUpgrade.RANGE);
        if (d == 0.0) {
            d = 8.0;
            v3Min = new Vector3(-1.0, -1.0, -1.0);
            v3Max = new Vector3(1.0, 1.0, 1.0);
        }
        if (this.hasFusion || this.isInverted) {
            d = Math.min(64.0, d);
        }
        this.vMin.x = (int)Math.round(Math.min(0.0, Math.max(-1.0, v3Min.x)) * d);
        this.vMin.y = (int)Math.round(Math.min(0.0, Math.max(-1.0, v3Min.y)) * d);
        this.vMin.z = (int)Math.round(Math.min(0.0, Math.max(-1.0, v3Min.z)) * d);
        this.vMax.x = (int)Math.round(Math.min(1.0, Math.max(0.0, v3Max.x)) * d);
        this.vMax.y = (int)Math.round(Math.min(1.0, Math.max(0.0, v3Max.y)) * d);
        this.vMax.z = (int)Math.round(Math.min(1.0, Math.max(0.0, v3Max.z)) * d);
        this.vTranslation.x += (int)Math.round(Math.min(1.0, Math.max(-1.0, v3Translation.x)) * d);
        this.vTranslation.y += (int)Math.round(Math.min(1.0, Math.max(-1.0, v3Translation.y)) * d);
        this.vTranslation.z += (int)Math.round(Math.min(1.0, Math.max(-1.0, v3Translation.z)) * d);
    }

    public double getEntityEnergyCost(int countEntityInteractions) {
        return this.entityEnergyCost * 5.0 * Math.exp(FORCEFIELD_TAU_FACTOR_ENTITY_COST / (double)countEntityInteractions);
    }

    public int onEntityEffect(World world, BlockPos blockPos, Entity entity) {
        int countdown = 0;
        TileEntity tileEntity = world.func_175625_s(this.getBlockPos());
        if (tileEntity instanceof TileEntityForceFieldProjector && ((TileEntityForceFieldProjector)tileEntity).onEntityInteracted(entity.func_110124_au())) {
            for (Map.Entry<IForceFieldUpgradeEffector, Float> entry : this.upgrades.entrySet()) {
                Float value = entry.getValue();
                if (entry.getKey() == EnumForceFieldUpgrade.COOLING || entry.getKey() == EnumForceFieldUpgrade.HEATING) {
                    value = Float.valueOf(this.temperatureLevel);
                } else if (entry.getKey() == EnumForceFieldUpgrade.ATTRACTION || entry.getKey() == EnumForceFieldUpgrade.REPULSION) {
                    value = Float.valueOf(this.accelerationLevel);
                }
                countdown += entry.getKey().onEntityEffect(value.floatValue(), world, this.x, this.y, this.z, blockPos, entity);
            }
        }
        return countdown;
    }

    public double applyDamage(World world, DamageSource damageSource, double damageLevel) {
        assert (damageSource != null);
        TileEntity tileEntity = world.func_175625_s(this.getBlockPos());
        if (tileEntity instanceof TileEntityForceFieldProjector) {
            double scaledDamage;
            if (damageSource.field_76373_n.contains("explosion")) {
                scaledDamage = damageLevel / WarpDriveConfig.FORCE_FIELD_PROJECTOR_EXPLOSION_SCALE + this.entityEnergyCost * 0.1;
            } else if (damageSource.field_76373_n.contains("laser")) {
                double scaleLaserEnergyPerFullProjector = WarpDriveConfig.FORCE_FIELD_PROJECTOR_MAX_LASER_REQUIRED * (double)(WarpDriveConfig.LASER_CANNON_MAX_LASER_ENERGY - WarpDriveConfig.LASER_CANNON_BLOCK_HIT_ENERGY_MAX) / (double)WarpDriveConfig.FORCE_FIELD_PROJECTOR_MAX_ENERGY_STORED_BY_TIER[EnumTier.SUPERIOR.getIndex()];
                scaledDamage = damageLevel / scaleLaserEnergyPerFullProjector + this.entityEnergyCost * 5.0;
            } else {
                WarpDrive.logger.warn(String.format("%s Unknown damage source %s '%s' %.1f", this, damageSource, damageSource.func_76355_l(), damageLevel));
                scaledDamage = Commons.clamp(0.0, 10000.0, damageLevel);
            }
            ((TileEntityForceFieldProjector)tileEntity).onEnergyDamage(scaledDamage);
            return 0.0;
        }
        return damageLevel;
    }

    @Override
    public String toString() {
        return String.format("%s @ DIM%d (%d %d %d) (%d %d %d) -> (%d %d %d)", this.getClass().getSimpleName(), this.dimensionId, this.x, this.y, this.z, this.vMin.x, this.vMin.y, this.vMin.z, this.vMax.x, this.vMax.y, this.vMax.z);
    }
}

