/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.data.CelestialObject;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.data.GlobalRegionManager;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.data.VectorI;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.DimensionManager;

public class GlobalPosition {
    public final int dimensionId;
    public final int x;
    public final int y;
    public final int z;
    private BlockPos cache_blockPos;

    public GlobalPosition(int dimensionId, int x, int y, int z) {
        this.dimensionId = dimensionId;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public GlobalPosition(int dimensionId, @Nonnull BlockPos blockPos) {
        this.dimensionId = dimensionId;
        this.x = blockPos.func_177958_n();
        this.y = blockPos.func_177956_o();
        this.z = blockPos.func_177952_p();
    }

    public GlobalPosition(@Nonnull TileEntity tileEntity) {
        this(tileEntity.func_145831_w().field_73011_w.getDimension(), tileEntity.func_174877_v().func_177958_n(), tileEntity.func_174877_v().func_177956_o(), tileEntity.func_174877_v().func_177952_p());
    }

    public GlobalPosition(@Nonnull Entity entity) {
        this(entity.field_70170_p.field_73011_w.getDimension(), (int)Math.floor(entity.field_70165_t), (int)Math.floor(entity.field_70163_u), (int)Math.floor(entity.field_70161_v));
    }

    public WorldServer getWorldServerIfLoaded() {
        WorldServer world = DimensionManager.getWorld((int)this.dimensionId);
        if (world == null) {
            return null;
        }
        boolean isLoaded = false;
        ChunkProviderServer chunkProviderServer = world.func_72863_F();
        try {
            long i = ChunkPos.func_77272_a((int)(this.x >> 4), (int)(this.z >> 4));
            Chunk chunk = (Chunk)chunkProviderServer.field_73244_f.get(i);
            if (chunk != null) {
                isLoaded = !chunk.field_189550_d;
            }
        }
        catch (NoSuchFieldError exception) {
            isLoaded = chunkProviderServer.func_73149_a(this.x >> 4, this.z >> 4);
        }
        if (!isLoaded) {
            return null;
        }
        return world;
    }

    public boolean isLoaded() {
        return this.getWorldServerIfLoaded() != null;
    }

    public CelestialObject getCelestialObject(boolean isRemote) {
        return CelestialObjectManager.get(isRemote, this.dimensionId, this.x, this.z);
    }

    public Vector3 getUniversalCoordinates(boolean isRemote) {
        CelestialObject celestialObject = CelestialObjectManager.get(isRemote, this.dimensionId, this.x, this.z);
        return GlobalRegionManager.getUniversalCoordinates(celestialObject, this.x, this.y, this.z);
    }

    public BlockPos getBlockPos() {
        if (this.cache_blockPos == null || this.cache_blockPos.func_177958_n() != this.x || this.cache_blockPos.func_177956_o() != this.y || this.cache_blockPos.func_177952_p() != this.z) {
            this.cache_blockPos = new BlockPos(this.x, this.y, this.z);
        }
        return this.cache_blockPos;
    }

    public int distance2To(@Nonnull TileEntity tileEntity) {
        if (tileEntity.func_145831_w().field_73011_w.getDimension() != this.dimensionId) {
            return Integer.MAX_VALUE;
        }
        int newX = tileEntity.func_174877_v().func_177958_n() - this.x;
        int newY = tileEntity.func_174877_v().func_177956_o() - this.y;
        int newZ = tileEntity.func_174877_v().func_177952_p() - this.z;
        return newX * newX + newY * newY + newZ * newZ;
    }

    public double distance2To(@Nonnull Entity entity) {
        if (entity.field_70170_p.field_73011_w.getDimension() != this.dimensionId) {
            return Double.MAX_VALUE;
        }
        double newX = entity.field_70165_t - (double)this.x;
        double newY = entity.field_70163_u - (double)this.y;
        double newZ = entity.field_70161_v - (double)this.z;
        return newX * newX + newY * newY + newZ * newZ;
    }

    public GlobalPosition(@Nonnull NBTTagCompound tagCompound) {
        this.dimensionId = tagCompound.func_74762_e("dimensionId");
        this.x = tagCompound.func_74762_e("x");
        this.y = tagCompound.func_74762_e("y");
        this.z = tagCompound.func_74762_e("z");
    }

    public void writeToNBT(@Nonnull NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("dimensionId", this.dimensionId);
        tagCompound.func_74768_a("x", this.x);
        tagCompound.func_74768_a("y", this.y);
        tagCompound.func_74768_a("z", this.z);
    }

    public boolean equals(@Nonnull TileEntity tileEntity) {
        return this.dimensionId == tileEntity.func_145831_w().field_73011_w.getDimension() && this.x == tileEntity.func_174877_v().func_177958_n() && this.y == tileEntity.func_174877_v().func_177956_o() && this.z == tileEntity.func_174877_v().func_177952_p();
    }

    public boolean equals(Object object) {
        if (object instanceof GlobalPosition) {
            GlobalPosition globalPosition = (GlobalPosition)object;
            return this.dimensionId == globalPosition.dimensionId && this.x == globalPosition.x && this.y == globalPosition.y && this.z == globalPosition.z;
        }
        if (object instanceof VectorI) {
            VectorI vector = (VectorI)object;
            return this.x == vector.x && this.y == vector.y && this.z == vector.z;
        }
        if (object instanceof TileEntity) {
            TileEntity tileEntity = (TileEntity)object;
            return this.dimensionId == tileEntity.func_145831_w().field_73011_w.getDimension() && this.x == tileEntity.func_174877_v().func_177958_n() && this.y == tileEntity.func_174877_v().func_177956_o() && this.z == tileEntity.func_174877_v().func_177952_p();
        }
        return false;
    }

    public int hashCode() {
        return this.dimensionId << 24 + (this.x >> 10) << 12 + this.y << 10 + (this.z >> 10);
    }

    public String toString() {
        return String.format("GlobalPosition{DIM%d (%d %d %d)}", this.dimensionId, this.x, this.y, this.z);
    }
}

