/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.data.CelestialObjectManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;

public class GravityManager {
    private static final double OVERWORLD_ENTITY_GRAVITY = 0.08;
    private static final double OVERWORLD_ITEM_GRAVITY = (double)0.04f;
    private static final double OVERWORLD_ITEM_GRAVITY2 = (double)0.98f;
    private static final double HYPERSPACE_FIELD_ENTITY_GRAVITY = 0.035;
    private static final double HYPERSPACE_VOID_ENTITY_JITTER = 0.005;
    private static final double SPACE_FIELD_ENTITY_GRAVITY = 0.025;
    private static final double SPACE_FIELD_ITEM_GRAVITY = 0.02;
    private static final double SPACE_FIELD_ITEM_GRAVITY2 = 0.6;
    private static final double SPACE_VOID_GRAVITY = 0.001;
    private static final double SPACE_VOID_GRAVITY_JETPACK_SNEAK = 0.02;
    private static final double SPACE_VOID_GRAVITY_RAW_SNEAK = 0.005;
    private static boolean isAdvancedRocketryLoaded = false;
    private static Class<?> classGravityHandler;
    private static Method methodIPlanetaryProvider_applyGravity;

    public static void applyEntityItemGravity(@Nonnull EntityItem entityItem) {
        double gravity = CelestialObjectManager.getGravity((Entity)entityItem);
        if (gravity == 1.0) {
            if (!isAdvancedRocketryLoaded) {
                isAdvancedRocketryLoaded = true;
                try {
                    classGravityHandler = Class.forName("zmaster587.advancedRocketry.util.GravityHandler");
                    methodIPlanetaryProvider_applyGravity = classGravityHandler.getMethod("applyGravity", Entity.class);
                }
                catch (ClassNotFoundException | NoSuchMethodException exception) {
                    exception.printStackTrace(WarpDrive.printStreamError);
                    classGravityHandler = null;
                }
            }
            if (classGravityHandler != null) {
                try {
                    methodIPlanetaryProvider_applyGravity.invoke(null, entityItem);
                }
                catch (IllegalAccessException | InvocationTargetException exception) {
                    exception.printStackTrace(WarpDrive.printStreamError);
                    classGravityHandler = null;
                }
                return;
            }
        }
        entityItem.field_70181_x -= GravityManager.getItemGravity(entityItem);
    }

    public static double getGravityForEntity(Entity entity) {
        double gravity = CelestialObjectManager.getGravity(entity);
        if (gravity == 0.0) {
            return 0.001;
        }
        if (gravity == 1.0) {
            return 0.08;
        }
        if (gravity == -1.0 || gravity == -2.0) {
            EntityPlayer player;
            double jitter;
            boolean inHyperspace;
            boolean bl = inHyperspace = gravity == -2.0;
            if (GravityManager.isEntityInGraviField(entity)) {
                if (inHyperspace) {
                    return 0.035;
                }
                return 0.025;
            }
            double d = jitter = inHyperspace ? (entity.field_70170_p.field_73012_v.nextDouble() - 0.5) * 2.0 * 0.005 : 0.0;
            if (entity instanceof EntityPlayer && (player = (EntityPlayer)entity).func_70093_af()) {
                for (ItemStack armor : player.func_184193_aE()) {
                    if (armor == null || !Dictionary.ITEMS_FLYINSPACE.contains(armor.func_77973_b())) continue;
                    return 0.02;
                }
                return 0.005;
            }
            return 0.001 + jitter;
        }
        return gravity * 0.08;
    }

    public static double getNegGravityForEntity(Entity entity) {
        return -GravityManager.getGravityForEntity(entity);
    }

    public static double getItemGravity(EntityItem entity) {
        double gravity = CelestialObjectManager.getGravity((Entity)entity);
        if (gravity == 0.0) {
            return 0.001;
        }
        if (gravity == 1.0) {
            return 0.04f;
        }
        if (gravity == -1.0 || gravity == -2.0) {
            if (GravityManager.isEntityInGraviField((Entity)entity)) {
                return 0.02;
            }
            return 0.001;
        }
        return gravity * (double)0.04f;
    }

    public static double getItemGravity2(EntityItem entity) {
        double gravity = CelestialObjectManager.getGravity((Entity)entity);
        if (gravity == 0.0) {
            return 0.001;
        }
        if (gravity == 1.0) {
            return 0.98f;
        }
        if (gravity == -1.0 || gravity == -2.0) {
            if (GravityManager.isEntityInGraviField((Entity)entity)) {
                return 0.6;
            }
            return 0.001;
        }
        return gravity * (double)0.98f;
    }

    private static boolean isEntityInGraviField(Entity entity) {
        int y = MathHelper.func_76128_c((double)entity.field_70163_u);
        int x = MathHelper.func_76128_c((double)entity.field_70165_t);
        int z = MathHelper.func_76128_c((double)entity.field_70161_v);
        int CHECK_DISTANCE = 20;
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(x, y, z);
        for (int ny = y; ny > y - 20; --ny) {
            AxisAlignedBB axisAlignedBB;
            blockPos.func_185336_p(ny);
            IBlockState blockState = entity.field_70170_p.func_180495_p((BlockPos)blockPos);
            if (blockState.func_177230_c().isAir(blockState, (IBlockAccess)entity.field_70170_p, (BlockPos)blockPos) || (axisAlignedBB = blockState.func_185890_d((IBlockAccess)entity.field_70170_p, (BlockPos)blockPos)) == null || !(axisAlignedBB.func_72320_b() > 0.9)) continue;
            return true;
        }
        return false;
    }
}

