/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.block.movement.TileEntityShipCore;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.config.WarpDriveDataFixer;
import cr0s.warpdrive.data.JumpBlock;
import cr0s.warpdrive.data.MovingEntity;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.data.VectorI;
import cr0s.warpdrive.network.PacketHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class JumpShip {
    public World world;
    public BlockPos core;
    public int dx;
    public int dz;
    public int maxX;
    public int maxZ;
    public int maxY;
    public int minX;
    public int minZ;
    public int minY;
    public JumpBlock[] jumpBlocks;
    public int actualMass;
    public TileEntityShipCore shipCore;
    public List<MovingEntity> entitiesOnShip;

    public static JumpShip createFromFile(String fileName, WarpDriveText reason) {
        NBTTagCompound schematic = Commons.readNBTFromFile(WarpDriveConfig.G_SCHEMATICS_LOCATION + "/" + fileName + ".schematic");
        if (schematic == null) {
            reason.append(Commons.getStyleWarning(), "warpdrive.ship.guide.schematic_not_found", fileName + ".schematic");
            return null;
        }
        JumpShip jumpShip = new JumpShip();
        if (schematic.func_74764_b("ship")) {
            jumpShip.readFromNBT(schematic.func_74775_l("ship"));
        } else {
            byte[] localMetadata;
            HashMap<Integer, IBlockState> blockStatePalette;
            VectorI vOrigin;
            VectorI vCore;
            int width = schematic.func_74762_e("Width");
            int height = schematic.func_74762_e("Height");
            int length = schematic.func_74762_e("Length");
            if (width <= 0 || height <= 0 || length <= 0) {
                reason.append((ITextComponent)new WarpDriveText(Commons.getStyleWarning(), "warpdrive.ship.guide.schematic_invalid_format", String.format("Invalid size values: expecting strictly positive integers, found %1d %2d %3d.", width, height, length)));
                return null;
            }
            boolean isWorldEdit = schematic.func_74764_b("WEOffsetX");
            if (isWorldEdit) {
                vCore = new VectorI(-schematic.func_74762_e("WEOffsetX"), -schematic.func_74762_e("WEOffsetY"), -schematic.func_74762_e("WEOffsetZ"));
                vOrigin = new VectorI(schematic.func_74762_e("WEOriginX"), schematic.func_74762_e("WEOriginY"), schematic.func_74762_e("WEOriginZ"));
            } else if (schematic.func_74764_b("Offset")) {
                int[] intOffset = schematic.func_74759_k("Offset");
                if (intOffset.length != 3) {
                    reason.append((ITextComponent)new WarpDriveText(Commons.getStyleWarning(), "warpdrive.ship.guide.schematic_invalid_format", String.format("Invalid offset format: expecting 3 integers, found %1d", intOffset.length)));
                    return null;
                }
                vCore = new VectorI(intOffset[0], intOffset[1], intOffset[2]);
                vOrigin = new VectorI(0, 0, 0);
            } else {
                reason.append((ITextComponent)new WarpDriveText(Commons.getStyleWarning(), "warpdrive.ship.guide.schematic_invalid_format", "Unknown offset format"));
                return null;
            }
            if (schematic.func_74764_b("Palette")) {
                NBTTagCompound tagCompoundPalette = schematic.func_74775_l("Palette");
                blockStatePalette = new HashMap<Integer, IBlockState>(tagCompoundPalette.func_150296_c().size());
                for (String stringBlockstate : tagCompoundPalette.func_150296_c()) {
                    IBlockState blockState = WarpDriveDataFixer.getBlockState(stringBlockstate);
                    if (blockState != null) {
                        blockStatePalette.put(tagCompoundPalette.func_74762_e(stringBlockstate), blockState);
                        continue;
                    }
                    WarpDrive.logger.warn(String.format("Ignoring missing BlockState %s, consider updating your warpdrive/dataFixer.yml", stringBlockstate));
                }
            } else {
                blockStatePalette = null;
            }
            jumpShip.core = new BlockPos(vOrigin.x + vCore.x, vOrigin.y + vCore.y, vOrigin.z + vCore.z);
            jumpShip.minX = vOrigin.x;
            jumpShip.maxX = vOrigin.x + width - 1;
            jumpShip.minY = vOrigin.y;
            jumpShip.maxY = vOrigin.y + height - 1;
            jumpShip.minZ = vOrigin.z;
            jumpShip.maxZ = vOrigin.z + length - 1;
            jumpShip.jumpBlocks = new JumpBlock[width * height * length];
            byte[] localBlocks = schematic.func_74764_b("Blocks") ? schematic.func_74770_j("Blocks") : schematic.func_74770_j("BlockData");
            byte[] localAddBlocks = schematic.func_74764_b("AddBlocks") ? schematic.func_74770_j("AddBlocks") : null;
            byte[] byArray = localMetadata = blockStatePalette == null ? schematic.func_74770_j("Data") : null;
            if (localBlocks.length != jumpShip.jumpBlocks.length) {
                reason.append((ITextComponent)new WarpDriveText(Commons.getStyleWarning(), "warpdrive.ship.guide.schematic_invalid_format", String.format("Invalid array size for Blocks: expecting %d (%d x %d x %d), found %d", width, height, length, jumpShip.jumpBlocks.length, localBlocks.length)));
                return null;
            }
            int sizeAddBlocks = (int)Math.ceil(((float)jumpShip.jumpBlocks.length + 1.0f) / 2.0f);
            if (localAddBlocks != null && localAddBlocks.length != sizeAddBlocks) {
                reason.append((ITextComponent)new WarpDriveText(Commons.getStyleWarning(), "warpdrive.ship.guide.schematic_invalid_format", String.format("Invalid array size for AddBlocks: expecting %d (%d x %d x %d), found %d", width, height, length, jumpShip.jumpBlocks.length, localAddBlocks.length)));
                return null;
            }
            if (localMetadata != null && localMetadata.length != jumpShip.jumpBlocks.length) {
                reason.append((ITextComponent)new WarpDriveText(Commons.getStyleWarning(), "warpdrive.ship.guide.schematic_invalid_format", String.format("Invalid array size for Metadata: expecting %d (%d x %d x %d), found %d", width, height, length, jumpShip.jumpBlocks.length, localMetadata.length)));
                return null;
            }
            NBTTagCompound[] tileEntities = new NBTTagCompound[jumpShip.jumpBlocks.length];
            NBTTagList tagListTileEntities = schematic.func_150295_c("TileEntities", 10);
            for (int index = 0; index < tagListTileEntities.func_74745_c(); ++index) {
                int zTileEntity;
                int yTileEntity;
                int xTileEntity;
                NBTTagCompound tagCompoundTileEntity = tagListTileEntities.func_150305_b(index);
                if (isWorldEdit) {
                    xTileEntity = tagCompoundTileEntity.func_74762_e("x");
                    yTileEntity = tagCompoundTileEntity.func_74762_e("y");
                    zTileEntity = tagCompoundTileEntity.func_74762_e("z");
                } else if (tagCompoundTileEntity.func_74764_b("Pos")) {
                    int[] intPosition = tagCompoundTileEntity.func_74759_k("Pos");
                    if (intPosition.length != 3) {
                        reason.append((ITextComponent)new WarpDriveText(Commons.getStyleWarning(), "warpdrive.ship.guide.schematic_invalid_format", String.format("Invalid array size for TileEntity Pos: expecting 3, found %d in %s", intPosition.length, tagCompoundTileEntity)));
                        return null;
                    }
                    xTileEntity = intPosition[0];
                    yTileEntity = intPosition[1];
                    zTileEntity = intPosition[2];
                } else {
                    reason.append((ITextComponent)new WarpDriveText(Commons.getStyleWarning(), "warpdrive.ship.guide.schematic_invalid_format", String.format("Missing position for TileEntity %s", tagCompoundTileEntity)));
                    return null;
                }
                tagCompoundTileEntity.func_74768_a("x", vOrigin.x + xTileEntity);
                tagCompoundTileEntity.func_74768_a("y", vOrigin.y + yTileEntity);
                tagCompoundTileEntity.func_74768_a("z", vOrigin.z + zTileEntity);
                tileEntities[xTileEntity + (yTileEntity * length + zTileEntity) * width] = tagCompoundTileEntity;
            }
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    for (int z = 0; z < length; ++z) {
                        int index = x + (y * length + z) * width;
                        JumpBlock jumpBlock = new JumpBlock();
                        jumpBlock.x = vOrigin.x + x;
                        jumpBlock.y = vOrigin.y + y;
                        jumpBlock.z = vOrigin.z + z;
                        int blockId = localBlocks[index];
                        if (blockId < 0) {
                            blockId += 256;
                        }
                        if (localAddBlocks != null) {
                            int MSB = localAddBlocks[index / 2];
                            if (MSB < 0) {
                                MSB += 256;
                            }
                            blockId = index % 2 == 0 ? (blockId += (MSB & 0xF) << 8) : (blockId += (MSB & 0xF0) << 4);
                        }
                        if (blockStatePalette == null) {
                            jumpBlock.block = Block.func_149729_e((int)blockId);
                            jumpBlock.blockMeta = localMetadata[index] & 0xF;
                        } else {
                            IBlockState blockState = (IBlockState)blockStatePalette.get(blockId);
                            if (blockState != null) {
                                jumpBlock.block = blockState.func_177230_c();
                                jumpBlock.blockMeta = blockState.func_177230_c().func_176201_c(blockState);
                            }
                        }
                        if (jumpBlock.block != Blocks.field_150350_a) {
                            jumpBlock.blockNBT = tileEntities[index];
                        } else {
                            jumpBlock.blockMeta = 0;
                        }
                        if (jumpBlock.block != null) {
                            if (WarpDriveConfig.LOGGING_BUILDING) {
                                if (tileEntities[index] == null) {
                                    WarpDrive.logger.info("Adding block to deploy: " + jumpBlock.block.func_149739_a() + ":" + jumpBlock.blockMeta + " (no tile entity)");
                                } else {
                                    WarpDrive.logger.info("Adding block to deploy: " + jumpBlock.block.func_149739_a() + ":" + jumpBlock.blockMeta + " with tile entity " + tileEntities[index].func_74779_i("id"));
                                }
                            }
                        } else {
                            jumpBlock = null;
                        }
                        jumpShip.jumpBlocks[index] = jumpBlock;
                    }
                }
            }
        }
        return jumpShip;
    }

    public void messageToAllPlayersOnShip(WarpDriveText textComponent) {
        String name = this.shipCore != null && !this.shipCore.name.isEmpty() ? this.shipCore.name : "ShipCore";
        WarpDriveText messageFormatted = Commons.getNamedPrefix(name).appendSibling(textComponent);
        if (this.entitiesOnShip == null) {
            WarpDriveText reason = new WarpDriveText();
            this.saveEntities(reason);
        }
        WarpDrive.logger.info(this + " messageToAllPlayersOnShip: " + textComponent.func_150260_c());
        for (MovingEntity movingEntity : this.entitiesOnShip) {
            Entity entity = movingEntity.getEntity();
            if (!(entity instanceof EntityPlayer)) continue;
            Commons.addChatMessage((ICommandSender)entity, (ITextComponent)messageFormatted);
        }
    }

    public boolean saveEntities(WarpDriveText reason) {
        boolean isSuccess = true;
        this.entitiesOnShip = new ArrayList<MovingEntity>();
        if (this.world == null) {
            WarpDrive.logger.error("Invalid call to saveEntities, please report it to mod author: world is null");
            reason.append(Commons.getStyleWarning(), "warpdrive.error.internal_check_console", new Object[0]);
            return false;
        }
        AxisAlignedBB axisalignedbb = new AxisAlignedBB((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX + 0.99, (double)this.maxY + 0.99, (double)this.maxZ + 0.99);
        List list = this.world.func_72839_b(null, axisalignedbb);
        for (Entity entity : list) {
            if (entity == null) continue;
            if (Dictionary.isAnchor(entity)) {
                reason.append(Commons.getStyleWarning(), "warpdrive.ship.guide.anchor_entity_detected", Dictionary.getId(entity), Math.round(entity.field_70165_t), Math.round(entity.field_70163_u), Math.round(entity.field_70161_v));
                isSuccess = false;
                continue;
            }
            if (Dictionary.isLeftBehind(entity)) {
                if (!WarpDriveConfig.LOGGING_JUMPBLOCKS) continue;
                WarpDrive.logger.info(String.format("Leaving entity %s behind: %s", Dictionary.getId(entity), entity));
                continue;
            }
            if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                WarpDrive.logger.info(String.format("Adding entity %s: %s", Dictionary.getId(entity), entity));
            }
            MovingEntity movingEntity = new MovingEntity(entity);
            this.entitiesOnShip.add(movingEntity);
        }
        return isSuccess;
    }

    public boolean removeEntities(WarpDriveText reason) {
        if (this.world == null) {
            WarpDrive.logger.error("Invalid call to removeEntities, please report it to mod author: world is null");
            reason.append(Commons.getStyleWarning(), "warpdrive.error.internal_check_console", new Object[0]);
            return false;
        }
        AxisAlignedBB axisalignedbb = new AxisAlignedBB((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX + 0.99, (double)this.maxY + 0.99, (double)this.maxZ + 0.99);
        List list = this.world.func_72839_b(null, axisalignedbb);
        for (Entity entity : list) {
            if (entity == null || entity instanceof EntityPlayer || Dictionary.isLeftBehind(entity)) continue;
            WarpDrive.logger.warn(String.format("Removing entity %s: %s", Dictionary.getId(entity), entity));
            this.world.func_72900_e(entity);
        }
        return true;
    }

    public void addPlayerToEntities(String playerName) {
        EntityPlayerMP entityPlayerMP;
        if (this.entitiesOnShip == null) {
            this.entitiesOnShip = new ArrayList<MovingEntity>();
        }
        if ((entityPlayerMP = Commons.getOnlinePlayerByName(playerName)) == null) {
            WarpDrive.logger.error(String.format("%s Unable to add offline/missing player %s", this, playerName));
            return;
        }
        MovingEntity movingEntity = new MovingEntity((Entity)entityPlayerMP);
        this.entitiesOnShip.add(movingEntity);
    }

    public boolean isUnlimited() {
        if (this.entitiesOnShip == null) {
            return false;
        }
        for (MovingEntity movingEntity : this.entitiesOnShip) {
            if (!movingEntity.isUnlimited()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return String.format("%s/%d '%s' %s", this.getClass().getSimpleName(), this.hashCode(), this.shipCore == null ? "~NULL~" : this.shipCore.uuid + ":" + this.shipCore.name, Commons.format(this.world, this.core));
    }

    public boolean checkBorders(WarpDriveText reason) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int x = this.minX - 1; x <= this.maxX + 1; ++x) {
            boolean xBorder = x == this.minX - 1 || x == this.maxX + 1;
            for (int z = this.minZ - 1; z <= this.maxZ + 1; ++z) {
                boolean zBorder;
                boolean bl = zBorder = z == this.minZ - 1 || z == this.maxZ + 1;
                if (xBorder && zBorder) continue;
                for (int y = this.minY - 1; y <= this.maxY + 1; ++y) {
                    boolean yBorder;
                    boolean bl2 = yBorder = y == this.minY - 1 || y == this.maxY + 1;
                    if (y < 0 || y > 255 || !xBorder && !yBorder && !zBorder || yBorder && (xBorder || zBorder)) continue;
                    mutableBlockPos.func_181079_c(x, y, z);
                    IBlockState blockState = this.world.func_180495_p((BlockPos)mutableBlockPos);
                    Block block = blockState.func_177230_c();
                    if (this.world.func_175623_d((BlockPos)mutableBlockPos) || Dictionary.BLOCKS_LEFTBEHIND.contains(block) || Dictionary.BLOCKS_ANCHOR.contains(block) || !block.hasTileEntity(blockState)) continue;
                    mutableBlockPos.func_181079_c(x == this.minX - 1 ? this.minX : (x == this.maxX + 1 ? this.maxX : x), y == this.minY - 1 ? this.minY : (y == this.maxY + 1 ? this.maxY : y), z == this.minZ - 1 ? this.minZ : (z == this.maxZ + 1 ? this.maxZ : z));
                    IBlockState blockStateInner = this.world.func_180495_p((BlockPos)mutableBlockPos);
                    Block blockInner = blockStateInner.func_177230_c();
                    if (this.world.func_175623_d((BlockPos)mutableBlockPos) || Dictionary.BLOCKS_LEFTBEHIND.contains(blockInner) || !blockInner.hasTileEntity(blockStateInner)) continue;
                    reason.append(Commons.getStyleWarning(), "warpdrive.ship.guide.ship_snagged1", blockState.func_177230_c().func_149732_F(), x, y, z);
                    reason.append(Commons.getStyleCommand(), "warpdrive.ship.guide.ship_snagged2", new Object[0]);
                    this.world.func_72885_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 1.0f, false, false);
                    PacketHandler.sendSpawnParticlePacket(this.world, "jammed", (byte)5, new Vector3((double)x + 0.5, (double)y + 0.5, (double)z + 0.5), new Vector3(0.0, 0.0, 0.0), 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 32);
                    return false;
                }
            }
        }
        return true;
    }

    public boolean save(WarpDriveText reason) {
        BlockPos blockPos = new BlockPos(0, -1, 0);
        try {
            int estimatedVolume = (this.maxX - this.minX + 1) * (this.maxY - this.minY + 1) * (this.maxZ - this.minZ + 1);
            JumpBlock[][] placeTimeJumpBlocks = new JumpBlock[][]{new JumpBlock[estimatedVolume], new JumpBlock[estimatedVolume], new JumpBlock[estimatedVolume], new JumpBlock[estimatedVolume], new JumpBlock[estimatedVolume]};
            int[] placeTimeIndexes = new int[]{0, 0, 0, 0, 0};
            int actualVolume = 0;
            int newMass = 0;
            int xc1 = this.minX >> 4;
            int xc2 = this.maxX >> 4;
            int zc1 = this.minZ >> 4;
            int zc2 = this.maxZ >> 4;
            for (int xc = xc1; xc <= xc2; ++xc) {
                int x1 = Math.max(this.minX, xc << 4);
                int x2 = Math.min(this.maxX, (xc << 4) + 15);
                for (int zc = zc1; zc <= zc2; ++zc) {
                    int z1 = Math.max(this.minZ, zc << 4);
                    int z2 = Math.min(this.maxZ, (zc << 4) + 15);
                    for (int y = this.minY; y <= this.maxY; ++y) {
                        for (int x = x1; x <= x2; ++x) {
                            for (int z = z1; z <= z2; ++z) {
                                Integer placeTime;
                                blockPos = new BlockPos(x, y, z);
                                IBlockState blockState = this.world.func_180495_p(blockPos);
                                if (blockState.func_177230_c() == Blocks.field_150350_a || Dictionary.BLOCKS_LEFTBEHIND.contains(blockState.func_177230_c())) continue;
                                ++actualVolume;
                                if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                                    WarpDrive.logger.info(String.format("Checking for save from (%d %d %d) of %s (%d)", x, y, z, blockState, blockState.func_177230_c().func_176201_c(blockState)));
                                }
                                if (!Dictionary.BLOCKS_NOMASS.contains(blockState.func_177230_c())) {
                                    ++newMass;
                                }
                                if (Dictionary.BLOCKS_ANCHOR.contains(blockState.func_177230_c())) {
                                    reason.append(Commons.getStyleWarning(), "warpdrive.ship.guide.anchor_block_detected", blockState.func_177230_c().func_149732_F(), x, y, z);
                                    return false;
                                }
                                TileEntity tileEntity = this.world.func_175625_s(blockPos);
                                JumpBlock jumpBlock = new JumpBlock(this.world, blockPos, blockState, tileEntity);
                                if (tileEntity != null && jumpBlock.externals != null) {
                                    for (Map.Entry<String, NBTBase> external : jumpBlock.externals.entrySet()) {
                                        IBlockTransformer blockTransformer = WarpDriveConfig.blockTransformers.get(external.getKey());
                                        if (blockTransformer == null || blockTransformer.isJumpReady(jumpBlock.block, jumpBlock.blockMeta, tileEntity, reason)) continue;
                                        reason.append(Commons.getStyleWarning(), "warpdrive.ship.guide.block_not_ready_for_jump", jumpBlock.block.func_149732_F(), jumpBlock.x, jumpBlock.y, jumpBlock.z);
                                        return false;
                                    }
                                }
                                if ((placeTime = Dictionary.BLOCKS_PLACE.get(blockState.func_177230_c())) == null) {
                                    placeTime = tileEntity == null ? Integer.valueOf(2) : Integer.valueOf(3);
                                }
                                placeTimeJumpBlocks[placeTime.intValue()][placeTimeIndexes[placeTime.intValue()]] = jumpBlock;
                                int n = placeTime;
                                placeTimeIndexes[n] = placeTimeIndexes[n] + 1;
                            }
                        }
                    }
                }
            }
            this.jumpBlocks = new JumpBlock[actualVolume];
            int indexShip = 0;
            for (int placeTime = 0; placeTime < 5; ++placeTime) {
                for (int placeTimeIndex = 0; placeTimeIndex < placeTimeIndexes[placeTime]; ++placeTimeIndex) {
                    this.jumpBlocks[indexShip] = placeTimeJumpBlocks[placeTime][placeTimeIndex];
                    ++indexShip;
                }
            }
            this.actualMass = newMass;
        }
        catch (Exception exception) {
            exception.printStackTrace(WarpDrive.printStreamError);
            WarpDriveText textComponent = new WarpDriveText(Commons.getStyleWarning(), "warpdrive.ship.guide.save_exception", Commons.format(this.world, blockPos));
            WarpDrive.logger.error(textComponent.func_150260_c());
            reason.appendSibling(textComponent);
            return false;
        }
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(String.format("%s Ship saved as %d blocks", this, this.jumpBlocks.length));
        }
        return true;
    }

    public void readFromNBT(@Nonnull NBTTagCompound tagCompound) {
        this.core = new BlockPos(tagCompound.func_74762_e("coreX"), tagCompound.func_74762_e("coreY"), tagCompound.func_74762_e("coreZ"));
        this.dx = tagCompound.func_74762_e("dx");
        this.dz = tagCompound.func_74762_e("dz");
        this.maxX = tagCompound.func_74762_e("maxX");
        this.maxZ = tagCompound.func_74762_e("maxZ");
        this.maxY = tagCompound.func_74762_e("maxY");
        this.minX = tagCompound.func_74762_e("minX");
        this.minZ = tagCompound.func_74762_e("minZ");
        this.minY = tagCompound.func_74762_e("minY");
        this.actualMass = tagCompound.func_74762_e("actualMass");
        NBTTagList tagList = tagCompound.func_150295_c("jumpBlocks", 10);
        this.jumpBlocks = new JumpBlock[tagList.func_74745_c()];
        for (int index = 0; index < tagList.func_74745_c(); ++index) {
            this.jumpBlocks[index] = new JumpBlock();
            this.jumpBlocks[index].readFromNBT(tagList.func_150305_b(index));
        }
    }

    public void writeToNBT(@Nonnull NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("coreX", this.core.func_177958_n());
        tagCompound.func_74768_a("coreY", this.core.func_177956_o());
        tagCompound.func_74768_a("coreZ", this.core.func_177952_p());
        tagCompound.func_74768_a("dx", this.dx);
        tagCompound.func_74768_a("dz", this.dz);
        tagCompound.func_74768_a("maxX", this.maxX);
        tagCompound.func_74768_a("maxZ", this.maxZ);
        tagCompound.func_74768_a("maxY", this.maxY);
        tagCompound.func_74768_a("minX", this.minX);
        tagCompound.func_74768_a("minZ", this.minZ);
        tagCompound.func_74768_a("minY", this.minY);
        tagCompound.func_74768_a("actualMass", this.actualMass);
        NBTTagList tagListJumpBlocks = new NBTTagList();
        for (JumpBlock jumpBlock : this.jumpBlocks) {
            NBTTagCompound tagCompoundBlock = new NBTTagCompound();
            jumpBlock.writeToNBT(this.world, tagCompoundBlock);
            tagListJumpBlocks.func_74742_a((NBTBase)tagCompoundBlock);
        }
        tagCompound.func_74782_a("jumpBlocks", (NBTBase)tagListJumpBlocks);
    }
}

