/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.CommonProxy;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.atomic.BlockVoidShellPlain;
import cr0s.warpdrive.block.atomic.TileEntityAcceleratorCore;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.AcceleratorControlParameter;
import cr0s.warpdrive.data.AcceleratorSetup;
import cr0s.warpdrive.data.TrajectoryPoint;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.data.VectorI;
import cr0s.warpdrive.entity.EntityParticleBunch;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class ParticleBunch
extends Vector3 {
    private static final double RADIATION_RADIUS_VOID_PIPE = 2.1;
    private static final double RADIATION_RADIUS_FREE_FLIGHT = 3.1;
    private static final int FREE_FLIGHT_MAXIMUM_RANGE = 64;
    private static final double FREE_FLIGHT_ENERGY_FACTOR_PER_TICK = 0.997;
    private static final double SPEED_STEPS = 0.999;
    public int id;
    public double energy = TileEntityAcceleratorCore.PARTICLE_BUNCH_ENERGY_MINIMUM[0];
    public EnumFacing directionCurrentMotion = null;
    public Vector3 vectorCurrentMotion = new Vector3(0.0, 0.0, 0.0);
    public Vector3 vectorTurningPoint = null;
    private int tickFreeFlight = 0;
    private Vector3 vectorFreeFlightStart = null;
    private VectorI vLastBlock = null;
    private int entityId = -1;
    private TrajectoryPoint trajectoryPointCurrent = null;
    private boolean isDead = false;

    public ParticleBunch(int x, int y, int z, EnumFacing directionCurrentMotion, Vector3 vectorCurrentMotion) {
        super((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        this.id = (int)System.nanoTime();
        this.directionCurrentMotion = directionCurrentMotion;
        this.vectorCurrentMotion = vectorCurrentMotion;
    }

    public ParticleBunch(NBTTagCompound tagCompound) {
        super(0.0, 0.0, 0.0);
        this.readFromNBT(tagCompound);
    }

    public boolean onUpdate(World world, Map<Integer, AcceleratorControlParameter> mapParameters, AcceleratorSetup acceleratorSetup) {
        double speed;
        boolean isChunkLoaded;
        Entity entity;
        if (this.entityId >= 0 && ((entity = world.func_73045_a(this.entityId)) == null || entity.field_70128_L)) {
            this.entityId = -1;
        }
        boolean bl = isChunkLoaded = (speed = ParticleBunch.getSpeedFromEnergy(this.energy)) > 0.0;
        while (!this.isDead && speed > 0.0) {
            isChunkLoaded = isChunkLoaded && this.moveForward(world, mapParameters, acceleratorSetup, Math.min(0.999, speed));
            speed -= 0.999;
        }
        Entity entity2 = null;
        if (this.entityId < 0 && isChunkLoaded && !this.isDead) {
            entity2 = new EntityParticleBunch(world, this.x, this.y, this.z);
            this.entityId = entity2.func_145782_y();
            world.func_72838_d(entity2);
        } else if (this.entityId > 0) {
            entity2 = world.func_73045_a(this.entityId);
            if (entity2 == null) {
                this.entityId = -1;
            } else if (!isChunkLoaded || this.isDead) {
                entity2.func_70106_y();
                entity2 = null;
                this.entityId = -1;
            }
        }
        if (entity2 instanceof EntityParticleBunch) {
            EntityParticleBunch entityParticleBunch = (EntityParticleBunch)entity2;
            entityParticleBunch.onRefreshFromSimulation(this.energy, this, this.vectorTurningPoint);
            this.doIrradiation(world, this.tickFreeFlight > 0 ? 3.1 : 2.1, this.tickFreeFlight > 0 ? 3.0f : 1.0f);
        }
        return !this.isDead;
    }

    public void onCollided(World world, TrajectoryPoint trajectoryPointCollider) {
        if (this.entityId < 0) {
            return;
        }
        Entity entity = world.func_73045_a(this.entityId);
        if (entity == null) {
            return;
        }
        if (entity instanceof EntityParticleBunch) {
            EntityParticleBunch entityParticleBunch = (EntityParticleBunch)entity;
            this.x = (double)trajectoryPointCollider.x + 0.5;
            this.y = (double)trajectoryPointCollider.y + 0.5;
            this.z = (double)trajectoryPointCollider.z + 0.5;
            entityParticleBunch.onRefreshFromSimulation(this.energy, this, this.vectorTurningPoint);
        }
    }

    private boolean moveForward(World world, Map<Integer, AcceleratorControlParameter> mapParameters, AcceleratorSetup acceleratorSetup, double speed) {
        boolean enableControlPoint;
        int controlChannel;
        int tier;
        boolean isNewBlock;
        VectorI vCurrentBlock = new VectorI((int)Math.floor(this.x), (int)Math.floor(this.y), (int)Math.floor(this.z));
        boolean bl = isNewBlock = this.vLastBlock == null || this.vLastBlock.x != vCurrentBlock.x || this.vLastBlock.z != vCurrentBlock.z;
        if (this.trajectoryPointCurrent == null) {
            this.trajectoryPointCurrent = acceleratorSetup == null ? null : acceleratorSetup.getTrajectoryPoint(vCurrentBlock);
        }
        int n = tier = this.trajectoryPointCurrent == null ? 0 : this.trajectoryPointCurrent.getTier();
        if (tier > 0 && this.trajectoryPointCurrent.hasNoMissingVoidShells() && isNewBlock && this.energy >= TileEntityAcceleratorCore.PARTICLE_BUNCH_ENERGY_MINIMUM[tier - 1] && this.energy <= TileEntityAcceleratorCore.PARTICLE_BUNCH_ENERGY_MAXIMUM[tier - 1]) {
            int countMagnets = this.trajectoryPointCurrent.getMagnetsCount();
            double energy_before = this.energy;
            this.energy *= 1.0 + (double)countMagnets * TileEntityAcceleratorCore.PARTICLE_BUNCH_ENERGY_FACTOR_PER_MAGNET[tier - 1];
            this.energy = Math.min(this.energy, TileEntityAcceleratorCore.PARTICLE_BUNCH_ENERGY_MAXIMUM[tier - 1]);
            if (WarpDriveConfig.LOGGING_ACCELERATOR && WarpDrive.isDev) {
                WarpDrive.logger.info(String.format(this + " accelerating by %d magnets energy %.5f -> %.5f at [%d %d %d]", countMagnets, energy_before, this.energy, vCurrentBlock.x, vCurrentBlock.y, vCurrentBlock.z));
            }
        }
        int n2 = controlChannel = this.trajectoryPointCurrent == null ? -1 : this.trajectoryPointCurrent.controlChannel;
        if (tier > 0 && controlChannel >= 0) {
            AcceleratorControlParameter acceleratorControlParameter = mapParameters.get(controlChannel);
            double threshold = Math.max(0.01, acceleratorControlParameter == null ? 0.95 : acceleratorControlParameter.threshold);
            boolean bl2 = enableControlPoint = this.energy > threshold * TileEntityAcceleratorCore.PARTICLE_BUNCH_ENERGY_MAXIMUM[tier - 1];
            if (enableControlPoint && WarpDriveConfig.LOGGING_ACCELERATOR) {
                WarpDrive.logger.info(String.format(this + " control point enabled at [%d %d %d]", vCurrentBlock.x, vCurrentBlock.y, vCurrentBlock.z));
            }
        } else {
            enableControlPoint = false;
        }
        EnumFacing directionNewMotion = null;
        Vector3 vectorNewMotion = null;
        Vector3 vectorNewTurningPoint = null;
        boolean isTurning = false;
        if (this.trajectoryPointCurrent != null) {
            if (this.tickFreeFlight != 0 || this.vectorFreeFlightStart != null) {
                this.doExplosion(world, "Re-entry");
                return false;
            }
            if (!this.trajectoryPointCurrent.isTransferPipe()) {
                if (enableControlPoint) {
                    vectorNewMotion = this.trajectoryPointCurrent.getJunctionOut(this.directionCurrentMotion);
                    if (vectorNewMotion != null) {
                        directionNewMotion = this.directionCurrentMotion;
                        if (WarpDriveConfig.LOGGING_ACCELERATOR) {
                            WarpDrive.logger.info(String.format(this + " approaching tier %d transfer towards %s %s", tier, directionNewMotion, vectorNewMotion));
                        }
                    } else if (WarpDriveConfig.LOGGING_ACCELERATOR) {
                        WarpDrive.logger.info(String.format(this + " ignoring output junction in other direction", tier, directionNewMotion, vectorNewMotion));
                    }
                }
                if (!(enableControlPoint && vectorNewMotion != null || (directionNewMotion = this.trajectoryPointCurrent.getTurnedDirection(this.directionCurrentMotion)) == null)) {
                    boolean bl3 = isTurning = this.energy >= TileEntityAcceleratorCore.PARTICLE_BUNCH_ENERGY_MINIMUM[tier - 1];
                    if (isTurning) {
                        vectorNewMotion = new Vector3(directionNewMotion);
                        if (WarpDriveConfig.LOGGING_ACCELERATOR) {
                            WarpDrive.logger.info(String.format(this + " approaching tier %d turn towards %s %s", tier, directionNewMotion, vectorNewMotion));
                        }
                    } else {
                        directionNewMotion = null;
                        vectorNewMotion = null;
                        vectorNewTurningPoint = null;
                    }
                }
            }
            if (vectorNewMotion != null) {
                vectorNewTurningPoint = new Vector3((double)vCurrentBlock.x + 0.5, (double)vCurrentBlock.y + 0.5, (double)vCurrentBlock.z + 0.5);
                if (Math.abs(vectorNewMotion.x) != 1.0 && Math.abs(vectorNewMotion.z) != 1.0) {
                    vectorNewTurningPoint.translateFactor(this.vectorCurrentMotion, -0.5);
                }
            }
        } else {
            IBlockState blockStateCurrent = vCurrentBlock.getBlockState((IBlockAccess)world);
            Block blockCurrent = blockStateCurrent.func_177230_c();
            if (!(blockCurrent instanceof BlockVoidShellPlain)) {
                if (this.vectorFreeFlightStart == null) {
                    this.vectorFreeFlightStart = new Vector3(this.x, this.y, this.z);
                } else if (this.distanceTo_square(this.vectorFreeFlightStart) > 4096.0) {
                    this.doExplosion(world, "Out of range");
                    return false;
                }
                ++this.tickFreeFlight;
                if (!blockCurrent.isAir(blockStateCurrent, (IBlockAccess)world, vCurrentBlock.getBlockPos()) && blockStateCurrent.func_185914_p()) {
                    this.doExplosion(world, "Opaque cube");
                    return false;
                }
                this.energy *= 0.997;
            }
        }
        double speedAdjusted = speed;
        Vector3 vectorNewPosition = new Vector3(this.x + speedAdjusted * this.vectorCurrentMotion.x, this.y + speedAdjusted * this.vectorCurrentMotion.y, this.z + speedAdjusted * this.vectorCurrentMotion.z);
        if (isTurning) {
            Vector3 vectorOldPosition = new Vector3(this.x, this.y, this.z);
            if (isNewBlock) {
                vectorOldPosition = new Vector3(this.x - this.vectorCurrentMotion.x, this.y - this.vectorCurrentMotion.y, this.z - this.vectorCurrentMotion.z);
                speedAdjusted += 1.0;
            }
            Vector3 vectorOffset = vectorNewTurningPoint.clone().subtract(vectorOldPosition);
            if (vectorOffset.x * this.vectorCurrentMotion.x >= 0.0 && vectorOffset.z * this.vectorCurrentMotion.z >= 0.0) {
                Vector3 vectorAfter = vectorNewTurningPoint.clone().subtract(vectorNewPosition);
                if (vectorAfter.x * this.vectorCurrentMotion.x <= 0.0 && vectorAfter.z * this.vectorCurrentMotion.z <= 0.0) {
                    double distanceLeft = speedAdjusted - vectorOffset.getMagnitude();
                    vectorNewPosition = vectorNewTurningPoint.clone().translateFactor(vectorNewMotion, distanceLeft);
                    double energy_before = this.energy;
                    double energyMin = TileEntityAcceleratorCore.PARTICLE_BUNCH_ENERGY_MINIMUM[tier - 1];
                    double energyMax = TileEntityAcceleratorCore.PARTICLE_BUNCH_ENERGY_MAXIMUM[tier - 1];
                    this.energy = Commons.clamp(energyMin, energyMax, this.energy * Commons.interpolate(new double[]{energyMin, energyMax}, new double[]{TileEntityAcceleratorCore.PARTICLE_BUNCH_TURN_COEFFICIENTS_AT_MIN_ENERGY[tier - 1], TileEntityAcceleratorCore.PARTICLE_BUNCH_TURN_COEFFICIENTS_AT_MAX_ENERGY[tier - 1]}, this.energy));
                    if (WarpDriveConfig.LOGGING_ACCELERATOR) {
                        WarpDrive.logger.info(String.format(this + " turning energy %.5f -> %.5f at [%d %d %d]", energy_before, this.energy, vCurrentBlock.x, vCurrentBlock.y, vCurrentBlock.z));
                    }
                } else {
                    directionNewMotion = null;
                    vectorNewMotion = null;
                    vectorNewTurningPoint = null;
                }
            } else {
                directionNewMotion = null;
                vectorNewMotion = null;
                vectorNewTurningPoint = null;
            }
        }
        this.vLastBlock = vCurrentBlock.clone();
        VectorI vNewBlock = new VectorI((int)Math.floor(vectorNewPosition.x), (int)Math.floor(vectorNewPosition.y), (int)Math.floor(vectorNewPosition.z));
        if (!vNewBlock.equals(vCurrentBlock)) {
            this.trajectoryPointCurrent = null;
        }
        if (directionNewMotion != null) {
            this.directionCurrentMotion = directionNewMotion;
            this.vectorCurrentMotion = vectorNewMotion;
            this.vectorTurningPoint = vectorNewTurningPoint;
        } else {
            this.vectorTurningPoint = null;
        }
        this.x = vectorNewPosition.x;
        this.y = vectorNewPosition.y;
        this.z = vectorNewPosition.z;
        return Commons.isChunkLoaded((IBlockAccess)world, vCurrentBlock.x, vCurrentBlock.z) && (vCurrentBlock == vNewBlock || Commons.isChunkLoaded((IBlockAccess)world, vNewBlock.x, vNewBlock.z));
    }

    private static double getSpeedFromEnergy(double energy) {
        return Commons.interpolate(TileEntityAcceleratorCore.PARTICLE_BUNCH_ENERGY_TO_SPEEDS_X, TileEntityAcceleratorCore.PARTICLE_BUNCH_ENERGY_TO_SPEEDS_Y, energy);
    }

    private void doIrradiation(@Nonnull World world, double radius, float strength) {
        AxisAlignedBB axisAlignedBB = new AxisAlignedBB(this.x + 0.5 - radius, this.y + 0.5 - radius, this.z + 0.5 - radius, this.x + 0.5 + radius, this.y + 0.5 + radius, this.z + 0.5 + radius);
        List listEntityLivingBase = world.func_72872_a(EntityLivingBase.class, axisAlignedBB);
        for (EntityLivingBase entityLivingBase : listEntityLivingBase) {
            WarpDrive.damageIrradiation.onEntityEffect(strength, world, this, (Entity)entityLivingBase);
        }
    }

    private void doExplosion(World world, String reason) {
        WarpDrive.logger.info(String.format("Particle bunch explosion due to %s %s", reason, Commons.format(world, this.x, this.y, this.z)));
        if (world instanceof WorldServer) {
            double explosionStrength = Commons.interpolate(TileEntityAcceleratorCore.PARTICLE_BUNCH_ENERGY_TO_EXPLOSION_STRENGTH_X, TileEntityAcceleratorCore.PARTICLE_BUNCH_ENERGY_TO_EXPLOSION_STRENGTH_Y, this.energy);
            EntityPlayer entityPlayer = CommonProxy.getFakePlayer(null, (WorldServer)world, this.getBlockPos());
            world.func_72885_a((Entity)entityPlayer, this.x, this.y, this.z, (float)explosionStrength, true, true);
            this.doIrradiation(world, explosionStrength, (float)explosionStrength);
            this.isDead = true;
        }
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.id = tagCompound.func_74762_e("id");
        try {
            this.directionCurrentMotion = EnumFacing.valueOf((String)tagCompound.func_74779_i("direction"));
        }
        catch (Exception exception) {
            WarpDrive.logger.error(String.format("Invalid direction %s in ParticleBunch NBT %s", tagCompound.func_74779_i("direction"), tagCompound));
        }
        this.vectorCurrentMotion = Vector3.createFromNBT(tagCompound.func_74775_l("vector"));
        this.energy = tagCompound.func_74769_h("energy");
        this.tickFreeFlight = tagCompound.func_74762_e("freeFlight_ticks");
        this.vectorFreeFlightStart = tagCompound.func_74764_b("freeFlightStart") ? Vector3.createFromNBT(tagCompound.func_74775_l("freeFlightStart")) : null;
    }

    @Override
    public NBTTagCompound writeToNBT(@Nonnull NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74768_a("id", this.id);
        tagCompound.func_74778_a("direction", this.directionCurrentMotion.name());
        tagCompound.func_74782_a("vector", (NBTBase)this.vectorCurrentMotion.writeToNBT(new NBTTagCompound()));
        tagCompound.func_74780_a("energy", this.energy);
        tagCompound.func_74768_a("freeFlight_ticks", this.tickFreeFlight);
        if (this.vectorFreeFlightStart != null) {
            tagCompound.func_74782_a("freeFlightStart", (NBTBase)this.vectorFreeFlightStart.writeToNBT(new NBTTagCompound()));
        }
        return tagCompound;
    }

    @Override
    public int hashCode() {
        return this.id;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ParticleBunch) {
            ParticleBunch particleBunch = (ParticleBunch)object;
            return this.id == particleBunch.id && this.x == particleBunch.x && this.y == particleBunch.y && this.z == particleBunch.z;
        }
        return false;
    }

    @Override
    public String toString() {
        return String.format("%s/%d @ (%.2f %.2f %.2f) energy %.5f", this.getClass().getSimpleName(), this.entityId, this.x, this.y, this.z, this.energy);
    }
}

