/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.data.EnumTier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;

public class ReactorFace
implements IStringSerializable {
    public static final ReactorFace UNKNOWN;
    public final EnumTier enumTier;
    public final int indexStability;
    public final String name;
    public final int x;
    public final int y;
    public final int z;
    public final EnumFacing facingLaserProperty;
    public static final int maxInstabilities;
    private static final HashMap<String, ReactorFace> NAME_MAP;
    private static final HashMap<EnumTier, ReactorFace[]> FACES_BY_TIER;
    private static final HashMap<EnumTier, ReactorFace[]> LASERS_BY_TIER;
    private static final ReactorFace[] LASERS;

    private static void addCoreBlocks(EnumTier enumTier, int radius, int xOffset, int yOffset, int zOffset) {
        double sqRadiusHigh = ((double)radius + 0.5) * ((double)radius + 0.5);
        int radiusCeil = radius + 1;
        for (int x = -radiusCeil; x <= radiusCeil; ++x) {
            double x2 = ((double)x + 0.5) * ((double)x + 0.5);
            for (int y = -radiusCeil; y <= radiusCeil; ++y) {
                double x2y2 = x2 + ((double)y + 0.5) * ((double)y + 0.5);
                for (int z = -radiusCeil; z <= radiusCeil; ++z) {
                    double sqRange = x2y2 + ((double)z + 0.5) * ((double)z + 0.5);
                    if (sqRange > sqRadiusHigh) continue;
                    new ReactorFace(enumTier, -1, String.format("core.%s.[%d,%d,%d]", enumTier.func_176610_l(), x, y, z), xOffset + x, yOffset + y, zOffset + z, null);
                }
            }
        }
    }

    ReactorFace(EnumTier enumTier, int indexStability, String name, int x, int y, int z, EnumFacing facingLaserProperty) {
        this.enumTier = enumTier;
        this.indexStability = indexStability;
        this.name = name;
        this.x = x;
        this.y = y;
        this.z = z;
        this.facingLaserProperty = facingLaserProperty;
        NAME_MAP.put(name, this);
        if (facingLaserProperty != null) {
            new ReactorFace(enumTier, -1, name + ".lens", x - facingLaserProperty.func_82601_c(), y - facingLaserProperty.func_96559_d(), z - facingLaserProperty.func_82599_e(), null);
        }
    }

    @Nonnull
    public static ReactorFace[] get(@Nonnull EnumTier tier) {
        return FACES_BY_TIER.get((Object)tier);
    }

    @Nonnull
    public static ReactorFace[] getLasers() {
        return LASERS;
    }

    @Nonnull
    public static ReactorFace[] getLasers(@Nonnull EnumTier tier) {
        return LASERS_BY_TIER.get((Object)tier);
    }

    @Nonnull
    public String func_176610_l() {
        return this.name;
    }

    public static ReactorFace get(String name) {
        return NAME_MAP.get(name);
    }

    static {
        NAME_MAP = new HashMap();
        UNKNOWN = new ReactorFace(null, -1, "unknown", 0, 0, 0, null);
        new ReactorFace(EnumTier.BASIC, 0, "laser.basic.south", 0, 0, -2, EnumFacing.NORTH);
        new ReactorFace(EnumTier.BASIC, 1, "laser.basic.north", 0, 0, 2, EnumFacing.SOUTH);
        new ReactorFace(EnumTier.BASIC, 2, "laser.basic.east", -2, 0, 0, EnumFacing.WEST);
        new ReactorFace(EnumTier.BASIC, 3, "laser.basic.west", 2, 0, 0, EnumFacing.EAST);
        new ReactorFace(EnumTier.ADVANCED, 0, "laser.advanced.south+", 1, 2, -3, EnumFacing.NORTH);
        new ReactorFace(EnumTier.ADVANCED, 1, "laser.advanced.south-", -1, 4, -3, EnumFacing.NORTH);
        new ReactorFace(EnumTier.ADVANCED, 2, "laser.advanced.north-", -1, 2, 3, EnumFacing.SOUTH);
        new ReactorFace(EnumTier.ADVANCED, 3, "laser.advanced.north+", 1, 4, 3, EnumFacing.SOUTH);
        new ReactorFace(EnumTier.ADVANCED, 4, "laser.advanced.east-", -3, 2, -1, EnumFacing.WEST);
        new ReactorFace(EnumTier.ADVANCED, 5, "laser.advanced.east+", -3, 4, 1, EnumFacing.WEST);
        new ReactorFace(EnumTier.ADVANCED, 6, "laser.advanced.west+", 3, 2, 1, EnumFacing.EAST);
        new ReactorFace(EnumTier.ADVANCED, 7, "laser.advanced.west-", 3, 4, -1, EnumFacing.EAST);
        ReactorFace.addCoreBlocks(EnumTier.ADVANCED, 1, 0, 3, 0);
        new ReactorFace(EnumTier.SUPERIOR, 0, "laser.superior.south+", 1, 3, -4, EnumFacing.NORTH);
        new ReactorFace(EnumTier.SUPERIOR, 1, "laser.superior.south-", -1, 5, -4, EnumFacing.NORTH);
        new ReactorFace(EnumTier.SUPERIOR, 2, "laser.superior.north-", -1, 3, 4, EnumFacing.SOUTH);
        new ReactorFace(EnumTier.SUPERIOR, 3, "laser.superior.north+", 1, 5, 4, EnumFacing.SOUTH);
        new ReactorFace(EnumTier.SUPERIOR, 4, "laser.superior.east-", -4, 3, -1, EnumFacing.WEST);
        new ReactorFace(EnumTier.SUPERIOR, 5, "laser.superior.east+", -4, 5, 1, EnumFacing.WEST);
        new ReactorFace(EnumTier.SUPERIOR, 6, "laser.superior.west+", 4, 3, 1, EnumFacing.EAST);
        new ReactorFace(EnumTier.SUPERIOR, 7, "laser.superior.west-", 4, 5, -1, EnumFacing.EAST);
        new ReactorFace(EnumTier.SUPERIOR, 8, "laser.superior.south--", -2, 2, -4, EnumFacing.NORTH);
        new ReactorFace(EnumTier.SUPERIOR, 9, "laser.superior.south++", 2, 6, -4, EnumFacing.NORTH);
        new ReactorFace(EnumTier.SUPERIOR, 10, "laser.superior.north++", 2, 2, 4, EnumFacing.SOUTH);
        new ReactorFace(EnumTier.SUPERIOR, 11, "laser.superior.north--", -2, 6, 4, EnumFacing.SOUTH);
        new ReactorFace(EnumTier.SUPERIOR, 12, "laser.superior.east++", -4, 2, 2, EnumFacing.WEST);
        new ReactorFace(EnumTier.SUPERIOR, 13, "laser.superior.east--", -4, 6, -2, EnumFacing.WEST);
        new ReactorFace(EnumTier.SUPERIOR, 14, "laser.superior.west--", 4, 2, -2, EnumFacing.EAST);
        new ReactorFace(EnumTier.SUPERIOR, 15, "laser.superior.west++", 4, 6, 2, EnumFacing.EAST);
        ReactorFace.addCoreBlocks(EnumTier.SUPERIOR, 2, 0, 4, 0);
        HashMap facesByTiers = new HashMap(EnumTier.length);
        HashMap lasersByTiers = new HashMap(EnumTier.length);
        for (EnumTier tierLoop : EnumTier.values()) {
            facesByTiers.put(tierLoop, new ArrayList(16));
            lasersByTiers.put(tierLoop, new ArrayList(16));
        }
        for (ReactorFace reactorFace : NAME_MAP.values()) {
            if (reactorFace.enumTier == null) continue;
            ((ArrayList)facesByTiers.get((Object)reactorFace.enumTier)).add(reactorFace);
            if (reactorFace.indexStability < 0) continue;
            ((ArrayList)lasersByTiers.get((Object)reactorFace.enumTier)).add(reactorFace);
        }
        FACES_BY_TIER = new HashMap(EnumTier.length);
        for (Map.Entry entry : facesByTiers.entrySet()) {
            FACES_BY_TIER.put((EnumTier)((Object)entry.getKey()), ((ArrayList)entry.getValue()).toArray(new ReactorFace[0]));
        }
        int max = 0;
        LASERS_BY_TIER = new HashMap(EnumTier.length);
        ArrayList arrayList = new ArrayList(32);
        for (Map.Entry entry : lasersByTiers.entrySet()) {
            LASERS_BY_TIER.put((EnumTier)((Object)entry.getKey()), ((ArrayList)entry.getValue()).toArray(new ReactorFace[0]));
            arrayList.addAll((Collection)entry.getValue());
            max = Math.max(max, ((ArrayList)entry.getValue()).size());
        }
        LASERS = arrayList.toArray(new ReactorFace[0]);
        maxInstabilities = max;
    }
}

