/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.block.atomic.BlockAcceleratorControlPoint;
import cr0s.warpdrive.block.atomic.BlockElectromagnetPlain;
import cr0s.warpdrive.block.atomic.BlockParticlesCollider;
import cr0s.warpdrive.block.atomic.BlockParticlesInjector;
import cr0s.warpdrive.block.atomic.BlockVoidShellPlain;
import cr0s.warpdrive.block.atomic.TileEntityAcceleratorControlPoint;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.data.VectorI;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TrajectoryPoint
extends VectorI {
    public static final int NO_TYPE = 0;
    public static final int TIER_NORMAL = 1;
    public static final int TIER_ADVANCED = 2;
    public static final int TIER_SUPERIOR = 3;
    public static final int MASK_TIERS = 3;
    public static final int MAGNETS_HORIZONTAL = 4;
    public static final int MAGNETS_VERTICAL = 8;
    public static final int MASK_MAGNETS_BOTH = 12;
    public static final int IS_INPUT_FORWARD = 16;
    public static final int IS_INPUT_BACKWARD = 32;
    public static final int MASK_IS_INPUT = 48;
    public static final int IS_OUTPUT_FORWARD = 64;
    public static final int IS_OUTPUT_BACKWARD = 128;
    public static final int MASK_IS_OUTPUT = 192;
    public static final int IS_COLLIDER = 256;
    public static final int IS_TRANSFER_PIPE = 512;
    public static final int NEEDS_REEVALUATION = 1024;
    public static final int ERROR_NONE = 0;
    public static final int ERROR_DOUBLE_JUNCTION = 65536;
    public static final int ERROR_VERTICAL_JUNCTION = 131072;
    public static final int ERROR_MISSING_TURNING_MAGNET = 262144;
    public static final int ERROR_MISSING_MAIN_MAGNET = 524288;
    public static final int ERROR_MISSING_CORNER_MAGNET = 0x100000;
    public static final int ERROR_MISSING_COLLIDER = 0x200000;
    public static final int ERROR_MISSING_VOID_SHELL = 0x400000;
    public static final int ERROR_TOO_MANY_VOID_SHELLS = 0x800000;
    public static final int MASK_ERRORS = -65536;
    public final int type;
    public final VectorI vControlPoint;
    public final int controlChannel;
    public final EnumFacing directionForward;
    public final EnumFacing directionBackward;
    public final VectorI vJunctionForward;
    public final VectorI vJunctionBackward;

    public TrajectoryPoint(@Nonnull World world, @Nonnull VectorI vPosition, @Nonnull EnumFacing directionForward) {
        this(world, vPosition.x, vPosition.y, vPosition.z, directionForward);
    }

    public TrajectoryPoint(int x, int y, int z, int type, VectorI vControlPoint, int controlChannel, EnumFacing directionForward, EnumFacing directionBackward, VectorI vJunctionForward, VectorI vJunctionBackward) {
        super(x, y, z);
        this.type = type;
        this.vControlPoint = vControlPoint;
        this.controlChannel = controlChannel;
        this.directionForward = directionForward;
        this.directionBackward = directionBackward;
        this.vJunctionForward = vJunctionForward;
        this.vJunctionBackward = vJunctionBackward;
    }

    private TrajectoryPoint(@Nonnull World world, int x, int y, int z, @Nonnull EnumFacing directionMain) {
        super(x, y, z);
        int tierLeft;
        int tierUp;
        int typeNew = 0;
        BlockPos blockPos = new BlockPos(x, y, z);
        Block blockCore = world.func_180495_p(blockPos).func_177230_c();
        if (!(blockCore instanceof BlockVoidShellPlain)) {
            typeNew |= 0x400000;
        }
        EnumFacing directionLeft = directionMain.func_176735_f();
        EnumFacing directionRight = directionMain.func_176746_e();
        Block blockForward = world.func_180495_p(blockPos.func_177972_a(directionMain)).func_177230_c();
        Block blockUp = world.func_180495_p(blockPos.func_177984_a()).func_177230_c();
        Block blockDown = world.func_180495_p(blockPos.func_177977_b()).func_177230_c();
        Block blockLeft = world.func_180495_p(blockPos.func_177972_a(directionLeft)).func_177230_c();
        Block blockRight = world.func_180495_p(blockPos.func_177972_a(directionRight)).func_177230_c();
        int tier = 0;
        if (blockUp instanceof BlockElectromagnetPlain && blockDown instanceof BlockElectromagnetPlain && (tierUp = ((BlockElectromagnetPlain)blockUp).enumTier.getIndex()) == ((BlockElectromagnetPlain)blockDown).enumTier.getIndex()) {
            tier = tier == 0 || tier == tierUp ? tierUp : -1;
            typeNew |= 8;
        }
        if (blockLeft instanceof BlockElectromagnetPlain && blockRight instanceof BlockElectromagnetPlain && (tierLeft = ((BlockElectromagnetPlain)blockLeft).enumTier.getIndex()) == ((BlockElectromagnetPlain)blockRight).enumTier.getIndex()) {
            tier = tier == 0 || tier == tierLeft ? tierLeft : -1;
            typeNew |= 4;
        }
        TurnEvaluator turnEvaluator = new TurnEvaluator(world, x, y, z, directionMain, typeNew, directionLeft, directionRight, blockForward, blockUp, blockDown, blockLeft, blockRight, tier);
        typeNew = turnEvaluator.typeNew;
        boolean isShellValid = turnEvaluator.isShellValid;
        boolean isTurning = turnEvaluator.isTurning;
        boolean isForward = turnEvaluator.isForward;
        this.directionForward = turnEvaluator.directionForward;
        this.directionBackward = turnEvaluator.directionBackward;
        VectorI new_vControlPoint = null;
        int new_controlChannel = -1;
        if (isShellValid) {
            for (EnumFacing direction : EnumFacing.field_82609_l) {
                BlockPos blockPosOffset = blockPos.func_177967_a(direction, 2);
                Block block = world.func_180495_p(blockPosOffset).func_177230_c();
                if (!(block instanceof BlockAcceleratorControlPoint) || block instanceof BlockParticlesInjector) continue;
                TileEntity tileEntity = world.func_175625_s(blockPosOffset);
                if (!(tileEntity instanceof TileEntityAcceleratorControlPoint) || !((TileEntityAcceleratorControlPoint)tileEntity).getIsEnabled()) break;
                if ((typeNew & 0xC) == 0) {
                    typeNew |= 0x80000;
                    break;
                }
                new_vControlPoint = new VectorI(blockPos.func_177967_a(direction, 2));
                new_controlChannel = ((TileEntityAcceleratorControlPoint)new_vControlPoint.getTileEntity((IBlockAccess)world)).getControlChannel();
                break;
            }
        }
        this.vControlPoint = new_vControlPoint;
        this.controlChannel = new_controlChannel;
        boolean isInput = false;
        boolean isOutput = false;
        if (isShellValid) {
            NodeEvaluator nodeEvaluator = new NodeEvaluator(world, x, y, z, typeNew, tier, isTurning);
            typeNew = nodeEvaluator.typeNew;
            if (nodeEvaluator.isCollider && this.vControlPoint != null) {
                typeNew |= 0x100;
            }
            isOutput = nodeEvaluator.isOutput && this.vControlPoint != null;
            isInput = nodeEvaluator.isInput;
        }
        if (!isInput && !isOutput) {
            this.vJunctionBackward = null;
            this.vJunctionForward = null;
        } else if (isTurning) {
            if (isForward) {
                typeNew |= isInput ? 16 : 64;
                this.vJunctionBackward = null;
                this.vJunctionForward = new VectorI(directionMain);
            } else {
                typeNew |= isInput ? 32 : 128;
                this.vJunctionForward = null;
                this.vJunctionBackward = this.directionForward == directionRight ? new VectorI(directionLeft) : new VectorI(directionRight);
            }
        } else {
            typeNew |= isInput ? 16 : 64;
            Block blockForwardLeft = world.func_180495_p(new BlockPos(x + directionMain.func_82601_c() + directionLeft.func_82601_c(), y, z + directionMain.func_82599_e() + directionLeft.func_82599_e())).func_177230_c();
            Block blockForwardRight = world.func_180495_p(new BlockPos(x + directionMain.func_82601_c() + directionRight.func_82601_c(), y, z + directionMain.func_82599_e() + directionRight.func_82599_e())).func_177230_c();
            Block blockBackwardLeft = world.func_180495_p(new BlockPos(x - directionMain.func_82601_c() + directionLeft.func_82601_c(), y, z - directionMain.func_82599_e() + directionLeft.func_82599_e())).func_177230_c();
            Block blockBackwardRight = world.func_180495_p(new BlockPos(x - directionMain.func_82601_c() + directionRight.func_82601_c(), y, z - directionMain.func_82599_e() + directionRight.func_82599_e())).func_177230_c();
            if (blockForwardLeft instanceof BlockVoidShellPlain) {
                typeNew |= isInput ? 16 : 64;
                this.vJunctionForward = new VectorI(directionLeft).translate(directionMain);
                if (blockBackwardLeft instanceof BlockVoidShellPlain) {
                    typeNew |= isInput ? 32 : 128;
                    this.vJunctionBackward = new VectorI(directionLeft).translate(directionMain, -1);
                } else {
                    this.vJunctionBackward = null;
                }
            } else if (blockForwardRight instanceof BlockVoidShellPlain) {
                typeNew |= isInput ? 16 : 64;
                this.vJunctionForward = new VectorI(directionRight).translate(directionMain);
                if (blockBackwardRight instanceof BlockVoidShellPlain) {
                    typeNew |= isInput ? 32 : 128;
                    this.vJunctionBackward = new VectorI(directionRight).translate(directionMain, -1);
                } else {
                    this.vJunctionBackward = null;
                }
            } else {
                this.vJunctionForward = null;
                if (blockBackwardLeft instanceof BlockVoidShellPlain) {
                    typeNew |= isInput ? 32 : 128;
                    this.vJunctionBackward = new VectorI(directionLeft).translate(directionMain, -1);
                } else if (blockBackwardRight instanceof BlockVoidShellPlain) {
                    typeNew |= isInput ? 32 : 128;
                    this.vJunctionBackward = new VectorI(directionRight).translate(directionMain, -1);
                } else {
                    this.vJunctionBackward = null;
                }
            }
        }
        if (tier == 1) {
            typeNew |= 1;
        } else if (tier == 2) {
            typeNew |= 2;
        } else if (tier == 3) {
            typeNew |= 3;
        }
        this.type = typeNew;
    }

    public TrajectoryPoint(@Nonnull World world, @Nonnull TrajectoryPoint trajectoryPoint, boolean isForward) {
        boolean isShellValid;
        int tierUp;
        int typeNew = 512;
        this.x = trajectoryPoint.x + (isForward ? trajectoryPoint.vJunctionForward.x : trajectoryPoint.vJunctionBackward.x);
        this.y = trajectoryPoint.y + (isForward ? trajectoryPoint.vJunctionForward.y : trajectoryPoint.vJunctionBackward.y);
        this.z = trajectoryPoint.z + (isForward ? trajectoryPoint.vJunctionForward.z : trajectoryPoint.vJunctionBackward.z);
        this.directionForward = isForward ? trajectoryPoint.directionBackward.func_176734_d() : trajectoryPoint.directionForward.func_176734_d();
        this.directionBackward = this.directionForward.func_176734_d();
        this.vJunctionForward = isForward ? trajectoryPoint.vJunctionForward : trajectoryPoint.vJunctionBackward;
        this.vJunctionBackward = null;
        int tier = (trajectoryPoint.type & 3) + ((trajectoryPoint.type & 0x30) != 0 ? -1 : 0) + ((trajectoryPoint.type & 0xC0) != 0 ? 1 : 0);
        if (tier <= 0 || tier > 3) {
            tier = 0;
        }
        boolean isStraightLine = this.vJunctionForward.x == -this.directionBackward.func_82601_c() && this.vJunctionForward.z == -this.directionBackward.func_82599_e();
        Block blockForward = world.func_180495_p(new BlockPos(this.x + this.vJunctionForward.x, this.y, this.z + this.vJunctionForward.z)).func_177230_c();
        Block blockBack = world.func_180495_p(new BlockPos(this.x + this.directionBackward.func_82601_c(), this.y, this.z + this.directionBackward.func_82599_e())).func_177230_c();
        Block blockUp = world.func_180495_p(new BlockPos(this.x, this.y + 1, this.z)).func_177230_c();
        Block blockDown = world.func_180495_p(new BlockPos(this.x, this.y - 1, this.z)).func_177230_c();
        boolean hasVerticalMagnets = false;
        if (blockUp instanceof BlockElectromagnetPlain && blockDown instanceof BlockElectromagnetPlain && (tierUp = ((BlockElectromagnetPlain)blockUp).enumTier.getIndex()) == ((BlockElectromagnetPlain)blockDown).enumTier.getIndex()) {
            hasVerticalMagnets = tier == tierUp;
        }
        boolean isForwardOk = blockForward instanceof BlockVoidShellPlain;
        boolean isBackOk = blockBack instanceof BlockVoidShellPlain;
        boolean bl = isShellValid = !(blockUp instanceof BlockVoidShellPlain) && !(blockDown instanceof BlockVoidShellPlain) && isForwardOk && isBackOk && tier != 0;
        if (blockUp instanceof BlockVoidShellPlain || blockDown instanceof BlockVoidShellPlain) {
            typeNew |= 0x20000;
        }
        if (!isForwardOk || !isBackOk) {
            typeNew |= 0x400000;
        }
        boolean isTurning = false;
        if (hasVerticalMagnets && isStraightLine) {
            EnumFacing directionMain = this.directionBackward.func_176734_d();
            EnumFacing directionLeft = directionMain.func_176735_f();
            EnumFacing directionRight = directionLeft.func_176746_e();
            Block blockLeft = world.func_180495_p(new BlockPos(this.x + directionLeft.func_82601_c(), this.y, this.z + directionLeft.func_82599_e())).func_177230_c();
            Block blockRight = world.func_180495_p(new BlockPos(this.x + directionRight.func_82601_c(), this.y, this.z + directionRight.func_82599_e())).func_177230_c();
            isTurning = blockLeft instanceof BlockVoidShellPlain || blockRight instanceof BlockVoidShellPlain;
        }
        this.vControlPoint = null;
        this.controlChannel = -1;
        if (isShellValid && hasVerticalMagnets) {
            NodeEvaluator nodeEvaluator = new NodeEvaluator(world, this.x, this.y, this.z, typeNew, tier, isTurning);
            typeNew = nodeEvaluator.typeNew;
            if (nodeEvaluator.isInput || nodeEvaluator.isOutput) {
                typeNew |= 0x400;
            }
        }
        if (tier == 1) {
            typeNew |= 1;
        } else if (tier == 2) {
            typeNew |= 2;
        } else if (tier == 3) {
            typeNew |= 3;
        }
        this.type = typeNew;
    }

    public boolean needsReevaluation() {
        return (this.type & 0x400) != 0;
    }

    public boolean hasNoMissingVoidShells() {
        return (this.type & 0x400000) == 0;
    }

    public int getTier() {
        return TrajectoryPoint.getTier(this.type);
    }

    public static int getTier(int type) {
        switch (type & 3) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    public int getMagnetsCount() {
        switch (this.type & 0xFFFF000C) {
            case 4: 
            case 8: {
                return 1;
            }
            case 12: {
                return 2;
            }
        }
        return 0;
    }

    public boolean isTransferPipe() {
        return (this.type & 0x200) != 0;
    }

    public boolean isCollider() {
        return TrajectoryPoint.isCollider(this.type);
    }

    public boolean getStatus(WarpDriveText textReason) {
        int errorCode = this.type & 0xFFFF0000;
        if (errorCode != 0) {
            String strReasonBefore = textReason.func_150260_c();
            String strPosition = String.format("(%d %d %d)", this.x, this.y, this.z);
            if ((errorCode & 0x10000) != 0) {
                textReason.append(Commons.getStyleWarning(), "warpdrive.accelerator.status_line.invalid_double_junction", strPosition);
            }
            if ((errorCode & 0x20000) != 0) {
                textReason.append(Commons.getStyleWarning(), "warpdrive.accelerator.status_line.invalid_vertical_junction", strPosition);
            }
            if ((errorCode & 0x40000) != 0) {
                textReason.append(Commons.getStyleWarning(), "warpdrive.accelerator.status_line.missing_turning_magnet", strPosition);
            }
            if ((errorCode & 0x80000) != 0) {
                textReason.append(Commons.getStyleWarning(), "warpdrive.accelerator.status_line.missing_main_magnets", strPosition);
            }
            if ((errorCode & 0x100000) != 0) {
                textReason.append(Commons.getStyleWarning(), "warpdrive.accelerator.status_line.missing_corner_magnets", strPosition);
            }
            if ((errorCode & 0x200000) != 0) {
                textReason.append(Commons.getStyleWarning(), "warpdrive.accelerator.status_line.missing_collider_block", strPosition);
            }
            if ((errorCode & 0x400000) != 0) {
                textReason.append(Commons.getStyleWarning(), "warpdrive.accelerator.status_line.missing_void_shell", strPosition);
            }
            if ((errorCode & 0x800000) != 0) {
                textReason.append(Commons.getStyleWarning(), "warpdrive.accelerator.status_line.too_many_void_shells", strPosition);
            }
            if (strReasonBefore.equals(textReason.func_150260_c())) {
                textReason.append(Commons.getStyleWarning(), "warpdrive.accelerator.status_line.invalid_error_code", errorCode, strPosition);
            }
            return false;
        }
        return true;
    }

    public static boolean isCollider(int type) {
        return (type & 0x100) != 0;
    }

    public static boolean isInput(int type) {
        return (type & 0x30) != 0;
    }

    public static boolean isOutput(int type) {
        return (type & 0xC0) != 0;
    }

    public Vector3 getJunctionOut(EnumFacing directionCurrent) {
        if ((this.type & 0xFFFF0000) != 0) {
            return null;
        }
        if ((this.type & 0x40) != 0 && directionCurrent.func_176734_d().equals((Object)this.directionBackward)) {
            return new Vector3(this.vJunctionForward.x, this.vJunctionForward.y, this.vJunctionForward.z).normalize();
        }
        if ((this.type & 0x80) != 0 && directionCurrent.func_176734_d().equals((Object)this.directionForward)) {
            return new Vector3(this.vJunctionBackward.x, this.vJunctionBackward.y, this.vJunctionBackward.z).normalize();
        }
        return null;
    }

    public EnumFacing getTurnedDirection(EnumFacing directionCurrent) {
        if ((this.type & 0x40000) != 0) {
            return null;
        }
        if (this.directionForward.func_176734_d().equals((Object)this.directionBackward)) {
            return null;
        }
        if (directionCurrent.equals((Object)this.directionForward.func_176734_d())) {
            return this.directionBackward;
        }
        if (directionCurrent.equals((Object)this.directionBackward.func_176734_d())) {
            return this.directionForward;
        }
        return null;
    }

    public EnumFacing getJunctionIn(Vector3 vectorCurrent) {
        if ((this.type & 0xFFFF0000) != 0) {
            return null;
        }
        if ((this.type & 0x30) == 0) {
            return null;
        }
        VectorI vJunctionRequired = new VectorI((int)(-Math.signum(vectorCurrent.x)), (int)(-Math.signum(vectorCurrent.y)), (int)(-Math.signum(vectorCurrent.z)));
        if ((this.type & 0x10) != 0 && vJunctionRequired.equals(this.vJunctionBackward)) {
            return this.directionForward;
        }
        if ((this.type & 0x20) != 0 && vJunctionRequired.equals(this.vJunctionBackward)) {
            return this.directionBackward;
        }
        return null;
    }

    @Override
    public TrajectoryPoint clone() {
        return new TrajectoryPoint(this.x, this.y, this.z, this.type, this.vControlPoint, this.controlChannel, this.directionForward, this.directionBackward, this.vJunctionForward, this.vJunctionBackward);
    }

    public VectorI getVectorI() {
        return new VectorI(this.x, this.y, this.z);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof VectorI) {
            VectorI vector = (VectorI)object;
            return this.x == vector.x && this.y == vector.y && this.z == vector.z;
        }
        return false;
    }

    @Override
    public String toString() {
        return String.format("TrajectoryPoint [%d %d %d] %8x %5s %5s %s %s %s tier%d %s", this.x, this.y, this.z, this.type, this.directionForward == null ? "-null-" : this.directionForward.toString(), this.directionBackward == null ? "-null-" : this.directionBackward.toString(), this.vJunctionForward == null ? "-null-" : this.vJunctionForward.toString(), this.vJunctionBackward == null ? "-null-" : this.vJunctionBackward.toString(), this.vControlPoint == null ? "-null-" : this.vControlPoint.toString(), this.type & 3, this.hasNoMissingVoidShells());
    }

    private class TurnEvaluator {
        public int typeNew;
        public boolean isForward;
        public boolean isShellValid;
        public boolean isTurning;
        public EnumFacing directionForward;
        public EnumFacing directionBackward;

        public TurnEvaluator(World world, int x, int y, int z, EnumFacing directionMain, int typeOriginal, EnumFacing directionLeft, EnumFacing directionRight, Block blockForward, Block blockUp, Block blockDown, Block blockLeft, Block blockRight, int tier) {
            this.typeNew = typeOriginal;
            this.isForward = blockForward instanceof BlockVoidShellPlain;
            boolean isLeftTurn = blockLeft instanceof BlockVoidShellPlain;
            boolean isRightTurn = blockRight instanceof BlockVoidShellPlain;
            boolean bl = this.isShellValid = !(blockUp instanceof BlockVoidShellPlain) && !(blockDown instanceof BlockVoidShellPlain) && (!this.isForward || !isLeftTurn || !isRightTurn);
            if (blockUp instanceof BlockVoidShellPlain || blockDown instanceof BlockVoidShellPlain) {
                this.typeNew |= 0x20000;
            }
            if (this.isForward && isLeftTurn && isRightTurn) {
                this.typeNew |= 0x10000;
            }
            this.isTurning = false;
            if (this.isShellValid && (isLeftTurn || isRightTurn)) {
                Block blockForwardLeft = world.func_180495_p(new BlockPos(x + directionMain.func_82601_c() + directionLeft.func_82601_c(), y, z + directionMain.func_82599_e() + directionLeft.func_82599_e())).func_177230_c();
                Block blockForwardRight = world.func_180495_p(new BlockPos(x + directionMain.func_82601_c() + directionRight.func_82601_c(), y, z + directionMain.func_82599_e() + directionRight.func_82599_e())).func_177230_c();
                Block blockBackwardLeft = world.func_180495_p(new BlockPos(x - directionMain.func_82601_c() + directionLeft.func_82601_c(), y, z - directionMain.func_82599_e() + directionLeft.func_82599_e())).func_177230_c();
                Block blockBackwardRight = world.func_180495_p(new BlockPos(x - directionMain.func_82601_c() + directionRight.func_82601_c(), y, z - directionMain.func_82599_e() + directionRight.func_82599_e())).func_177230_c();
                if (tier > 0 && blockForwardLeft instanceof BlockElectromagnetPlain && tier == ((BlockElectromagnetPlain)blockForwardLeft).enumTier.getIndex() && blockForwardRight instanceof BlockElectromagnetPlain && tier == ((BlockElectromagnetPlain)blockForwardRight).enumTier.getIndex() && blockBackwardLeft instanceof BlockElectromagnetPlain && tier == ((BlockElectromagnetPlain)blockBackwardLeft).enumTier.getIndex() && blockBackwardRight instanceof BlockElectromagnetPlain && tier == ((BlockElectromagnetPlain)blockBackwardRight).enumTier.getIndex() && (this.typeNew & 8) == 8) {
                    boolean bl2 = this.isTurning = !(!this.isForward && !(blockForward instanceof BlockElectromagnetPlain) && !(blockForward instanceof BlockParticlesInjector) || !isLeftTurn && !(blockLeft instanceof BlockElectromagnetPlain) && !(blockLeft instanceof BlockParticlesInjector) || !isRightTurn && !(blockRight instanceof BlockElectromagnetPlain) && !(blockRight instanceof BlockParticlesInjector));
                }
                if (!this.isTurning) {
                    if (!(isLeftTurn && (blockBackwardLeft instanceof BlockVoidShellPlain || blockForwardLeft instanceof BlockVoidShellPlain) || isRightTurn && (blockBackwardRight instanceof BlockVoidShellPlain || blockForwardRight instanceof BlockVoidShellPlain))) {
                        this.typeNew |= 0x40000;
                    }
                } else {
                    this.typeNew |= 0xC;
                }
            }
            if (!this.isTurning && (this.typeNew & 0x40000) == 0) {
                this.directionForward = directionMain;
            } else if (isLeftTurn && !isRightTurn) {
                this.directionForward = directionLeft;
            } else if (!isLeftTurn && isRightTurn) {
                this.directionForward = directionRight;
            } else {
                assert (isLeftTurn && isRightTurn);
                Block blockUpRight = world.func_180495_p(new BlockPos(x + directionRight.func_82601_c(), y + 1, z + directionRight.func_82599_e())).func_177230_c();
                this.directionForward = blockUpRight instanceof BlockElectromagnetPlain && tier != ((BlockElectromagnetPlain)blockUpRight).enumTier.getIndex() ? directionLeft : directionRight;
            }
            this.directionBackward = directionMain.func_176734_d();
        }
    }

    private class NodeEvaluator {
        public int typeNew;
        public boolean isCollider;
        public boolean isInput;
        public boolean isOutput;

        public NodeEvaluator(World world, int x, int y, int z, int typeOriginal, int tierMain, boolean isTurning) {
            this.typeNew = typeOriginal;
            this.isInput = false;
            this.isOutput = false;
            int countVoidShell = 0;
            int countMainMagnet = 0;
            int countLowerMagnet = 0;
            int countHigherMagnet = 0;
            int countCollider = 0;
            for (int offsetX = -1; offsetX < 2; ++offsetX) {
                for (int offsetY = -1; offsetY < 2; ++offsetY) {
                    for (int offsetZ = -1; offsetZ < 2; ++offsetZ) {
                        int tierCheck;
                        Block blockCheck = world.func_180495_p(new BlockPos(x + offsetX, y + offsetY, z + offsetZ)).func_177230_c();
                        if (blockCheck instanceof BlockElectromagnetPlain) {
                            tierCheck = ((BlockElectromagnetPlain)blockCheck).enumTier.getIndex();
                            if (tierCheck == tierMain) {
                                ++countMainMagnet;
                                continue;
                            }
                            if (tierCheck > tierMain) {
                                ++countHigherMagnet;
                                continue;
                            }
                            ++countLowerMagnet;
                            continue;
                        }
                        if (blockCheck instanceof BlockVoidShellPlain) {
                            ++countVoidShell;
                            continue;
                        }
                        if (blockCheck instanceof BlockParticlesCollider) {
                            ++countCollider;
                            continue;
                        }
                        if (!(blockCheck instanceof BlockParticlesInjector) || (tierCheck = ((BlockParticlesInjector)blockCheck).enumTier.getIndex()) != tierMain) continue;
                        ++countMainMagnet;
                    }
                }
            }
            if (countCollider > 8) {
                if (countCollider < 12) {
                    this.typeNew |= 0x200000;
                } else if (countVoidShell < 3) {
                    this.typeNew |= 0x400000;
                } else if (countVoidShell > 3) {
                    this.typeNew |= 0x800000;
                } else if (countMainMagnet < 12) {
                    this.typeNew |= 0x80000;
                } else {
                    this.isCollider = true;
                }
            }
            if (tierMain != 0 && (countLowerMagnet > 8 || countHigherMagnet > 8)) {
                if (countMainMagnet < 9) {
                    this.typeNew |= 0x80000;
                } else if (countLowerMagnet < 12 && countHigherMagnet < 12) {
                    this.typeNew |= 0x100000;
                } else if (countLowerMagnet != 0 && countHigherMagnet != 0) {
                    this.typeNew |= 0x100000;
                } else if (isTurning && countVoidShell < 4) {
                    this.typeNew |= 0x400000;
                } else if (isTurning && countVoidShell > 4) {
                    this.typeNew |= 0x800000;
                } else if (!isTurning && countVoidShell < 5) {
                    this.typeNew |= 0x400000;
                } else if (!isTurning && countVoidShell > 6) {
                    this.typeNew |= 0x800000;
                } else if (countVoidShell + countMainMagnet != 15) {
                    this.typeNew |= 0x80000;
                } else {
                    this.isInput = countLowerMagnet > 0;
                    this.isOutput = countHigherMagnet > 0;
                }
            }
        }
    }
}

