/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.block.movement.TileEntityShipCore;
import cr0s.warpdrive.data.JumpShip;
import cr0s.warpdrive.data.VectorI;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Transformation
implements ITransformation {
    private final VectorI sourceCore;
    private final VectorI targetCore;
    private final VectorI move;
    private final byte rotationSteps;
    private final World targetWorld;
    private final int minX;
    private final int minY;
    private final int minZ;
    private final int maxX;
    private final int maxY;
    private final int maxZ;

    public Transformation(@Nonnull JumpShip ship, @Nonnull World targetWorld, int moveX, int moveY, int moveZ, byte rotationSteps) {
        this.sourceCore = new VectorI(ship.core);
        this.minX = ship.minX;
        this.minY = ship.minY;
        this.minZ = ship.minZ;
        this.maxX = ship.maxX;
        this.maxY = ship.maxY;
        this.maxZ = ship.maxZ;
        this.targetWorld = targetWorld;
        this.move = new VectorI(moveX, moveY, moveZ);
        this.targetCore = this.sourceCore.add(this.move);
        this.rotationSteps = (byte)((rotationSteps + 4) % 4);
    }

    @SideOnly(value=Side.CLIENT)
    public Transformation(@Nonnull TileEntityShipCore tileEntityShipCore, int moveX, int moveY, int moveZ, byte rotationSteps) {
        this.sourceCore = new VectorI(tileEntityShipCore);
        this.minX = tileEntityShipCore.minX;
        this.minY = tileEntityShipCore.minY;
        this.minZ = tileEntityShipCore.minZ;
        this.maxX = tileEntityShipCore.maxX;
        this.maxY = tileEntityShipCore.maxY;
        this.maxZ = tileEntityShipCore.maxZ;
        this.targetWorld = null;
        this.move = new VectorI(moveX, moveY, moveZ);
        this.targetCore = this.sourceCore.add(this.move);
        this.rotationSteps = (byte)((rotationSteps + 4) % 4);
    }

    @Override
    public World getTargetWorld() {
        return this.targetWorld;
    }

    @Override
    public byte getRotationSteps() {
        return this.rotationSteps;
    }

    @Override
    public float getRotationYaw() {
        return 90.0f * (float)this.rotationSteps;
    }

    @Override
    public boolean isInside(double x, double y, double z) {
        return (double)this.minX <= x && x <= (double)this.maxX + 1.0 && (double)this.minY <= y && y <= (double)this.maxY + 1.0 && (double)this.minZ <= z && z <= (double)this.maxZ + 1.0;
    }

    @Override
    public boolean isInside(int x, int y, int z) {
        return this.minX <= x && x <= this.maxX && this.minY <= y && y <= this.maxY && this.minZ <= z && z <= this.maxZ;
    }

    @Override
    public Vec3d apply(double sourceX, double sourceY, double sourceZ) {
        if (this.rotationSteps == 0) {
            return new Vec3d(sourceX + (double)this.move.x, sourceY + (double)this.move.y, sourceZ + (double)this.move.z);
        }
        double dX = sourceX - (double)this.sourceCore.x - 0.5;
        double dZ = sourceZ - (double)this.sourceCore.z - 0.5;
        switch (this.rotationSteps) {
            case 1: {
                return new Vec3d((double)this.targetCore.x + 0.5 - dZ, sourceY + (double)this.move.y, (double)this.targetCore.z + 0.5 + dX);
            }
            case 2: {
                return new Vec3d((double)this.targetCore.x + 0.5 - dX, sourceY + (double)this.move.y, (double)this.targetCore.z + 0.5 - dZ);
            }
            case 3: {
                return new Vec3d((double)this.targetCore.x + 0.5 + dZ, sourceY + (double)this.move.y, (double)this.targetCore.z + 0.5 - dX);
            }
        }
        return null;
    }

    @Override
    public BlockPos apply(int sourceX, int sourceY, int sourceZ) {
        if (this.rotationSteps == 0) {
            return new BlockPos(sourceX + this.move.x, sourceY + this.move.y, sourceZ + this.move.z);
        }
        int dX = sourceX - this.sourceCore.x;
        int dZ = sourceZ - this.sourceCore.z;
        switch (this.rotationSteps) {
            case 1: {
                return new BlockPos(this.targetCore.x - dZ, sourceY + this.move.y, this.targetCore.z + dX);
            }
            case 2: {
                return new BlockPos(this.targetCore.x - dX, sourceY + this.move.y, this.targetCore.z - dZ);
            }
            case 3: {
                return new BlockPos(this.targetCore.x + dZ, sourceY + this.move.y, this.targetCore.z - dX);
            }
        }
        return null;
    }

    @Override
    public BlockPos apply(TileEntity tileEntity) {
        return this.apply(tileEntity.func_174877_v());
    }

    @Override
    public BlockPos apply(BlockPos blockPos) {
        return this.apply(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
    }

    public void rotate(Entity entity) {
        if (this.rotationSteps == 0) {
            return;
        }
        entity.field_70177_z = (entity.field_70177_z + 270.0f * (float)this.rotationSteps) % 360.0f - 180.0f;
    }
}

