/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.render.AbstractEntityFX;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class Vector3
implements Cloneable {
    public double x;
    public double y;
    public double z;

    public Vector3() {
        this(0.0, 0.0, 0.0);
    }

    public Vector3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3(Entity entity) {
        this.x = entity.field_70165_t;
        this.y = entity.field_70163_u;
        this.z = entity.field_70161_v;
    }

    public Vector3(AbstractEntityFX entityFX) {
        this.x = entityFX.getX();
        this.y = entityFX.getY();
        this.z = entityFX.getZ();
    }

    public Vector3(TileEntity tileEntity) {
        this.x = tileEntity.func_174877_v().func_177958_n();
        this.y = tileEntity.func_174877_v().func_177956_o();
        this.z = tileEntity.func_174877_v().func_177952_p();
    }

    public Vector3(Vec3d vec3) {
        this.x = vec3.field_72450_a;
        this.y = vec3.field_72448_b;
        this.z = vec3.field_72449_c;
    }

    public Vector3(RayTraceResult rayTraceResult) {
        this.x = rayTraceResult.func_178782_a().func_177958_n();
        this.y = rayTraceResult.func_178782_a().func_177956_o();
        this.z = rayTraceResult.func_178782_a().func_177952_p();
    }

    public Vector3(BlockPos blockPos) {
        this.x = blockPos.func_177958_n();
        this.y = blockPos.func_177956_o();
        this.z = blockPos.func_177952_p();
    }

    public Vector3(EnumFacing direction) {
        this.x = direction.func_82601_c();
        this.y = direction.func_96559_d();
        this.z = direction.func_82599_e();
    }

    public int intX() {
        return (int)Math.floor(this.x);
    }

    public int intY() {
        return (int)Math.floor(this.y);
    }

    public int intZ() {
        return (int)Math.floor(this.z);
    }

    public Vector3 clone() {
        return new Vector3(this.x, this.y, this.z);
    }

    public Vec3d toVec3d() {
        return new Vec3d(this.x, this.y, this.z);
    }

    public double getMagnitude() {
        return Math.sqrt(this.getMagnitudeSquared());
    }

    public double getMagnitudeSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Vector3 normalize() {
        double d = this.getMagnitude();
        if (d != 0.0) {
            this.scale(1.0 / d);
        }
        return this;
    }

    public static double distance(Vector3 v1, Vector3 v2) {
        double dX = v1.x - v2.x;
        double dY = v1.y - v2.y;
        double dZ = v1.z - v2.z;
        return Math.sqrt(dX * dX + dY * dY + dZ * dZ);
    }

    public double distanceTo(Vector3 vector3) {
        double dX = vector3.x - this.x;
        double dY = vector3.y - this.y;
        double dZ = vector3.z - this.z;
        return Math.sqrt(dX * dX + dY * dY + dZ * dZ);
    }

    public double distanceTo_square(Vector3 vector3) {
        double dX = vector3.x - this.x;
        double dY = vector3.y - this.y;
        double dZ = vector3.z - this.z;
        return dX * dX + dY * dY + dZ * dZ;
    }

    public double distanceTo_square(Entity entity) {
        double dX = entity.field_70165_t - this.x;
        double dY = entity.field_70163_u - this.y;
        double dZ = entity.field_70161_v - this.z;
        return dX * dX + dY * dY + dZ * dZ;
    }

    public double distanceTo_square(AbstractEntityFX entityFX) {
        double var2 = entityFX.getX() - this.x;
        double var4 = entityFX.getY() - this.y;
        double var6 = entityFX.getZ() - this.z;
        return var2 * var2 + var4 * var4 + var6 * var6;
    }

    public Vector3 invert() {
        this.scale(-1.0);
        return this;
    }

    public Vector3 translate(Vec3d vector3) {
        this.x += vector3.field_72450_a;
        this.y += vector3.field_72448_b;
        this.z += vector3.field_72449_c;
        return this;
    }

    public Vector3 translate(Vector3 vector3) {
        this.x += vector3.x;
        this.y += vector3.y;
        this.z += vector3.z;
        return this;
    }

    public Vector3 translate(double amount) {
        this.x += amount;
        this.y += amount;
        this.z += amount;
        return this;
    }

    public Vector3 translate(EnumFacing side, double amount) {
        switch (side) {
            case DOWN: {
                this.y -= amount;
                break;
            }
            case UP: {
                this.y += amount;
                break;
            }
            case NORTH: {
                this.z -= amount;
                break;
            }
            case SOUTH: {
                this.z += amount;
                break;
            }
            case WEST: {
                this.x -= amount;
                break;
            }
            case EAST: {
                this.x += amount;
                break;
            }
        }
        return this;
    }

    public Vector3 translate(EnumFacing side) {
        this.x += (double)side.func_82601_c();
        this.y += (double)side.func_96559_d();
        this.z += (double)side.func_82599_e();
        return this;
    }

    public static Vector3 translate(Vector3 translate, Vector3 offset) {
        translate.x += offset.x;
        translate.y += offset.y;
        translate.z += offset.z;
        return translate;
    }

    public Vector3 translateFactor(Vector3 direction, double factor) {
        this.x += direction.x * factor;
        this.y += direction.y * factor;
        this.z += direction.z * factor;
        return this;
    }

    public Vector3 subtract(Vector3 amount) {
        return this.translate(amount.clone().invert());
    }

    public Vector3 scale(double amount) {
        this.x *= amount;
        this.y *= amount;
        this.z *= amount;
        return this;
    }

    public Vector3 scale(Vector3 amount) {
        this.x *= amount.x;
        this.y *= amount.y;
        this.z *= amount.z;
        return this;
    }

    public static Vector3 scale(Vector3 vector3, double amount) {
        return vector3.scale(amount);
    }

    public static Vector3 scale(Vector3 vector3, Vector3 amount) {
        return vector3.scale(amount);
    }

    public Vector3 round() {
        return new Vector3(Math.round(this.x), Math.round(this.y), Math.round(this.z));
    }

    public Vector3 ceil() {
        return new Vector3(Math.ceil(this.x), Math.ceil(this.y), Math.ceil(this.z));
    }

    public Vector3 floor() {
        return new Vector3(Math.floor(this.x), Math.floor(this.y), Math.floor(this.z));
    }

    public Vector3 toRound() {
        this.x = Math.round(this.x);
        this.y = Math.round(this.y);
        this.z = Math.round(this.z);
        return this;
    }

    public Vector3 toCeil() {
        this.x = Math.ceil(this.x);
        this.y = Math.ceil(this.y);
        this.z = Math.ceil(this.z);
        return this;
    }

    public Vector3 toFloor() {
        this.x = Math.floor(this.x);
        this.y = Math.floor(this.y);
        this.z = Math.floor(this.z);
        return this;
    }

    public BlockPos getBlockPos() {
        return new BlockPos(Math.floor(this.x), Math.floor(this.y), Math.floor(this.z));
    }

    public List<Entity> getEntitiesWithin(World world, Class<? extends Entity> clazz) {
        return world.func_72872_a(clazz, new AxisAlignedBB((double)this.intX(), (double)this.intY(), (double)this.intZ(), (double)(this.intX() + 1), (double)(this.intY() + 1), (double)(this.intZ() + 1)));
    }

    public Vector3 modifyPositionFromSide(EnumFacing side, double amount) {
        switch (side.ordinal()) {
            case 0: {
                this.y -= amount;
                break;
            }
            case 1: {
                this.y += amount;
                break;
            }
            case 2: {
                this.z -= amount;
                break;
            }
            case 3: {
                this.z += amount;
                break;
            }
            case 4: {
                this.x -= amount;
                break;
            }
            case 5: {
                this.x += amount;
                break;
            }
        }
        return this;
    }

    public Vector3 modifyPositionFromSide(EnumFacing side) {
        this.modifyPositionFromSide(side, 1.0);
        return this;
    }

    public Vector3 crossProduct(Vector3 vector3) {
        return new Vector3(this.y * vector3.z - this.z * vector3.y, this.z * vector3.x - this.x * vector3.z, this.x * vector3.y - this.y * vector3.x);
    }

    public Vector3 xCrossProduct() {
        return new Vector3(0.0, this.z, -this.y);
    }

    public Vector3 zCrossProduct() {
        return new Vector3(-this.y, this.x, 0.0);
    }

    public double dotProduct(Vector3 vector3) {
        return this.x * vector3.x + this.y * vector3.y + this.z * vector3.z;
    }

    public Vector3 getPerpendicular() {
        if (this.z == 0.0) {
            return this.zCrossProduct();
        }
        return this.xCrossProduct();
    }

    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    public Vector3 rotate(float angle, Vector3 axis) {
        return Vector3.translateMatrix(Vector3.getRotationMatrix(angle, axis), this.clone());
    }

    public double[] getRotationMatrix(float angle_deg) {
        double[] matrix = new double[16];
        Vector3 axis = this.clone().normalize();
        double xn = axis.x;
        double yn = axis.y;
        double zn = axis.z;
        float angle_rad = angle_deg * ((float)Math.PI / 180);
        float cos = (float)Math.cos(angle_rad);
        float oCos = 1.0f - cos;
        float sin = (float)Math.sin(angle_rad);
        matrix[0] = xn * xn * (double)oCos + (double)cos;
        matrix[1] = yn * xn * (double)oCos + zn * (double)sin;
        matrix[2] = xn * zn * (double)oCos - yn * (double)sin;
        matrix[4] = xn * yn * (double)oCos - zn * (double)sin;
        matrix[5] = yn * yn * (double)oCos + (double)cos;
        matrix[6] = yn * zn * (double)oCos + xn * (double)sin;
        matrix[8] = xn * zn * (double)oCos + yn * (double)sin;
        matrix[9] = yn * zn * (double)oCos - xn * (double)sin;
        matrix[10] = zn * zn * (double)oCos + (double)cos;
        matrix[15] = 1.0;
        return matrix;
    }

    public static Vector3 translateMatrix(double[] matrix, Vector3 translation) {
        double x = translation.x * matrix[0] + translation.y * matrix[1] + translation.z * matrix[2] + matrix[3];
        double y = translation.x * matrix[4] + translation.y * matrix[5] + translation.z * matrix[6] + matrix[7];
        double z = translation.x * matrix[8] + translation.y * matrix[9] + translation.z * matrix[10] + matrix[11];
        translation.x = x;
        translation.y = y;
        translation.z = z;
        return translation;
    }

    public static double[] getRotationMatrix(float angle, Vector3 axis) {
        return axis.getRotationMatrix(angle);
    }

    public void rotate(double yaw, double pitch, double roll) {
        double yawRadians = Math.toRadians(yaw);
        double pitchRadians = Math.toRadians(pitch);
        double rollRadians = Math.toRadians(roll);
        double oldX = this.x;
        double oldY = this.y;
        double oldZ = this.z;
        this.x = oldX * Math.cos(yawRadians) * Math.cos(pitchRadians) + oldZ * (Math.cos(yawRadians) * Math.sin(pitchRadians) * Math.sin(rollRadians) - Math.sin(yawRadians) * Math.cos(rollRadians)) + oldY * (Math.cos(yawRadians) * Math.sin(pitchRadians) * Math.cos(rollRadians) + Math.sin(yawRadians) * Math.sin(rollRadians));
        this.z = oldX * Math.sin(yawRadians) * Math.cos(pitchRadians) + oldZ * (Math.sin(yawRadians) * Math.sin(pitchRadians) * Math.sin(rollRadians) + Math.cos(yawRadians) * Math.cos(rollRadians)) + oldY * (Math.sin(yawRadians) * Math.sin(pitchRadians) * Math.cos(rollRadians) - Math.cos(yawRadians) * Math.sin(rollRadians));
        this.y = -oldX * Math.sin(pitchRadians) + oldZ * Math.cos(pitchRadians) * Math.sin(rollRadians) + oldY * Math.cos(pitchRadians) * Math.cos(rollRadians);
    }

    public void rotate(double yaw, double pitch) {
        this.rotate(yaw, pitch, 0.0);
    }

    public void rotate(double yaw) {
        double yawRadians = Math.toRadians(yaw);
        double oldX = this.x;
        double oldZ = this.z;
        if (yaw != 0.0) {
            this.x = oldX * Math.cos(yawRadians) - oldZ * Math.sin(yawRadians);
            this.z = oldX * Math.sin(yawRadians) + oldZ * Math.cos(yawRadians);
        }
    }

    public static Vector3 getDeltaPositionFromRotation(float rotationYaw1, float rotationPitch1) {
        float rotationYaw2 = rotationYaw1 + 90.0f;
        float rotationPitch2 = -rotationPitch1;
        return new Vector3(Math.cos(Math.toRadians(rotationYaw2)), Math.sin(Math.toRadians(rotationPitch2)), Math.sin(Math.toRadians(rotationYaw2)));
    }

    public double getAngle(Vector3 vector3) {
        return Vector3.anglePreNorm(this.clone().normalize(), vector3.clone().normalize());
    }

    public static double getAngle(Vector3 v1, Vector3 v2) {
        return v1.getAngle(v2);
    }

    public double anglePreNorm(Vector3 vector3) {
        return Math.acos(this.dotProduct(vector3));
    }

    public static double anglePreNorm(Vector3 v1, Vector3 v2) {
        return Math.acos(v1.clone().dotProduct(v2));
    }

    public static Vector3 createFromNBT(NBTTagCompound tagCompound) {
        Vector3 vector = new Vector3();
        vector.readFromNBT(tagCompound);
        return vector;
    }

    public void readFromNBT(@Nonnull NBTTagCompound tagCompound) {
        this.x = tagCompound.func_74769_h("x");
        this.y = tagCompound.func_74769_h("y");
        this.z = tagCompound.func_74769_h("z");
    }

    public NBTTagCompound writeToNBT(@Nonnull NBTTagCompound tagCompound) {
        tagCompound.func_74780_a("x", this.x);
        tagCompound.func_74780_a("y", this.y);
        tagCompound.func_74780_a("z", this.z);
        return tagCompound;
    }

    public static Vector3 UP() {
        return new Vector3(0.0, 1.0, 0.0);
    }

    public static Vector3 DOWN() {
        return new Vector3(0.0, -1.0, 0.0);
    }

    public static Vector3 NORTH() {
        return new Vector3(0.0, 0.0, -1.0);
    }

    public static Vector3 SOUTH() {
        return new Vector3(0.0, 0.0, 1.0);
    }

    public static Vector3 WEST() {
        return new Vector3(-1.0, 0.0, 0.0);
    }

    public static Vector3 EAST() {
        return new Vector3(1.0, 0.0, 0.0);
    }

    public RayTraceResult rayTrace(World world, float rotationYaw, float rotationPitch, boolean collisionFlag, double reachDistance) {
        RayTraceResult pickedBlock = this.rayTraceBlocks(world, rotationYaw, rotationPitch, reachDistance);
        RayTraceResult pickedEntity = this.rayTraceEntities(world, rotationYaw, rotationPitch, reachDistance);
        if (pickedBlock == null) {
            return pickedEntity;
        }
        if (pickedEntity == null) {
            return pickedBlock;
        }
        double dBlock = this.distanceTo(new Vector3(pickedBlock.field_72307_f));
        double dEntity = this.distanceTo(new Vector3(pickedEntity.field_72307_f));
        if (dEntity < dBlock) {
            return pickedEntity;
        }
        return pickedBlock;
    }

    public RayTraceResult rayTraceBlocks(World world, float rotationYaw, float rotationPitch, double reachDistance) {
        Vector3 lookVector = Vector3.getDeltaPositionFromRotation(rotationYaw, rotationPitch);
        Vector3 reachPoint = this.clone().translateFactor(lookVector, reachDistance);
        return world.func_72933_a(this.toVec3d(), reachPoint.toVec3d());
    }

    public RayTraceResult rayTraceEntities(World world, float rotationYaw, float rotationPitch, double reachDistance) {
        RayTraceResult pickedEntity = null;
        Vec3d startingPosition = this.toVec3d();
        Vec3d look = Vector3.getDeltaPositionFromRotation(rotationYaw, rotationPitch).toVec3d();
        Vec3d reachPoint = new Vec3d(startingPosition.field_72450_a + look.field_72450_a * reachDistance, startingPosition.field_72448_b + look.field_72448_b * reachDistance, startingPosition.field_72449_c + look.field_72449_c * reachDistance);
        double playerBorder = 1.1 * reachDistance;
        AxisAlignedBB boxToScan = new AxisAlignedBB(-playerBorder, -playerBorder, -playerBorder, playerBorder, playerBorder, playerBorder);
        List entitiesHit = world.func_72839_b(null, boxToScan);
        double closestEntity = reachDistance;
        if (entitiesHit.isEmpty()) {
            return null;
        }
        for (Entity entityHit : entitiesHit) {
            if (entityHit == null || !entityHit.func_70067_L()) continue;
            float border = entityHit.func_70111_Y();
            AxisAlignedBB aabb = entityHit.func_174813_aQ().func_72321_a((double)border, (double)border, (double)border);
            RayTraceResult hitMOP = aabb.func_72327_a(startingPosition, reachPoint);
            if (hitMOP == null) continue;
            if (aabb.func_72318_a(startingPosition)) {
                if (!(0.0 < closestEntity) && closestEntity != 0.0) continue;
                pickedEntity = new RayTraceResult(entityHit);
                pickedEntity.field_72307_f = hitMOP.field_72307_f;
                closestEntity = 0.0;
                continue;
            }
            double distance = startingPosition.func_72438_d(hitMOP.field_72307_f);
            if (!(distance < closestEntity) && closestEntity != 0.0) continue;
            pickedEntity = new RayTraceResult(entityHit);
            pickedEntity.field_72307_f = hitMOP.field_72307_f;
            closestEntity = distance;
        }
        return pickedEntity;
    }

    public int hashCode() {
        return ("X:" + this.x + "Y:" + this.y + "Z:" + this.z).hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof Vector3) {
            Vector3 vector3 = (Vector3)object;
            return this.x == vector3.x && this.y == vector3.y && this.z == vector3.z;
        }
        return false;
    }

    public String toString() {
        return String.format("Vector3 [%.3f %.3f %.3f]", this.x, this.y, this.z);
    }
}

