/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.entity;

import com.google.common.base.Optional;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.GlobalPosition;
import cr0s.warpdrive.data.OfflineAvatarManager;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.world.World;

public class EntityOfflineAvatar
extends EntityLiving {
    private static final DataParameter<Optional<UUID>> DATA_PLAYER_UUID = EntityDataManager.func_187226_a(EntityOfflineAvatar.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<String> DATA_PLAYER_NAME = EntityDataManager.func_187226_a(EntityOfflineAvatar.class, (DataSerializer)DataSerializers.field_187194_d);
    private GlobalPosition cache_globalPosition;
    private boolean isDirtyGlobalPosition = true;
    private int tickUpdateGlobalPosition = 0;

    public EntityOfflineAvatar(@Nonnull World world) {
        super(world);
        this.func_98053_h(false);
        this.func_94061_f(true);
        this.func_96094_a("Offline avatar");
        this.func_174805_g(WarpDriveConfig.OFFLINE_AVATAR_ALWAYS_RENDER_NAME_TAG);
        this.func_70105_a(this.field_70130_N * WarpDriveConfig.OFFLINE_AVATAR_MODEL_SCALE, this.field_70131_O * WarpDriveConfig.OFFLINE_AVATAR_MODEL_SCALE);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_PLAYER_UUID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(DATA_PLAYER_NAME, (Object)"");
    }

    public void setPlayer(@Nonnull UUID uuidPlayer, @Nonnull String namePlayer) {
        this.field_70180_af.func_187227_b(DATA_PLAYER_UUID, (Object)Optional.of((Object)uuidPlayer));
        this.field_70180_af.func_187227_b(DATA_PLAYER_NAME, (Object)namePlayer);
    }

    @Nullable
    public UUID getPlayerUUID() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(DATA_PLAYER_UUID)).orNull();
    }

    public String getPlayerName() {
        return (String)this.field_70180_af.func_187225_a(DATA_PLAYER_NAME);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.cache_globalPosition == null || this.cache_globalPosition.distance2To((Entity)this) > 1.0) {
            this.isDirtyGlobalPosition = true;
            this.cache_globalPosition = new GlobalPosition((Entity)this);
        }
        if (this.isDirtyGlobalPosition) {
            this.tickUpdateGlobalPosition = 0;
        }
        --this.tickUpdateGlobalPosition;
        if (this.tickUpdateGlobalPosition <= 0) {
            this.tickUpdateGlobalPosition = WarpDriveConfig.G_REGISTRY_UPDATE_INTERVAL_TICKS;
            this.isDirtyGlobalPosition = false;
            UUID uuidPlayer = this.getPlayerUUID();
            if (uuidPlayer == null) {
                if (this.field_70173_aa > 5) {
                    WarpDrive.logger.error(String.format("Removing invalid EntityOfflineAvatar with no UUID %s", new Object[]{this}));
                    this.func_70106_y();
                }
            } else {
                OfflineAvatarManager.update(this);
            }
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (WarpDriveConfig.OFFLINE_AVATAR_FORGET_ON_DEATH) {
            OfflineAvatarManager.remove(this);
        }
    }

    public float func_70603_bj() {
        return WarpDriveConfig.OFFLINE_AVATAR_MODEL_SCALE;
    }

    public void func_70037_a(@Nonnull NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        UUID uuidPlayer = tagCompound.func_186857_a("player");
        String namePlayer = tagCompound.func_74779_i("playerName");
        if (uuidPlayer == null || namePlayer.isEmpty()) {
            WarpDrive.logger.error(String.format("Removing on reading invalid offline avatar in %s", tagCompound));
            this.func_70106_y();
            return;
        }
        this.setPlayer(uuidPlayer, namePlayer);
    }

    public void func_70014_b(@Nonnull NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        UUID uuidPlayer = this.getPlayerUUID();
        if (uuidPlayer == null) {
            WarpDrive.logger.error(String.format("Removing on writing invalid offline avatar in %s", tagCompound));
            this.func_70106_y();
            return;
        }
        tagCompound.func_186854_a("player", uuidPlayer);
        tagCompound.func_74778_a("playerName", this.getPlayerName());
    }

    public boolean func_184652_a(@Nonnull EntityPlayer entityPlayer) {
        return false;
    }

    protected boolean func_70610_aX() {
        return true;
    }

    public boolean func_94059_bO() {
        return super.func_94059_bO();
    }

    public boolean func_174833_aM() {
        return super.func_174833_aM();
    }
}

