/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.event;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.LocalProfiler;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.ExceptionChunkNotLoaded;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.data.ChunkData;
import cr0s.warpdrive.data.GlobalRegionManager;
import cr0s.warpdrive.data.OfflineAvatarManager;
import cr0s.warpdrive.data.StateAir;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.procedure.TLongObjectProcedure;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class ChunkHandler {
    private static final long CHUNK_HANDLER_UNLOADED_CHUNK_MAX_AGE_MS = 30000L;
    private static final TIntObjectHashMap<TLongObjectHashMap<ChunkData>> registryClient = new TIntObjectHashMap(32);
    private static final TIntObjectHashMap<TLongObjectHashMap<ChunkData>> registryServer = new TIntObjectHashMap(32);
    public static long delayLogging = 0L;

    @SubscribeEvent
    public void onLoadWorld(@Nonnull WorldEvent.Load event) {
        if ((event.getWorld().field_72995_K || event.getWorld().field_73011_w.getDimension() == 0) && WarpDriveConfig.LOGGING_CHUNK_HANDLER) {
            WarpDrive.logger.info(String.format("%s world %s load.", event.getWorld().field_72995_K ? "Client" : "Server", Commons.format(event.getWorld())));
        }
        if (!event.getWorld().field_72995_K && event.getWorld().field_73011_w.getDimension() == 0) {
            String filename = String.format("%s/%s.dat", event.getWorld().func_72860_G().func_75765_b().getPath(), "warpdrive");
            NBTTagCompound tagCompound = Commons.readNBTFromFile(filename);
            GlobalRegionManager.readFromNBT(tagCompound);
            OfflineAvatarManager.readFromNBT(tagCompound);
            WorldBorder worldBorder = event.getWorld().func_175723_af();
            double maxWorldBorder = CelestialObjectManager.getMaxWorldBorder(event.getWorld());
            WarpDrive.logger.info(String.format("Checking vanilla WorldBorder size (%.1f m) against celestial map maximum border (%.1f m)", worldBorder.func_177741_h(), maxWorldBorder));
            if (worldBorder.func_177741_h() < maxWorldBorder) {
                worldBorder.func_177750_a(maxWorldBorder);
                WarpDrive.logger.warn(String.format("Vanilla WorldBorder size was too small, it has been adjusted to %.1f m!", worldBorder.func_177741_h()));
            }
        }
    }

    public static void onGenerated(@Nonnull World world, int chunkX, int chunkZ) {
        if (WarpDriveConfig.LOGGING_CHUNK_HANDLER) {
            WarpDrive.logger.info(String.format("%s world %s chunk [%d, %d] generating", world.field_72995_K ? "Client" : "Server", Commons.format(world), chunkX, chunkZ));
        }
        ChunkData chunkData = ChunkHandler.getChunkData(world.field_72995_K, world.field_73011_w.getDimension(), chunkX, chunkZ, true);
        assert (chunkData != null);
        if (!chunkData.isLoaded()) {
            chunkData.load(new NBTTagCompound());
        }
    }

    @SubscribeEvent
    public void onLoadChunkData(@Nonnull ChunkDataEvent.Load event) {
        if (WarpDriveConfig.LOGGING_CHUNK_HANDLER) {
            WarpDrive.logger.info(String.format("%s world %s chunk %s loading data (1)", event.getWorld().field_72995_K ? "Client" : "Server", Commons.format(event.getWorld()), event.getChunk().func_76632_l()));
        }
        ChunkData chunkData = ChunkHandler.getChunkData(event.getWorld().field_72995_K, event.getWorld().field_73011_w.getDimension(), event.getChunk().field_76635_g, event.getChunk().field_76647_h, true);
        assert (chunkData != null);
        chunkData.load(event.getData());
    }

    @SubscribeEvent
    public void onLoadChunk(@Nonnull ChunkEvent.Load event) {
        if (WarpDriveConfig.LOGGING_CHUNK_HANDLER) {
            WarpDrive.logger.info(String.format("%s world %s chunk %s loaded (2)", event.getWorld().field_72995_K ? "Client" : "Server", Commons.format(event.getWorld()), event.getChunk().func_76632_l()));
        }
        ChunkData chunkData = ChunkHandler.getChunkData(event.getWorld().field_72995_K, event.getWorld().field_73011_w.getDimension(), event.getChunk().field_76635_g, event.getChunk().field_76647_h, true);
        assert (chunkData != null);
        if (!chunkData.isLoaded()) {
            chunkData.load(new NBTTagCompound());
        }
    }

    @SubscribeEvent
    public void onSaveChunkData(@Nonnull ChunkDataEvent.Save event) {
        ChunkData chunkData;
        if (WarpDriveConfig.LOGGING_CHUNK_HANDLER) {
            WarpDrive.logger.info(String.format("%s world %s chunk %s save data", event.getWorld().field_72995_K ? "Client" : "Server", Commons.format(event.getWorld()), event.getChunk().func_76632_l()));
        }
        if ((chunkData = ChunkHandler.getChunkData(event.getWorld().field_72995_K, event.getWorld().field_73011_w.getDimension(), event.getChunk().field_76635_g, event.getChunk().field_76647_h, false)) != null) {
            chunkData.save(event.getData());
        } else if (WarpDriveConfig.LOGGING_CHUNK_HANDLER) {
            WarpDrive.logger.error(String.format("%s world %s chunk %s is saving data without loading it first!", event.getWorld().field_72995_K ? "Client" : "Server", Commons.format(event.getWorld()), event.getChunk().func_76632_l()));
        }
    }

    @SubscribeEvent
    public void onSaveWorld(@Nonnull WorldEvent.Save event) {
        if (event.getWorld().field_73011_w.getDimension() != 0) {
            return;
        }
        if (WarpDriveConfig.LOGGING_CHUNK_HANDLER) {
            WarpDrive.logger.info(String.format("%s world %s saved.", event.getWorld().field_72995_K ? "Client" : "Server", Commons.format(event.getWorld())));
        }
        if (event.getWorld().field_72995_K) {
            return;
        }
        String filename = String.format("%s/%s.dat", event.getWorld().func_72860_G().func_75765_b().getPath(), "warpdrive");
        NBTTagCompound tagCompound = new NBTTagCompound();
        GlobalRegionManager.writeToNBT(tagCompound);
        OfflineAvatarManager.writeToNBT(tagCompound);
        Commons.writeNBTToFile(filename, tagCompound);
    }

    @SubscribeEvent
    public void onUnloadWorld(@Nonnull WorldEvent.Unload event) {
        if (WarpDriveConfig.LOGGING_CHUNK_HANDLER) {
            WarpDrive.logger.info(String.format("%s world %s unload", event.getWorld().field_72995_K ? "Client" : "Server", Commons.format(event.getWorld())));
        }
        LocalProfiler.updateCallStat("onUnloadWorld");
        TIntObjectHashMap<TLongObjectHashMap<ChunkData>> registry = event.getWorld().field_72995_K ? registryClient : registryServer;
        TLongObjectHashMap mapRegistryItems = (TLongObjectHashMap)registry.get(event.getWorld().field_73011_w.getDimension());
        if (mapRegistryItems != null) {
            for (Object object : mapRegistryItems.values()) {
                ChunkData chunkData = (ChunkData)object;
                if (!chunkData.isLoaded()) continue;
                chunkData.unload();
            }
        }
    }

    @SubscribeEvent
    public void onUnloadChunk(@Nonnull ChunkEvent.Unload event) {
        ChunkData chunkData;
        if (WarpDriveConfig.LOGGING_CHUNK_HANDLER) {
            WarpDrive.logger.info(String.format("%s world %s chunk %s unload", event.getWorld().field_72995_K ? "Client" : "Server", Commons.format(event.getWorld()), event.getChunk().func_76632_l()));
        }
        if ((chunkData = ChunkHandler.getChunkData(event.getWorld().field_72995_K, event.getWorld().field_73011_w.getDimension(), event.getChunk().field_76635_g, event.getChunk().field_76647_h, false)) != null) {
            chunkData.unload();
        } else if (WarpDriveConfig.LOGGING_CHUNK_HANDLER) {
            WarpDrive.logger.error(String.format("%s world %s chunk %s is unloading without loading it first!", event.getWorld().field_72995_K ? "Client" : "Server", Commons.format(event.getWorld()), event.getChunk().func_76632_l()));
        }
    }

    @SubscribeEvent
    public void onWorldTick(@Nonnull TickEvent.WorldTickEvent event) {
        if (event.side != Side.SERVER || event.phase != TickEvent.Phase.END) {
            return;
        }
        ChunkHandler.updateTick(event.world);
    }

    public static void onBlockUpdated(@Nonnull World world, @Nonnull BlockPos blockPos) {
        if (!world.field_72995_K) {
            ChunkData chunkData = ChunkHandler.getChunkData(world, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
            if (chunkData != null) {
                chunkData.onBlockUpdated(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
            } else if (Commons.throttleMe("ChunkHandler block updating in non-loaded chunk")) {
                WarpDrive.logger.error(String.format("%s block updating %s, while chunk isn't loaded!", world.field_72995_K ? "Client" : "Server", Commons.format(world, blockPos)));
                Commons.dumpAllThreads();
            }
        }
    }

    public static ChunkData getChunkData(@Nonnull World world, int x, int y, int z) {
        ChunkData chunkData = ChunkHandler.getChunkData(world.field_72995_K, world.field_73011_w.getDimension(), x, y, z);
        if (chunkData == null) {
            if (Commons.throttleMe("ChunkHandler get data from an non-loaded chunk")) {
                WarpDrive.logger.error(String.format("Trying to get data from an non-loaded chunk in %s %s", world.field_72995_K ? "Client" : "Server", Commons.format(world, x, y, z)));
                LocalProfiler.printCallStats();
                Commons.dumpAllThreads();
            }
            assert (false);
        }
        return chunkData;
    }

    private static ChunkData getChunkData(boolean isRemote, int dimensionId, int x, int y, int z) {
        assert (y >= -1 && y <= 256);
        return ChunkHandler.getChunkData(isRemote, dimensionId, x >> 4, z >> 4, false);
    }

    @Nullable
    private static ChunkData getChunkData(boolean isRemote, int dimensionId, int xChunk, int zChunk, boolean doCreate) {
        long index;
        ChunkData chunkData;
        LocalProfiler.updateCallStat("getChunkData");
        TIntObjectHashMap<TLongObjectHashMap<ChunkData>> registry = isRemote ? registryClient : registryServer;
        TLongObjectHashMap mapRegistryItems = (TLongObjectHashMap)registry.get(dimensionId);
        if (mapRegistryItems == null) {
            if (!doCreate) {
                return null;
            }
            mapRegistryItems = new TLongObjectHashMap(2048);
            registry.put(dimensionId, (Object)mapRegistryItems);
        }
        if ((chunkData = (ChunkData)mapRegistryItems.get(index = ChunkPos.func_77272_a((int)xChunk, (int)zChunk))) == null) {
            if (!doCreate) {
                if (WarpDriveConfig.LOGGING_CHUNK_HANDLER) {
                    WarpDrive.logger.info(String.format("getChunkData(%s, %d, %d, %d, false) returning null", isRemote, dimensionId, xChunk, zChunk));
                }
                return null;
            }
            chunkData = new ChunkData(xChunk, zChunk);
            if (WarpDriveConfig.LOGGING_CHUNK_HANDLER) {
                WarpDrive.logger.info(String.format("%s world DIM%d chunk %s is being added to the registry", isRemote ? "Client" : "Server", dimensionId, chunkData.getChunkCoords()));
            }
            if (Commons.isSafeThread()) {
                mapRegistryItems.put(index, (Object)chunkData);
            } else if (Commons.throttleMe("ChunkHandler added to the registry outside main thread")) {
                WarpDrive.logger.error(String.format("%s world DIM%d chunk %s is being added to the registry outside main thread!", isRemote ? "Client" : "Server", dimensionId, chunkData.getChunkCoords()));
                Commons.dumpAllThreads();
                mapRegistryItems.put(index, (Object)chunkData);
            }
        }
        return chunkData;
    }

    private static boolean isLoaded(@Nonnull TLongObjectHashMap<ChunkData> mapRegistryItems, int xChunk, int zChunk) {
        long index = ChunkPos.func_77272_a((int)xChunk, (int)zChunk);
        ChunkData chunkData = (ChunkData)mapRegistryItems.get(index);
        return chunkData != null && chunkData.isLoaded();
    }

    public static boolean isLoaded(@Nonnull World world, int x, int y, int z) {
        ChunkData chunkData = ChunkHandler.getChunkData(world.field_72995_K, world.field_73011_w.getDimension(), x, y, z);
        return chunkData != null && chunkData.isLoaded();
    }

    @Nullable
    public static StateAir getStateAir(@Nonnull World world, int x, int y, int z) {
        ChunkData chunkData = ChunkHandler.getChunkData(world, x, y, z);
        if (chunkData == null) {
            return null;
        }
        try {
            return chunkData.getStateAir(world, x, y, z);
        }
        catch (ExceptionChunkNotLoaded exceptionChunkNotLoaded) {
            WarpDrive.logger.warn(String.format("Aborting air evaluation: chunk isn't loaded %s", Commons.format(world, x, y, z)));
            return null;
        }
    }

    private static void updateTick(final @Nonnull World world) {
        LocalProfiler.updateCallStat("updateTick");
        TIntObjectHashMap<TLongObjectHashMap<ChunkData>> registry = world.field_72995_K ? registryClient : registryServer;
        final TLongObjectHashMap mapRegistryItems = (TLongObjectHashMap)registry.get(world.field_73011_w.getDimension());
        if (mapRegistryItems == null) {
            return;
        }
        final int[] countLoaded = new int[]{0};
        final int[] countRemoved = new int[]{0};
        final long timeForRemoval = System.currentTimeMillis() - 30000L;
        final long timeForThrottle = System.currentTimeMillis() + 200L;
        long sizeBefore = mapRegistryItems.size();
        final long[] indexCurrent = new long[]{0L};
        try {
            mapRegistryItems.retainEntries((TLongObjectProcedure)new TLongObjectProcedure<ChunkData>(){

                public final boolean execute(long key, ChunkData chunkData) {
                    indexCurrent[0] = key;
                    if (chunkData.isLoaded()) {
                        countLoaded[0] = countLoaded[0] + 1;
                        if (System.currentTimeMillis() < timeForThrottle) {
                            ChunkHandler.updateTickLoopStep(world, (TLongObjectHashMap<ChunkData>)mapRegistryItems, chunkData);
                        }
                    } else if (chunkData.timeUnloaded < timeForRemoval) {
                        if (WarpDriveConfig.LOGGING_CHUNK_HANDLER) {
                            WarpDrive.logger.info(String.format("%s world %s chunk %s is being removed from updateTick (size is %d)", world.field_72995_K ? "Client" : "Server", Commons.format(world), chunkData.getChunkCoords(), mapRegistryItems.size()));
                        }
                        countRemoved[0] = countRemoved[0] + 1;
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace(WarpDrive.printStreamError);
            WarpDrive.logger.error(String.format("%s world %s had an exception, maybe some chunks changed outside main thread? (size %d -> %d, loaded %d, removed %d, index 0x%X x %d z %d)", world.field_72995_K ? "Client" : "Server", Commons.format(world), sizeBefore, mapRegistryItems.size(), countLoaded[0], countRemoved[0], indexCurrent[0], indexCurrent[0] & 0xFFFFFFFFL, indexCurrent[0] >> 32 & 0xFFFFFFFFL));
            LocalProfiler.printCallStats();
        }
        if (WarpDriveConfig.LOGGING_CHUNK_HANDLER) {
            if (world.field_73011_w.getDimension() == 0) {
                delayLogging = (delayLogging + 1L) % 4096L;
            }
            if (delayLogging == 1L) {
                WarpDrive.logger.info(String.format("Dimension %d has %d / %d chunks loaded", world.field_73011_w.getDimension(), countLoaded[0], mapRegistryItems.size()));
            }
        }
    }

    private static void updateTickLoopStep(@Nonnull World world, @Nonnull TLongObjectHashMap<ChunkData> mapRegistryItems, @Nonnull ChunkData chunkData) {
        ChunkPos chunkCoordIntPair = chunkData.getChunkCoords();
        if (chunkData.isNotEmpty() && ChunkHandler.isLoaded(mapRegistryItems, chunkCoordIntPair.field_77276_a + 1, chunkCoordIntPair.field_77275_b) && ChunkHandler.isLoaded(mapRegistryItems, chunkCoordIntPair.field_77276_a - 1, chunkCoordIntPair.field_77275_b) && ChunkHandler.isLoaded(mapRegistryItems, chunkCoordIntPair.field_77276_a, chunkCoordIntPair.field_77275_b + 1) && ChunkHandler.isLoaded(mapRegistryItems, chunkCoordIntPair.field_77276_a, chunkCoordIntPair.field_77275_b - 1)) {
            chunkData.updateTick(world);
        }
    }
}

