/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.event;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.Filler;
import cr0s.warpdrive.config.GenericSet;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.config.structures.OrbInstance;
import cr0s.warpdrive.config.structures.StructureGroup;
import cr0s.warpdrive.data.CelestialObject;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.event.ChunkHandler;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class CommonWorldGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        ChunkHandler.onGenerated(world, chunkX, chunkZ);
        try {
            int x = chunkX * 16 + (5 - random.nextInt(10));
            int z = chunkZ * 16 + (5 - random.nextInt(10));
            CelestialObject celestialObject = CelestialObjectManager.get(world, x, z);
            if (celestialObject == null) {
                return;
            }
            if (Math.abs(x - celestialObject.dimensionCenterX) > celestialObject.borderRadiusX || Math.abs(z - celestialObject.dimensionCenterZ) > celestialObject.borderRadiusZ) {
                return;
            }
            int y = WarpDriveConfig.SPACE_GENERATOR_Y_MIN_CENTER + random.nextInt(WarpDriveConfig.SPACE_GENERATOR_Y_MAX_CENTER - WarpDriveConfig.SPACE_GENERATOR_Y_MIN_CENTER);
            StructureGroup structureGroup = celestialObject.getRandomStructure(random, x, z);
            if (structureGroup == null) {
                return;
            }
            structureGroup.generate(world, random, x, y, z);
        }
        catch (Exception exception) {
            exception.printStackTrace(WarpDrive.printStreamError);
        }
    }

    @Deprecated
    public static void generateSphereDirect(OrbInstance orbInstance, World world, int xCoord, int yCoord, int zCoord) {
        double dRadius = (double)orbInstance.getTotalThickness() + 0.5;
        double dSqRadius = dRadius * dRadius;
        int ceilRadius = (int)Math.ceil(dRadius);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(xCoord, yCoord, zCoord);
        for (int x = 0; x <= ceilRadius; ++x) {
            double dX2 = ((double)x + 0.5) * ((double)x + 0.5);
            for (int y = 0; y <= ceilRadius; ++y) {
                double dX2Y2 = dX2 + ((double)y + 0.5) * ((double)y + 0.5);
                for (int z = 0; z <= ceilRadius; ++z) {
                    double dZ2 = ((double)z + 0.5) * ((double)z + 0.5);
                    double dSqRange = dX2Y2 + dZ2;
                    if (dSqRange > dSqRadius) continue;
                    int intSqRange = (int)Math.round(dSqRange);
                    GenericSet<Filler> fillerSet = orbInstance.getFillerSetFromSquareRange(intSqRange);
                    Filler filler = fillerSet.getRandomUnit(world.field_73012_v);
                    filler.setBlock(world, (BlockPos)mutableBlockPos.func_181079_c(xCoord + x, yCoord + y, zCoord + z));
                    filler.setBlock(world, (BlockPos)mutableBlockPos.func_181079_c(xCoord - x, yCoord + y, zCoord + z));
                    filler.setBlock(world, (BlockPos)mutableBlockPos.func_181079_c(xCoord + x, yCoord - y, zCoord + z));
                    filler.setBlock(world, (BlockPos)mutableBlockPos.func_181079_c(xCoord + x, yCoord + y, zCoord - z));
                    filler.setBlock(world, (BlockPos)mutableBlockPos.func_181079_c(xCoord - x, yCoord - y, zCoord + z));
                    filler.setBlock(world, (BlockPos)mutableBlockPos.func_181079_c(xCoord + x, yCoord - y, zCoord - z));
                    filler.setBlock(world, (BlockPos)mutableBlockPos.func_181079_c(xCoord - x, yCoord + y, zCoord - z));
                    filler.setBlock(world, (BlockPos)mutableBlockPos.func_181079_c(xCoord - x, yCoord - y, zCoord - z));
                }
            }
        }
    }
}

