/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.event;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.ISequencerCallbacks;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.block.movement.TileEntityShipCore;
import cr0s.warpdrive.data.EnumShipMovementType;
import cr0s.warpdrive.data.JumpShip;
import cr0s.warpdrive.event.JumpSequencer;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class DeploySequencer
extends JumpSequencer {
    private String playerNameRequester;
    private boolean isRequesterCaptain = false;
    private ISequencerCallbacks callback;

    public DeploySequencer(JumpShip jumpShip, World world, boolean isInstantiated, int destX, int destY, int destZ, byte rotationSteps) {
        super(jumpShip, world, isInstantiated ? EnumShipMovementType.INSTANTIATE : EnumShipMovementType.RESTORE, destX, destY, destZ, rotationSteps);
    }

    public void setRequester(String playerName, boolean isCaptain) {
        this.playerNameRequester = playerName;
        this.isRequesterCaptain = isCaptain;
        this.addPlayerToEntities(playerName);
    }

    public void setCallback(ISequencerCallbacks object) {
        this.callback = object;
    }

    @Override
    public void disable(boolean isSuccessful, WarpDriveText reason) {
        super.disable(isSuccessful, reason);
        this.callback.sequencer_finished();
    }

    @Override
    protected void state_removeBlocks() {
        this.actualIndexInShip = this.ship.jumpBlocks.length;
    }

    @Override
    protected void state_chunkReleasing() {
        EntityPlayerMP entityPlayerMP;
        super.state_chunkReleasing();
        if (this.playerNameRequester != null && (entityPlayerMP = Commons.getOnlinePlayerByName(this.playerNameRequester)) != null) {
            Commons.addChatMessage((ICommandSender)entityPlayerMP, (ITextComponent)new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.builder.guide.ship_deployed", new Object[0]));
        }
    }

    @Override
    protected void state_finishing() {
        EntityPlayerMP entityPlayerMP;
        if (this.playerNameRequester != null && !this.playerNameRequester.isEmpty() && this.isRequesterCaptain && (entityPlayerMP = Commons.getOnlinePlayerByName(this.playerNameRequester)) != null) {
            TileEntity tileEntity = this.worldTarget.func_175625_s(new BlockPos(this.destX, this.destY, this.destZ));
            if (tileEntity instanceof TileEntityShipCore) {
                boolean isSuccess = ((TileEntityShipCore)tileEntity).summonOwnerOnDeploy(entityPlayerMP);
                if (isSuccess) {
                    Commons.addChatMessage((ICommandSender)entityPlayerMP, (ITextComponent)new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.builder.guide.welcome_aboard", new Object[0]));
                } else {
                    WarpDrive.logger.warn(String.format("Failed to assign new captain %s", this.playerNameRequester));
                }
            } else {
                WarpDrive.logger.warn(String.format("Unable to detect ship core after deployment, found %s", tileEntity));
            }
        }
        super.state_finishing();
    }
}

