/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.event;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.TileEntityAbstractBase;
import cr0s.warpdrive.config.WarpDriveConfig;
import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.caps.IEMPReceiver;
import icbm.classic.api.explosion.IBlast;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Optional.InterfaceList(value={@Optional.Interface(iface="icbm.classic.api.caps.IEMPReceiver", modid="icbmclassic")})
public class EMPReceiver
implements IEMPReceiver,
ICapabilityProvider {
    public static final ResourceLocation resourceLocation = new ResourceLocation("warpdrive", "EMPReceiver");
    private final TileEntityAbstractBase tileEntityAbstractBase;

    @SubscribeEvent
    @Optional.Method(modid="icbmclassic")
    public static void onAttachCapability(AttachCapabilitiesEvent<TileEntity> event) {
        TileEntity tileEntity = (TileEntity)event.getObject();
        if (tileEntity instanceof TileEntityAbstractBase) {
            event.addCapability(resourceLocation, (ICapabilityProvider)new EMPReceiver((TileEntityAbstractBase)tileEntity));
        }
    }

    private EMPReceiver(TileEntityAbstractBase tileEntityAbstractBase) {
        this.tileEntityAbstractBase = tileEntityAbstractBase;
    }

    @Optional.Method(modid="icbmclassic")
    public float applyEmpAction(World world, double x, double y, double z, IBlast blastEMP, float power, boolean doAction) {
        Entity exploder;
        if (!doAction) {
            return power;
        }
        Entity entity = exploder = blastEMP instanceof Explosion ? ((Explosion)blastEMP).field_77283_e : null;
        if (WarpDriveConfig.LOGGING_WEAPON) {
            WarpDrive.logger.info(String.format("EMP received %s from %s with source %s and radius %.1f", Commons.format(world, x, y, z), blastEMP, exploder, Float.valueOf(blastEMP.getBlastRadius())));
        }
        if (blastEMP.getBlastRadius() == 50.0f) {
            this.tileEntityAbstractBase.onEMP(0.7f);
        } else if (blastEMP.getBlastRadius() > 0.0f) {
            this.tileEntityAbstractBase.onEMP(Math.min(1.0f, blastEMP.getBlastRadius() / 60.0f) * 0.02f);
        } else {
            if (Commons.throttleMe("EMPReceiver Invalid radius")) {
                WarpDrive.logger.warn(String.format("EMP received @ %s from %s with source %s and unsupported radius %.1f", Commons.format(world, x, y, z), blastEMP, exploder, Float.valueOf(blastEMP.getBlastRadius())));
                Commons.dumpAllThreads();
            }
            this.tileEntityAbstractBase.onEMP(0.02f);
        }
        return power;
    }

    public boolean shouldEmpSubObjects(World world, double x, double y, double z) {
        return true;
    }

    @Optional.Method(modid="icbmclassic")
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == ICBMClassicAPI.EMP_CAPABILITY;
    }

    @Nullable
    @Optional.Method(modid="icbmclassic")
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == ICBMClassicAPI.EMP_CAPABILITY ? this : null);
    }
}

