/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.event;

import cr0s.warpdrive.CommonProxy;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.FastSetBlockState;
import cr0s.warpdrive.LocalProfiler;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.EventWarpDrive;
import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.block.movement.TileEntityShipCore;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CelestialObject;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.data.EnumJumpSequencerState;
import cr0s.warpdrive.data.EnumShipMovementType;
import cr0s.warpdrive.data.GlobalRegion;
import cr0s.warpdrive.data.JumpBlock;
import cr0s.warpdrive.data.JumpShip;
import cr0s.warpdrive.data.MovingEntity;
import cr0s.warpdrive.data.SoundEvents;
import cr0s.warpdrive.data.Transformation;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.data.VectorI;
import cr0s.warpdrive.event.AbstractSequencer;
import cr0s.warpdrive.network.PacketHandler;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class JumpSequencer
extends AbstractSequencer {
    protected Transformation transformation;
    private final EnumShipMovementType shipMovementType;
    private int moveX;
    private int moveY;
    private int moveZ;
    private final byte rotationSteps;
    private final String nameTarget;
    protected final int destX;
    protected final int destY;
    protected final int destZ;
    private Vector3 v3Source;
    private int blocksPerTick = WarpDriveConfig.G_BLOCKS_PER_TICK;
    private static final boolean enforceEntitiesPosition = false;
    protected final World worldSource;
    private ForgeChunkManager.Ticket ticketSourcePosition;
    private GlobalRegion globalRegionLock;
    protected World worldTarget;
    private ForgeChunkManager.Ticket ticketTargetAnchor;
    private ForgeChunkManager.Ticket ticketTargetPosition;
    private boolean collisionDetected = false;
    private ArrayList<Vector3> collisionAtSource;
    private ArrayList<Vector3> collisionAtTarget;
    private float collisionStrength = 0.0f;
    protected boolean isEnabled = false;
    private EnumJumpSequencerState enumJumpSequencerState = EnumJumpSequencerState.IDLE;
    protected int actualIndexInShip = 0;
    protected final JumpShip ship;
    private boolean betweenWorlds;
    private boolean isPluginCheckDone = false;
    private WarpDriveText firstAdjustmentReason = null;
    private long msCounter = 0L;
    private int ticks = 0;
    private static final WarpDriveText reasonUnknown = new WarpDriveText(null, "warpdrive.error.internal_check_console", new Object[0]);

    public JumpSequencer(@Nonnull TileEntityShipCore shipCore, EnumShipMovementType shipMovementType, String nameTarget, int moveX, int moveY, int moveZ, byte rotationSteps, int destX, int destY, int destZ) {
        this.worldSource = shipCore.func_145831_w();
        this.ship = new JumpShip();
        this.ship.world = this.worldSource;
        this.ship.core = shipCore.func_174877_v();
        this.ship.dx = shipCore.facing.func_82601_c();
        this.ship.dz = shipCore.facing.func_82599_e();
        this.ship.minX = shipCore.minX;
        this.ship.maxX = shipCore.maxX;
        this.ship.minY = shipCore.minY;
        this.ship.maxY = shipCore.maxY;
        this.ship.minZ = shipCore.minZ;
        this.ship.maxZ = shipCore.maxZ;
        this.ship.shipCore = shipCore;
        this.shipMovementType = shipMovementType;
        this.moveX = moveX;
        this.moveY = moveY;
        this.moveZ = moveZ;
        this.rotationSteps = rotationSteps;
        this.nameTarget = nameTarget;
        this.destX = destX;
        this.destY = destY;
        this.destZ = destZ;
        this.v3Source = null;
        this.worldTarget = null;
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(String.format("%s Sequencer created for shipCore %s with shipMovementType %s", new Object[]{this, shipCore, shipMovementType}));
        }
    }

    public JumpSequencer(JumpShip jumpShip, World world, EnumShipMovementType enumShipMovementType, int destX, int destY, int destZ, byte rotationSteps) {
        this.worldSource = null;
        this.ship = jumpShip;
        this.shipMovementType = enumShipMovementType;
        this.rotationSteps = rotationSteps;
        this.nameTarget = null;
        this.destX = destX;
        this.destY = destY;
        this.destZ = destZ;
        this.worldTarget = world;
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(String.format("%s Sequencer created for ship %s with shipMovementType %s", new Object[]{this, this.ship, this.shipMovementType}));
        }
    }

    public void setBlocksPerTick(int blocksPerTick) {
        this.blocksPerTick = Math.min(WarpDriveConfig.G_BLOCKS_PER_TICK, blocksPerTick);
    }

    public void setEffectSource(Vector3 v3Source) {
        this.v3Source = v3Source;
    }

    public void addPlayerToEntities(String playerName) {
        this.ship.addPlayerToEntities(playerName);
    }

    public void enable() {
        this.isEnabled = true;
        this.register();
    }

    public void disableAndMessage(boolean isSuccessful, WarpDriveText reasonRaw) {
        WarpDriveText reason = isSuccessful ? reasonRaw : new WarpDriveText(Commons.getStyleWarning(), "warpdrive.ship.guide.movement_aborted", new Object[0]).append((ITextComponent)reasonRaw);
        this.disable(isSuccessful, reason);
        this.ship.messageToAllPlayersOnShip(reason);
    }

    public void disable(boolean isSuccessful, WarpDriveText reason) {
        EventWarpDrive.Ship.JumpResult jumpResult;
        String formattedText;
        if (!this.isEnabled) {
            return;
        }
        this.isEnabled = false;
        if (this.globalRegionLock != null) {
            JumpSequencer.removeLock(this.globalRegionLock);
            this.globalRegionLock = null;
        }
        String string = formattedText = reason == null ? "" : reason.func_150254_d();
        if (WarpDriveConfig.LOGGING_JUMP) {
            if (formattedText.isEmpty()) {
                WarpDrive.logger.info(String.format("%s Killing jump sequencer...", this));
            } else {
                WarpDrive.logger.info(String.format("%s Killing jump sequencer... (%s)", this, formattedText));
            }
        }
        if (!isSuccessful) {
            jumpResult = new EventWarpDrive.Ship.JumpResult(this.worldSource, this.ship.core, this.ship.shipCore, this.shipMovementType.func_176610_l(), false, (ITextComponent)reason);
        } else {
            BlockPos blockPosCoreTarget = this.transformation.apply(this.ship.core);
            TileEntity tileEntity = this.worldTarget.func_175625_s(blockPosCoreTarget);
            TileEntityShipCore shipController = tileEntity instanceof TileEntityShipCore ? (TileEntityShipCore)tileEntity : null;
            jumpResult = new EventWarpDrive.Ship.JumpResult(this.worldTarget, blockPosCoreTarget, shipController, this.shipMovementType.func_176610_l(), true, (ITextComponent)reason);
        }
        MinecraftForge.EVENT_BUS.post((Event)jumpResult);
        this.releaseChunks();
        this.unregister();
    }

    @Override
    public boolean onUpdate() {
        if (this.worldSource != null && this.worldSource.field_72995_K || this.worldTarget != null && this.worldTarget.field_72995_K) {
            return false;
        }
        if (!this.isEnabled) {
            if (WarpDriveConfig.LOGGING_JUMP) {
                WarpDrive.logger.info(this + " Removing from onUpdate...");
            }
            return false;
        }
        if (this.ship.minY < 0 || this.ship.maxY > 255) {
            this.disableAndMessage(false, new WarpDriveText(Commons.getStyleWarning(), "warpdrive.ship.guide.invalid_y_coordinates", new Object[0]));
            return true;
        }
        ++this.ticks;
        switch (this.enumJumpSequencerState) {
            case IDLE: {
                this.msCounter = System.currentTimeMillis();
                if (!this.isEnabled) break;
                if (this.shipMovementType != EnumShipMovementType.INSTANTIATE && this.shipMovementType != EnumShipMovementType.RESTORE) {
                    this.enumJumpSequencerState = EnumJumpSequencerState.LOAD_SOURCE_CHUNKS;
                    break;
                }
                this.enumJumpSequencerState = EnumJumpSequencerState.GET_INITIAL_VECTOR;
                break;
            }
            case LOAD_SOURCE_CHUNKS: {
                this.state_chunkLoadingSource();
                if (this.ship.shipCore != null) {
                    this.globalRegionLock = JumpSequencer.addLock(this.ship.shipCore);
                }
                if (!this.isEnabled) break;
                this.actualIndexInShip = 0;
                this.enumJumpSequencerState = EnumJumpSequencerState.SAVE_TO_MEMORY;
                break;
            }
            case SAVE_TO_MEMORY: {
                this.state_saveToMemory();
                if (!this.isEnabled) break;
                this.actualIndexInShip = 0;
                this.enumJumpSequencerState = EnumJumpSequencerState.CHECK_BORDERS;
                break;
            }
            case CHECK_BORDERS: {
                this.state_checkBorders();
                if (!this.isEnabled) break;
                this.enumJumpSequencerState = EnumJumpSequencerState.SAVE_TO_DISK;
                break;
            }
            case SAVE_TO_DISK: {
                this.state_saveToDisk();
                if (!this.isEnabled) break;
                this.enumJumpSequencerState = EnumJumpSequencerState.GET_INITIAL_VECTOR;
                break;
            }
            case GET_INITIAL_VECTOR: {
                this.state_getInitialVector();
                if (!this.isEnabled) break;
                this.enumJumpSequencerState = EnumJumpSequencerState.ADJUST_JUMP_VECTOR;
                break;
            }
            case ADJUST_JUMP_VECTOR: {
                this.state_adjustJumpVector();
                if (!this.isEnabled) break;
                this.enumJumpSequencerState = EnumJumpSequencerState.LOAD_TARGET_CHUNKS;
                break;
            }
            case LOAD_TARGET_CHUNKS: {
                this.state_loadTargetChunks();
                if (!this.isEnabled) break;
                this.enumJumpSequencerState = EnumJumpSequencerState.SAVE_ENTITIES;
                break;
            }
            case SAVE_ENTITIES: {
                this.state_saveEntitiesAndInformPlayers();
                if (!this.isEnabled) break;
                this.actualIndexInShip = 0;
                this.enumJumpSequencerState = EnumJumpSequencerState.MOVE_BLOCKS;
                break;
            }
            case MOVE_BLOCKS: {
                this.state_moveBlocks();
                if (this.actualIndexInShip < this.ship.jumpBlocks.length - 1) break;
                this.actualIndexInShip = 0;
                this.enumJumpSequencerState = EnumJumpSequencerState.MOVE_EXTERNALS;
                break;
            }
            case MOVE_EXTERNALS: {
                this.state_moveExternals();
                if (this.actualIndexInShip < this.ship.jumpBlocks.length - 1) break;
                this.enumJumpSequencerState = EnumJumpSequencerState.MOVE_ENTITIES;
                break;
            }
            case MOVE_ENTITIES: {
                this.state_moveEntities();
                this.actualIndexInShip = 0;
                this.enumJumpSequencerState = EnumJumpSequencerState.REMOVING;
                break;
            }
            case REMOVING: {
                this.state_removeBlocks();
                if (this.actualIndexInShip < this.ship.jumpBlocks.length - 1) break;
                this.enumJumpSequencerState = EnumJumpSequencerState.CHUNK_UNLOADING;
                break;
            }
            case CHUNK_UNLOADING: {
                this.state_chunkReleasing();
                this.enumJumpSequencerState = EnumJumpSequencerState.FINISHING;
                break;
            }
            case FINISHING: {
                this.state_finishing();
                this.enumJumpSequencerState = EnumJumpSequencerState.IDLE;
                break;
            }
            default: {
                this.disableAndMessage(false, new WarpDriveText(Commons.getStyleWarning(), "warpdrive.ship.guide.invalid_state", new Object[0]));
                return true;
            }
        }
        return true;
    }

    private boolean forceSourceChunks(WarpDriveText reason) {
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(String.format("%s Forcing source chunks in %s", this, Commons.format(this.worldSource)));
        }
        this.ticketSourcePosition = ForgeChunkManager.requestTicket((Object)WarpDrive.instance, (World)this.worldSource, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (this.ticketSourcePosition == null) {
            reason.append(Commons.getStyleWarning(), "warpdrive.ship.guide.chunkloading_rejected_in_source_world", Commons.format(this.worldSource));
            return false;
        }
        int minX = this.ship.minX >> 4;
        int maxX = this.ship.maxX >> 4;
        int minZ = this.ship.minZ >> 4;
        int maxZ = this.ship.maxZ >> 4;
        int chunkCount = 0;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                if (++chunkCount > this.ticketSourcePosition.getMaxChunkListDepth()) {
                    reason.append(Commons.getStyleWarning(), "warpdrive.ship.guide.too_many_chunks_to_load", (maxX - minX + 1) * (maxZ - minZ + 1), this.ticketSourcePosition.getMaxChunkListDepth());
                    reason.append(Commons.getStyleCommand(), "warpdrive.ship.guide.max_chunkloading", new Object[0]);
                    return false;
                }
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticketSourcePosition, (ChunkPos)new ChunkPos(x, z));
            }
        }
        return true;
    }

    private boolean forceTargetAnchor(WarpDriveText reason) {
        LocalProfiler.start("Jump.forceTargetAnchor");
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(String.format("%s Forcing target world %s", this, Commons.format(this.worldTarget)));
        }
        this.ticketTargetAnchor = ForgeChunkManager.requestTicket((Object)WarpDrive.instance, (World)this.worldTarget, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (this.ticketTargetAnchor == null) {
            reason.append(Commons.getStyleWarning(), "warpdrive.ship.guide.chunkloading_rejected_in_target_world", Commons.format(this.worldTarget));
            return false;
        }
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticketTargetAnchor, (ChunkPos)new ChunkPos(0, 0));
        LocalProfiler.stop();
        return true;
    }

    private boolean forceTargetChunks(WarpDriveText reason) {
        LocalProfiler.start("Jump.forceTargetChunks");
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(String.format("%s Forcing target chunks in %s", this, Commons.format(this.worldTarget)));
        }
        this.ticketTargetPosition = ForgeChunkManager.requestTicket((Object)WarpDrive.instance, (World)this.worldTarget, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (this.ticketTargetPosition == null) {
            reason.append(Commons.getStyleWarning(), "warpdrive.ship.guide.chunkloading_rejected_in_target_world", Commons.format(this.worldTarget));
            return false;
        }
        BlockPos targetMin = this.transformation.apply(this.ship.minX, this.ship.minY, this.ship.minZ);
        BlockPos targetMax = this.transformation.apply(this.ship.maxX, this.ship.maxY, this.ship.maxZ);
        int minX = Math.min(targetMin.func_177958_n(), targetMax.func_177958_n()) >> 4;
        int maxX = Math.max(targetMin.func_177958_n(), targetMax.func_177958_n()) >> 4;
        int minZ = Math.min(targetMin.func_177952_p(), targetMax.func_177952_p()) >> 4;
        int maxZ = Math.max(targetMin.func_177952_p(), targetMax.func_177952_p()) >> 4;
        int chunkCount = 0;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                if (++chunkCount > this.ticketTargetPosition.getMaxChunkListDepth()) {
                    reason.append(Commons.getStyleWarning(), "warpdrive.ship.guide.too_many_chunks_to_load", (maxX - minX + 1) * (maxZ - minZ + 1), this.ticketTargetPosition.getMaxChunkListDepth());
                    reason.append(Commons.getStyleCommand(), "warpdrive.ship.guide.max_chunkloading", new Object[0]);
                    return false;
                }
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticketTargetPosition, (ChunkPos)new ChunkPos(x, z));
            }
        }
        LocalProfiler.stop();
        return true;
    }

    private void releaseChunks() {
        int maxZ;
        int minZ;
        int maxX;
        int minX;
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Releasing chunks");
        }
        if (this.ticketSourcePosition != null) {
            minX = this.ship.minX >> 4;
            maxX = this.ship.maxX >> 4;
            minZ = this.ship.minZ >> 4;
            maxZ = this.ship.maxZ >> 4;
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    this.worldSource.func_72964_e(x, z).func_76603_b();
                    ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.ticketSourcePosition, (ChunkPos)new ChunkPos(x, z));
                }
            }
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticketSourcePosition);
            this.ticketSourcePosition = null;
        }
        if (this.ticketTargetAnchor != null) {
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.ticketTargetAnchor, (ChunkPos)new ChunkPos(0, 0));
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticketTargetAnchor);
            this.ticketTargetAnchor = null;
        }
        if (this.ticketTargetPosition != null) {
            BlockPos targetMin = this.transformation.apply(this.ship.minX, this.ship.minY, this.ship.minZ);
            BlockPos targetMax = this.transformation.apply(this.ship.maxX, this.ship.maxY, this.ship.maxZ);
            minX = Math.min(targetMin.func_177958_n(), targetMax.func_177958_n()) >> 4;
            maxX = Math.max(targetMin.func_177958_n(), targetMax.func_177958_n()) >> 4;
            minZ = Math.min(targetMin.func_177952_p(), targetMax.func_177952_p()) >> 4;
            maxZ = Math.max(targetMin.func_177952_p(), targetMax.func_177952_p()) >> 4;
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    this.worldTarget.func_72964_e(x, z).func_76603_b();
                    ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.ticketTargetPosition, (ChunkPos)new ChunkPos(x, z));
                }
            }
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticketTargetPosition);
            this.ticketTargetPosition = null;
        }
    }

    protected void state_chunkLoadingSource() {
        LocalProfiler.start("Jump.chunkLoadingSource");
        WarpDriveText reason = new WarpDriveText();
        if (!this.forceSourceChunks(reason)) {
            this.disableAndMessage(false, reason);
            LocalProfiler.stop();
            return;
        }
        LocalProfiler.stop();
    }

    protected void state_saveToMemory() {
        WarpDriveText reason;
        LocalProfiler.start("Jump.saveToMemory");
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Saving ship...");
        }
        if (!this.ship.save(reason = new WarpDriveText())) {
            this.disableAndMessage(false, reason);
            LocalProfiler.stop();
            return;
        }
        LocalProfiler.stop();
    }

    protected void state_checkBorders() {
        WarpDriveText reason;
        LocalProfiler.start("Jump.checkBorders");
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Checking ship borders...");
        }
        if (!this.ship.checkBorders(reason = new WarpDriveText())) {
            this.disableAndMessage(false, reason);
            LocalProfiler.stop();
            return;
        }
        LocalProfiler.stop();
    }

    protected void state_saveToDisk() {
        LocalProfiler.start("Jump.saveToDisk");
        File file = new File(WarpDriveConfig.G_SCHEMATICS_LOCATION + "/auto");
        if (!(file.exists() && file.isDirectory() || file.mkdirs())) {
            WarpDrive.logger.warn("Unable to create auto-backup folder, skipping...");
            LocalProfiler.stop();
            return;
        }
        try {
            Date now;
            String schematicFileName;
            SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd_HH'h'mm'm'ss's'SSS");
            String shipName = Commons.sanitizeFileName(this.ship.shipCore.name.replaceAll("[-~]", "").replaceAll(" ", "_"));
            do {
                now = new Date();
            } while (new File(schematicFileName = WarpDriveConfig.G_SCHEMATICS_LOCATION + "/auto/" + shipName + "_" + sdfDate.format(now) + ".schematic").exists());
            NBTTagCompound schematic = new NBTTagCompound();
            short width = (short)(this.ship.shipCore.maxX - this.ship.shipCore.minX + 1);
            short length = (short)(this.ship.shipCore.maxZ - this.ship.shipCore.minZ + 1);
            short height = (short)(this.ship.shipCore.maxY - this.ship.shipCore.minY + 1);
            schematic.func_74777_a("Width", width);
            schematic.func_74777_a("Length", length);
            schematic.func_74777_a("Height", height);
            schematic.func_74768_a("shipMass", this.ship.shipCore.shipMass);
            schematic.func_74778_a("shipName", this.ship.shipCore.name);
            schematic.func_74768_a("shipVolume", this.ship.shipCore.shipVolume);
            NBTTagCompound tagCompoundShip = new NBTTagCompound();
            this.ship.writeToNBT(tagCompoundShip);
            schematic.func_74782_a("ship", (NBTBase)tagCompoundShip);
            WarpDrive.logger.info(this + " Saving ship state prior to jump in " + schematicFileName);
            Commons.writeNBTToFile(schematicFileName, schematic);
        }
        catch (Exception exception) {
            exception.printStackTrace(WarpDrive.printStreamError);
        }
        this.msCounter = System.currentTimeMillis();
        LocalProfiler.stop();
    }

    protected void state_getInitialVector() {
        LocalProfiler.start("Jump.getInitialVector");
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Getting initial target vector...");
        }
        WarpDriveText reason = new WarpDriveText();
        this.betweenWorlds = this.shipMovementType == EnumShipMovementType.PLANET_TAKEOFF || this.shipMovementType == EnumShipMovementType.PLANET_LANDING || this.shipMovementType == EnumShipMovementType.HYPERSPACE_EXITING || this.shipMovementType == EnumShipMovementType.HYPERSPACE_ENTERING;
        CelestialObject celestialObjectSource = CelestialObjectManager.get(this.worldSource, this.ship.core.func_177958_n(), this.ship.core.func_177952_p());
        boolean isTargetWorldFound = this.computeTargetWorld(celestialObjectSource, this.shipMovementType, reason);
        if (!isTargetWorldFound) {
            LocalProfiler.stop();
            this.disableAndMessage(false, reason);
            return;
        }
        if ((this.worldSource != null && CelestialObjectManager.isPlanet(this.worldSource, this.ship.core.func_177958_n(), this.ship.core.func_177952_p()) || CelestialObjectManager.isPlanet(this.worldTarget, this.ship.core.func_177958_n() + this.moveX, this.ship.core.func_177952_p() + this.moveZ)) && !this.ship.isUnlimited() && this.ship.actualMass > WarpDriveConfig.SHIP_MASS_MAX_ON_PLANET_SURFACE) {
            LocalProfiler.stop();
            this.disableAndMessage(false, new WarpDriveText(Commons.getStyleWarning(), "warpdrive.ship.guide.too_much_mass_for_planet", WarpDriveConfig.SHIP_MASS_MAX_ON_PLANET_SURFACE, this.ship.actualMass));
            return;
        }
        if (this.betweenWorlds && WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(String.format("%s From world %s to %s", this, Commons.format(this.worldSource), Commons.format(this.worldTarget)));
        }
        this.isPluginCheckDone = false;
        this.firstAdjustmentReason = null;
        switch (this.shipMovementType) {
            case GATE_ACTIVATING: {
                this.moveX = this.destX - this.ship.core.func_177958_n();
                this.moveY = this.destY - this.ship.core.func_177956_o();
                this.moveZ = this.destZ - this.ship.core.func_177952_p();
                break;
            }
            case INSTANTIATE: 
            case RESTORE: {
                this.moveX = this.destX - this.ship.core.func_177958_n();
                this.moveY = this.destY - this.ship.core.func_177956_o();
                this.moveZ = this.destZ - this.ship.core.func_177952_p();
                this.isPluginCheckDone = true;
                break;
            }
            case PLANET_TAKEOFF: {
                this.moveY = 0;
                break;
            }
            case PLANET_LANDING: {
                this.moveY = 245 - this.ship.maxY;
                break;
            }
            case PLANET_MOVING: 
            case SPACE_MOVING: 
            case HYPERSPACE_MOVING: {
                int rangeZ;
                int rangeX;
                if (this.ship.maxY + this.moveY > 255) {
                    this.moveY = 255 - this.ship.maxY;
                }
                if (this.ship.minY + this.moveY < 5) {
                    this.moveY = 5 - this.ship.minY;
                }
                if (Math.max(rangeX = Math.abs(this.moveX) - (this.ship.maxX - this.ship.minX), rangeZ = Math.abs(this.moveZ) - (this.ship.maxZ - this.ship.minZ)) >= 256) break;
                this.firstAdjustmentReason = this.getPossibleJumpDistance();
                this.isPluginCheckDone = true;
                break;
            }
            case HYPERSPACE_ENTERING: 
            case HYPERSPACE_EXITING: {
                break;
            }
            default: {
                WarpDrive.logger.error(String.format("Invalid movement type %s in JumpSequence.", new Object[]{this.shipMovementType}));
            }
        }
        this.transformation = new Transformation(this.ship, this.worldTarget, this.moveX, this.moveY, this.moveZ, this.rotationSteps);
        LocalProfiler.stop();
    }

    protected void state_adjustJumpVector() {
        CheckMovementResult checkMovementResult;
        LocalProfiler.start("Jump.adjustJumpVector");
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Adjusting jump vector...");
        }
        BlockPos blockPosMinAtTarget = this.transformation.apply(this.ship.minX, this.ship.minY, this.ship.minZ);
        BlockPos blockPosMaxAtTarget = this.transformation.apply(this.ship.maxX, this.ship.maxY, this.ship.maxZ);
        AxisAlignedBB aabbSource = new AxisAlignedBB((double)this.ship.minX, (double)this.ship.minY, (double)this.ship.minZ, (double)this.ship.maxX, (double)this.ship.maxY, (double)this.ship.maxZ);
        aabbSource.func_72321_a(1.0, 1.0, 1.0);
        AxisAlignedBB aabbTarget = new AxisAlignedBB((double)blockPosMinAtTarget.func_177958_n(), (double)blockPosMinAtTarget.func_177956_o(), (double)blockPosMinAtTarget.func_177952_p(), (double)blockPosMaxAtTarget.func_177958_n(), (double)blockPosMaxAtTarget.func_177956_o(), (double)blockPosMaxAtTarget.func_177952_p());
        if (this.shipMovementType != EnumShipMovementType.INSTANTIATE && this.shipMovementType != EnumShipMovementType.RESTORE && !this.betweenWorlds && aabbSource.func_72326_a(aabbTarget)) {
            this.doCollisionDamage(false);
            WarpDriveText textOverlapping = new WarpDriveText(Commons.getStyleWarning(), "warpdrive.ship.guide.overlapping_source_and_target", new Object[0]);
            WarpDriveText textComponent = this.firstAdjustmentReason.isEmpty() ? textOverlapping : (this.firstAdjustmentReason.func_150260_c().equals(textOverlapping.func_150260_c()) ? this.firstAdjustmentReason : this.firstAdjustmentReason.append(Commons.getStyleWarning(), "warpdrive.ship.guide.not_enough_space_after_adjustment", new Object[0]));
            this.disableAndMessage(false, textComponent);
            LocalProfiler.stop();
            return;
        }
        CelestialObject celestialObjectTarget = CelestialObjectManager.get(this.worldTarget, (int)aabbTarget.field_72340_a, (int)aabbTarget.field_72339_c);
        if (celestialObjectTarget == null) {
            if (WarpDriveConfig.LOGGING_JUMP) {
                WarpDrive.logger.error(String.format("There's no world border defined for %s (%d)", Commons.format(this.worldTarget), this.worldTarget.field_73011_w.getDimension()));
            }
        } else if (!celestialObjectTarget.isInsideBorder(aabbTarget)) {
            AxisAlignedBB axisAlignedBB = celestialObjectTarget.getWorldBorderArea();
            WarpDriveText message = new WarpDriveText(Commons.getStyleWarning(), "warpdrive.ship.guide.target_outside_planet_border", (int)axisAlignedBB.field_72340_a, (int)axisAlignedBB.field_72338_b, (int)axisAlignedBB.field_72339_c, (int)axisAlignedBB.field_72336_d, (int)axisAlignedBB.field_72337_e, (int)axisAlignedBB.field_72334_f);
            LocalProfiler.stop();
            this.disableAndMessage(false, message);
            return;
        }
        if (!this.isPluginCheckDone && (checkMovementResult = this.checkCollisionAndProtection(this.transformation, true, "target", new VectorI(0, 0, 0))) != null) {
            this.disableAndMessage(false, checkMovementResult.reason);
            LocalProfiler.stop();
            return;
        }
        LocalProfiler.stop();
    }

    protected void state_loadTargetChunks() {
        WarpDriveText reason;
        LocalProfiler.start("Jump.loadTargetChunks");
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Loading chunks at target...");
        }
        if (!this.forceTargetChunks(reason = new WarpDriveText())) {
            this.disableAndMessage(false, reason);
            LocalProfiler.stop();
            return;
        }
        LocalProfiler.stop();
    }

    protected void state_saveEntitiesAndInformPlayers() {
        LocalProfiler.start("Jump.saveEntitiesAndInformPlayers");
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Saving entities...");
        }
        WarpDriveText reason = new WarpDriveText();
        if (this.shipMovementType != EnumShipMovementType.INSTANTIATE && this.shipMovementType != EnumShipMovementType.RESTORE && !this.ship.saveEntities(reason)) {
            this.disableAndMessage(false, reason);
            LocalProfiler.stop();
            return;
        }
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Saved " + this.ship.entitiesOnShip.size() + " entities from ship");
        }
        switch (this.shipMovementType) {
            case HYPERSPACE_ENTERING: {
                this.ship.messageToAllPlayersOnShip(new WarpDriveText(null, "warpdrive.ship.guide.entering_hyperspace", new Object[0]));
                break;
            }
            case HYPERSPACE_EXITING: {
                this.ship.messageToAllPlayersOnShip(new WarpDriveText(null, "warpdrive.ship.guide.leaving_hyperspace", new Object[0]));
                break;
            }
            case GATE_ACTIVATING: {
                this.ship.messageToAllPlayersOnShip(new WarpDriveText(null, "warpdrive.ship.guide.engaging_jumpgate_x", this.nameTarget));
                break;
            }
            case INSTANTIATE: 
            case RESTORE: {
                break;
            }
            default: {
                this.ship.messageToAllPlayersOnShip(new WarpDriveText(null, "warpdrive.ship.guide.jumping_xyz", (int)Math.ceil(Math.sqrt(this.moveX * this.moveX + this.moveY * this.moveY + this.moveZ * this.moveZ)), this.moveX, this.moveY, this.moveZ));
            }
        }
        if (this.shipMovementType != EnumShipMovementType.INSTANTIATE && this.shipMovementType != EnumShipMovementType.RESTORE) {
            switch (this.rotationSteps) {
                case 1: {
                    this.ship.messageToAllPlayersOnShip(new WarpDriveText(null, "warpdrive.ship.guide.turning_right", new Object[0]));
                    break;
                }
                case 2: {
                    this.ship.messageToAllPlayersOnShip(new WarpDriveText(null, "warpdrive.ship.guide.turning_back", new Object[0]));
                    break;
                }
                case 3: {
                    this.ship.messageToAllPlayersOnShip(new WarpDriveText(null, "warpdrive.ship.guide.turning_left", new Object[0]));
                    break;
                }
            }
        }
        LocalProfiler.stop();
        if (WarpDrive.isDev && WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(String.format("Checking for TE duplicates: tileEntities in target world before jump: %d", this.worldTarget.field_147482_g.size()));
        }
    }

    protected boolean computeTargetWorld(CelestialObject celestialObjectSource, @Nonnull EnumShipMovementType shipMovementType, WarpDriveText reason) {
        switch (shipMovementType) {
            case INSTANTIATE: 
            case RESTORE: {
                break;
            }
            case HYPERSPACE_EXITING: {
                CelestialObject celestialObject = CelestialObjectManager.getClosestChild(this.worldSource, this.ship.core.func_177958_n(), this.ship.core.func_177952_p());
                if (celestialObject == null) {
                    reason.append(Commons.getStyleWarning(), "warpdrive.ship.guide.no_celestial_object_in_hyperspace", Commons.format(this.worldSource), this.worldSource.field_73011_w.getDimension());
                    return false;
                }
                double distanceSquared = celestialObject.getSquareDistanceInParent(this.worldSource.field_73011_w.getDimension(), this.ship.core.func_177958_n(), this.ship.core.func_177952_p());
                if (distanceSquared > 0.0) {
                    AxisAlignedBB axisAlignedBB = celestialObject.getAreaInParent();
                    reason.append(Commons.getStyleWarning(), "warpdrive.ship.guide.no_star_system_in_range", (int)Math.sqrt(distanceSquared), (int)axisAlignedBB.field_72340_a, (int)axisAlignedBB.field_72338_b, (int)axisAlignedBB.field_72339_c, (int)axisAlignedBB.field_72336_d, (int)axisAlignedBB.field_72337_e, (int)axisAlignedBB.field_72334_f);
                    return false;
                }
                int dimensionIdSpace = celestialObject.dimensionId;
                this.worldTarget = Commons.getOrCreateWorldServer(dimensionIdSpace);
                if (this.worldTarget == null) {
                    reason.append(Commons.getStyleWarning(), "warpdrive.ship.guide.exception_loading_dimension", dimensionIdSpace);
                    return false;
                }
                VectorI vEntry = celestialObject.getEntryOffset();
                this.moveX = vEntry.x;
                this.moveZ = vEntry.z;
                break;
            }
            case HYPERSPACE_ENTERING: {
                if (celestialObjectSource == null || celestialObjectSource.parent == null) {
                    reason.append(Commons.getStyleWarning(), "warpdrive.ship.guide.unable_to_reach_hyperspace_no_parent", Commons.format(this.worldSource), this.worldSource.field_73011_w.getDimension());
                    return false;
                }
                int dimensionIdHyperspace = celestialObjectSource.parent.dimensionId;
                this.worldTarget = Commons.getOrCreateWorldServer(dimensionIdHyperspace);
                if (this.worldTarget == null) {
                    reason.append(Commons.getStyleWarning(), "warpdrive.ship.guide.exception_loading_dimension", dimensionIdHyperspace);
                    return false;
                }
                VectorI vEntry = celestialObjectSource.getEntryOffset();
                this.moveX = -vEntry.x;
                this.moveZ = -vEntry.z;
                break;
            }
            case PLANET_TAKEOFF: {
                if (celestialObjectSource == null || celestialObjectSource.parent == null) {
                    reason.append(Commons.getStyleWarning(), "warpdrive.ship.guide.unable_to_reach_space_no_parent", Commons.format(this.worldSource), this.worldSource.field_73011_w.getDimension());
                    return false;
                }
                double distanceSquared = celestialObjectSource.getSquareDistanceOutsideBorder(this.ship.core.func_177958_n(), this.ship.core.func_177952_p());
                if (distanceSquared > 0.0) {
                    AxisAlignedBB axisAlignedBB = celestialObjectSource.getAreaToReachParent();
                    reason.append(Commons.getStyleWarning(), "warpdrive.ship.guide.unable_to_reach_space_outside_border", (int)Math.sqrt(distanceSquared), (int)axisAlignedBB.field_72340_a, (int)axisAlignedBB.field_72338_b, (int)axisAlignedBB.field_72339_c, (int)axisAlignedBB.field_72336_d, (int)axisAlignedBB.field_72337_e, (int)axisAlignedBB.field_72334_f);
                    return false;
                }
                int dimensionIdSpace = celestialObjectSource.parent.dimensionId;
                this.worldTarget = Commons.getOrCreateWorldServer(dimensionIdSpace);
                if (this.worldTarget == null) {
                    reason.append(Commons.getStyleWarning(), "warpdrive.ship.guide.exception_loading_dimension", dimensionIdSpace);
                    return false;
                }
                VectorI vEntry = celestialObjectSource.getEntryOffset();
                this.moveX = -vEntry.x;
                this.moveZ = -vEntry.z;
                break;
            }
            case PLANET_LANDING: {
                CelestialObject celestialObject = CelestialObjectManager.getClosestChild(this.worldSource, this.ship.core.func_177958_n(), this.ship.core.func_177952_p());
                if (celestialObject == null) {
                    reason.append(Commons.getStyleWarning(), "warpdrive.ship.guide.no_celestial_object_in_space", Commons.format(this.worldSource), this.worldSource.field_73011_w.getDimension());
                    return false;
                }
                double distanceSquared = celestialObject.getSquareDistanceInParent(this.worldSource.field_73011_w.getDimension(), this.ship.core.func_177958_n(), this.ship.core.func_177952_p());
                if (distanceSquared > 0.0) {
                    AxisAlignedBB axisAlignedBB = celestialObject.getAreaInParent();
                    reason.append(Commons.getStyleWarning(), "warpdrive.ship.guide.unable_to_land_outside_orbit", (int)Math.sqrt(distanceSquared), (int)axisAlignedBB.field_72340_a, (int)axisAlignedBB.field_72338_b, (int)axisAlignedBB.field_72339_c, (int)axisAlignedBB.field_72336_d, (int)axisAlignedBB.field_72337_e, (int)axisAlignedBB.field_72334_f);
                    return false;
                }
                if (celestialObject.isVirtual()) {
                    reason.append(Commons.getStyleWarning(), "warpdrive.ship.guide.unable_to_land_virtual_planet", celestialObject.getDisplayName());
                    return false;
                }
                this.worldTarget = Commons.getOrCreateWorldServer(celestialObject.dimensionId);
                if (this.worldTarget == null) {
                    reason.append(Commons.getStyleWarning(), "warpdrive.ship.guide.exception_loading_dimension", celestialObject.getDisplayName(), celestialObject.dimensionId);
                    return false;
                }
                VectorI vEntry = celestialObject.getEntryOffset();
                this.moveX = vEntry.x;
                this.moveZ = vEntry.z;
                break;
            }
            case PLANET_MOVING: 
            case SPACE_MOVING: 
            case HYPERSPACE_MOVING: {
                this.worldTarget = this.worldSource;
                break;
            }
            default: {
                WarpDrive.logger.error(String.format("Invalid movement type %s", new Object[]{shipMovementType}));
                reason.append(Commons.getStyleWarning(), "warpdrive.error.internal_check_console", new Object[0]);
                return false;
            }
        }
        if (this.worldTarget != this.worldSource) {
            return this.forceTargetAnchor(reason);
        }
        return true;
    }

    protected void state_moveBlocks() {
        LocalProfiler.start("Jump.moveBlocks");
        int blocksToMove = Math.min(this.blocksPerTick, this.ship.jumpBlocks.length - this.actualIndexInShip);
        int periodEffect = Math.max(1, blocksToMove / 10);
        if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
            WarpDrive.logger.info(this + " Moving ship blocks " + this.actualIndexInShip + " to " + (this.actualIndexInShip + blocksToMove - 1) + " / " + (this.ship.jumpBlocks.length - 1));
        }
        int indexEffect = this.worldTarget.field_73012_v.nextInt(periodEffect);
        for (int index = 0; index < blocksToMove && this.actualIndexInShip < this.ship.jumpBlocks.length; ++index) {
            JumpBlock jumpBlock = this.ship.jumpBlocks[this.actualIndexInShip];
            if (jumpBlock != null) {
                if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                    WarpDrive.logger.info(String.format("Deploying from (%d %d %d) of %s@%d", jumpBlock.x, jumpBlock.y, jumpBlock.z, jumpBlock.block, jumpBlock.blockMeta));
                }
                if (this.shipMovementType == EnumShipMovementType.INSTANTIATE) {
                    jumpBlock.removeUniqueIDs();
                    jumpBlock.fillEnergyStorage();
                }
                if (this.shipMovementType != EnumShipMovementType.INSTANTIATE && this.shipMovementType != EnumShipMovementType.RESTORE && WarpDriveConfig.G_ENABLE_EXPERIMENTAL_REFRESH) {
                    jumpBlock.refreshSource(this.worldSource);
                }
                BlockPos target = jumpBlock.deploy(this.worldSource, this.worldTarget, this.transformation);
                if (this.shipMovementType != EnumShipMovementType.INSTANTIATE && this.shipMovementType != EnumShipMovementType.RESTORE) {
                    this.worldSource.func_175713_t(new BlockPos(jumpBlock.x, jumpBlock.y, jumpBlock.z));
                }
                if (--indexEffect <= 0) {
                    indexEffect = periodEffect;
                    if (target != null) {
                        this.doBlockEffect(jumpBlock, target);
                    }
                }
            }
            ++this.actualIndexInShip;
        }
        LocalProfiler.stop();
    }

    protected void doBlockEffect(@Nonnull JumpBlock jumpBlock, @Nonnull BlockPos target) {
        switch (this.shipMovementType) {
            case PLANET_TAKEOFF: 
            case HYPERSPACE_ENTERING: {
                PacketHandler.sendBeamPacket(this.worldSource, new Vector3((double)jumpBlock.x + 0.5, (double)jumpBlock.y + 0.5, (double)jumpBlock.z + 0.5), new Vector3((double)target.func_177958_n() + 0.5, (double)target.func_177956_o() + 32.5 + (double)this.worldTarget.field_73012_v.nextInt(5), (double)target.func_177952_p() + 0.5), 0.5f, 0.7f, 0.2f, 30, 0, 100);
                PacketHandler.sendBeamPacket(this.worldTarget, new Vector3((double)target.func_177958_n() + 0.5, (double)target.func_177956_o() - 31.5 - (double)this.worldTarget.field_73012_v.nextInt(5), (double)target.func_177952_p() + 0.5), new Vector3((double)target.func_177958_n() + 0.5, (double)target.func_177956_o() + 0.5, (double)target.func_177952_p() + 0.5), 0.5f, 0.7f, 0.2f, 30, 0, 100);
                break;
            }
            case PLANET_LANDING: 
            case HYPERSPACE_EXITING: {
                PacketHandler.sendBeamPacket(this.worldSource, new Vector3((double)jumpBlock.x + 0.5, (double)jumpBlock.y + 0.5, (double)jumpBlock.z + 0.5), new Vector3((double)target.func_177958_n() + 0.5, (double)target.func_177956_o() - 31.5 - (double)this.worldTarget.field_73012_v.nextInt(5), (double)target.func_177952_p() + 0.5), 0.7f, 0.1f, 0.6f, 30, 0, 100);
                PacketHandler.sendBeamPacket(this.worldTarget, new Vector3((double)target.func_177958_n() + 0.5, (double)target.func_177956_o() + 32.5 + (double)this.worldTarget.field_73012_v.nextInt(5), (double)target.func_177952_p() + 0.5), new Vector3((double)target.func_177958_n() + 0.5, (double)target.func_177956_o() + 0.5, (double)target.func_177952_p() + 0.5), 0.7f, 0.1f, 0.6f, 30, 0, 100);
                break;
            }
            case PLANET_MOVING: 
            case SPACE_MOVING: 
            case HYPERSPACE_MOVING: {
                PacketHandler.sendBeamPacket(this.worldTarget, new Vector3((double)jumpBlock.x + 0.5, (double)jumpBlock.y + 0.5, (double)jumpBlock.z + 0.5), new Vector3((double)target.func_177958_n() + 0.5, (double)target.func_177956_o() + 0.5, (double)target.func_177952_p() + 0.5), 0.6f, 0.1f, 0.7f, 30, 0, 100);
                break;
            }
            case GATE_ACTIVATING: {
                break;
            }
            case INSTANTIATE: 
            case RESTORE: {
                if (this.v3Source != null) {
                    this.worldTarget.func_184133_a(null, target, SoundEvents.LASER_LOW, SoundCategory.BLOCKS, 0.5f, 1.0f);
                    PacketHandler.sendBeamPacket(this.worldTarget, this.v3Source, new Vector3((double)target.func_177958_n() + 0.5, (double)target.func_177956_o() + 0.5, (double)target.func_177952_p() + 0.5), 0.0f, 1.0f, 0.0f, 15, 0, 100);
                }
                SoundType soundtype = jumpBlock.block.getSoundType(this.worldTarget.func_180495_p(target), this.worldTarget, target, null);
                this.worldTarget.func_184133_a(null, target, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                break;
            }
        }
    }

    protected void state_moveExternals() {
        LocalProfiler.start("Jump.moveExternals");
        int blocksToMove = Math.min(this.blocksPerTick, this.ship.jumpBlocks.length - this.actualIndexInShip);
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(String.format("%s Moving ship externals from %d/%d", this, this.actualIndexInShip, this.ship.jumpBlocks.length - 1));
        }
        int index = 0;
        while (index < blocksToMove && this.actualIndexInShip < this.ship.jumpBlocks.length) {
            JumpBlock jumpBlock = this.ship.jumpBlocks[this.ship.jumpBlocks.length - this.actualIndexInShip - 1];
            if (jumpBlock == null) {
                if (WarpDriveConfig.LOGGING_JUMP) {
                    WarpDrive.logger.info(String.format("%s Moving ship externals: unexpected null found at ship[%d]", this, this.actualIndexInShip));
                }
                ++this.actualIndexInShip;
                continue;
            }
            if (jumpBlock.externals != null) {
                if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                    WarpDrive.logger.info(String.format("Moving externals from (%d %d %d) of %s@%d", jumpBlock.x, jumpBlock.y, jumpBlock.z, jumpBlock.block, jumpBlock.blockMeta));
                }
                try {
                    TileEntity tileEntitySource = jumpBlock.getTileEntity(this.worldSource);
                    BlockPos blockPosTarget = this.transformation.apply(jumpBlock.x, jumpBlock.y, jumpBlock.z);
                    IBlockState blockStateTarget = this.worldTarget.func_180495_p(blockPosTarget);
                    for (Map.Entry<String, NBTBase> external : jumpBlock.externals.entrySet()) {
                        IBlockTransformer blockTransformer = WarpDriveConfig.blockTransformers.get(external.getKey());
                        if (blockTransformer == null) continue;
                        if (this.shipMovementType != EnumShipMovementType.INSTANTIATE && this.shipMovementType != EnumShipMovementType.RESTORE) {
                            blockTransformer.removeExternals(this.worldSource, jumpBlock.x, jumpBlock.y, jumpBlock.z, jumpBlock.block, jumpBlock.blockMeta, tileEntitySource);
                        }
                        TileEntity tileEntityTarget = jumpBlock.blockNBT == null ? null : this.worldTarget.func_175625_s(blockPosTarget);
                        blockTransformer.restoreExternals(this.worldTarget, blockPosTarget, blockStateTarget, tileEntityTarget, this.transformation, external.getValue());
                    }
                }
                catch (Exception exception) {
                    if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                        exception.printStackTrace(WarpDrive.printStreamError);
                    }
                    WarpDrive.logger.info(String.format("Exception while moving external %s@%d at (%d %d %d)", jumpBlock.block, jumpBlock.blockMeta, jumpBlock.x, jumpBlock.y, jumpBlock.z));
                }
                ++index;
            }
            ++this.actualIndexInShip;
        }
        LocalProfiler.stop();
    }

    protected void state_moveEntities() {
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Moving entities");
        }
        LocalProfiler.start("Jump.moveEntities");
        if (this.shipMovementType != EnumShipMovementType.INSTANTIATE && this.shipMovementType != EnumShipMovementType.RESTORE) {
            for (MovingEntity movingEntity : this.ship.entitiesOnShip) {
                Entity entity = movingEntity.getEntity();
                if (entity == null) continue;
                double oldEntityX = movingEntity.v3OriginalPosition.x;
                double oldEntityY = movingEntity.v3OriginalPosition.y;
                double oldEntityZ = movingEntity.v3OriginalPosition.z;
                Vec3d target = this.transformation.apply(oldEntityX, oldEntityY, oldEntityZ);
                double newEntityX = target.field_72450_a;
                double newEntityY = target.field_72448_b;
                double newEntityZ = target.field_72449_c;
                if (WarpDriveConfig.LOGGING_JUMP) {
                    WarpDrive.logger.info(String.format("%s Entity moving: (%.2f %.2f %.2f) -> (%.2f %.2f %.2f) entity %s", this, movingEntity.v3OriginalPosition.x, movingEntity.v3OriginalPosition.y, movingEntity.v3OriginalPosition.z, newEntityX, newEntityY, newEntityZ, entity.toString()));
                }
                this.transformation.rotate(entity);
                Commons.moveEntity(entity, this.worldTarget, new Vector3(newEntityX, newEntityY, newEntityZ));
                if (!(entity instanceof EntityPlayerMP)) continue;
                EntityPlayerMP player = (EntityPlayerMP)entity;
                BlockPos bedLocation = player.getBedLocation(player.field_70170_p.field_73011_w.getDimension());
                if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                    WarpDrive.logger.info(String.format("bedLocation %s ship %s min %d %d %d max %d %d %d", bedLocation, this.ship, this.ship.minX, this.ship.minY, this.ship.minZ, this.ship.maxX, this.ship.maxY, this.ship.maxZ));
                }
                if (bedLocation == null || this.ship.minX > bedLocation.func_177958_n() || this.ship.maxX < bedLocation.func_177958_n() || this.ship.minY > bedLocation.func_177956_o() || this.ship.maxY < bedLocation.func_177956_o() || this.ship.minZ > bedLocation.func_177952_p() || this.ship.maxZ < bedLocation.func_177952_p()) continue;
                bedLocation = this.transformation.apply(bedLocation);
                player.setSpawnChunk(bedLocation, false, this.worldTarget.field_73011_w.getDimension());
            }
        }
        LocalProfiler.stop();
    }

    protected void state_removeBlocks() {
        LocalProfiler.start("Jump.removeBlocks");
        int blocksToMove = Math.min(this.blocksPerTick, this.ship.jumpBlocks.length - this.actualIndexInShip);
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(String.format("%s Removing ship blocks %s to %d/%d", this, this.actualIndexInShip, this.actualIndexInShip + blocksToMove - 1, this.ship.jumpBlocks.length - 1));
        }
        for (int index = 0; index < blocksToMove && this.actualIndexInShip < this.ship.jumpBlocks.length; ++index) {
            JumpBlock jumpBlock = this.ship.jumpBlocks[this.ship.jumpBlocks.length - this.actualIndexInShip - 1];
            if (jumpBlock == null) {
                if (WarpDriveConfig.LOGGING_JUMP) {
                    WarpDrive.logger.info(String.format("%s Removing ship part: unexpected null found at ship[%d]", this, this.actualIndexInShip));
                }
                ++this.actualIndexInShip;
                continue;
            }
            if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                WarpDrive.logger.info(String.format("Removing block %s@%d at (%d %d %d)", jumpBlock.block, jumpBlock.blockMeta, jumpBlock.x, jumpBlock.y, jumpBlock.z));
            }
            if (this.worldSource != null) {
                BlockPos blockPos = new BlockPos(jumpBlock.x, jumpBlock.y, jumpBlock.z);
                if (jumpBlock.hasTileEntity) {
                    if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                        WarpDrive.logger.info(String.format("Removing tile entity at (%d %d %d)", jumpBlock.x, jumpBlock.y, jumpBlock.z));
                    }
                    this.worldSource.func_175713_t(blockPos);
                }
                try {
                    boolean isRemoved = FastSetBlockState.setBlockStateNoLight(this.worldSource, blockPos, Blocks.field_150350_a.func_176223_P(), 2);
                    if (!isRemoved && this.worldSource.func_180495_p(blockPos) != Blocks.field_150350_a.func_176223_P()) {
                        WarpDrive.logger.info(String.format("Failed to remove %s@%d at (%d %d %d), retrying...", jumpBlock.block, jumpBlock.blockMeta, jumpBlock.x, jumpBlock.y, jumpBlock.z));
                        isRemoved = FastSetBlockState.setBlockStateNoLight(this.worldSource, blockPos, Blocks.field_150350_a.func_176223_P(), 2);
                        if (!isRemoved) {
                            WarpDrive.logger.error(String.format("Failed to remove %s@%d at (%d %d %d), still failing?", jumpBlock.block, jumpBlock.blockMeta, jumpBlock.x, jumpBlock.y, jumpBlock.z));
                        }
                    }
                }
                catch (Exception exception) {
                    if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                        exception.printStackTrace(WarpDrive.printStreamError);
                    }
                    WarpDrive.logger.info(String.format("Exception while removing %s@%d at (%d %d %d)", jumpBlock.block, jumpBlock.blockMeta, jumpBlock.x, jumpBlock.y, jumpBlock.z));
                }
            }
            BlockPos target = this.transformation.apply(jumpBlock.x, jumpBlock.y, jumpBlock.z);
            JumpBlock.refreshBlockStateOnClient(this.worldTarget, target);
            ++this.actualIndexInShip;
        }
        WarpDriveText reason = new WarpDriveText();
        if (!this.ship.removeEntities(reason)) {
            WarpDrive.logger.error(reason.func_150260_c());
        }
        LocalProfiler.stop();
    }

    protected void state_chunkReleasing() {
        LocalProfiler.start("Jump.chunkReleasing");
        this.releaseChunks();
        LocalProfiler.stop();
    }

    protected void state_finishing() {
        int countBefore;
        block4: {
            LocalProfiler.start("Jump.finishing()");
            if (WarpDriveConfig.LOGGING_JUMP) {
                WarpDrive.logger.info(this + " Jump done in " + (float)(System.currentTimeMillis() - this.msCounter) / 1000.0f + " seconds and " + this.ticks + " ticks");
            }
            countBefore = this.worldTarget.field_147482_g.size();
            try {
                JumpSequencer.removeDuplicates(this.worldTarget.field_147482_g);
            }
            catch (Exception exception) {
                if (!WarpDriveConfig.LOGGING_JUMP) break block4;
                exception.printStackTrace(WarpDrive.printStreamError);
                WarpDrive.logger.info(String.format("Exception while checking for TE duplicates: %s", exception.getMessage()));
            }
        }
        this.doCollisionDamage(true);
        this.disable(true, new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.ship.guide.jump_done", new Object[0]));
        int countAfter = this.worldTarget.field_147482_g.size();
        if (WarpDriveConfig.LOGGING_JUMP && countBefore != countAfter) {
            WarpDrive.logger.info(String.format("Checking for TE duplicates: tileEntities in target world after jump, cleanup %d -> %d", countBefore, countAfter));
        }
        LocalProfiler.stop();
    }

    private WarpDriveText getPossibleJumpDistance() {
        int originalRange;
        CheckMovementResult result;
        int testRange;
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Calculating possible jump distance...");
        }
        int blowPoints = 0;
        this.collisionDetected = false;
        WarpDriveText firstAdjustmentReason = null;
        for (testRange = originalRange = Math.max(Math.abs(this.moveX), Math.max(Math.abs(this.moveY), Math.abs(this.moveZ))); testRange >= 0 && (result = this.checkMovement((double)testRange / (double)originalRange, false)) != null; --testRange) {
            if (firstAdjustmentReason == null) {
                firstAdjustmentReason = result.reason;
            }
            if (!result.isCollision) continue;
            ++blowPoints;
        }
        VectorI finalMovement = this.getMovementVector((double)testRange / (double)originalRange);
        if (originalRange != testRange && WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Jump range adjusted from " + originalRange + " to " + testRange + " after " + blowPoints + " collisions");
        }
        if (blowPoints > WarpDriveConfig.SHIP_COLLISION_TOLERANCE_BLOCKS) {
            result = this.checkMovement(Math.min(1.0, Math.max(0.0, (double)(testRange + 1) / (double)originalRange)), true);
            if (result != null) {
                float massCorrection = 0.5f + (float)Math.sqrt(Math.min(1.0, Math.max(0.0, (double)(this.ship.shipCore.shipMass - WarpDriveConfig.SHIP_MASS_MAX_ON_PLANET_SURFACE)) / (double)WarpDriveConfig.SHIP_MASS_MIN_FOR_HYPERSPACE));
                this.collisionDetected = true;
                this.collisionStrength = (4.0f + (float)blowPoints - (float)WarpDriveConfig.SHIP_COLLISION_TOLERANCE_BLOCKS) * massCorrection;
                this.collisionAtSource = result.atSource;
                this.collisionAtTarget = result.atTarget;
                WarpDrive.logger.info(this + " Reporting " + this.collisionAtTarget.size() + " collisions points after " + blowPoints + " blowPoints with " + String.format("%.2f", Float.valueOf(massCorrection)) + " ship mass correction => " + String.format("%.2f", Float.valueOf(this.collisionStrength)) + " explosion strength");
            } else {
                WarpDrive.logger.error("WarpDrive error: unable to compute collision points, ignoring...");
            }
        }
        this.moveX = finalMovement.x;
        this.moveY = finalMovement.y;
        this.moveZ = finalMovement.z;
        return firstAdjustmentReason;
    }

    private void doCollisionDamage(boolean atTarget) {
        if (!this.collisionDetected) {
            if (WarpDriveConfig.LOGGING_JUMP) {
                WarpDrive.logger.info(this + " doCollisionDamage No collision detected...");
            }
            return;
        }
        ArrayList<Vector3> collisionPoints = atTarget ? this.collisionAtTarget : this.collisionAtSource;
        Vector3 min = collisionPoints.get(0).clone();
        Vector3 max = collisionPoints.get(0).clone();
        for (Vector3 v : collisionPoints) {
            if (min.x > v.x) {
                min.x = v.x;
            } else if (max.x < v.x) {
                max.x = v.x;
            }
            if (min.y > v.y) {
                min.y = v.y;
            } else if (max.y < v.y) {
                max.y = v.y;
            }
            if (min.z > v.z) {
                min.z = v.z;
                continue;
            }
            if (!(max.z < v.z)) continue;
            max.z = v.z;
        }
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Ship collision from " + min + " to " + max);
        }
        double rx = Math.round(min.x + (double)this.worldSource.field_73012_v.nextInt(Math.max(1, (int)(max.x - min.x))));
        double ry = Math.round(min.y + (double)this.worldSource.field_73012_v.nextInt(Math.max(1, (int)(max.y - min.y))));
        double rz = Math.round(min.z + (double)this.worldSource.field_73012_v.nextInt(Math.max(1, (int)(max.z - min.z))));
        this.ship.messageToAllPlayersOnShip(new WarpDriveText(Commons.getStyleWarning(), "warpdrive.ship.guide.ship_collision", (int)rx, (int)ry, (int)rz));
        int nbExplosions = Math.min(5, collisionPoints.size());
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(String.format("doCollisionDamage nbExplosions %d/%d", nbExplosions, collisionPoints.size()));
        }
        for (int i = 0; i < nbExplosions; ++i) {
            Vector3 current;
            if (nbExplosions < collisionPoints.size()) {
                if (WarpDriveConfig.LOGGING_JUMP) {
                    WarpDrive.logger.info(String.format("doCollisionDamage random #%d", i));
                }
                current = collisionPoints.get(this.worldSource.field_73012_v.nextInt(collisionPoints.size()));
            } else {
                if (WarpDriveConfig.LOGGING_JUMP) {
                    WarpDrive.logger.info(String.format("doCollisionDamage get %d", i));
                }
                current = collisionPoints.get(i);
            }
            float strength = Math.max(4.0f, this.collisionStrength / (float)nbExplosions - 2.0f + 2.0f * this.worldSource.field_73012_v.nextFloat());
            (atTarget ? this.worldTarget : this.worldSource).func_72885_a(null, current.x, current.y, current.z, strength, atTarget, atTarget);
            WarpDrive.logger.info(String.format("Ship collision caused explosion at (%.1f %.1f %.1f) with strength %.3f", current.x, current.y, current.z, Float.valueOf(strength)));
        }
    }

    private void restoreEntitiesPosition() {
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(String.format("%s Restoring entities position", this));
        }
        LocalProfiler.start("Jump.restoreEntitiesPosition");
        if (this.shipMovementType != EnumShipMovementType.INSTANTIATE && this.shipMovementType != EnumShipMovementType.RESTORE) {
            for (MovingEntity movingEntity : this.ship.entitiesOnShip) {
                Entity entity = movingEntity.getEntity();
                if (entity == null) continue;
                if (WarpDriveConfig.LOGGING_JUMP) {
                    WarpDrive.logger.info(String.format("Entity restoring position at (%f %f %f)", movingEntity.v3OriginalPosition.x, movingEntity.v3OriginalPosition.y, movingEntity.v3OriginalPosition.z));
                }
                if (entity instanceof EntityPlayerMP) {
                    EntityPlayerMP player = (EntityPlayerMP)entity;
                    player.func_70634_a(movingEntity.v3OriginalPosition.x, movingEntity.v3OriginalPosition.y, movingEntity.v3OriginalPosition.z);
                    continue;
                }
                entity.func_70107_b(movingEntity.v3OriginalPosition.x, movingEntity.v3OriginalPosition.y, movingEntity.v3OriginalPosition.z);
            }
        }
        LocalProfiler.stop();
    }

    private CheckMovementResult checkCollisionAndProtection(ITransformation transformation, boolean fullCollisionDetails, String context, VectorI vMovement) {
        CheckMovementResult result = new CheckMovementResult();
        VectorI offset = new VectorI((int)Math.signum(this.moveX), (int)Math.signum(this.moveY), (int)Math.signum(this.moveZ));
        BlockPos.MutableBlockPos mutableBlockPosSource = new BlockPos.MutableBlockPos(0, 0, 0);
        BlockPos blockPosCoreAtTarget = transformation.apply(this.ship.core.func_177958_n(), this.ship.core.func_177956_o(), this.ship.core.func_177952_p());
        AxisAlignedBB aabbSource = new AxisAlignedBB((double)this.ship.minX, (double)this.ship.minY, (double)this.ship.minZ, (double)this.ship.maxX, (double)this.ship.maxY, (double)this.ship.maxZ);
        aabbSource.func_72321_a(1.0, 1.0, 1.0);
        BlockPos blockPosMinAtTarget = transformation.apply(this.ship.minX, this.ship.minY, this.ship.minZ);
        BlockPos blockPosMaxAtTarget = transformation.apply(this.ship.maxX, this.ship.maxY, this.ship.maxZ);
        AxisAlignedBB aabbTarget = new AxisAlignedBB((double)blockPosMinAtTarget.func_177958_n(), (double)blockPosMinAtTarget.func_177956_o(), (double)blockPosMinAtTarget.func_177952_p(), (double)blockPosMaxAtTarget.func_177958_n(), (double)blockPosMaxAtTarget.func_177956_o(), (double)blockPosMaxAtTarget.func_177952_p());
        if (this.shipMovementType != EnumShipMovementType.INSTANTIATE && this.shipMovementType != EnumShipMovementType.RESTORE && !this.betweenWorlds && aabbSource.func_72326_a(aabbTarget)) {
            result.add(this.ship.core.func_177958_n(), this.ship.core.func_177956_o(), this.ship.core.func_177952_p(), blockPosCoreAtTarget.func_177958_n(), blockPosCoreAtTarget.func_177956_o(), blockPosCoreAtTarget.func_177952_p(), false, new WarpDriveText(Commons.getStyleWarning(), "warpdrive.ship.guide.overlapping_source_and_target", new Object[0]));
            return result;
        }
        EventWarpDrive.Ship.TargetCheck targetCheck = new EventWarpDrive.Ship.TargetCheck(this.worldSource, this.ship.core, this.ship.shipCore, this.shipMovementType.func_176610_l(), vMovement.x, vMovement.y, vMovement.z, this.worldTarget, aabbTarget);
        MinecraftForge.EVENT_BUS.post((Event)targetCheck);
        if (targetCheck.isCanceled()) {
            result.add(this.ship.core.func_177958_n(), this.ship.core.func_177956_o(), this.ship.core.func_177952_p(), blockPosCoreAtTarget.func_177958_n(), blockPosCoreAtTarget.func_177956_o(), blockPosCoreAtTarget.func_177952_p(), false, targetCheck.getReason());
            return result;
        }
        for (int y = this.ship.minY; y <= this.ship.maxY; ++y) {
            for (int x = this.ship.minX; x <= this.ship.maxX; ++x) {
                for (int z = this.ship.minZ; z <= this.ship.maxZ; ++z) {
                    mutableBlockPosSource.func_181079_c(x, y, z);
                    BlockPos blockPosTarget = transformation.apply(x, y, z);
                    IBlockState blockStateSource = this.worldSource.func_180495_p((BlockPos)mutableBlockPosSource);
                    IBlockState blockStateTarget = this.worldTarget.func_180495_p(blockPosTarget);
                    if (Dictionary.BLOCKS_ANCHOR.contains(blockStateTarget.func_177230_c())) {
                        result.add(x, y, z, (double)blockPosTarget.func_177958_n() + 0.5 - (double)offset.x, (double)blockPosTarget.func_177956_o() + 0.5 - (double)offset.y, (double)blockPosTarget.func_177952_p() + 0.5 - (double)offset.z, true, new WarpDriveText(Commons.getStyleWarning(), "warpdrive.ship.guide.impassable_block_detected", blockStateTarget, blockPosTarget.func_177958_n(), blockPosTarget.func_177956_o(), blockPosTarget.func_177952_p()));
                        if (!fullCollisionDetails) {
                            return result;
                        }
                        if (WarpDriveConfig.LOGGING_JUMP) {
                            WarpDrive.logger.info(String.format("Anchor collision at %s", context));
                        }
                    }
                    if (blockStateSource.func_177230_c() != Blocks.field_150350_a && !Dictionary.BLOCKS_EXPANDABLE.contains(blockStateSource.func_177230_c()) && blockStateTarget.func_177230_c() != Blocks.field_150350_a && !Dictionary.BLOCKS_EXPANDABLE.contains(blockStateTarget.func_177230_c())) {
                        result.add(x, y, z, (double)blockPosTarget.func_177958_n() + 0.5 + (double)offset.x * 0.1, (double)blockPosTarget.func_177956_o() + 0.5 + (double)offset.y * 0.1, (double)blockPosTarget.func_177952_p() + 0.5 + (double)offset.z * 0.1, true, new WarpDriveText(Commons.getStyleWarning(), "warpdrive.ship.guide.obstacle_block_detected", Commons.format(blockStateTarget, this.worldTarget, blockPosTarget), blockPosTarget.func_177958_n(), blockPosTarget.func_177956_o(), blockPosTarget.func_177952_p()));
                        if (!fullCollisionDetails) {
                            return result;
                        }
                        if (WarpDriveConfig.LOGGING_JUMP) {
                            WarpDrive.logger.info(String.format("Hard collision at %s", context));
                        }
                    }
                    if (blockStateSource.func_177230_c() == Blocks.field_150350_a || !WarpDriveConfig.G_ENABLE_PROTECTION_CHECKS || !CommonProxy.isBlockPlaceCanceled(null, blockPosCoreAtTarget, this.worldTarget, blockPosTarget, blockStateSource)) continue;
                    result.add(x, y, z, blockPosTarget.func_177958_n(), blockPosTarget.func_177956_o(), blockPosTarget.func_177952_p(), false, new WarpDriveText(Commons.getStyleWarning(), "warpdrive.ship.guide.entering_protected_area", blockPosTarget.func_177958_n(), blockPosTarget.func_177956_o(), blockPosTarget.func_177952_p()));
                    return result;
                }
            }
        }
        if (fullCollisionDetails && result.isCollision) {
            return result;
        }
        return null;
    }

    private CheckMovementResult checkMovement(double ratio, boolean fullCollisionDetails) {
        CheckMovementResult result = new CheckMovementResult();
        VectorI testMovement = this.getMovementVector(ratio);
        if (this.moveY > 0 && this.ship.maxY + testMovement.y > 255 && !this.betweenWorlds) {
            result.add(this.ship.core.func_177958_n(), this.ship.maxY + testMovement.y, this.ship.core.func_177952_p(), (double)this.ship.core.func_177958_n() + 0.5, (double)(this.ship.maxY + testMovement.y) + 1.0, (double)this.ship.core.func_177952_p() + 0.5, false, new WarpDriveText(Commons.getStyleWarning(), "warpdrive.ship.guide.moving_too_high", new Object[0]));
            return result;
        }
        if (this.moveY < 0 && this.ship.minY + testMovement.y <= 8 && !this.betweenWorlds) {
            result.add(this.ship.core.func_177958_n(), this.ship.minY + testMovement.y, this.ship.core.func_177952_p(), (double)this.ship.core.func_177958_n() + 0.5, this.ship.maxY + testMovement.y, (double)this.ship.core.func_177952_p() + 0.5, false, new WarpDriveText(Commons.getStyleWarning(), "warpdrive.ship.guide.moving_too_low", new Object[0]));
            return result;
        }
        Transformation testTransformation = new Transformation(this.ship, this.worldTarget, testMovement.x, testMovement.y, testMovement.z, this.rotationSteps);
        return this.checkCollisionAndProtection(testTransformation, fullCollisionDetails, String.format("ratio %.3f movement %s", ratio, testMovement), testMovement);
    }

    private VectorI getMovementVector(double ratio) {
        return new VectorI((int)Math.round((double)this.moveX * ratio), (int)Math.round((double)this.moveY * ratio), (int)Math.round((double)this.moveZ * ratio));
    }

    private static List<TileEntity> removeDuplicates(List<TileEntity> listTileEntities) {
        TreeSet<TileEntity> setTileEntities = new TreeSet<TileEntity>(new Comparator<TileEntity>(){

            @Override
            public int compare(TileEntity tileEntity1, TileEntity tileEntity2) {
                if (tileEntity1 == tileEntity2) {
                    if (WarpDriveConfig.LOGGING_JUMP) {
                        WarpDrive.logger.warn(String.format("Checking for TE duplicates: same instance listed twice %s: %s", Commons.format(tileEntity1.func_145831_w(), tileEntity1.func_174877_v()), tileEntity1));
                        NBTTagCompound nbtTagCompound1 = new NBTTagCompound();
                        tileEntity1.func_189515_b(nbtTagCompound1);
                        WarpDrive.logger.warn(String.format("NBT is %s", nbtTagCompound1));
                    }
                    return 0;
                }
                if (tileEntity1.func_174877_v().func_177958_n() == tileEntity2.func_174877_v().func_177958_n() && tileEntity1.func_174877_v().func_177956_o() == tileEntity2.func_174877_v().func_177956_o() && tileEntity1.func_174877_v().func_177952_p() == tileEntity2.func_174877_v().func_177952_p() && !tileEntity1.func_145837_r() && !tileEntity2.func_145837_r()) {
                    if (WarpDriveConfig.LOGGING_JUMP) {
                        WarpDrive.logger.warn(String.format("Checking for TE duplicates: detected duplicate %s: %s vs %s", Commons.format(tileEntity1.func_145831_w(), tileEntity1.func_174877_v()), tileEntity1, tileEntity2));
                        NBTTagCompound nbtTagCompound1 = new NBTTagCompound();
                        tileEntity1.func_189515_b(nbtTagCompound1);
                        WarpDrive.logger.warn(String.format("First  NBT is %s", nbtTagCompound1));
                        NBTTagCompound nbtTagCompound2 = new NBTTagCompound();
                        tileEntity2.func_189515_b(nbtTagCompound2);
                        WarpDrive.logger.warn(String.format("Second NBT is %s", nbtTagCompound2));
                    }
                    return 0;
                }
                return 1;
            }
        });
        setTileEntities.addAll(listTileEntities);
        return new ArrayList<TileEntity>(setTileEntities);
    }

    @Override
    protected void readFromNBT(@Nonnull NBTTagCompound tagCompound) {
        WarpDrive.logger.error(String.format("%s readFromNBT()", this));
    }

    @Override
    protected NBTTagCompound writeToNBT(@Nonnull NBTTagCompound tagCompound) {
        WarpDrive.logger.error(String.format("%s writeToNBT()", this));
        return tagCompound;
    }

    public String toString() {
        return String.format("%s/%d '%s' @ %s (%d %d %d) #%d", this.getClass().getSimpleName(), this.hashCode(), this.ship == null || this.ship.shipCore == null ? "~NULL~" : this.ship.shipCore.uuid + ":" + this.ship.shipCore.name, Commons.format(this.worldSource), this.ship == null ? -1 : this.ship.core.func_177958_n(), this.ship == null ? -1 : this.ship.core.func_177956_o(), this.ship == null ? -1 : this.ship.core.func_177952_p(), this.ticks);
    }

    static /* synthetic */ WarpDriveText access$000() {
        return reasonUnknown;
    }

    private class CheckMovementResult {
        final ArrayList<Vector3> atSource = new ArrayList(1);
        final ArrayList<Vector3> atTarget = new ArrayList(1);
        boolean isCollision = false;
        public WarpDriveText reason = JumpSequencer.access$000();

        CheckMovementResult() {
        }

        public void add(double sx, double sy, double sz, double tx, double ty, double tz, boolean isCollision, WarpDriveText reason) {
            this.atSource.add(new Vector3(sx, sy, sz));
            this.atTarget.add(new Vector3(tx, ty, tz));
            this.isCollision = this.isCollision || isCollision;
            this.reason = reason;
            if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                WarpDrive.logger.info(String.format("CheckMovementResult (%.1f %.1f %.1f) -> (%.1f %.1f %.1f) %s '%s'", new Object[]{sx, sy, sz, tx, ty, tz, isCollision, reason}));
            }
        }
    }
}

