/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.event;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBlockBase;
import cr0s.warpdrive.block.forcefield.BlockForceField;
import cr0s.warpdrive.block.movement.TileEntityShipCore;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnumGlobalRegionType;
import cr0s.warpdrive.data.GlobalRegion;
import cr0s.warpdrive.data.GlobalRegionManager;
import cr0s.warpdrive.data.OfflineAvatarManager;
import cr0s.warpdrive.event.AbstractSequencer;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class PlayerHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerLoadFromFile(@Nonnull PlayerEvent.LoadFromFile event) {
        OfflineAvatarManager.onPlayerLoggedIn(event.getEntityPlayer());
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(@Nonnull PlayerEvent.PlayerLoggedOutEvent event) {
        if (WarpDriveConfig.OFFLINE_AVATAR_ENABLE) {
            OfflineAvatarManager.onPlayerLoggedOut(event.player);
        }
    }

    @SubscribeEvent
    public void onBreakSpeed(@Nonnull PlayerEvent.BreakSpeed event) {
        EntityPlayer entityPlayer = event.getEntityPlayer();
        BlockPos blockPos = event.getPos();
        this.doCancelEventDuringJump((PlayerEvent)event, blockPos);
        if (event.isCanceled()) {
            return;
        }
        IBlockState blockState = event.getState();
        if (!(blockState.func_177230_c() instanceof IBlockBase) || blockState.func_177230_c() instanceof BlockForceField || blockState.func_185887_b(entityPlayer.field_70170_p, blockPos) < WarpDriveConfig.HULL_HARDNESS[1]) {
            return;
        }
        GlobalRegion globalRegion = GlobalRegionManager.getNearest(EnumGlobalRegionType.SHIP, entityPlayer.field_70170_p, blockPos);
        if (globalRegion == null || !globalRegion.contains(blockPos)) {
            return;
        }
        TileEntity tileEntity = entityPlayer.field_70170_p.func_175625_s(globalRegion.getBlockPos());
        if (!(tileEntity instanceof TileEntityShipCore)) {
            WarpDrive.logger.error(String.format("Unable to adjust harvest speed due to invalid tile entity for global region, expecting TileEntityShipCore, got %s", this));
            return;
        }
        TileEntityShipCore tileEntityShipCoreClosest = (TileEntityShipCore)tileEntity;
        if (!tileEntityShipCoreClosest.isAssemblyValid() || !tileEntityShipCoreClosest.isUnderMaintenance()) {
            return;
        }
        TileEntityShipCore tileEntityShipCoreIntersect = GlobalRegionManager.getIntersectingShipCore(tileEntityShipCoreClosest);
        if (tileEntityShipCoreIntersect == null) {
            int indexTier = ((IBlockBase)blockState.func_177230_c()).getTier(null).getIndex();
            event.setNewSpeed(100.0f * (float)indexTier);
        }
    }

    @SubscribeEvent
    public void onEntityItemPickup(@Nonnull EntityItemPickupEvent event) {
        this.doCancelEventDuringJump((PlayerEvent)event, event.getItem().func_180425_c());
    }

    @SubscribeEvent
    public void onRightClickBlock(@Nonnull PlayerInteractEvent.RightClickBlock event) {
        this.doCancelEventDuringJump((PlayerEvent)event, event.getPos());
    }

    private void doCancelEventDuringJump(@Nonnull PlayerEvent event, @Nonnull BlockPos blockPos) {
        assert (event.isCancelable());
        if (event.isCanceled()) {
            return;
        }
        if (AbstractSequencer.isLocked(blockPos)) {
            event.setCanceled(true);
        }
    }
}

