/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.event;

import cr0s.warpdrive.BreathingManager;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CelestialObject;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.data.GlobalRegionManager;
import cr0s.warpdrive.event.AbstractSequencer;
import cr0s.warpdrive.event.ChunkHandler;
import cr0s.warpdrive.event.LivingHandler;
import cr0s.warpdrive.network.PacketHandler;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldHandler {
    public void onChunkLoaded(ChunkWatchEvent event) {
        Chunk chunk = event.getChunkInstance();
        assert (chunk != null);
        WarpDrive.logger.info(String.format("onChunkLoaded %d %d", chunk.field_76635_g, chunk.field_76647_h));
        WarpDrive.cloaks.onChunkLoaded(event.getPlayer(), chunk.field_76635_g, chunk.field_76647_h);
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (event.getEntity() instanceof EntityLivingBase) {
            EntityLivingBase entityLivingBase = (EntityLivingBase)event.getEntity();
            int x = MathHelper.func_76128_c((double)entityLivingBase.field_70165_t);
            int y = MathHelper.func_76128_c((double)entityLivingBase.field_70163_u);
            int z = MathHelper.func_76128_c((double)entityLivingBase.field_70161_v);
            CelestialObject celestialObject = CelestialObjectManager.get(event.getWorld(), x, z);
            if (entityLivingBase instanceof EntityPlayerMP) {
                WarpDrive.cloaks.onPlayerJoinWorld((EntityPlayerMP)entityLivingBase, event.getWorld());
                PacketHandler.sendClientSync((EntityPlayerMP)entityLivingBase, celestialObject);
            } else {
                boolean canJoin;
                if (celestialObject == null) {
                    return;
                }
                if (entityLivingBase.field_70173_aa > 5) {
                    return;
                }
                if (!celestialObject.hasAtmosphere() && !(canJoin = BreathingManager.onLivingJoinEvent(entityLivingBase, x, y, z))) {
                    event.setCanceled(true);
                }
                if (!celestialObject.isInsideBorder(entityLivingBase.field_70165_t, entityLivingBase.field_70161_v)) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        WarpDrive.logger.info(String.format("onPlayerChangedDimension %s %d -> %d (%.1f %.1f %.1f)", event.player.func_70005_c_(), event.fromDim, event.toDim, event.player.field_70165_t, event.player.field_70163_u, event.player.field_70161_v));
        WarpDrive.cloaks.onPlayerJoinWorld((EntityPlayerMP)event.player, ((EntityPlayerMP)event.player).field_70170_p);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientConnectedToServer(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        WarpDrive.cloaks.onClientChangingDimension();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onWorldUnload(WorldEvent.Unload event) {
        WarpDrive.cloaks.onClientChangingDimension();
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.side != Side.SERVER || event.phase != TickEvent.Phase.END) {
            return;
        }
        AbstractSequencer.updateTick();
        LivingHandler.updateTick();
    }

    @SubscribeEvent
    public void onBlockEvent(BlockEvent blockEvent) {
        List listBlockSnapshots;
        IBlockState blockStatePlaced;
        IBlockState blockStateBefore;
        Entity entity;
        if (WarpDriveConfig.isGregtechLoaded && blockEvent.getWorld().func_72912_H().func_76065_j().equals("DummyServer")) {
            return;
        }
        if (blockEvent instanceof BlockEvent.EntityPlaceEvent) {
            BlockEvent.EntityPlaceEvent entityPlaceEvent = (BlockEvent.EntityPlaceEvent)blockEvent;
            entity = entityPlaceEvent.getEntity();
            if (entity instanceof EntityPlayer) {
                blockStateBefore = entityPlaceEvent.getBlockSnapshot().getReplacedBlock();
                blockStatePlaced = entityPlaceEvent.getPlacedBlock();
            } else {
                blockStateBefore = entityPlaceEvent.getPlacedAgainst();
                blockStatePlaced = entityPlaceEvent.getPlacedBlock();
            }
        } else if (blockEvent instanceof BlockEvent.BreakEvent) {
            entity = ((BlockEvent.BreakEvent)blockEvent).getPlayer();
            blockStateBefore = blockEvent.getWorld().func_180495_p(blockEvent.getPos());
            blockStatePlaced = blockEvent.getState();
        } else {
            entity = null;
            blockStateBefore = blockEvent.getWorld().func_180495_p(blockEvent.getPos());
            blockStatePlaced = blockEvent.getState();
        }
        if (WarpDriveConfig.LOGGING_BREAK_PLACE && WarpDrive.isDev) {
            if (blockStateBefore != blockStatePlaced) {
                WarpDrive.logger.info(String.format("onBlockEvent %s %s -> %s %s by %s", blockEvent.getClass().getSimpleName(), blockStateBefore, blockStatePlaced, Commons.format(blockEvent.getWorld(), blockEvent.getPos()), entity));
            } else {
                WarpDrive.logger.info(String.format("onBlockEvent %s %s %s by %s", blockEvent.getClass().getSimpleName(), blockStatePlaced, Commons.format(blockEvent.getWorld(), blockEvent.getPos()), entity));
            }
        }
        boolean isAllowed = true;
        if (blockEvent instanceof BlockEvent.MultiPlaceEvent || blockEvent instanceof BlockEvent.EntityMultiPlaceEvent) {
            listBlockSnapshots = blockEvent instanceof BlockEvent.MultiPlaceEvent ? ((BlockEvent.MultiPlaceEvent)blockEvent).getReplacedBlockSnapshots() : ((BlockEvent.EntityMultiPlaceEvent)blockEvent).getReplacedBlockSnapshots();
            for (BlockSnapshot blockSnapshot : listBlockSnapshots) {
                IBlockState blockStateCurrent = blockSnapshot.getCurrentBlock();
                boolean bl = isAllowed = isAllowed && GlobalRegionManager.onBlockUpdating(entity, blockEvent.getWorld(), blockSnapshot.getPos(), blockStateCurrent);
                if (blockStateCurrent == blockSnapshot.getReplacedBlock()) continue;
                isAllowed = isAllowed && GlobalRegionManager.onBlockUpdating(entity, blockEvent.getWorld(), blockSnapshot.getPos(), blockSnapshot.getReplacedBlock());
            }
        } else if (blockEvent instanceof BlockEvent.PortalSpawnEvent) {
            isAllowed = isAllowed && CelestialObjectManager.onOpeningNetherPortal(blockEvent.getWorld(), blockEvent.getPos());
        } else {
            boolean bl = isAllowed = isAllowed && GlobalRegionManager.onBlockUpdating(entity, blockEvent.getWorld(), blockEvent.getPos(), blockEvent.getState());
        }
        if (!isAllowed) {
            block26: {
                if (blockEvent.isCancelable()) {
                    blockEvent.setCanceled(true);
                } else if (blockEvent instanceof BlockEvent.HarvestDropsEvent) {
                    if (Commons.throttleMe("WorldHandler.onBlockEvent")) {
                        WarpDrive.logger.info(String.format("Skipping HarvestDropsEvent %s %s %s by %s", blockEvent.getClass().getSimpleName(), blockStatePlaced, Commons.format(blockEvent.getWorld(), blockEvent.getPos()), entity));
                    }
                } else {
                    try {
                        blockEvent.getWorld().func_175698_g(blockEvent.getPos());
                    }
                    catch (Exception exception) {
                        if (!Commons.throttleMe("WorldHandler.onBlockEvent")) break block26;
                        exception.printStackTrace();
                        WarpDrive.logger.info(String.format("Exception with %s %s %s by %s", blockEvent.getClass().getSimpleName(), blockStatePlaced, Commons.format(blockEvent.getWorld(), blockEvent.getPos()), entity));
                    }
                }
            }
            return;
        }
        if (blockEvent instanceof BlockEvent.MultiPlaceEvent || blockEvent instanceof BlockEvent.EntityMultiPlaceEvent) {
            listBlockSnapshots = blockEvent instanceof BlockEvent.MultiPlaceEvent ? ((BlockEvent.MultiPlaceEvent)blockEvent).getReplacedBlockSnapshots() : ((BlockEvent.EntityMultiPlaceEvent)blockEvent).getReplacedBlockSnapshots();
            for (BlockSnapshot blockSnapshot : listBlockSnapshots) {
                ChunkHandler.onBlockUpdated(blockEvent.getWorld(), blockSnapshot.getPos());
            }
        } else {
            ChunkHandler.onBlockUpdated(blockEvent.getWorld(), blockEvent.getPos());
        }
    }
}

