/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.item;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.api.IAirContainerItem;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnumAirTankTier;
import cr0s.warpdrive.item.ItemAbstractBase;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemAirTank
extends ItemAbstractBase
implements IAirContainerItem {
    protected EnumAirTankTier enumAirTankTier;

    public ItemAirTank(String registryName, EnumAirTankTier enumAirTankTier) {
        super(registryName, enumAirTankTier.getTier());
        this.enumAirTankTier = enumAirTankTier;
        this.func_77656_e(WarpDriveConfig.BREATHING_AIR_TANK_CAPACITY_BY_TIER[enumAirTankTier.getIndex()]);
        this.func_77625_d(1);
        this.func_77655_b("warpdrive.breathing.air_tank." + enumAirTankTier.func_176610_l());
    }

    public void func_150895_a(@Nonnull CreativeTabs creativeTab, @Nonnull NonNullList<ItemStack> list) {
        if (!this.func_194125_a(creativeTab)) {
            return;
        }
        list.add((Object)new ItemStack((Item)this, 1, 0));
        list.add((Object)new ItemStack((Item)this, 1, this.getMaxDamage(null)));
    }

    @Override
    public boolean canContainAir(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_77973_b() != this) {
            return false;
        }
        return itemStack.func_77952_i() > 0;
    }

    @Override
    public int getMaxAirStorage(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_77973_b() != this) {
            return 0;
        }
        return itemStack.func_77958_k();
    }

    @Override
    public int getCurrentAirStorage(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_77973_b() != this) {
            return 0;
        }
        return this.getMaxDamage(itemStack) - itemStack.func_77952_i();
    }

    @Override
    public ItemStack consumeAir(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_77973_b() != this) {
            return itemStack;
        }
        itemStack.func_77964_b(Math.min(this.getMaxDamage(itemStack), itemStack.func_77952_i() + 1));
        return itemStack;
    }

    @Override
    public int getAirTicksPerConsumption(ItemStack itemStack) {
        if (itemStack != null && itemStack.func_77973_b() != this) {
            return 0;
        }
        return WarpDriveConfig.BREATHING_AIR_TANK_BREATH_DURATION_TICKS;
    }

    @Override
    public ItemStack getEmptyAirContainer(ItemStack itemStack) {
        if (itemStack != null && itemStack.func_77973_b() != this) {
            return itemStack;
        }
        return new ItemStack((Item)this, 1, this.func_77612_l());
    }

    @Override
    public ItemStack getFullAirContainer(ItemStack itemStack) {
        if (itemStack != null && itemStack.func_77973_b() != this) {
            return itemStack;
        }
        return new ItemStack((Item)this, 1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack itemStack, @Nullable World world, @Nonnull List<String> list, @Nonnull ITooltipFlag advancedItemTooltips) {
        super.func_77624_a(itemStack, world, list, advancedItemTooltips);
        Commons.addTooltip(list, new TextComponentTranslation("item.warpdrive.breathing.air_tank.tooltip.usage", new Object[0]).func_150254_d());
    }
}

