/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.item;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IAirContainerItem;
import cr0s.warpdrive.block.BlockAbstractContainer;
import cr0s.warpdrive.data.EnumComponentType;
import cr0s.warpdrive.data.EnumTier;
import cr0s.warpdrive.item.ItemAbstractBase;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemComponent
extends ItemAbstractBase
implements IAirContainerItem {
    private static ItemStack[] itemStackCache;

    public ItemComponent(String registryName, EnumTier enumTier) {
        super(registryName, enumTier);
        this.func_77627_a(true);
        this.func_77655_b("warpdrive.component.malformed");
        itemStackCache = new ItemStack[EnumComponentType.length];
    }

    @Nonnull
    public static ItemStack getItemStack(EnumComponentType enumComponentType) {
        if (enumComponentType != null) {
            int damage = enumComponentType.ordinal();
            if (itemStackCache[damage] == null) {
                ItemComponent.itemStackCache[damage] = new ItemStack((Item)WarpDrive.itemComponent, 1, damage);
            }
            return itemStackCache[damage];
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public static ItemStack getItemStackNoCache(@Nonnull EnumComponentType enumComponentType, int amount) {
        return new ItemStack((Item)WarpDrive.itemComponent, amount, enumComponentType.ordinal());
    }

    @Nonnull
    public String func_77667_c(ItemStack itemStack) {
        int damage = itemStack.func_77952_i();
        if (damage >= 0 && damage < EnumComponentType.length) {
            return "item.warpdrive.component." + EnumComponentType.get(damage).func_176610_l();
        }
        return this.func_77658_a();
    }

    public void func_150895_a(@Nonnull CreativeTabs creativeTab, @Nonnull NonNullList<ItemStack> list) {
        if (!this.func_194125_a(creativeTab)) {
            return;
        }
        for (EnumComponentType enumComponentType : EnumComponentType.values()) {
            list.add((Object)new ItemStack((Item)this, 1, enumComponentType.ordinal()));
        }
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getModelResourceLocation(ItemStack itemStack) {
        int damage = itemStack.func_77952_i();
        ResourceLocation resourceLocation = this.getRegistryName();
        assert (resourceLocation != null);
        if (damage >= 0 && damage < EnumComponentType.length) {
            resourceLocation = new ResourceLocation(resourceLocation.func_110624_b(), resourceLocation.func_110623_a() + "-" + EnumComponentType.get(damage).func_176610_l());
        }
        return new ModelResourceLocation(resourceLocation, "inventory");
    }

    @Override
    public boolean canContainAir(ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof ItemComponent && itemStack.func_77952_i() == EnumComponentType.AIR_CANISTER.ordinal();
    }

    @Override
    public int getMaxAirStorage(ItemStack itemStack) {
        if (this.canContainAir(itemStack)) {
            return WarpDrive.itemAirTanks[0].getMaxAirStorage(itemStack);
        }
        return 0;
    }

    @Override
    public int getCurrentAirStorage(ItemStack itemStack) {
        return 0;
    }

    @Override
    public ItemStack consumeAir(ItemStack itemStack) {
        WarpDrive.logger.error(String.format("%s consumeAir() with itemStack %s", this, itemStack));
        throw new RuntimeException("Invalid call to consumeAir() on non or empty container");
    }

    @Override
    public int getAirTicksPerConsumption(ItemStack itemStack) {
        if (this.canContainAir(itemStack)) {
            return WarpDrive.itemAirTanks[0].getAirTicksPerConsumption(new ItemStack((Item)WarpDrive.itemAirTanks[0]));
        }
        return 0;
    }

    @Override
    public ItemStack getFullAirContainer(ItemStack itemStack) {
        if (this.canContainAir(itemStack)) {
            return WarpDrive.itemAirTanks[0].getFullAirContainer(new ItemStack((Item)WarpDrive.itemAirTanks[0]));
        }
        return null;
    }

    @Override
    public ItemStack getEmptyAirContainer(ItemStack itemStack) {
        if (this.canContainAir(itemStack)) {
            return WarpDrive.itemAirTanks[0].getEmptyAirContainer(new ItemStack((Item)WarpDrive.itemAirTanks[0]));
        }
        return null;
    }

    public boolean doesSneakBypassUse(@Nonnull ItemStack itemStack, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos, @Nonnull EntityPlayer player) {
        Block block = blockAccess.func_180495_p(blockPos).func_177230_c();
        return block instanceof BlockAbstractContainer || super.doesSneakBypassUse(itemStack, blockAccess, blockPos, player);
    }
}

