/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.item;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IParticleContainerItem;
import cr0s.warpdrive.api.Particle;
import cr0s.warpdrive.api.ParticleRegistry;
import cr0s.warpdrive.api.ParticleStack;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnumTier;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.item.ItemAbstractBase;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemElectromagneticCell
extends ItemAbstractBase
implements IParticleContainerItem {
    public ItemElectromagneticCell(String registryName, EnumTier enumTier) {
        super(registryName, enumTier);
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77655_b("warpdrive.atomic.electromagnetic_cell." + enumTier.func_176610_l());
        this.func_77627_a(true);
        this.func_185043_a(new ResourceLocation("warpdrive", "fill"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(@Nonnull ItemStack itemStack, @Nullable World world, @Nullable EntityLivingBase entity) {
                ParticleStack particleStack = ItemElectromagneticCell.this.getParticleStack(itemStack);
                if (particleStack != null) {
                    return (float)particleStack.getAmount() / (float)ItemElectromagneticCell.this.getCapacity(itemStack);
                }
                return 0.0f;
            }
        });
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getModelResourceLocation(ItemStack itemStack) {
        String variant = "empty";
        ParticleStack particleStack = this.getParticleStack(itemStack);
        if (particleStack != null) {
            variant = particleStack.getTranslationKey().replace("warpdrive.particle.", "");
        }
        ResourceLocation resourceLocation = this.getRegistryName();
        assert (resourceLocation != null);
        resourceLocation = new ResourceLocation(resourceLocation.func_110624_b(), resourceLocation.func_110623_a() + "-" + variant);
        return new ModelResourceLocation(resourceLocation, "inventory");
    }

    @Nonnull
    public static ItemStack getItemStackNoCache(@Nonnull EnumTier enumTier, @Nullable Particle particle, int amount) {
        return WarpDrive.itemElectromagneticCell[enumTier.getIndex()].getItemStackNoCache(particle, amount);
    }

    @Nonnull
    public ItemStack getItemStackNoCache(@Nullable Particle particle, int amount) {
        ItemStack itemStack = new ItemStack((Item)WarpDrive.itemElectromagneticCell[this.enumTier.getIndex()], 1, 0);
        ParticleStack particleStack = null;
        if (particle != null && amount != 0) {
            particleStack = new ParticleStack(particle, amount);
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74782_a("particle", (NBTBase)particleStack.writeToNBT(new NBTTagCompound()));
            itemStack.func_77982_d(tagCompound);
        }
        ItemElectromagneticCell.updateDamageLevel(itemStack, particleStack);
        return itemStack;
    }

    public void func_150895_a(@Nonnull CreativeTabs creativeTab, @Nonnull NonNullList<ItemStack> list) {
        if (!this.func_194125_a(creativeTab)) {
            return;
        }
        list.add((Object)this.getItemStackNoCache(null, 0));
        int capacity10PC = WarpDriveConfig.ELECTROMAGNETIC_CELL_CAPACITY_BY_TIER[this.enumTier.getIndex()] / 10;
        list.add((Object)this.getItemStackNoCache(ParticleRegistry.ION, capacity10PC));
        list.add((Object)this.getItemStackNoCache(ParticleRegistry.ION, capacity10PC * 3));
        list.add((Object)this.getItemStackNoCache(ParticleRegistry.ION, capacity10PC * 5));
        list.add((Object)this.getItemStackNoCache(ParticleRegistry.ION, capacity10PC * 7));
        list.add((Object)this.getItemStackNoCache(ParticleRegistry.ION, capacity10PC * 9));
        list.add((Object)this.getItemStackNoCache(ParticleRegistry.ION, capacity10PC * 10));
        list.add((Object)this.getItemStackNoCache(ParticleRegistry.PROTON, capacity10PC));
        list.add((Object)this.getItemStackNoCache(ParticleRegistry.PROTON, capacity10PC * 3));
        list.add((Object)this.getItemStackNoCache(ParticleRegistry.PROTON, capacity10PC * 5));
        list.add((Object)this.getItemStackNoCache(ParticleRegistry.PROTON, capacity10PC * 7));
        list.add((Object)this.getItemStackNoCache(ParticleRegistry.PROTON, capacity10PC * 9));
        list.add((Object)this.getItemStackNoCache(ParticleRegistry.PROTON, capacity10PC * 10));
        list.add((Object)this.getItemStackNoCache(ParticleRegistry.ANTIMATTER, capacity10PC));
        list.add((Object)this.getItemStackNoCache(ParticleRegistry.ANTIMATTER, capacity10PC * 3));
        list.add((Object)this.getItemStackNoCache(ParticleRegistry.ANTIMATTER, capacity10PC * 5));
        list.add((Object)this.getItemStackNoCache(ParticleRegistry.ANTIMATTER, capacity10PC * 7));
        list.add((Object)this.getItemStackNoCache(ParticleRegistry.ANTIMATTER, capacity10PC * 9));
        list.add((Object)this.getItemStackNoCache(ParticleRegistry.ANTIMATTER, capacity10PC * 10));
        list.add((Object)this.getItemStackNoCache(ParticleRegistry.STRANGE_MATTER, capacity10PC));
        list.add((Object)this.getItemStackNoCache(ParticleRegistry.STRANGE_MATTER, capacity10PC * 3));
        list.add((Object)this.getItemStackNoCache(ParticleRegistry.STRANGE_MATTER, capacity10PC * 5));
        list.add((Object)this.getItemStackNoCache(ParticleRegistry.STRANGE_MATTER, capacity10PC * 7));
        list.add((Object)this.getItemStackNoCache(ParticleRegistry.STRANGE_MATTER, capacity10PC * 9));
        list.add((Object)this.getItemStackNoCache(ParticleRegistry.STRANGE_MATTER, capacity10PC * 10));
    }

    public boolean hasContainerItem(@Nonnull ItemStack itemStack) {
        return true;
    }

    @Nonnull
    public Item func_77668_q() {
        return Item.func_150898_a((Block)Blocks.field_150480_ab);
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack itemStackFilled) {
        int amountToConsume;
        ParticleStack particleStack = this.getParticleStack(itemStackFilled);
        if (particleStack != null && (amountToConsume = this.getAmountToConsume(itemStackFilled)) > 0) {
            int amountLeft = particleStack.getAmount() - amountToConsume;
            if (amountLeft <= 0) {
                return this.getItemStackNoCache(null, 0);
            }
            return this.getItemStackNoCache(particleStack.getParticle(), amountLeft);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void setAmountToConsume(@Nonnull ItemStack itemStack, int amountToConsume) {
        ParticleStack particleStack = this.getParticleStack(itemStack);
        if (particleStack == null || particleStack.getParticle() == null) {
            return;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (amountToConsume > 0) {
            if (tagCompound == null) {
                tagCompound = new NBTTagCompound();
            }
            tagCompound.func_74768_a("amountToConsume", amountToConsume);
            tagCompound.func_74772_a("tickToConsume", System.currentTimeMillis());
        } else if (tagCompound != null) {
            tagCompound.func_82580_o("amountToConsume");
            tagCompound.func_82580_o("tickToConsume");
            if (tagCompound.func_82582_d()) {
                itemStack.func_77982_d(null);
            }
        }
    }

    private int getAmountToConsume(@Nonnull ItemStack itemStack) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            long tickToConsume = tagCompound.func_74763_f("tickToConsume");
            if (System.currentTimeMillis() - tickToConsume < 50L) {
                return tagCompound.func_74762_e("amountToConsume");
            }
            tagCompound.func_82580_o("amountToConsume");
            tagCompound.func_82580_o("tickToConsume");
        }
        return 0;
    }

    private static int getDamageLevel(@Nonnull ItemStack itemStack, ParticleStack particleStack) {
        if (!(itemStack.func_77973_b() instanceof ItemElectromagneticCell)) {
            WarpDrive.logger.error(String.format("Invalid ItemStack passed, expecting ItemElectromagneticCell: %s", itemStack));
            return itemStack.func_77952_i();
        }
        if (particleStack == null || particleStack.getParticle() == null) {
            return 0;
        }
        ItemElectromagneticCell itemElectromagneticCell = (ItemElectromagneticCell)itemStack.func_77973_b();
        int type = particleStack.getParticle().getColorIndex() % 5;
        double ratio = (double)particleStack.getAmount() / (double)itemElectromagneticCell.getCapacity(itemStack);
        int offset = ratio < 0.2 ? 0 : (ratio < 0.4 ? 1 : (ratio < 0.6 ? 2 : (ratio < 0.8 ? 3 : (ratio < 1.0 ? 4 : 5))));
        return 1 + type * 6 + offset;
    }

    private static void updateDamageLevel(@Nonnull ItemStack itemStack, ParticleStack particleStack) {
        itemStack.func_77964_b(ItemElectromagneticCell.getDamageLevel(itemStack, particleStack));
    }

    @Override
    public ParticleStack getParticleStack(@Nonnull ItemStack itemStack) {
        if (itemStack.func_190916_E() != 1 || itemStack.func_77973_b() != this) {
            return null;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            return null;
        }
        if (!tagCompound.func_74764_b("particle")) {
            return null;
        }
        return ParticleStack.loadFromNBT(tagCompound.func_74775_l("particle"));
    }

    @Override
    public int getCapacity(ItemStack container) {
        return WarpDriveConfig.ELECTROMAGNETIC_CELL_CAPACITY_BY_TIER[this.enumTier.getIndex()];
    }

    @Override
    public boolean isEmpty(ItemStack itemStack) {
        ParticleStack particleStack = this.getParticleStack(itemStack);
        return particleStack == null || particleStack.isEmpty();
    }

    @Override
    public int fill(ItemStack itemStack, ParticleStack resource, boolean doFill) {
        if (itemStack.func_190916_E() != 1) {
            return 0;
        }
        ParticleStack particleStack = this.getParticleStack(itemStack);
        if (particleStack == null || particleStack.getParticle() == null) {
            particleStack = new ParticleStack(resource.getParticle(), 0);
        } else if (!particleStack.isParticleEqual(resource) || particleStack.getAmount() >= this.getCapacity(itemStack)) {
            return 0;
        }
        int transfer = Math.min(resource.getAmount(), this.getCapacity(itemStack) - particleStack.getAmount());
        if (doFill) {
            NBTTagCompound tagCompound;
            particleStack.fill(transfer);
            NBTTagCompound nBTTagCompound = tagCompound = itemStack.func_77942_o() ? itemStack.func_77978_p() : new NBTTagCompound();
            assert (tagCompound != null);
            tagCompound.func_74782_a("particle", (NBTBase)particleStack.writeToNBT(new NBTTagCompound()));
            if (!itemStack.func_77942_o()) {
                itemStack.func_77982_d(tagCompound);
            }
            ItemElectromagneticCell.updateDamageLevel(itemStack, particleStack);
        }
        return transfer;
    }

    @Override
    public ParticleStack drain(ItemStack itemStack, ParticleStack resource, boolean doDrain) {
        ParticleStack particleStack = this.getParticleStack(itemStack);
        if (particleStack == null || particleStack.getParticle() == null || !particleStack.isParticleEqual(resource) || particleStack.getAmount() <= 0) {
            return null;
        }
        int transfer = Math.min(resource.getAmount(), particleStack.getAmount());
        if (doDrain) {
            NBTTagCompound tagCompound;
            particleStack.fill(-transfer);
            NBTTagCompound nBTTagCompound = tagCompound = itemStack.func_77942_o() ? itemStack.func_77978_p() : new NBTTagCompound();
            assert (tagCompound != null);
            tagCompound.func_74782_a("particle", (NBTBase)particleStack.writeToNBT(new NBTTagCompound()));
            if (!itemStack.func_77942_o()) {
                itemStack.func_77982_d(tagCompound);
            }
            ItemElectromagneticCell.updateDamageLevel(itemStack, particleStack);
        }
        return resource.copy(transfer);
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        ParticleStack particleStack = this.getParticleStack(itemStack);
        if (particleStack == null || particleStack.isEmpty()) {
            return super.getEntityLifespan(itemStack, world);
        }
        int lifespan = particleStack.getEntityLifespan();
        if (lifespan < 0) {
            return super.getEntityLifespan(itemStack, world);
        }
        return (2 - particleStack.getAmount() / this.getCapacity(itemStack)) * lifespan;
    }

    @Override
    public void onEntityExpireEvent(EntityItem entityItem, ItemStack itemStack) {
        ParticleStack particleStack = this.getParticleStack(itemStack);
        if (particleStack == null || particleStack.isEmpty()) {
            super.onEntityExpireEvent(entityItem, itemStack);
            return;
        }
        particleStack.onWorldEffect(entityItem.field_70170_p, new Vector3((Entity)entityItem));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack itemStack, @Nullable World world, @Nonnull List<String> list, @Nonnull ITooltipFlag advancedItemTooltips) {
        super.func_77624_a(itemStack, world, list, advancedItemTooltips);
        if (!(itemStack.func_77973_b() instanceof ItemElectromagneticCell)) {
            WarpDrive.logger.error(String.format("Invalid ItemStack passed, expecting ItemElectromagneticCell: %s", itemStack));
            return;
        }
        ItemElectromagneticCell itemElectromagneticCell = (ItemElectromagneticCell)itemStack.func_77973_b();
        ParticleStack particleStack = itemElectromagneticCell.getParticleStack(itemStack);
        if (particleStack == null || particleStack.getParticle() == null) {
            String tooltip = new TextComponentTranslation("item.warpdrive.atomic.electromagnetic_cell.tooltip.empty", new Object[0]).func_150254_d();
            Commons.addTooltip(list, tooltip);
        } else {
            Particle particle = particleStack.getParticle();
            String tooltip = new TextComponentTranslation("item.warpdrive.atomic.electromagnetic_cell.tooltip.filled", new Object[]{new WarpDriveText(Commons.getStyleValue(), particleStack.getAmount()), new WarpDriveText(Commons.getStyleValue(), particle.getLocalizedName(), new Object[0])}).func_150254_d();
            Commons.addTooltip(list, tooltip);
            String particleTooltip = particle.getLocalizedTooltip();
            if (!particleTooltip.isEmpty()) {
                Commons.addTooltip(list, particleTooltip);
            }
        }
    }
}

