/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.item;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.forcefield.BlockForceFieldProjector;
import cr0s.warpdrive.block.forcefield.BlockForceFieldRelay;
import cr0s.warpdrive.data.EnumComponentType;
import cr0s.warpdrive.data.EnumForceFieldShape;
import cr0s.warpdrive.data.EnumTier;
import cr0s.warpdrive.item.ItemAbstractBase;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemForceFieldShape
extends ItemAbstractBase {
    private static ItemStack[] itemStackCache;

    public ItemForceFieldShape(String registryName, EnumTier enumTier) {
        super(registryName, enumTier);
        this.func_77627_a(true);
        this.func_77655_b("warpdrive.force_field.shape");
        itemStackCache = new ItemStack[EnumForceFieldShape.length];
    }

    @Nonnull
    public static ItemStack getItemStack(EnumForceFieldShape forceFieldShape) {
        if (forceFieldShape != null) {
            int damage = forceFieldShape.ordinal();
            if (itemStackCache[damage] == null) {
                ItemForceFieldShape.itemStackCache[damage] = new ItemStack((Item)WarpDrive.itemForceFieldShape, 1, damage);
            }
            return itemStackCache[damage];
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public static ItemStack getItemStackNoCache(@Nonnull EnumForceFieldShape forceFieldShape, int amount) {
        return new ItemStack((Item)WarpDrive.itemForceFieldShape, amount, forceFieldShape.ordinal());
    }

    @Nonnull
    public String func_77667_c(ItemStack itemStack) {
        int damage = itemStack.func_77952_i();
        if (damage >= 0 && damage < EnumForceFieldShape.length) {
            return this.func_77658_a() + "." + EnumForceFieldShape.get(damage).func_176610_l();
        }
        return this.func_77658_a();
    }

    public void func_150895_a(@Nonnull CreativeTabs creativeTab, @Nonnull NonNullList<ItemStack> list) {
        if (!this.func_194125_a(creativeTab)) {
            return;
        }
        for (EnumForceFieldShape enumForceFieldShape : EnumForceFieldShape.values()) {
            if (enumForceFieldShape == EnumForceFieldShape.NONE) continue;
            list.add((Object)new ItemStack((Item)this, 1, enumForceFieldShape.ordinal()));
        }
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getModelResourceLocation(ItemStack itemStack) {
        int damage = itemStack.func_77952_i();
        ResourceLocation resourceLocation = this.getRegistryName();
        assert (resourceLocation != null);
        if (damage >= 0 && damage < EnumComponentType.length) {
            resourceLocation = new ResourceLocation(resourceLocation.func_110624_b(), resourceLocation.func_110623_a() + "-" + EnumForceFieldShape.get(damage).func_176610_l());
        }
        return new ModelResourceLocation(resourceLocation, "inventory");
    }

    public boolean doesSneakBypassUse(@Nonnull ItemStack itemStack, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos, @Nonnull EntityPlayer player) {
        Block block = blockAccess.func_180495_p(blockPos).func_177230_c();
        return block instanceof BlockForceFieldRelay || block instanceof BlockForceFieldProjector || super.doesSneakBypassUse(itemStack, blockAccess, blockPos, player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack itemStack, @Nullable World world, @Nonnull List<String> list, @Nonnull ITooltipFlag advancedItemTooltips) {
        super.func_77624_a(itemStack, world, list, advancedItemTooltips);
        Commons.addTooltip(list, "\n");
        Commons.addTooltip(list, new TextComponentTranslation("item.warpdrive.force_field.shape.tooltip.usage", new Object[0]).func_150254_d());
    }
}

