/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.item;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IParticleContainerItem;
import cr0s.warpdrive.api.Particle;
import cr0s.warpdrive.api.ParticleStack;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnumTier;
import cr0s.warpdrive.item.ItemAbstractBase;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPlasmaTorch
extends ItemAbstractBase
implements IParticleContainerItem {
    public ItemPlasmaTorch(String registryName, EnumTier enumTier) {
        super(registryName, enumTier);
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77655_b("warpdrive.tool.plasma_torch." + enumTier.func_176610_l());
        this.func_185043_a(new ResourceLocation("warpdrive", "fill"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(@Nonnull ItemStack itemStack, @Nullable World world, @Nullable EntityLivingBase entity) {
                ParticleStack particleStack = ItemPlasmaTorch.this.getParticleStack(itemStack);
                if (particleStack != null) {
                    return (float)particleStack.getAmount() / (float)ItemPlasmaTorch.this.getCapacity(itemStack);
                }
                return 0.0f;
            }
        });
    }

    @Nonnull
    public static ItemStack getItemStackNoCache(@Nonnull EnumTier enumTier, @Nullable Particle particle, int amount) {
        return WarpDrive.itemPlasmaTorch[enumTier.getIndex()].getItemStackNoCache(particle, amount);
    }

    @Nonnull
    public ItemStack getItemStackNoCache(@Nullable Particle particle, int amount) {
        ItemStack itemStack = new ItemStack((Item)this, 1, 0);
        ParticleStack particleStack = null;
        if (particle != null && amount != 0) {
            particleStack = new ParticleStack(particle, amount);
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74782_a("particle", (NBTBase)particleStack.writeToNBT(new NBTTagCompound()));
            itemStack.func_77982_d(tagCompound);
        }
        ItemPlasmaTorch.updateDamageLevel(itemStack, particleStack);
        return itemStack;
    }

    public void func_150895_a(@Nonnull CreativeTabs creativeTab, @Nonnull NonNullList<ItemStack> list) {
        if (!this.func_194125_a(creativeTab)) {
            return;
        }
        list.add((Object)this.getItemStackNoCache(null, 0));
    }

    public boolean hasContainerItem(@Nonnull ItemStack itemStack) {
        return true;
    }

    @Nonnull
    public Item func_77668_q() {
        return Item.func_150898_a((Block)Blocks.field_150480_ab);
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack itemStackFilled) {
        int amountToConsume;
        ParticleStack particleStack = this.getParticleStack(itemStackFilled);
        if (particleStack != null && (amountToConsume = this.getAmountToConsume(itemStackFilled)) > 0) {
            int amountLeft = particleStack.getAmount() - amountToConsume;
            if (amountLeft <= 0) {
                return this.getItemStackNoCache(null, 0);
            }
            return this.getItemStackNoCache(particleStack.getParticle(), amountLeft);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void setAmountToConsume(@Nonnull ItemStack itemStack, int amountToConsume) {
        ParticleStack particleStack = this.getParticleStack(itemStack);
        if (particleStack == null || particleStack.getParticle() == null) {
            return;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (amountToConsume > 0) {
            if (tagCompound == null) {
                tagCompound = new NBTTagCompound();
            }
            tagCompound.func_74768_a("amountToConsume", amountToConsume);
            tagCompound.func_74772_a("tickToConsume", System.currentTimeMillis());
        } else if (tagCompound != null) {
            tagCompound.func_82580_o("amountToConsume");
            tagCompound.func_82580_o("tickToConsume");
            if (tagCompound.func_82582_d()) {
                itemStack.func_77982_d(null);
            }
        }
    }

    private int getAmountToConsume(@Nonnull ItemStack itemStack) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            long tickToConsume = tagCompound.func_74762_e("tickToConsume");
            if (System.currentTimeMillis() - tickToConsume < 50L) {
                return tagCompound.func_74762_e("amountToConsume");
            }
            tagCompound.func_82580_o("amountToConsume");
            tagCompound.func_82580_o("tickToConsume");
        }
        return 0;
    }

    private static int getDamageLevel(@Nonnull ItemStack itemStack, ParticleStack particleStack) {
        if (!(itemStack.func_77973_b() instanceof ItemPlasmaTorch)) {
            WarpDrive.logger.error(String.format("Invalid ItemStack passed, expecting ItemPlasmaTorch: %s", itemStack));
            return itemStack.func_77952_i();
        }
        if (particleStack == null || particleStack.getParticle() == null) {
            return 0;
        }
        ItemPlasmaTorch itemPlasmaTorch = (ItemPlasmaTorch)itemStack.func_77973_b();
        int type = particleStack.getParticle().getColorIndex() % 5;
        double ratio = (double)particleStack.getAmount() / (double)itemPlasmaTorch.getCapacity(itemStack);
        int offset = ratio < 0.2 ? 0 : (ratio < 0.4 ? 1 : (ratio < 0.6 ? 2 : (ratio < 0.8 ? 3 : (ratio < 1.0 ? 4 : 5))));
        return 1 + type * 6 + offset;
    }

    private static void updateDamageLevel(@Nonnull ItemStack itemStack, ParticleStack particleStack) {
        itemStack.func_77964_b(ItemPlasmaTorch.getDamageLevel(itemStack, particleStack));
    }

    @Override
    public ParticleStack getParticleStack(@Nonnull ItemStack itemStack) {
        if (itemStack.func_190916_E() != 1 || itemStack.func_77973_b() != this) {
            return null;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            return null;
        }
        if (!tagCompound.func_74764_b("particle")) {
            return null;
        }
        return ParticleStack.loadFromNBT(tagCompound.func_74775_l("particle"));
    }

    @Override
    public int getCapacity(ItemStack container) {
        return WarpDriveConfig.PLASMA_TORCH_CAPACITY_BY_TIER[this.enumTier.getIndex()];
    }

    @Override
    public boolean isEmpty(ItemStack itemStack) {
        ParticleStack particleStack = this.getParticleStack(itemStack);
        return particleStack == null || particleStack.isEmpty();
    }

    @Override
    public int fill(ItemStack itemStack, ParticleStack resource, boolean doFill) {
        if (itemStack.func_190916_E() != 1) {
            return 0;
        }
        ParticleStack particleStack = this.getParticleStack(itemStack);
        if (particleStack == null || particleStack.getParticle() == null) {
            particleStack = new ParticleStack(resource.getParticle(), 0);
        } else if (!particleStack.isParticleEqual(resource) || particleStack.getAmount() >= this.getCapacity(itemStack)) {
            return 0;
        }
        int transfer = Math.min(resource.getAmount(), this.getCapacity(itemStack) - particleStack.getAmount());
        if (doFill) {
            NBTTagCompound tagCompound;
            particleStack.fill(transfer);
            NBTTagCompound nBTTagCompound = tagCompound = itemStack.func_77942_o() ? itemStack.func_77978_p() : new NBTTagCompound();
            assert (tagCompound != null);
            tagCompound.func_74782_a("particle", (NBTBase)particleStack.writeToNBT(new NBTTagCompound()));
            if (!itemStack.func_77942_o()) {
                itemStack.func_77982_d(tagCompound);
            }
            ItemPlasmaTorch.updateDamageLevel(itemStack, particleStack);
        }
        return transfer;
    }

    @Override
    public ParticleStack drain(ItemStack itemStack, ParticleStack resource, boolean doDrain) {
        ParticleStack particleStack = this.getParticleStack(itemStack);
        if (particleStack == null || particleStack.getParticle() == null || !particleStack.isParticleEqual(resource) || particleStack.getAmount() <= 0) {
            return null;
        }
        int transfer = Math.min(resource.getAmount(), particleStack.getAmount());
        if (doDrain) {
            NBTTagCompound tagCompound;
            particleStack.fill(-transfer);
            NBTTagCompound nBTTagCompound = tagCompound = itemStack.func_77942_o() ? itemStack.func_77978_p() : new NBTTagCompound();
            assert (tagCompound != null);
            tagCompound.func_74782_a("particle", (NBTBase)particleStack.writeToNBT(new NBTTagCompound()));
            if (!itemStack.func_77942_o()) {
                itemStack.func_77982_d(tagCompound);
            }
            ItemPlasmaTorch.updateDamageLevel(itemStack, particleStack);
        }
        return resource.copy(transfer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack itemStack, @Nullable World world, @Nonnull List<String> list, @Nonnull ITooltipFlag advancedItemTooltips) {
        super.func_77624_a(itemStack, world, list, advancedItemTooltips);
        if (!(itemStack.func_77973_b() instanceof ItemPlasmaTorch)) {
            WarpDrive.logger.error(String.format("Invalid ItemStack passed, expecting ItemPlasmaTorch: %s", itemStack));
            return;
        }
        ItemPlasmaTorch itemPlasmaTorch = (ItemPlasmaTorch)itemStack.func_77973_b();
        ParticleStack particleStack = itemPlasmaTorch.getParticleStack(itemStack);
        if (particleStack == null || particleStack.getParticle() == null) {
            String tooltip = new TextComponentTranslation("item.warpdrive.tool.plasma_torch.tooltip.empty", new Object[0]).func_150254_d();
            Commons.addTooltip(list, tooltip);
        } else {
            Particle particle = particleStack.getParticle();
            String tooltip = new TextComponentTranslation("item.warpdrive.tool.plasma_torch.tooltip.filled", new Object[]{particleStack.getAmount(), particle.getLocalizedName()}).func_150254_d();
            Commons.addTooltip(list, tooltip);
            String particleTooltip = particle.getLocalizedTooltip();
            if (!particleTooltip.isEmpty()) {
                Commons.addTooltip(list, particleTooltip);
            }
        }
    }
}

