/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.item;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.data.EnumTier;
import cr0s.warpdrive.item.ItemAbstractBase;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemShipToken
extends ItemAbstractBase {
    private static ItemStack[] itemStackCache;
    private static final int[] VALID_METADATAS;

    public ItemShipToken(String registryName, EnumTier enumTier) {
        super(registryName, enumTier);
        this.func_77627_a(true);
        this.func_77655_b("warpdrive.tool.ship_token");
        this.func_77637_a(WarpDrive.creativeTabMain);
        itemStackCache = new ItemStack[VALID_METADATAS.length];
    }

    public static ItemStack getItemStack(Random random) {
        return ItemShipToken.getItemStack(VALID_METADATAS[random.nextInt(VALID_METADATAS.length)]);
    }

    public static ItemStack getItemStack(int metadataWanted) {
        for (int index = 0; index < VALID_METADATAS.length; ++index) {
            if (metadataWanted != VALID_METADATAS[index]) continue;
            if (itemStackCache[index] == null) {
                ItemShipToken.itemStackCache[index] = new ItemStack((Item)WarpDrive.itemShipToken, 1, metadataWanted);
            }
            return itemStackCache[index];
        }
        return null;
    }

    @Nonnull
    public static ItemStack getItemStackNoCache(int metadataWanted, int amount) {
        for (int metadataValid : VALID_METADATAS) {
            if (metadataWanted != metadataValid) continue;
            return new ItemStack((Item)WarpDrive.itemShipToken, amount, metadataWanted);
        }
        return new ItemStack((Item)WarpDrive.itemShipToken, amount, 0);
    }

    @Nonnull
    public String func_77667_c(ItemStack itemStack) {
        int metadata = itemStack.func_77952_i();
        for (int metadataValid : VALID_METADATAS) {
            if (metadata != metadataValid) continue;
            return "item.warpdrive.tool.ship_token" + metadata;
        }
        return this.func_77658_a();
    }

    public void func_150895_a(@Nonnull CreativeTabs creativeTab, @Nonnull NonNullList<ItemStack> list) {
        if (!this.func_194125_a(creativeTab)) {
            return;
        }
        for (int metadataValid : VALID_METADATAS) {
            list.add((Object)new ItemStack((Item)this, 1, metadataValid));
        }
    }

    public static String getSchematicName(ItemStack itemStack) {
        String schematicName = "" + itemStack.func_77952_i();
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null && tagCompound.func_74764_b("shipName")) {
            schematicName = tagCompound.func_74779_i("shipName");
        }
        return schematicName;
    }

    public static void setSchematicName(ItemStack itemStack, String schematicName) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        assert (tagCompound != null);
        tagCompound.func_74778_a("shipName", schematicName);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack itemStack, @Nullable World world, @Nonnull List<String> list, @Nonnull ITooltipFlag advancedItemTooltips) {
        super.func_77624_a(itemStack, world, list, advancedItemTooltips);
        Commons.addTooltip(list, new TextComponentTranslation("item.warpdrive.tool.ship_token.tooltip.usage", new Object[]{ItemShipToken.getSchematicName(itemStack)}).func_150254_d());
    }

    static {
        VALID_METADATAS = new int[]{0, 1, 2, 3, 4, 5, 10, 11, 12, 13, 14, 15, 20, 21, 22, 23, 24, 25, 30, 31, 32, 33, 34, 35, 40, 41, 42, 43, 44, 45};
    }
}

