/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.item;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBeamFrequency;
import cr0s.warpdrive.api.IControlChannel;
import cr0s.warpdrive.api.IVideoChannel;
import cr0s.warpdrive.api.IWarpTool;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.block.energy.BlockCapacitor;
import cr0s.warpdrive.data.EnumTier;
import cr0s.warpdrive.data.SoundEvents;
import cr0s.warpdrive.item.ItemAbstractBase;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTuningDriver
extends ItemAbstractBase
implements IWarpTool {
    public static final int MODE_VIDEO_CHANNEL = 0;
    public static final int MODE_BEAM_FREQUENCY = 1;
    public static final int MODE_CONTROL_CHANNEL = 2;

    public ItemTuningDriver(String registryName, EnumTier enumTier) {
        super(registryName, enumTier);
        this.func_77656_e(0);
        this.func_77637_a(WarpDrive.creativeTabMain);
        this.func_77625_d(1);
        this.func_77655_b("warpdrive.tool.tuning_driver");
        this.func_77664_n();
        this.func_77627_a(true);
    }

    public void func_150895_a(@Nonnull CreativeTabs creativeTab, @Nonnull NonNullList<ItemStack> list) {
        if (!this.func_194125_a(creativeTab)) {
            return;
        }
        for (int metadata = 0; metadata < 3; ++metadata) {
            list.add((Object)new ItemStack((Item)this, 1, metadata));
        }
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getModelResourceLocation(@Nonnull ItemStack itemStack) {
        int damage = itemStack.func_77952_i();
        ResourceLocation resourceLocation = this.getRegistryName();
        assert (resourceLocation != null);
        switch (damage) {
            case 0: {
                resourceLocation = new ResourceLocation(resourceLocation.func_110624_b(), resourceLocation.func_110623_a() + "-video_channel");
                break;
            }
            case 1: {
                resourceLocation = new ResourceLocation(resourceLocation.func_110624_b(), resourceLocation.func_110623_a() + "-beam_frequency");
                break;
            }
            case 2: {
                resourceLocation = new ResourceLocation(resourceLocation.func_110624_b(), resourceLocation.func_110623_a() + "-control_channel");
                break;
            }
            default: {
                resourceLocation = new ResourceLocation(resourceLocation.func_110624_b(), resourceLocation.func_110623_a() + "-invalid");
            }
        }
        return new ModelResourceLocation(resourceLocation, "inventory");
    }

    @Nonnull
    public String func_77667_c(@Nonnull ItemStack itemStack) {
        int damage = itemStack.func_77952_i();
        switch (damage) {
            case 0: {
                return this.func_77658_a() + ".video_channel";
            }
            case 1: {
                return this.func_77658_a() + ".beam_frequency";
            }
            case 2: {
                return this.func_77658_a() + ".control_channel";
            }
        }
        return this.func_77658_a();
    }

    public static int getVideoChannel(@Nonnull ItemStack itemStack) {
        if (!(itemStack.func_77973_b() instanceof ItemTuningDriver)) {
            return -1;
        }
        if (!itemStack.func_77942_o()) {
            return -1;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        assert (tagCompound != null);
        if (tagCompound.func_74764_b("videoChannel")) {
            return tagCompound.func_74762_e("videoChannel");
        }
        return -1;
    }

    @Nonnull
    public static ItemStack setVideoChannel(@Nonnull ItemStack itemStack, int videoChannel) {
        if (!(itemStack.func_77973_b() instanceof ItemTuningDriver) || videoChannel == -1) {
            return itemStack;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        tagCompound.func_74768_a("videoChannel", videoChannel);
        itemStack.func_77982_d(tagCompound);
        return itemStack;
    }

    public static int getBeamFrequency(@Nonnull ItemStack itemStack) {
        if (!(itemStack.func_77973_b() instanceof ItemTuningDriver)) {
            return -1;
        }
        if (!itemStack.func_77942_o()) {
            return -1;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null && tagCompound.func_74764_b("beamFrequency")) {
            return tagCompound.func_74762_e("beamFrequency");
        }
        return -1;
    }

    @Nonnull
    public static ItemStack setBeamFrequency(@Nonnull ItemStack itemStack, int beamFrequency) {
        if (!(itemStack.func_77973_b() instanceof ItemTuningDriver) || beamFrequency == -1) {
            return itemStack;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        tagCompound.func_74768_a("beamFrequency", beamFrequency);
        itemStack.func_77982_d(tagCompound);
        return itemStack;
    }

    public static int getControlChannel(@Nonnull ItemStack itemStack) {
        if (!(itemStack.func_77973_b() instanceof ItemTuningDriver)) {
            return -1;
        }
        if (!itemStack.func_77942_o()) {
            return -1;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null && tagCompound.func_74764_b("controlChannel")) {
            return tagCompound.func_74762_e("controlChannel");
        }
        return -1;
    }

    @Nonnull
    public static ItemStack setControlChannel(@Nonnull ItemStack itemStack, int controlChannel) {
        if (!(itemStack.func_77973_b() instanceof ItemTuningDriver) || controlChannel == -1) {
            return itemStack;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        tagCompound.func_74768_a("controlChannel", controlChannel);
        itemStack.func_77982_d(tagCompound);
        return itemStack;
    }

    @Nonnull
    public static ItemStack setValue(@Nonnull ItemStack itemStack, int dye) {
        switch (itemStack.func_77952_i()) {
            case 0: {
                return ItemTuningDriver.setVideoChannel(itemStack, dye);
            }
            case 1: {
                return ItemTuningDriver.setBeamFrequency(itemStack, dye);
            }
            case 2: {
                return ItemTuningDriver.setControlChannel(itemStack, dye);
            }
        }
        return itemStack;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull EntityPlayer entityPlayer, @Nonnull EnumHand hand) {
        ItemStack itemStackHeld = entityPlayer.func_184586_b(hand);
        if (world.field_72995_K || !(itemStackHeld.func_77973_b() instanceof ItemTuningDriver)) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemStackHeld);
        }
        RayTraceResult movingObjectPosition = Commons.getInteractingBlock(world, entityPlayer);
        if (movingObjectPosition.field_72313_a != RayTraceResult.Type.MISS) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemStackHeld);
        }
        if (entityPlayer.func_70093_af() && entityPlayer.field_71075_bZ.field_75098_d) {
            switch (itemStackHeld.func_77952_i()) {
                case 0: {
                    ItemTuningDriver.setVideoChannel(itemStackHeld, 1 + world.field_73012_v.nextInt(0xFFFFFFF));
                    Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.video_channel.get", entityPlayer.func_70005_c_(), ItemTuningDriver.getVideoChannel(itemStackHeld)));
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackHeld);
                }
                case 1: {
                    ItemTuningDriver.setBeamFrequency(itemStackHeld, 1 + world.field_73012_v.nextInt(65000));
                    Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.beam_frequency.get", entityPlayer.func_70005_c_(), ItemTuningDriver.getBeamFrequency(itemStackHeld)));
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackHeld);
                }
                case 2: {
                    ItemTuningDriver.setControlChannel(itemStackHeld, world.field_73012_v.nextInt(0xFFFFFFF));
                    Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.control_channel.get", entityPlayer.func_70005_c_(), ItemTuningDriver.getControlChannel(itemStackHeld)));
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackHeld);
                }
            }
            return new ActionResult(EnumActionResult.PASS, (Object)itemStackHeld);
        }
        switch (itemStackHeld.func_77952_i()) {
            case 0: {
                itemStackHeld.func_77964_b(1);
                entityPlayer.func_184611_a(hand, itemStackHeld);
                break;
            }
            case 1: {
                itemStackHeld.func_77964_b(2);
                entityPlayer.func_184611_a(hand, itemStackHeld);
                break;
            }
            case 2: {
                itemStackHeld.func_77964_b(0);
                entityPlayer.func_184611_a(hand, itemStackHeld);
                break;
            }
            default: {
                itemStackHeld.func_77964_b(0);
            }
        }
        world.func_184134_a(entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v, SoundEvents.DING, SoundCategory.PLAYERS, 0.1f, 1.0f, false);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackHeld);
    }

    @Nonnull
    public EnumActionResult func_180614_a(@Nonnull EntityPlayer entityPlayer, @Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return EnumActionResult.FAIL;
        }
        ItemStack itemStackHeld = entityPlayer.func_184586_b(hand);
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity == null) {
            return EnumActionResult.FAIL;
        }
        switch (itemStackHeld.func_77952_i()) {
            case 0: {
                if (tileEntity instanceof IVideoChannel) {
                    if (entityPlayer.func_70093_af()) {
                        ItemTuningDriver.setVideoChannel(itemStackHeld, ((IVideoChannel)tileEntity).getVideoChannel());
                        Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.video_channel.get", tileEntity.func_145838_q().func_149732_F(), ItemTuningDriver.getVideoChannel(itemStackHeld)));
                    } else {
                        ((IVideoChannel)tileEntity).setVideoChannel(ItemTuningDriver.getVideoChannel(itemStackHeld));
                        Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.video_channel.set", tileEntity.func_145838_q().func_149732_F(), ItemTuningDriver.getVideoChannel(itemStackHeld)));
                    }
                    return EnumActionResult.SUCCESS;
                }
                return EnumActionResult.FAIL;
            }
            case 1: {
                if (tileEntity instanceof IBeamFrequency) {
                    if (entityPlayer.func_70093_af()) {
                        ItemTuningDriver.setBeamFrequency(itemStackHeld, ((IBeamFrequency)tileEntity).getBeamFrequency());
                        Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.beam_frequency.get", tileEntity.func_145838_q().func_149732_F(), ItemTuningDriver.getBeamFrequency(itemStackHeld)));
                    } else {
                        ((IBeamFrequency)tileEntity).setBeamFrequency(ItemTuningDriver.getBeamFrequency(itemStackHeld));
                        Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.beam_frequency.set", tileEntity.func_145838_q().func_149732_F(), ItemTuningDriver.getBeamFrequency(itemStackHeld)));
                    }
                    return EnumActionResult.SUCCESS;
                }
                return EnumActionResult.FAIL;
            }
            case 2: {
                if (tileEntity instanceof IControlChannel) {
                    if (entityPlayer.func_70093_af()) {
                        ItemTuningDriver.setControlChannel(itemStackHeld, ((IControlChannel)tileEntity).getControlChannel());
                        Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.control_channel.get", tileEntity.func_145838_q().func_149732_F(), ItemTuningDriver.getControlChannel(itemStackHeld)));
                    } else {
                        ((IControlChannel)tileEntity).setControlChannel(ItemTuningDriver.getControlChannel(itemStackHeld));
                        Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.control_channel.set", tileEntity.func_145838_q().func_149732_F(), ItemTuningDriver.getControlChannel(itemStackHeld)));
                    }
                    return EnumActionResult.SUCCESS;
                }
                return EnumActionResult.FAIL;
            }
        }
        return EnumActionResult.FAIL;
    }

    public boolean doesSneakBypassUse(@Nonnull ItemStack itemStack, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos, @Nonnull EntityPlayer player) {
        Block block = blockAccess.func_180495_p(blockPos).func_177230_c();
        return block instanceof BlockCapacitor || super.doesSneakBypassUse(itemStack, blockAccess, blockPos, player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack itemStack, @Nullable World world, @Nonnull List<String> list, @Nonnull ITooltipFlag advancedItemTooltips) {
        super.func_77624_a(itemStack, world, list, advancedItemTooltips);
        WarpDriveText textTooltip = new WarpDriveText();
        switch (itemStack.func_77952_i()) {
            case 0: {
                textTooltip.append(null, "warpdrive.video_channel.tooltip", new Object[]{new WarpDriveText(Commons.getStyleValue(), ItemTuningDriver.getVideoChannel(itemStack))});
                break;
            }
            case 1: {
                textTooltip.append(null, "warpdrive.beam_frequency.tooltip", new Object[]{new WarpDriveText(Commons.getStyleValue(), ItemTuningDriver.getBeamFrequency(itemStack))});
                break;
            }
            case 2: {
                textTooltip.append(null, "warpdrive.control_channel.tooltip", new Object[]{new WarpDriveText(Commons.getStyleValue(), ItemTuningDriver.getControlChannel(itemStack))});
                break;
            }
            default: {
                textTooltip.append((ITextComponent)new TextComponentString("I'm broken :("));
            }
        }
        textTooltip.appendLineBreak();
        textTooltip.append(null, "item.warpdrive.tool.tuning_driver.tooltip.usage", new Object[0]);
        Commons.addTooltip(list, textTooltip.func_150254_d());
    }
}

