/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.item;

import cr0s.warpdrive.api.IWarpTool;
import cr0s.warpdrive.data.EnumTier;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.item.ItemAbstractBase;
import cr0s.warpdrive.network.PacketHandler;
import javax.annotation.Nonnull;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemWrench
extends ItemAbstractBase
implements IWarpTool {
    public ItemWrench(String registryName, EnumTier enumTier) {
        super(registryName, enumTier);
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77655_b("warpdrive.tool.wrench");
        this.func_77664_n();
    }

    @Nonnull
    public EnumActionResult func_180614_a(@Nonnull EntityPlayer entityPlayer, @Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return EnumActionResult.FAIL;
        }
        ItemStack itemStackHeld = entityPlayer.func_184586_b(hand);
        IBlockState blockState = world.func_180495_p(blockPos);
        if (blockState.func_177230_c().isAir(blockState, (IBlockAccess)world, blockPos)) {
            return EnumActionResult.FAIL;
        }
        Vector3 vFace = new Vector3(blockPos).translate(0.5);
        if (!entityPlayer.func_175151_a(blockPos, facing, itemStackHeld) || !world.func_175660_a(entityPlayer, blockPos)) {
            PacketHandler.sendSpawnParticlePacket(world, "jammed", (byte)5, vFace, new Vector3(0.0, 0.0, 0.0), 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 6);
            return EnumActionResult.FAIL;
        }
        if (!blockState.func_177230_c().rotateBlock(world, blockPos, facing)) {
            PacketHandler.sendSpawnParticlePacket(world, "jammed", (byte)5, vFace, new Vector3(0.0, 0.0, 0.0), 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 6);
            return EnumActionResult.FAIL;
        }
        SoundType soundType = blockState.func_177230_c().getSoundType(blockState, world, blockPos, null);
        world.func_184133_a(null, blockPos, soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
        world.func_175685_c(blockPos, blockState.func_177230_c(), false);
        entityPlayer.func_184609_a(hand);
        return EnumActionResult.SUCCESS;
    }
}

