/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.network;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.TileEntityLaser;
import cr0s.warpdrive.config.WarpDriveConfig;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageTargeting
implements IMessage,
IMessageHandler<MessageTargeting, IMessage> {
    private int x;
    private int y;
    private int z;
    private float yaw;
    private float pitch;

    public MessageTargeting() {
    }

    public MessageTargeting(int x, int y, int z, float yaw, float pitch) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public void fromBytes(ByteBuf buffer) {
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.yaw = buffer.readFloat();
        this.pitch = buffer.readFloat();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        buffer.writeFloat(this.yaw);
        buffer.writeFloat(this.pitch);
    }

    private void handle(World world) {
        TileEntity tileEntity = world.func_175625_s(new BlockPos(this.x, this.y, this.z));
        if (tileEntity instanceof TileEntityLaser) {
            TileEntityLaser laser = (TileEntityLaser)tileEntity;
            laser.initiateBeamEmission(this.yaw, this.pitch);
        }
    }

    public IMessage onMessage(MessageTargeting targetingMessage, MessageContext context) {
        if (WarpDriveConfig.LOGGING_TARGETING) {
            WarpDrive.logger.info(String.format("Received target packet: (%d %d %d) yaw: %.1f pitch: %.1f", targetingMessage.x, targetingMessage.y, targetingMessage.z, Float.valueOf(targetingMessage.yaw), Float.valueOf(targetingMessage.pitch)));
        }
        targetingMessage.handle(context.getServerHandler().field_147369_b.field_70170_p);
        return null;
    }
}

