/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.network;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CelestialObject;
import cr0s.warpdrive.data.CloakedArea;
import cr0s.warpdrive.data.GlobalPosition;
import cr0s.warpdrive.data.MovingEntity;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.network.MessageBeamEffect;
import cr0s.warpdrive.network.MessageClientSync;
import cr0s.warpdrive.network.MessageClientUnseating;
import cr0s.warpdrive.network.MessageClientValidation;
import cr0s.warpdrive.network.MessageCloak;
import cr0s.warpdrive.network.MessageSpawnParticle;
import cr0s.warpdrive.network.MessageTargeting;
import cr0s.warpdrive.network.MessageTransporterEffect;
import cr0s.warpdrive.network.MessageVideoChannel;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketEntityEquipment;
import net.minecraft.network.play.server.SPacketEntityMetadata;
import net.minecraft.network.play.server.SPacketEntityProperties;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.network.play.server.SPacketSpawnMob;
import net.minecraft.network.play.server.SPacketUseBed;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;

public class PacketHandler {
    private static final SimpleNetworkWrapper simpleNetworkManager = NetworkRegistry.INSTANCE.newSimpleChannel("warpdrive");
    private static Method EntityTrackerEntry_getPacketForThisEntity;

    public static void init() {
        simpleNetworkManager.registerMessage(MessageBeamEffect.class, MessageBeamEffect.class, 0, Side.CLIENT);
        simpleNetworkManager.registerMessage(MessageClientSync.class, MessageClientSync.class, 2, Side.CLIENT);
        simpleNetworkManager.registerMessage(MessageCloak.class, MessageCloak.class, 3, Side.CLIENT);
        simpleNetworkManager.registerMessage(MessageSpawnParticle.class, MessageSpawnParticle.class, 4, Side.CLIENT);
        simpleNetworkManager.registerMessage(MessageVideoChannel.class, MessageVideoChannel.class, 5, Side.CLIENT);
        simpleNetworkManager.registerMessage(MessageTransporterEffect.class, MessageTransporterEffect.class, 6, Side.CLIENT);
        simpleNetworkManager.registerMessage(MessageTargeting.class, MessageTargeting.class, 100, Side.SERVER);
        simpleNetworkManager.registerMessage(MessageClientValidation.class, MessageClientValidation.class, 101, Side.SERVER);
        simpleNetworkManager.registerMessage(MessageClientUnseating.class, MessageClientUnseating.class, 102, Side.SERVER);
        try {
            EntityTrackerEntry_getPacketForThisEntity = ReflectionHelper.findMethod(EntityTrackerEntry.class, (String)"createSpawnPacket", (String)"func_151260_c", (Class[])new Class[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void sendBeamPacket(@Nonnull World world, Vector3 v3Source, Vector3 v3Target, float red, float green, float blue, int age, int energy, int radius) {
        assert (!world.field_72995_K);
        MessageBeamEffect messageBeamEffect = new MessageBeamEffect(v3Source, v3Target, red, green, blue, age);
        if (v3Source.distanceTo_square(v3Target) < 3600.0) {
            simpleNetworkManager.sendToAllAround((IMessage)messageBeamEffect, new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (v3Source.x + v3Target.x) / 2.0, (v3Source.y + v3Target.y) / 2.0, (v3Source.z + v3Target.z) / 2.0, (double)radius));
        } else {
            assert (world.func_73046_m() != null);
            List playerEntityList = world.func_73046_m().func_184103_al().func_181057_v();
            int dimensionId = world.field_73011_w.getDimension();
            int radius_square = radius * radius;
            for (EntityPlayerMP entityPlayerMP : playerEntityList) {
                if (entityPlayerMP.field_71093_bK != dimensionId || !(v3Source.distanceTo_square((Entity)entityPlayerMP) < (double)radius_square) && !(v3Target.distanceTo_square((Entity)entityPlayerMP) < (double)radius_square)) continue;
                simpleNetworkManager.sendTo((IMessage)messageBeamEffect, entityPlayerMP);
            }
        }
    }

    public static void sendBeamPacketToPlayersInArea(@Nonnull World world, Vector3 source, Vector3 target, float red, float green, float blue, int age, AxisAlignedBB aabb) {
        assert (!world.field_72995_K);
        MessageBeamEffect messageBeamEffect = new MessageBeamEffect(source, target, red, green, blue, age);
        List list = world.func_72872_a(EntityPlayerMP.class, aabb);
        for (Entity entity : list) {
            if (!(entity instanceof EntityPlayerMP)) continue;
            simpleNetworkManager.sendTo((IMessage)messageBeamEffect, (EntityPlayerMP)entity);
        }
    }

    public static void sendScanningPacket(@Nonnull World world, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, float red, float green, float blue, int age) {
        assert (!world.field_72995_K);
        Vector3 vMinMin = new Vector3(xMin, yMin, zMin);
        Vector3 vMaxMin = new Vector3(xMax, yMin, zMin);
        Vector3 vMaxMax = new Vector3(xMax, yMin, zMax);
        Vector3 vMinMax = new Vector3(xMin, yMin, zMax);
        PacketHandler.sendBeamPacket(world, vMinMin, vMaxMin, red, green, blue, age, 0, 50);
        PacketHandler.sendBeamPacket(world, vMaxMin, vMaxMax, red, green, blue, age, 0, 50);
        PacketHandler.sendBeamPacket(world, vMaxMax, vMinMax, red, green, blue, age, 0, 50);
        PacketHandler.sendBeamPacket(world, vMinMax, vMinMin, red, green, blue, age, 0, 50);
    }

    public static void sendSpawnParticlePacket(World world, String type, byte quantity, Vector3 origin, Vector3 direction, float baseRed, float baseGreen, float baseBlue, float fadeRed, float fadeGreen, float fadeBlue, int radius) {
        assert (!world.field_72995_K);
        MessageSpawnParticle messageSpawnParticle = new MessageSpawnParticle(type, quantity, origin, direction, baseRed, baseGreen, baseBlue, fadeRed, fadeGreen, fadeBlue);
        simpleNetworkManager.sendToAllAround((IMessage)messageSpawnParticle, new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), origin.x, origin.y, origin.z, (double)radius));
        if (WarpDriveConfig.LOGGING_EFFECTS) {
            WarpDrive.logger.info(String.format("Sent particle effect '%s' x %d from %s toward %s as RGB %.2f %.2f %.2f fading to %.2f %.2f %.2f", type, quantity, origin, direction, Float.valueOf(baseRed), Float.valueOf(baseGreen), Float.valueOf(baseBlue), Float.valueOf(fadeRed), Float.valueOf(fadeGreen), Float.valueOf(fadeBlue)));
        }
    }

    public static void sendTransporterEffectPacket(World world, GlobalPosition globalPositionLocal, GlobalPosition globalPositionRemote, double lockStrength, Collection<MovingEntity> movingEntitiesLocal, Collection<MovingEntity> movingEntitiesRemote, int tickEnergizing, int tickCooldown, int radius) {
        assert (!world.field_72995_K);
        MessageTransporterEffect messageTransporterEffectLocal = new MessageTransporterEffect(true, globalPositionLocal, movingEntitiesLocal, lockStrength, tickEnergizing, tickCooldown);
        MessageTransporterEffect messageTransporterEffectRemote = new MessageTransporterEffect(false, globalPositionRemote, movingEntitiesRemote, lockStrength, tickEnergizing, tickCooldown);
        assert (world.func_73046_m() != null);
        List playerEntityList = world.func_73046_m().func_184103_al().func_181057_v();
        int radius_square = radius * radius;
        for (EntityPlayerMP entityPlayerMP : playerEntityList) {
            if (globalPositionLocal != null && globalPositionLocal.distance2To((Entity)entityPlayerMP) < (double)radius_square) {
                simpleNetworkManager.sendTo((IMessage)messageTransporterEffectLocal, entityPlayerMP);
            }
            if (globalPositionRemote == null || !(globalPositionRemote.distance2To((Entity)entityPlayerMP) < (double)radius_square)) continue;
            simpleNetworkManager.sendTo((IMessage)messageTransporterEffectRemote, entityPlayerMP);
        }
    }

    public static void sendVideoChannelPacket(World world, BlockPos blockPos, int videoChannel) {
        MessageVideoChannel messageVideoChannel = new MessageVideoChannel(blockPos, videoChannel);
        simpleNetworkManager.sendToAllAround((IMessage)messageVideoChannel, new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), 100.0));
        if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
            WarpDrive.logger.info(String.format("Sent video channel packet at %s videoChannel %d", Commons.format(world, blockPos), videoChannel));
        }
    }

    public static void sendLaserTargetingPacket(int x, int y, int z, float yaw, float pitch) {
        MessageTargeting messageTargeting = new MessageTargeting(x, y, z, yaw, pitch);
        simpleNetworkManager.sendToServer((IMessage)messageTargeting);
        if (WarpDriveConfig.LOGGING_TARGETING) {
            WarpDrive.logger.info(String.format("Sent targeting packet (%d %d %d) yaw %.3f pitch %.3f", x, y, z, Float.valueOf(yaw), Float.valueOf(pitch)));
        }
    }

    public static void sendCloakPacket(EntityPlayerMP entityPlayerMP, CloakedArea area, boolean isUncloaking) {
        MessageCloak messageCloak = new MessageCloak(area, isUncloaking);
        simpleNetworkManager.sendTo((IMessage)messageCloak, entityPlayerMP);
        if (WarpDriveConfig.LOGGING_CLOAKING) {
            WarpDrive.logger.info(String.format("Sent cloak packet (area %s isUncloaking %s)", area, isUncloaking));
        }
    }

    public static void sendClientSync(EntityPlayerMP entityPlayerMP, CelestialObject celestialObject) {
        if (WarpDriveConfig.LOGGING_CLIENT_SYNCHRONIZATION) {
            WarpDrive.logger.info(String.format("PacketHandler.sendClientSync %s", entityPlayerMP));
        }
        MessageClientSync messageClientSync = new MessageClientSync(entityPlayerMP, celestialObject);
        simpleNetworkManager.sendTo((IMessage)messageClientSync, entityPlayerMP);
    }

    public static Packet<?> getPacketForThisEntity(Entity entity) {
        EntityTrackerEntry entry = new EntityTrackerEntry(entity, 0, 0, 0, false);
        try {
            return (Packet)EntityTrackerEntry_getPacketForThisEntity.invoke((Object)entry, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace(WarpDrive.printStreamError);
            WarpDrive.logger.error(String.format("Unable to get packet for entity %s", entity));
            return null;
        }
    }

    public static void revealEntityToPlayer(Entity entity, EntityPlayerMP entityPlayerMP) {
        try {
            EntityPlayer entityplayer;
            EntityEquipmentSlot[] attributemap;
            Collection collection;
            if (entityPlayerMP.field_71135_a == null) {
                WarpDrive.logger.warn(String.format("Unable to reveal entity %s to player %s: no connection", entity, entityPlayerMP));
                return;
            }
            Packet<?> packet = PacketHandler.getPacketForThisEntity(entity);
            if (packet == null) {
                WarpDrive.logger.error(String.format("Unable to reveal entity %s to player %s: null packet", entity, entityPlayerMP));
                return;
            }
            if (WarpDriveConfig.LOGGING_CLOAKING) {
                WarpDrive.logger.info(String.format("Revealing entity %s with patcket %s", entity, packet));
            }
            entityPlayerMP.field_71135_a.func_147359_a(packet);
            if (!entity.func_184212_Q().func_187228_d()) {
                entityPlayerMP.field_71135_a.func_147359_a((Packet)new SPacketEntityMetadata(entity.func_145782_y(), entity.func_184212_Q(), true));
            }
            if (entity instanceof EntityLivingBase && !(collection = (attributemap = (EntityEquipmentSlot[])((EntityLivingBase)entity).func_110140_aT()).func_111160_c()).isEmpty()) {
                entityPlayerMP.field_71135_a.func_147359_a((Packet)new SPacketEntityProperties(entity.func_145782_y(), collection));
            }
            if (!(packet instanceof SPacketSpawnMob)) {
                entityPlayerMP.field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(entity.func_145782_y(), entity.field_70159_w, entity.field_70181_x, entity.field_70179_y));
            }
            if (entity instanceof EntityLivingBase) {
                for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
                    ItemStack itemstack = ((EntityLivingBase)entity).func_184582_a(entityequipmentslot);
                    if (itemstack.func_190926_b()) continue;
                    entityPlayerMP.field_71135_a.func_147359_a((Packet)new SPacketEntityEquipment(entity.func_145782_y(), entityequipmentslot, itemstack));
                }
            }
            if (entity instanceof EntityPlayer && (entityplayer = (EntityPlayer)entity).func_70608_bn()) {
                entityPlayerMP.field_71135_a.func_147359_a((Packet)new SPacketUseBed(entityplayer, new BlockPos(entity)));
            }
            if (entity instanceof EntityLivingBase) {
                EntityLivingBase entitylivingbase = (EntityLivingBase)entity;
                for (PotionEffect potioneffect : entitylivingbase.func_70651_bq()) {
                    entityPlayerMP.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(entity.func_145782_y(), potioneffect));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(WarpDrive.printStreamError);
        }
    }

    public static void sendUnseating() {
        MessageClientUnseating messageClientUnseating = new MessageClientUnseating();
        simpleNetworkManager.sendToServer((IMessage)messageClientUnseating);
        if (WarpDriveConfig.LOGGING_CAMERA) {
            WarpDrive.logger.info("Sent unseating packet");
        }
    }
}

