/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.render;

import com.google.common.collect.ImmutableList;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IMyBakedModel;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.util.vector.Vector3f;

public abstract class BakedModelAbstractBase
implements IMyBakedModel {
    protected ModelResourceLocation modelResourceLocation;
    protected IBakedModel bakedModelOriginal;
    protected TextureAtlasSprite spriteParticle;
    protected TextureAtlasSprite spriteBlock;
    protected int tintIndex = -1;
    protected VertexFormat format = DefaultVertexFormats.field_176599_b;
    protected IBlockState blockStateDefault;
    protected ItemOverrideList itemOverrideList = new ItemOverrideList((List)ImmutableList.of()){

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel model, @Nonnull ItemStack itemStack, World world, EntityLivingBase entity) {
            Block block = ((ItemBlock)itemStack.func_77973_b()).func_179223_d();
            IBlockState blockState = block.func_176203_a(itemStack.func_77960_j());
            IBakedModel bakedModelNew = Minecraft.func_71410_x().func_175602_ab().func_184389_a(blockState);
            BakedModelAbstractBase.this.blockStateDefault = blockState;
            return bakedModelNew;
        }
    };

    @Override
    public void setModelResourceLocation(ModelResourceLocation modelResourceLocation) {
        this.modelResourceLocation = modelResourceLocation;
    }

    @Override
    public void setOriginalBakedModel(IBakedModel bakedModel) {
        this.bakedModelOriginal = bakedModel;
        this.spriteParticle = bakedModel.func_177554_e();
        try {
            for (EnumFacing enumFacing : EnumFacing.field_82609_l) {
                List bakedQuads = bakedModel.func_188616_a(null, enumFacing, 0L);
                if (bakedQuads.isEmpty()) continue;
                BakedQuad bakedQuad = (BakedQuad)bakedQuads.get(0);
                this.format = bakedQuad.getFormat();
                this.spriteBlock = bakedQuad.func_187508_a();
                if (bakedQuad.func_178212_b()) {
                    this.tintIndex = bakedQuad.func_178211_c();
                }
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(WarpDrive.printStreamError);
            WarpDrive.logger.error(String.format("Exception trying to retrieve format for %s original baked model %s, defaulting to forge", this.modelResourceLocation, this.bakedModelOriginal));
            this.format = DefaultVertexFormats.field_176599_b;
        }
    }

    protected void putVertex(UnpackedBakedQuad.Builder builder, float x, float y, float z, float red, float green, float blue, float alpha, float u, float v, @Nullable Vector3f normal) {
        block7: for (int index = 0; index < this.format.func_177345_h(); ++index) {
            switch (this.format.func_177348_c(index).func_177375_c()) {
                case POSITION: {
                    builder.put(index, new float[]{x, y, z, 1.0f});
                    continue block7;
                }
                case NORMAL: {
                    if (normal != null) {
                        builder.put(index, new float[]{normal.x, normal.y, normal.z});
                        continue block7;
                    }
                    WarpDrive.logger.warn(String.format("Missing normal vector, it's required in format %s", this.format));
                    builder.put(index, new float[0]);
                    continue block7;
                }
                case COLOR: {
                    builder.put(index, new float[]{red, green, blue, alpha});
                    continue block7;
                }
                case UV: {
                    builder.put(index, new float[]{u, v, 0.0f, 1.0f});
                    continue block7;
                }
                case PADDING: {
                    builder.put(index, new float[0]);
                    continue block7;
                }
                default: {
                    WarpDrive.logger.warn(String.format("Unsupported format element #%d %s in %s", index, this.format.func_177348_c(index), this.format));
                    builder.put(index, new float[0]);
                }
            }
        }
    }

    protected void addBakedQuad(List<BakedQuad> quads, TextureAtlasSprite sprite, float red, float green, float blue, float alpha, float x1, float y1, float z1, float u1, float v1, float x2, float y2, float z2, float u2, float v2, float x3, float y3, float z3, float u3, float v3, float x4, float y4, float z4, float u4, float v4) {
        Vector3f vectorNormal;
        if (this.format.func_177350_b()) {
            Vector3f vectorTemp1 = new Vector3f(x3 - x2, y3 - y2, z3 - z2);
            Vector3f vectorTemp2 = new Vector3f(x1 - x2, y1 - y2, z1 - z2);
            vectorNormal = Vector3f.cross((Vector3f)vectorTemp1, (Vector3f)vectorTemp2, (Vector3f)vectorTemp1);
            vectorNormal.normalise(vectorNormal);
        } else {
            vectorNormal = null;
        }
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(this.format);
        builder.setTexture(sprite);
        this.putVertex(builder, x1, y1, z1, red, green, blue, alpha, u1, v1, vectorNormal);
        this.putVertex(builder, x2, y2, z2, red, green, blue, alpha, u2, v2, vectorNormal);
        this.putVertex(builder, x3, y3, z3, red, green, blue, alpha, u3, v3, vectorNormal);
        this.putVertex(builder, x4, y4, z4, red, green, blue, alpha, u4, v4, vectorNormal);
        quads.add((BakedQuad)builder.build());
    }

    protected void addBakedQuad(List<BakedQuad> quads, TextureAtlasSprite sprite, int color, float x1, float y1, float z1, float u1, float v1, float x2, float y2, float z2, float u2, float v2, float x3, float y3, float z3, float u3, float v3, float x4, float y4, float z4, float u4, float v4) {
        float[] rgba = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f};
        if (rgba[3] == 0.0f) {
            rgba[3] = 1.0f;
        }
        this.addBakedQuad(quads, sprite, rgba[0], rgba[1], rgba[2], rgba[3], x1, y1, z1, u1, v1, x2, y2, z2, u2, v2, x3, y3, z3, u3, v3, x4, y4, z4, u4, v4);
    }

    public boolean func_177555_b() {
        return this.bakedModelOriginal.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.bakedModelOriginal.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.bakedModelOriginal.func_188618_c();
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.spriteParticle;
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.itemOverrideList;
    }

    @Nonnull
    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(@Nonnull ItemCameraTransforms.TransformType cameraTransformType) {
        if (this.bakedModelOriginal == null) {
            return ForgeHooksClient.handlePerspective((IBakedModel)this, (ItemCameraTransforms.TransformType)cameraTransformType);
        }
        Matrix4f matrix4f = (Matrix4f)this.bakedModelOriginal.handlePerspective(cameraTransformType).getRight();
        return Pair.of((Object)this, (Object)matrix4f);
    }
}

