/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.render;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.network.PacketHandler;
import cr0s.warpdrive.render.ClientCameraHandler;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public final class EntityCamera
extends EntityLivingBase {
    private int cameraX;
    private int cameraY;
    private int cameraZ;
    private EntityPlayer player;
    private final Minecraft mc = Minecraft.func_71410_x();
    private int dx = 0;
    private int dy = 0;
    private int dz = 0;
    private int closeWaitTicks = 0;
    private int zoomWaitTicks = 0;
    private int fireWaitTicks = 0;
    private boolean isActive = true;
    private int bootUpTicks = 20;
    private boolean isCentered = true;

    public EntityCamera(World world) {
        super(world);
    }

    public EntityCamera(World world, int x, int y, int z, EntityPlayer player) {
        super(world);
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        this.cameraX = x;
        this.cameraY = y;
        this.cameraZ = z;
        this.player = player;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_82142_c(true);
        this.field_70145_X = true;
    }

    public float func_70047_e() {
        return 1.62f;
    }

    public void func_70080_a(double x, double y, double z, float yaw, float pitch) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    private void closeCamera() {
        if (!this.isActive) {
            return;
        }
        ClientCameraHandler.resetViewpoint();
        this.field_70170_p.func_72900_e((Entity)this);
        this.isActive = false;
    }

    public void func_70030_z() {
        if (this.field_70170_p.field_72995_K) {
            if (this.player == null || this.player.field_70128_L) {
                WarpDrive.logger.error(String.format("%s Player is null or dead, closing camera...", new Object[]{this}));
                this.closeCamera();
                return;
            }
            if (!ClientCameraHandler.isValidContext(this.field_70170_p)) {
                WarpDrive.logger.error(String.format("%s Invalid context, closing camera...", new Object[]{this}));
                this.closeCamera();
                return;
            }
            Block block = this.field_70170_p.func_180495_p(new BlockPos(this.cameraX, this.cameraY, this.cameraZ)).func_177230_c();
            if (this.mc.func_175606_aa() != null) {
                this.mc.func_175606_aa().field_70177_z = this.player.field_70177_z;
                this.mc.func_175606_aa().field_70125_A = this.player.field_70125_A;
            }
            ClientCameraHandler.overlayLoggingMessage = "Mouse " + Mouse.isButtonDown((int)0) + " " + Mouse.isButtonDown((int)1) + " " + Mouse.isButtonDown((int)2) + " " + Mouse.isButtonDown((int)3) + "\nBackspace " + Keyboard.isKeyDown((int)43) + " Space " + Keyboard.isKeyDown((int)57) + " Shift ";
            if (Mouse.isButtonDown((int)0)) {
                ++this.zoomWaitTicks;
                if (this.zoomWaitTicks >= 2) {
                    this.zoomWaitTicks = 0;
                    ClientCameraHandler.zoom();
                }
            } else {
                this.zoomWaitTicks = 0;
            }
            if (this.bootUpTicks > 0) {
                --this.bootUpTicks;
            } else if (Mouse.isButtonDown((int)1)) {
                ++this.closeWaitTicks;
                if (this.closeWaitTicks >= 2) {
                    this.closeWaitTicks = 0;
                    this.closeCamera();
                }
            } else {
                this.closeWaitTicks = 0;
            }
            if (Keyboard.isKeyDown((int)57)) {
                ++this.fireWaitTicks;
                if (this.fireWaitTicks >= 2) {
                    this.fireWaitTicks = 0;
                    if (block.func_149667_c(WarpDrive.blockLaserCamera)) {
                        PacketHandler.sendLaserTargetingPacket(this.cameraX, this.cameraY, this.cameraZ, this.mc.func_175606_aa().field_70177_z, this.mc.func_175606_aa().field_70125_A);
                    }
                }
            } else {
                this.fireWaitTicks = 0;
            }
            if (Keyboard.isKeyDown((int)208)) {
                this.dy = -1;
            } else if (Keyboard.isKeyDown((int)200)) {
                this.dy = 2;
            } else if (Commons.isKeyPressed(this.mc.field_71474_y.field_74370_x)) {
                this.dz = -1;
            } else if (Commons.isKeyPressed(this.mc.field_71474_y.field_74366_z)) {
                this.dz = 1;
            } else if (Commons.isKeyPressed(this.mc.field_71474_y.field_74351_w)) {
                this.dx = 1;
            } else if (Commons.isKeyPressed(this.mc.field_71474_y.field_74368_y)) {
                this.dx = -1;
            } else if (Keyboard.isKeyDown((int)46)) {
                this.dx = 0;
                this.dy = 0;
                this.dz = 0;
                this.isCentered = !this.isCentered;
                return;
            }
            if (this.isCentered) {
                this.func_70107_b((double)this.cameraX + 0.5, (double)this.cameraY + 0.5, (double)this.cameraZ + 0.5);
            } else {
                this.func_70107_b(this.cameraX + this.dx, this.cameraY + this.dy, this.cameraZ + this.dz);
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
    }

    public boolean shouldRenderInPass(int pass) {
        return false;
    }

    public AxisAlignedBB func_70046_E() {
        return Block.field_185506_k;
    }

    public boolean func_70104_M() {
        return false;
    }

    @Nonnull
    public EnumHandSide func_184591_cq() {
        return EnumHandSide.RIGHT;
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
    }

    public void func_70037_a(@Nonnull NBTTagCompound tagCompound) {
        this.cameraX = tagCompound.func_74762_e("x");
        this.cameraY = tagCompound.func_74762_e("y");
        this.cameraZ = tagCompound.func_74762_e("z");
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("x", this.cameraX);
        nbttagcompound.func_74768_a("y", this.cameraY);
        nbttagcompound.func_74768_a("z", this.cameraZ);
    }

    @Nonnull
    public Iterable<ItemStack> func_184193_aE() {
        return Collections.emptyList();
    }

    @Nonnull
    public ItemStack func_184582_a(@Nonnull EntityEquipmentSlot slotIn) {
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(@Nonnull EntityEquipmentSlot slotIn, @Nullable ItemStack itemStack) {
    }
}

