/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.render;

import cr0s.warpdrive.data.Vector3;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class EntityFXBeam
extends Particle {
    private static final int ROTATION_SPEED = 20;
    private static final float END_MODIFIER = 1.0f;
    private static final ResourceLocation TEXTURE = new ResourceLocation("warpdrive", "textures/particle/energy_grey.png");
    private float length = 0.0f;
    private float rotYaw = 0.0f;
    private float rotPitch = 0.0f;
    private float prevYaw = 0.0f;
    private float prevPitch = 0.0f;
    private float prevSize = 0.0f;

    public EntityFXBeam(World world, Vector3 position, Vector3 target, float red, float green, float blue, int age) {
        super(world, position.x, position.y, position.z, 0.0, 0.0, 0.0);
        this.func_70538_b(red, green, blue);
        this.func_187115_a(0.02f, 0.02f);
        this.field_190017_n = false;
        this.field_187129_i = 0.0;
        this.field_187130_j = 0.0;
        this.field_187131_k = 0.0;
        float xd = (float)(this.field_187126_f - target.x);
        float yd = (float)(this.field_187127_g - target.y);
        float zd = (float)(this.field_187128_h - target.z);
        this.length = (float)position.distanceTo(target);
        double lengthXZ = MathHelper.func_76129_c((float)(xd * xd + zd * zd));
        this.rotYaw = (float)(Math.atan2(xd, zd) * 180.0 / Math.PI);
        this.rotPitch = (float)(Math.atan2(yd, lengthXZ) * 180.0 / Math.PI);
        this.prevYaw = this.rotYaw;
        this.prevPitch = this.rotPitch;
        this.field_70547_e = age;
        Entity entityRender = Minecraft.func_71410_x().func_175606_aa();
        int visibleDistance = 300;
        if (!Minecraft.func_71410_x().field_71474_y.field_74347_j) {
            visibleDistance = 100;
        }
        if (entityRender != null && entityRender.func_70011_f(this.field_187126_f, this.field_187127_g, this.field_187128_h) > (double)visibleDistance) {
            this.field_70547_e = 0;
        }
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.prevYaw = this.rotYaw;
        this.prevPitch = this.rotPitch;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
    }

    public void func_180434_a(BufferBuilder vertexBuffer, Entity entityIn, float partialTick, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        GlStateManager.func_179094_E();
        float rot = (float)(this.field_187122_b.field_73011_w.getWorldTime() % 18L * 20L) + 20.0f * partialTick;
        float sizeTarget = Math.min((float)this.field_70546_d / 4.0f, 1.0f);
        float size = this.prevSize + (sizeTarget - this.prevSize) * partialTick;
        float alpha = 0.5f;
        if (this.field_70547_e - this.field_70546_d <= 4) {
            alpha = 0.5f - (float)(4 - (this.field_70547_e - this.field_70546_d)) * 0.1f;
        }
        int brightnessForRender = this.func_189214_a(partialTick);
        int brightnessHigh = brightnessForRender >> 16 & 0xFFFF;
        int brightnessLow = Math.max(240, brightnessForRender & 0xFFFF);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
        GlStateManager.func_187403_b((int)3553, (int)10242, (float)10497.0f);
        GlStateManager.func_187403_b((int)3553, (int)10243, (float)10497.0f);
        GlStateManager.func_179129_p();
        float relativeTime = (float)this.field_187122_b.func_82737_E() + partialTick;
        float vOffset = -relativeTime * 0.2f - (float)MathHelper.func_76141_d((float)(-relativeTime * 0.1f));
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.func_179132_a((boolean)false);
        float xx = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTick - field_70556_an);
        float yy = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTick - field_70554_ao);
        float zz = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTick - field_70555_ap);
        GlStateManager.func_179109_b((float)xx, (float)yy, (float)zz);
        float rotYaw = this.prevYaw + (this.rotYaw - this.prevYaw) * partialTick;
        float rotPitch = this.prevPitch + (this.rotPitch - this.prevPitch) * partialTick;
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(180.0f + rotYaw), (float)0.0f, (float)0.0f, (float)-1.0f);
        GlStateManager.func_179114_b((float)rotPitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)rot, (float)0.0f, (float)1.0f, (float)0.0f);
        double xMinStart = -0.15 * (double)size;
        double xMaxStart = 0.15 * (double)size;
        double xMinEnd = -0.15 * (double)size * 1.0;
        double xMaxEnd = 0.15 * (double)size * 1.0;
        double yMax = this.length * size;
        double uMin = 0.0;
        double uMax = 1.0;
        Tessellator tessellator = Tessellator.func_178181_a();
        for (int t = 0; t < 3; ++t) {
            double vMin = -1.0f + vOffset + (float)t / 3.0f;
            double vMax = vMin + (double)(this.length * size);
            GlStateManager.func_179114_b((float)60.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
            vertexBuffer.func_181662_b(xMinEnd, yMax, 0.0).func_187315_a(1.0, vMax).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
            vertexBuffer.func_181662_b(xMinStart, 0.0, 0.0).func_187315_a(1.0, vMin).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
            vertexBuffer.func_181662_b(xMaxStart, 0.0, 0.0).func_187315_a(0.0, vMin).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
            vertexBuffer.func_181662_b(xMaxEnd, yMax, 0.0).func_187315_a(0.0, vMax).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
            tessellator.func_78381_a();
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179084_k();
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
        this.prevSize = size;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("textures/particle/particles.png"));
    }

    public int func_70537_b() {
        return 3;
    }
}

