/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.render;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.data.EnumDisplayAlignment;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderCommons {
    private static final Minecraft minecraft = Minecraft.func_71410_x();
    private static final int TEXT_BORDER = 2;
    private static final float SCALE_UV = 0.00390625f;

    protected static int colorGradient(float gradient, int start, int end) {
        return Math.max(0, Math.min(255, start + Math.round(gradient * (float)(end - start))));
    }

    protected static void drawTexturedModalRect(int x, int y, int u, int v, int sizeX, int sizeY, int zLevel) {
        RenderCommons.drawTexturedModalRect(x, y, u, v, sizeX, sizeY, zLevel, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected static void drawTexturedModalRect(int x, int y, int u, int v, int sizeX, int sizeY, int zLevel, float red, float green, float blue, float alpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        vertexBuffer.func_181662_b((double)x, (double)(y + sizeY), (double)zLevel).func_187315_a((double)(0.00390625f * (float)u), (double)(0.00390625f * (float)(v + sizeY))).func_181666_a(red, green, blue, alpha).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + sizeX), (double)(y + sizeY), (double)zLevel).func_187315_a((double)(0.00390625f * (float)(u + sizeX)), (double)(0.00390625f * (float)(v + sizeY))).func_181666_a(red, green, blue, alpha).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + sizeX), (double)y, (double)zLevel).func_187315_a((double)(0.00390625f * (float)(u + sizeX)), (double)(0.00390625f * (float)v)).func_181666_a(red, green, blue, alpha).func_181675_d();
        vertexBuffer.func_181662_b((double)x, (double)y, (double)zLevel).func_187315_a((double)(0.00390625f * (float)u), (double)(0.00390625f * (float)v)).func_181666_a(red, green, blue, alpha).func_181675_d();
        tessellator.func_78381_a();
    }

    public static int drawSplashAlarm(int scaledWidth, int scaledHeight, String title, String message) {
        double cycle = (double)(System.nanoTime() / 1000L % 0x200000L) / 2097152.0;
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)0.0f);
        int y = scaledHeight / 10;
        String textTitle = Commons.updateEscapeCodes("\u00c2\u00a7l" + new TextComponentTranslation(title, new Object[0]).func_150254_d());
        RenderCommons.minecraft.field_71466_p.func_175065_a(textTitle, (float)scaledWidth / 4.0f - (float)RenderCommons.minecraft.field_71466_p.func_78256_a(textTitle) / 2.0f, (float)(y - RenderCommons.minecraft.field_71466_p.field_78288_b), Commons.colorARGBtoInt(230, 255, 32, 24), true);
        String textMessage = Commons.updateEscapeCodes(new TextComponentTranslation(message, new Object[0]).func_150254_d());
        int alpha = 160 + (int)(85.0 * Math.sin(cycle * 2.0 * Math.PI));
        List listMessages = RenderCommons.minecraft.field_71466_p.func_78271_c(textMessage, scaledWidth / 2);
        for (String textLine : listMessages) {
            RenderCommons.minecraft.field_71466_p.func_175065_a(textLine, (float)scaledWidth / 4.0f - (float)RenderCommons.minecraft.field_71466_p.func_78256_a(textLine) / 2.0f, (float)y, Commons.colorARGBtoInt(alpha, 192, 64, 48), false);
            y += RenderCommons.minecraft.field_71466_p.field_78288_b;
        }
        GlStateManager.func_179121_F();
        return alpha;
    }

    public static void drawText(int screen_width, int screen_height, String text, float scale, String formatPrefix, int colorBackground, int colorText, boolean hasShadow, EnumDisplayAlignment enumScreenAnchor, int xOffset, int yOffset, EnumDisplayAlignment enumTextAlignment, float widthTextRatio, int widthTextMin) {
        String text_formatted = Commons.updateEscapeCodes(formatPrefix + new TextComponentTranslation(text, new Object[0]).func_150254_d());
        int scaled_box_width = Math.max(widthTextMin, Math.round(widthTextRatio * (float)screen_width)) + 4;
        List listLines = RenderCommons.minecraft.field_71466_p.func_78271_c(text_formatted, scaled_box_width - 4);
        int scaled_box_height = listLines.size() * RenderCommons.minecraft.field_71466_p.field_78288_b + 4;
        int screen_text_x = Math.round((float)screen_width * enumScreenAnchor.xRatio + (float)xOffset - enumTextAlignment.xRatio * (float)scaled_box_width * scale);
        int screen_text_y = Math.round((float)screen_height * enumScreenAnchor.yRatio + (float)yOffset - enumTextAlignment.yRatio * (float)scaled_box_height * scale);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)0.0f);
        int scaled_box_x = Math.round((float)screen_text_x / scale - 2.0f);
        int scaled_box_y = Math.round((float)screen_text_y / scale - 2.0f);
        int scaled_text_x = Math.round((float)screen_text_x / scale);
        int scaled_text_y = Math.round((float)screen_text_y / scale);
        GlStateManager.func_179090_x();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        float red = (float)(colorBackground >> 16 & 0xFF) / 255.0f;
        float blue = (float)(colorBackground >> 8 & 0xFF) / 255.0f;
        float green = (float)(colorBackground & 0xFF) / 255.0f;
        float alpha = (float)(colorBackground >> 24 & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexBuffer.func_181662_b((double)scaled_box_x, (double)(scaled_box_y + scaled_box_height), -90.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        vertexBuffer.func_181662_b((double)(scaled_box_x + scaled_box_width), (double)(scaled_box_y + scaled_box_height), -90.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        vertexBuffer.func_181662_b((double)(scaled_box_x + scaled_box_width), (double)scaled_box_y, -90.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        vertexBuffer.func_181662_b((double)scaled_box_x, (double)scaled_box_y, -90.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        for (String textLine : listLines) {
            RenderCommons.minecraft.field_71466_p.func_175065_a(textLine, (float)scaled_text_x, (float)scaled_text_y, colorText, hasShadow);
            scaled_text_y += RenderCommons.minecraft.field_71466_p.field_78288_b;
        }
        GlStateManager.func_179121_F();
    }

    public static void drawText(int screen_width, int screen_height, String textHeader, String textContent, float scale, String prefixHeader, int colorBackground, int colorText, boolean hasHeaderShadow, @Nonnull EnumDisplayAlignment enumScreenAnchor, int xOffset, int yOffset, @Nonnull EnumDisplayAlignment enumTextAlignment, float widthTextRatio, int widthTextMin) {
        String header_formatted = Commons.updateEscapeCodes(prefixHeader + new TextComponentTranslation(textHeader, new Object[0]).func_150254_d());
        String content_formatted = Commons.updateEscapeCodes(new TextComponentTranslation(textContent, new Object[0]).func_150254_d());
        int scaled_box_width = Math.max(widthTextMin, Math.round(widthTextRatio * (float)screen_width)) + 4;
        ArrayList listHeaderLines = header_formatted.isEmpty() ? new ArrayList(0) : RenderCommons.minecraft.field_71466_p.func_78271_c(header_formatted, scaled_box_width - 4);
        ArrayList listContentLines = content_formatted.isEmpty() ? new ArrayList(0) : RenderCommons.minecraft.field_71466_p.func_78271_c(content_formatted, scaled_box_width - 4);
        boolean hasTileAndContent = listHeaderLines.size() > 0 && listContentLines.size() > 0;
        int scaled_box_height = (listHeaderLines.size() + listContentLines.size()) * RenderCommons.minecraft.field_71466_p.field_78288_b + (hasTileAndContent ? 3 : 1) * 2;
        int screen_text_x = Math.round((float)screen_width * enumScreenAnchor.xRatio + (float)xOffset - enumTextAlignment.xRatio * (float)scaled_box_width * scale);
        int screen_text_y = Math.round((float)screen_height * enumScreenAnchor.yRatio + (float)yOffset - enumTextAlignment.yRatio * (float)scaled_box_height * scale);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)0.0f);
        int scaled_box_x = Math.round((float)screen_text_x / scale - 2.0f);
        int scaled_box_y = Math.round((float)screen_text_y / scale - 2.0f);
        int scaled_text_x = Math.round((float)screen_text_x / scale);
        int scaled_text_y = Math.round((float)screen_text_y / scale);
        GlStateManager.func_179090_x();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        float red = (float)(colorBackground >> 16 & 0xFF) / 255.0f;
        float green = (float)(colorBackground >> 8 & 0xFF) / 255.0f;
        float blue = (float)(colorBackground & 0xFF) / 255.0f;
        float alpha = (float)(colorBackground >> 24 & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexBuffer.func_181662_b((double)scaled_box_x, (double)(scaled_box_y + scaled_box_height), -90.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        vertexBuffer.func_181662_b((double)(scaled_box_x + scaled_box_width), (double)(scaled_box_y + scaled_box_height), -90.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        vertexBuffer.func_181662_b((double)(scaled_box_x + scaled_box_width), (double)scaled_box_y, -90.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        vertexBuffer.func_181662_b((double)scaled_box_x, (double)scaled_box_y, -90.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        for (String textLine : listHeaderLines) {
            RenderCommons.minecraft.field_71466_p.func_175065_a(textLine, (float)scaled_text_x, (float)scaled_text_y, colorText, hasHeaderShadow);
            scaled_text_y += RenderCommons.minecraft.field_71466_p.field_78288_b;
        }
        if (hasTileAndContent) {
            scaled_text_y += 2;
        }
        for (String textLine : listContentLines) {
            RenderCommons.minecraft.field_71466_p.func_175065_a(textLine, (float)scaled_text_x, (float)scaled_text_y, colorText, false);
            scaled_text_y += RenderCommons.minecraft.field_71466_p.field_78288_b;
        }
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179121_F();
    }

    public static IModel getModel(ResourceLocation resourceLocation) {
        IModel model;
        try {
            model = ModelLoaderRegistry.getModel((ResourceLocation)resourceLocation);
        }
        catch (Exception exception) {
            WarpDrive.logger.info(String.format("getModel %s", resourceLocation));
            throw new RuntimeException(exception);
        }
        return model;
    }

    public static void renderModelTESR(@Nonnull List<BakedQuad> quads, @Nonnull BufferBuilder renderer, int brightness) {
        int l1 = brightness >> 16 & 0xFFFF;
        int l2 = brightness & 0xFFFF;
        for (BakedQuad quad : quads) {
            int[] vData = quad.func_178209_a();
            VertexFormat format = quad.getFormat();
            int size = format.func_181719_f();
            int uv = format.func_177344_b(0) / 4;
            for (int i = 0; i < 4; ++i) {
                renderer.func_181662_b((double)Float.intBitsToFloat(vData[size * i]), (double)Float.intBitsToFloat(vData[size * i + 1]), (double)Float.intBitsToFloat(vData[size * i + 2])).func_181669_b(255, 255, 255, 255).func_187315_a((double)Float.intBitsToFloat(vData[size * i + uv]), (double)Float.intBitsToFloat(vData[size * i + uv + 1])).func_187314_a(l1, l2).func_181675_d();
            }
        }
    }
}

