/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.render;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnumCameraType;
import cr0s.warpdrive.render.ClientCameraHandler;
import cr0s.warpdrive.render.RenderCommons;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderOverlayCamera {
    private static final int ANIMATION_FRAMES = 200;
    private final Minecraft minecraft = Minecraft.func_71410_x();
    private int frameCount = 0;

    private void renderOverlay(int scaledWidth, int scaledHeight) {
        GlStateManager.func_179097_i();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179118_c();
        try {
            String strHelp;
            if (ClientCameraHandler.overlayType == EnumCameraType.SIMPLE_CAMERA) {
                this.minecraft.func_110434_K().func_110577_a(new ResourceLocation("warpdrive", "textures/blocks/detection/camera-overlay.png"));
                strHelp = "Left click to zoom / Right click to exit";
            } else {
                this.minecraft.func_110434_K().func_110577_a(new ResourceLocation("warpdrive", "textures/blocks/weapon/laser_camera-overlay.png"));
                strHelp = "Left click to zoom / Right click to exit / Space to fire";
            }
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexBuffer = tessellator.func_178180_c();
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            vertexBuffer.func_181662_b(0.0, (double)scaledHeight, -90.0).func_187315_a(0.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
            vertexBuffer.func_181662_b((double)scaledWidth, (double)scaledHeight, -90.0).func_187315_a(1.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
            vertexBuffer.func_181662_b((double)scaledWidth, 0.0, -90.0).func_187315_a(1.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
            vertexBuffer.func_181662_b(0.0, 0.0, -90.0).func_187315_a(0.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
            tessellator.func_78381_a();
            ++this.frameCount;
            if (this.frameCount >= 200) {
                this.frameCount = 0;
            }
            float time = Math.abs((float)this.frameCount * 2.0f / 200.0f - 1.0f);
            int color = (RenderCommons.colorGradient(time, 64, 160) << 16) + (RenderCommons.colorGradient(time, 128, 0) << 8) + RenderCommons.colorGradient(time, 128, 255);
            this.minecraft.field_71466_p.func_175065_a(strHelp, (float)((scaledWidth - this.minecraft.field_71466_p.func_78256_a(strHelp)) / 2), (float)((int)((double)scaledHeight * 0.19) - this.minecraft.field_71466_p.field_78288_b), color, true);
            String strZoom = "Zoom " + ClientCameraHandler.originalFOV / this.minecraft.field_71474_y.field_74334_X + "x";
            this.minecraft.field_71466_p.func_175065_a(strZoom, (float)((int)((double)scaledWidth * 0.91) - this.minecraft.field_71466_p.func_78256_a(strZoom)), (float)((int)((double)scaledHeight * 0.81)), 4235392, true);
            if (WarpDriveConfig.LOGGING_CAMERA) {
                this.minecraft.field_71466_p.func_175065_a(ClientCameraHandler.overlayLoggingMessage, (float)((scaledWidth - this.minecraft.field_71466_p.func_78256_a(ClientCameraHandler.overlayLoggingMessage)) / 2), (float)((int)((double)scaledHeight * 0.19)), 0xFF008F, true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(WarpDrive.printStreamError);
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
    }

    @SubscribeEvent
    public void onRender(RenderGameOverlayEvent.Pre event) {
        if (ClientCameraHandler.isOverlayEnabled) {
            switch (event.getType()) {
                case HELMET: {
                    this.renderOverlay(event.getResolution().func_78326_a(), event.getResolution().func_78328_b());
                    break;
                }
                case AIR: 
                case ARMOR: 
                case BOSSHEALTH: 
                case BOSSINFO: 
                case CROSSHAIRS: 
                case EXPERIENCE: 
                case FOOD: 
                case HEALTH: 
                case HEALTHMOUNT: 
                case HOTBAR: 
                case TEXT: {
                    if (!event.isCancelable()) break;
                    event.setCanceled(true);
                    break;
                }
            }
        }
    }
}

