/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.render;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CelestialObject;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.data.GlobalRegionManager;
import cr0s.warpdrive.data.Vector3;
import java.awt.Color;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.client.FMLClientHandler;

public class RenderSpaceSky
extends IRenderHandler {
    private static RenderSpaceSky INSTANCE;
    private static final double PLANET_FAR = 1786.0;
    private static final double PLANET_APPROACHING = 512.0;
    private static final double PLANET_ORBIT = 128.0;
    private static final double BOX_RENDER_RANGE = 100.0;
    private static final int callListRoot;
    private static final int callListStars;
    private static float starBrightness;
    private static final float ALPHA_TOLERANCE = 0.00390625f;
    private static final int callListUpperPlane;
    private static final int callListLowerPlane;

    public static RenderSpaceSky getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RenderSpaceSky();
        }
        return INSTANCE;
    }

    public void render(float partialTicks, @Nonnull WorldClient world, @Nonnull Minecraft mc) {
        Vec3d vec3Player = mc.field_71439_g.func_174824_e(partialTicks);
        CelestialObject celestialObject = world.field_73011_w == null ? null : CelestialObjectManager.get((World)world, (int)vec3Player.field_72450_a, (int)vec3Player.field_72449_c);
        Tessellator tessellator = Tessellator.func_178181_a();
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        if (celestialObject != null && celestialObject.boxTextures != null && celestialObject.boxTextures.length > 0) {
            RenderSpaceSky.renderSkyBox(tessellator, celestialObject.boxTextures, celestialObject.boxBrightness, celestialObject.boxRepeat);
        }
        float alphaBase = 1.0f;
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.func_179118_c();
        float starBrightness = 0.2f;
        if (world.field_73011_w != null) {
            starBrightness = world.func_72880_h(partialTicks);
        }
        if (starBrightness > 0.0f && celestialObject != null) {
            this.renderStars_cached(1.0f * starBrightness);
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179118_c();
        if (celestialObject != null && celestialObject.opacityCelestialObjects > 0.0f) {
            Vector3 vectorPlayer = GlobalRegionManager.getUniversalCoordinates(celestialObject, vec3Player.field_72450_a, vec3Player.field_72448_b, vec3Player.field_72449_c);
            for (CelestialObject celestialObjectChild : CelestialObjectManager.getRenderStack()) {
                if (celestialObject == celestialObjectChild || !celestialObject.id.equals(celestialObjectChild.parentId)) continue;
                RenderSpaceSky.renderCelestialObject(tessellator, celestialObjectChild, celestialObject.opacityCelestialObjects, vectorPlayer);
            }
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179127_m();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
    }

    private static void renderSkyBox(@Nonnull Tessellator tessellator, @Nonnull ResourceLocation[] textureSkyBox, float brightness, int countTextureRepeat) {
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        double maxUV = (double)countTextureRepeat * 1.0;
        GlStateManager.func_179106_n();
        GlStateManager.func_179118_c();
        GlStateManager.func_179098_w();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(textureSkyBox[0]);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b(-100.0, -100.0, -100.0).func_187315_a(0.0, 0.0).func_181666_a(brightness, brightness, brightness, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(-100.0, -100.0, 100.0).func_187315_a(0.0, maxUV).func_181666_a(brightness, brightness, brightness, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(100.0, -100.0, 100.0).func_187315_a(maxUV, maxUV).func_181666_a(brightness, brightness, brightness, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(100.0, -100.0, -100.0).func_187315_a(maxUV, 0.0).func_181666_a(brightness, brightness, brightness, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        if (textureSkyBox.length > 1) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(textureSkyBox[1]);
        }
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b(-100.0, 100.0, -100.0).func_187315_a(0.0, 0.0).func_181666_a(brightness, brightness, brightness, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(-100.0, -100.0, -100.0).func_187315_a(0.0, maxUV).func_181666_a(brightness, brightness, brightness, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(100.0, -100.0, -100.0).func_187315_a(maxUV, maxUV).func_181666_a(brightness, brightness, brightness, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(100.0, 100.0, -100.0).func_187315_a(maxUV, 0.0).func_181666_a(brightness, brightness, brightness, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        if (textureSkyBox.length > 1) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(textureSkyBox[2]);
        }
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b(100.0, 100.0, 100.0).func_187315_a(0.0, 0.0).func_181666_a(brightness, brightness, brightness, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(100.0, -100.0, 100.0).func_187315_a(0.0, maxUV).func_181666_a(brightness, brightness, brightness, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(-100.0, -100.0, 100.0).func_187315_a(maxUV, maxUV).func_181666_a(brightness, brightness, brightness, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(-100.0, 100.0, 100.0).func_187315_a(maxUV, 0.0).func_181666_a(brightness, brightness, brightness, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        if (textureSkyBox.length > 1) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(textureSkyBox[3]);
        }
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b(-100.0, 100.0, -100.0).func_187315_a(0.0, maxUV).func_181666_a(brightness, brightness, brightness, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(100.0, 100.0, -100.0).func_187315_a(maxUV, maxUV).func_181666_a(brightness, brightness, brightness, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(100.0, 100.0, 100.0).func_187315_a(maxUV, 0.0).func_181666_a(brightness, brightness, brightness, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(-100.0, 100.0, 100.0).func_187315_a(0.0, 0.0).func_181666_a(brightness, brightness, brightness, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        if (textureSkyBox.length > 1) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(textureSkyBox[4]);
        }
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b(100.0, 100.0, -100.0).func_187315_a(0.0, 0.0).func_181666_a(brightness, brightness, brightness, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(100.0, -100.0, -100.0).func_187315_a(0.0, maxUV).func_181666_a(brightness, brightness, brightness, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(100.0, -100.0, 100.0).func_187315_a(maxUV, maxUV).func_181666_a(brightness, brightness, brightness, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(100.0, 100.0, 100.0).func_187315_a(maxUV, 0.0).func_181666_a(brightness, brightness, brightness, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        if (textureSkyBox.length > 1) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(textureSkyBox[5]);
        }
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b(-100.0, 100.0, 100.0).func_187315_a(0.0, 0.0).func_181666_a(brightness, brightness, brightness, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(-100.0, -100.0, 100.0).func_187315_a(0.0, maxUV).func_181666_a(brightness, brightness, brightness, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(-100.0, -100.0, -100.0).func_187315_a(maxUV, maxUV).func_181666_a(brightness, brightness, brightness, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(-100.0, 100.0, -100.0).func_187315_a(maxUV, 0.0).func_181666_a(brightness, brightness, brightness, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
    }

    private static void renderStar(@Nonnull Tessellator tessellator, @Nonnull ResourceLocation texture, float brightness, float red, float green, float blue, float alpha) {
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        double starScale = 40.0;
        double starRange = 150.0;
        float celestialAngle_rad = 0.3f;
        float redActual = red * brightness;
        float greenActual = green * brightness;
        float blueActual = blue * brightness;
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)108.00001f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179090_x();
        vertexBuffer.func_181668_a(6, DefaultVertexFormats.field_181706_f);
        vertexBuffer.func_181662_b(0.0, 100.0, 0.0).func_181666_a(redActual, greenActual, blueActual, alpha * 2.0f / brightness).func_181675_d();
        double size = 45.0;
        vertexBuffer.func_181662_b(-size, 150.0, -size).func_181666_a(redActual, greenActual, blueActual, 0.01f).func_181675_d();
        vertexBuffer.func_181662_b(0.0, 150.0, -size * 1.5).func_181666_a(redActual, greenActual, blueActual, 0.01f).func_181675_d();
        vertexBuffer.func_181662_b(size, 150.0, -size).func_181666_a(redActual, greenActual, blueActual, 0.01f).func_181675_d();
        vertexBuffer.func_181662_b(size * 1.5, 150.0, 0.0).func_181666_a(redActual, greenActual, blueActual, 0.01f).func_181675_d();
        vertexBuffer.func_181662_b(size, 150.0, size).func_181666_a(redActual, greenActual, blueActual, 0.01f).func_181675_d();
        vertexBuffer.func_181662_b(0.0, 150.0, size * 1.5).func_181666_a(redActual, greenActual, blueActual, 0.01f).func_181675_d();
        vertexBuffer.func_181662_b(-size, 150.0, size).func_181666_a(redActual, greenActual, blueActual, 0.01f).func_181675_d();
        vertexBuffer.func_181662_b(-size * 1.5, 150.0, 0.0).func_181666_a(redActual, greenActual, blueActual, 0.01f).func_181675_d();
        vertexBuffer.func_181662_b(-size, 150.0, -size).func_181666_a(redActual, greenActual, blueActual, 0.01f).func_181675_d();
        tessellator.func_78381_a();
        vertexBuffer.func_181668_a(6, DefaultVertexFormats.field_181706_f);
        vertexBuffer.func_181662_b(0.0, 100.0, 0.0).func_181666_a(redActual, greenActual, blueActual, alpha * brightness).func_181675_d();
        size = 50.0;
        vertexBuffer.func_181662_b(-size, 150.0, -size).func_181666_a(redActual, greenActual, blueActual, 0.01f).func_181675_d();
        vertexBuffer.func_181662_b(0.0, 150.0, -size * 1.5).func_181666_a(redActual, greenActual, blueActual, 0.01f).func_181675_d();
        vertexBuffer.func_181662_b(size, 150.0, -size).func_181666_a(redActual, greenActual, blueActual, 0.01f).func_181675_d();
        vertexBuffer.func_181662_b(size * 1.5, 150.0, 0.0).func_181666_a(redActual, greenActual, blueActual, 0.01f).func_181675_d();
        vertexBuffer.func_181662_b(size, 150.0, size).func_181666_a(redActual, greenActual, blueActual, 0.01f).func_181675_d();
        vertexBuffer.func_181662_b(0.0, 150.0, size * 1.5).func_181666_a(redActual, greenActual, blueActual, 0.01f).func_181675_d();
        vertexBuffer.func_181662_b(-size, 150.0, size).func_181666_a(redActual, greenActual, blueActual, 0.01f).func_181675_d();
        vertexBuffer.func_181662_b(-size * 1.5, 150.0, 0.0).func_181666_a(redActual, greenActual, blueActual, 0.01f).func_181675_d();
        vertexBuffer.func_181662_b(-size, 150.0, -size).func_181666_a(redActual, greenActual, blueActual, 0.01f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179118_c();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        vertexBuffer.func_181662_b(-40.0, 150.0, -40.0).func_187315_a(0.0, 0.0).func_181666_a(redActual, greenActual, blueActual, alpha).func_181675_d();
        vertexBuffer.func_181662_b(40.0, 150.0, -40.0).func_187315_a(1.0, 0.0).func_181666_a(redActual, greenActual, blueActual, alpha).func_181675_d();
        vertexBuffer.func_181662_b(40.0, 150.0, 40.0).func_187315_a(1.0, 1.0).func_181666_a(redActual, greenActual, blueActual, alpha).func_181675_d();
        vertexBuffer.func_181662_b(-40.0, 150.0, 40.0).func_187315_a(0.0, 1.0).func_181666_a(redActual, greenActual, blueActual, alpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }

    private static void renderCelestialObject(Tessellator tessellator, CelestialObject celestialObject, float alphaSky, Vector3 vectorPlayer) {
        double distanceToBorder;
        Vector3 vectorCenter = GlobalRegionManager.getUniversalCoordinates(celestialObject, celestialObject.dimensionCenterX, 64.0, celestialObject.dimensionCenterZ);
        Vector3 vectorBorderPos = GlobalRegionManager.getUniversalCoordinates(celestialObject, celestialObject.dimensionCenterX + celestialObject.borderRadiusX, 64.0, celestialObject.dimensionCenterZ + celestialObject.borderRadiusZ);
        if (vectorCenter == null || vectorBorderPos == null) {
            return;
        }
        double borderRadiusX = vectorBorderPos.x - vectorCenter.x;
        double borderRadiusZ = vectorBorderPos.z - vectorCenter.z;
        double dx = Math.abs(vectorPlayer.x - vectorCenter.x) - borderRadiusX;
        double dz = Math.abs(vectorPlayer.z - vectorCenter.z) - borderRadiusZ;
        if (dx <= 0.0 && dz <= 0.0) {
            distanceToBorder = 0.0;
        } else {
            double dxOutside = Math.max(0.0, dx);
            double dzOutside = Math.max(0.0, dz);
            distanceToBorder = Math.sqrt(dxOutside * dxOutside + dzOutside * dzOutside);
        }
        double distanceToCenterX = vectorCenter.x - vectorPlayer.x;
        double distanceToCenterZ = vectorCenter.z - vectorPlayer.z;
        double distanceToCenter = Math.sqrt(distanceToCenterX * distanceToCenterX + distanceToCenterZ * distanceToCenterZ);
        double transitionFar = (Math.max(512.0, Math.min(1786.0, distanceToBorder)) - 512.0) / 1274.0;
        double transitionApproaching = (Math.max(128.0, Math.min(512.0, distanceToBorder)) - 128.0) / 384.0;
        double transitionOrbit = Math.max(0.0, Math.min(128.0, distanceToBorder)) / 128.0;
        double offsetX = (1.0 - transitionOrbit) * (distanceToCenterX / borderRadiusX);
        double offsetZ = (1.0 - transitionOrbit) * (distanceToCenterZ / borderRadiusZ);
        double planetY_far = (double)(celestialObject.dimensionId + 99 - 50) * Math.log(distanceToCenter) / 1.0;
        double planetY = planetY_far * transitionApproaching;
        double renderRange = 9.0 + 0.5 * (distanceToCenter / Math.max(borderRadiusX, borderRadiusZ));
        double renderSize = 0.005 * Math.min(1000.0, Math.max(borderRadiusX, borderRadiusZ)) * (1.0 - transitionOrbit) + 2.5 * (transitionOrbit < 1.0 ? transitionOrbit : 1.0 - transitionApproaching) + 0.25 * (transitionApproaching < 1.0 ? transitionApproaching : 1.0 - transitionFar) + 0.1 * transitionFar;
        double angleH = Math.atan2(distanceToCenterX, distanceToCenterZ);
        double angleV_far = Math.atan2(distanceToCenter, planetY);
        double angleV = Math.PI * (1.0 - transitionOrbit) + angleV_far * transitionOrbit;
        double angleS = 0.15 * (double)celestialObject.dimensionId * transitionApproaching + angleH * (1.0 - transitionApproaching);
        if (WarpDriveConfig.LOGGING_RENDERING && celestialObject.dimensionId == 1 && Minecraft.func_71386_F() / 10L % 100L == 0L) {
            WarpDrive.logger.info(String.format("transition Far %.2f Approaching %.2f Orbit %.2f distanceToCenter %.3f %.3f offset %.3f %.3f angle H %.3f V_far %.3f V %.3f S %.3f", transitionFar, transitionApproaching, transitionOrbit, distanceToCenterX, distanceToCenterZ, offsetX, offsetZ, angleH, angleV_far, angleV, angleS));
        }
        double sinH = Math.sin(angleH);
        double cosH = Math.cos(angleH);
        double sinV = Math.sin(angleV);
        double cosV = Math.cos(angleV);
        double sinS = Math.sin(angleS);
        double cosS = Math.cos(angleS);
        GlStateManager.func_179094_E();
        double time = (double)Minecraft.func_71386_F() / 1000.0;
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        for (CelestialObject.RenderData renderData : celestialObject.setRenderData) {
            float offsetU = (float)(Math.signum(renderData.periodU) * (time / Math.abs(renderData.periodU) % 1.0));
            float offsetV = (float)(Math.signum(renderData.periodV) * (time / Math.abs(renderData.periodV) % 1.0));
            if (renderData.texture != null) {
                GlStateManager.func_179098_w();
                Minecraft.func_71410_x().func_110434_K().func_110577_a(renderData.resourceLocation);
                vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            } else {
                GlStateManager.func_179090_x();
                vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            }
            if (renderData.isAdditive) {
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            } else {
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            }
            for (int indexVertex = 0; indexVertex < 4; ++indexVertex) {
                double offset1 = (double)((indexVertex & 2) - 1) * renderSize;
                double offset2 = (double)((indexVertex + 1 & 2) - 1) * renderSize;
                double valV = offset1 * cosS - offset2 * sinS;
                double valH = offset2 * cosS + offset1 * sinS;
                double y = valV * sinV + renderRange * cosV;
                double valD = renderRange * sinV - valV * cosV;
                double x = valD * sinH - valH * cosH + renderSize * offsetX;
                double z = valH * sinH + valD * cosH + renderSize * offsetZ;
                vertexBuffer.func_181662_b(x, y, z);
                if (renderData.texture != null) {
                    vertexBuffer.func_187315_a((double)((float)((indexVertex & 2) / 2) + offsetU), (double)((float)((indexVertex + 1 & 2) / 2) + offsetV));
                }
                vertexBuffer.func_181666_a(renderData.red, renderData.green, renderData.blue, renderData.alpha * alphaSky).func_181675_d();
            }
            tessellator.func_78381_a();
            renderRange -= 0.25;
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179121_F();
    }

    private void renderStars_direct(float brightness) {
        Random rand = new Random(10842L);
        boolean hasMoreStars = rand.nextBoolean() || rand.nextBoolean();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        double renderRangeMax = 10.0;
        for (int indexStars = 0; indexStars < (hasMoreStars ? 20000 : 2000); ++indexStars) {
            double randomZ;
            double randomY;
            double randomX;
            double randomLength;
            while ((randomLength = (randomX = rand.nextDouble() * 2.0 - 1.0) * randomX + (randomY = rand.nextDouble() * 2.0 - 1.0) * randomY + (randomZ = rand.nextDouble() * 2.0 - 1.0) * randomZ) >= 1.0 || randomLength <= 0.9) {
            }
            double renderSize = (double)0.02f + (double)0.0025f * Math.log(1.1 - rand.nextDouble());
            randomLength = 1.0 / Math.sqrt(randomLength);
            double x0 = (randomX *= randomLength) * 10.0;
            double y0 = (randomY *= randomLength) * 10.0;
            double z0 = (randomZ *= randomLength) * 10.0;
            double angleH = Math.atan2(randomX, randomZ);
            double angleV = Math.atan2(Math.sqrt(randomX * randomX + randomZ * randomZ), randomY);
            double angleS = rand.nextDouble() * Math.PI * 2.0;
            int rgb = RenderSpaceSky.getStarColorRGB(rand);
            float fRed = brightness * (float)(rgb >> 16 & 0xFF) / 255.0f;
            float fGreen = brightness * (float)(rgb >> 8 & 0xFF) / 255.0f;
            float fBlue = brightness * (float)(rgb & 0xFF) / 255.0f;
            float fAlpha = 1.0f;
            double sinH = Math.sin(angleH);
            double cosH = Math.cos(angleH);
            double sinV = Math.sin(angleV);
            double cosV = Math.cos(angleV);
            double sinS = Math.sin(angleS);
            double cosS = Math.cos(angleS);
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            for (int indexVertex = 0; indexVertex < 4; ++indexVertex) {
                double valZero = 0.0;
                double offset1 = (double)((indexVertex & 2) - 1) * renderSize;
                double offset2 = (double)((indexVertex + 1 & 2) - 1) * renderSize;
                double valV = offset1 * cosS - offset2 * sinS;
                double valH = offset2 * cosS + offset1 * sinS;
                double y1 = valV * sinV + 0.0 * cosV;
                double valD = 0.0 * sinV - valV * cosV;
                double x1 = valD * sinH - valH * cosH;
                double z1 = valH * sinH + valD * cosH;
                vertexBuffer.func_181662_b(x0 + x1, y0 + y1, z0 + z1).func_181666_a(fRed, fGreen, fBlue, 1.0f).func_181675_d();
            }
            tessellator.func_78381_a();
        }
    }

    private void renderStars_cached(float brightness) {
        if (Math.abs(starBrightness - brightness) > 0.00390625f) {
            starBrightness = brightness;
            GlStateManager.func_179094_E();
            GlStateManager.func_187423_f((int)callListStars, (int)4864);
            this.renderStars_direct(brightness);
            GlStateManager.func_187415_K();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179148_o((int)callListStars);
    }

    private static int getStarColorRGB(@Nonnull Random rand) {
        float saturation;
        float hue;
        double colorType = rand.nextDouble();
        float brightness = 1.0f - 0.8f * rand.nextFloat();
        if (colorType <= 0.08) {
            hue = 0.48f + 0.08f * rand.nextFloat();
            saturation = 0.18f + 0.22f * rand.nextFloat();
        } else if (colorType <= 0.24) {
            hue = 0.126f + 0.04f * rand.nextFloat();
            saturation = 0.0f + 0.15f * rand.nextFloat();
            brightness *= 0.95f;
        } else if (colorType <= 0.45) {
            hue = 0.126f + 0.04f * rand.nextFloat();
            saturation = 0.15f + 0.15f * rand.nextFloat();
            brightness *= 0.9f;
        } else if (colorType <= 0.67) {
            hue = 0.126f + 0.04f * rand.nextFloat();
            saturation = 0.8f + 0.15f * rand.nextFloat();
            brightness = rand.nextInt(3) == 1 ? (brightness *= 0.9f) : (brightness *= 0.85f);
        } else if (colorType <= 0.92) {
            hue = 0.055f + 0.055f * rand.nextFloat();
            saturation = 0.85f + 0.15f * rand.nextFloat();
            brightness = rand.nextInt(3) == 1 ? (brightness *= 0.9f) : (brightness *= 0.8f);
        } else {
            hue = 0.95f + 0.05f * rand.nextFloat();
            if (rand.nextInt(3) == 1) {
                saturation = 0.8f + 0.2f * rand.nextFloat();
                brightness *= 0.95f;
            } else {
                saturation = 0.7f + 0.2f * rand.nextFloat();
                brightness *= 0.65f;
            }
        }
        return Color.HSBtoRGB(hue, saturation, brightness);
    }

    private static Vec3d getCustomSkyColor() {
        return new Vec3d(0.26796875, 0.1796875, 0.0);
    }

    public static float getSkyBrightness(float par1) {
        float var2 = FMLClientHandler.instance().getClient().field_71441_e.func_72826_c(par1);
        float var3 = 1.0f - (MathHelper.func_76126_a((float)(var2 * (float)Math.PI * 2.0f)) * 2.0f + 0.25f);
        if (var3 < 0.0f) {
            var3 = 0.0f;
        }
        if (var3 > 1.0f) {
            var3 = 1.0f;
        }
        return var3 * var3 * 1.0f;
    }

    static {
        int z;
        int x;
        INSTANCE = null;
        callListStars = callListRoot = GLAllocation.func_74526_a((int)3);
        starBrightness = 0.0f;
        callListUpperPlane = callListRoot + 1;
        callListLowerPlane = callListRoot + 2;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        GlStateManager.func_187423_f((int)callListUpperPlane, (int)4864);
        int stepSize = 64;
        int nbSteps = 6;
        float y = 16.0f;
        for (x = -384; x <= 384; x += 64) {
            for (z = -384; z <= 384; z += 64) {
                vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                vertexBuffer.func_181662_b((double)x, (double)y, (double)z).func_181666_a(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
                vertexBuffer.func_181662_b((double)(x + 64), (double)y, (double)z).func_181666_a(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
                vertexBuffer.func_181662_b((double)(x + 64), (double)y, (double)(z + 64)).func_181666_a(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
                vertexBuffer.func_181662_b((double)x, (double)y, (double)(z + 64)).func_181666_a(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
                tessellator.func_78381_a();
            }
        }
        GlStateManager.func_187415_K();
        GlStateManager.func_187423_f((int)callListLowerPlane, (int)4864);
        y = -16.0f;
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        for (x = -384; x <= 384; x += 64) {
            for (z = -384; z <= 384; z += 64) {
                vertexBuffer.func_181662_b((double)(x + 64), (double)y, (double)z).func_181666_a(0.3f, 0.3f, 0.3f, 1.0f).func_181675_d();
                vertexBuffer.func_181662_b((double)x, (double)y, (double)z).func_181666_a(0.3f, 0.3f, 0.3f, 1.0f).func_181675_d();
                vertexBuffer.func_181662_b((double)x, (double)y, (double)(z + 64)).func_181666_a(0.3f, 0.3f, 0.3f, 1.0f).func_181675_d();
                vertexBuffer.func_181662_b((double)(x + 64), (double)y, (double)(z + 64)).func_181666_a(0.3f, 0.3f, 0.3f, 1.0f).func_181675_d();
            }
        }
        tessellator.func_78381_a();
        GlStateManager.func_187415_K();
    }
}

