/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.world;

import cr0s.warpdrive.FastSetBlockState;
import cr0s.warpdrive.LocalProfiler;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.Filler;
import cr0s.warpdrive.config.GenericSet;
import cr0s.warpdrive.config.structures.OrbInstance;
import cr0s.warpdrive.data.JumpBlock;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class EntitySphereGen
extends Entity {
    public int xCoord;
    public int yCoord;
    public int zCoord;
    private int radius;
    private int gasColor;
    private static final int BLOCKS_PER_TICK = 5000;
    private static final int STATE_SAVING = 0;
    private static final int STATE_SETUP = 1;
    private static final int STATE_DELETE = 2;
    private static final int STATE_STOP = 3;
    private int state = 2;
    private int ticksDelay = 0;
    private int currentIndex = 0;
    private int pregenSize = 0;
    private ArrayList<JumpBlock> blocks;
    private ArrayList<Boolean> isSurfaces;
    private OrbInstance orbInstance;
    private boolean replace;

    public EntitySphereGen(World world) {
        super(world);
    }

    public EntitySphereGen(World world, int x, int y, int z, OrbInstance orbInstance, boolean replace) {
        super(world);
        this.xCoord = x;
        this.field_70165_t = x;
        this.yCoord = y;
        this.field_70163_u = y;
        this.zCoord = z;
        this.field_70161_v = z;
        this.orbInstance = orbInstance;
        this.gasColor = world.field_73012_v.nextInt(12);
        this.replace = replace;
        this.constructionFinalizer();
    }

    public void killEntity() {
        this.state = 3;
        int minY_clamped = Math.max(0, this.yCoord - this.radius);
        int maxY_clamped = Math.min(255, this.yCoord + this.radius);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int x = this.xCoord - this.radius; x <= this.xCoord + this.radius; ++x) {
            for (int z = this.zCoord - this.radius; z <= this.zCoord + this.radius; ++z) {
                for (int y = minY_clamped; y <= maxY_clamped; ++y) {
                    mutableBlockPos.func_181079_c(x, y, z);
                    IBlockState blockState = this.field_70170_p.func_180495_p((BlockPos)mutableBlockPos);
                    if (blockState.func_177230_c() == Blocks.field_150350_a) continue;
                    this.field_70170_p.func_184138_a((BlockPos)mutableBlockPos, blockState, blockState, 3);
                }
            }
        }
        this.field_70170_p.func_72900_e((Entity)this);
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.ticksDelay > 0) {
            --this.ticksDelay;
            return;
        }
        switch (this.state) {
            case 0: {
                this.tickScheduleBlocks();
                this.state = 1;
                break;
            }
            case 1: {
                if (this.currentIndex >= this.blocks.size() - 1) {
                    this.state = 2;
                    break;
                }
                this.tickPlaceBlocks();
                break;
            }
            case 2: {
                this.currentIndex = 0;
                this.killEntity();
                break;
            }
            default: {
                WarpDrive.logger.error(String.format("%s Invalid state %s. Killing entity...", new Object[]{this, this.state}));
                this.killEntity();
            }
        }
    }

    private void tickPlaceBlocks() {
        int blocksToMove = Math.min(5000, this.blocks.size() - this.currentIndex);
        LocalProfiler.start("[EntitySphereGen] Placing blocks from " + this.currentIndex + " to " + (this.currentIndex + blocksToMove) + "/" + this.blocks.size());
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int index = 0; index < blocksToMove && this.currentIndex < this.blocks.size(); ++index) {
            JumpBlock jumpBlock = this.blocks.get(this.currentIndex);
            mutableBlockPos.func_181079_c(jumpBlock.x, jumpBlock.y, jumpBlock.z);
            if (this.isSurfaces.get(this.currentIndex).booleanValue() && jumpBlock.x % 4 == 0 && jumpBlock.z % 4 == 0) {
                this.field_70170_p.func_180501_a((BlockPos)mutableBlockPos, jumpBlock.block.func_176203_a(jumpBlock.blockMeta), 2);
            } else {
                FastSetBlockState.setBlockStateNoLight(this.field_70170_p, (BlockPos)mutableBlockPos, jumpBlock.block.func_176203_a(jumpBlock.blockMeta), 2);
            }
            ++this.currentIndex;
        }
        LocalProfiler.stop();
    }

    private void tickScheduleBlocks() {
        LocalProfiler.start("[EntitySphereGen] Saving blocks, radius " + this.radius);
        double sqRadiusHigh = ((double)this.radius + 0.5) * ((double)this.radius + 0.5);
        double sqRadiusLow = ((double)this.radius - 0.5) * ((double)this.radius - 0.5);
        int ceilRadius = this.radius + 1;
        for (int x = 0; x <= ceilRadius; ++x) {
            double x2 = ((double)x + 0.5) * ((double)x + 0.5);
            for (int y = 0; y <= ceilRadius; ++y) {
                double x2y2 = x2 + ((double)y + 0.5) * ((double)y + 0.5);
                for (int z = 0; z <= ceilRadius; ++z) {
                    double dSqRange = x2y2 + ((double)z + 0.5) * ((double)z + 0.5);
                    if (dSqRange > sqRadiusHigh) continue;
                    boolean isSurface = dSqRange > sqRadiusLow;
                    int intSqRadius = (int)Math.round(dSqRange);
                    GenericSet<Filler> orbShell = this.orbInstance.getFillerSetFromSquareRange(intSqRadius);
                    this.addBlock(isSurface, new JumpBlock(orbShell.getRandomUnit(this.field_70146_Z), this.xCoord + x, this.yCoord - y, this.zCoord + z));
                    if (x != 0) {
                        this.addBlock(isSurface, new JumpBlock(orbShell.getRandomUnit(this.field_70146_Z), this.xCoord - x, this.yCoord - y, this.zCoord + z));
                    }
                    if (y != 0) {
                        this.addBlock(isSurface, new JumpBlock(orbShell.getRandomUnit(this.field_70146_Z), this.xCoord + x, this.yCoord + y, this.zCoord + z));
                        if (x != 0) {
                            this.addBlock(isSurface, new JumpBlock(orbShell.getRandomUnit(this.field_70146_Z), this.xCoord - x, this.yCoord + y, this.zCoord + z));
                        }
                    }
                    if (z == 0) continue;
                    this.addBlock(isSurface, new JumpBlock(orbShell.getRandomUnit(this.field_70146_Z), this.xCoord + x, this.yCoord - y, this.zCoord - z));
                    if (x != 0) {
                        this.addBlock(isSurface, new JumpBlock(orbShell.getRandomUnit(this.field_70146_Z), this.xCoord - x, this.yCoord - y, this.zCoord - z));
                    }
                    if (y == 0) continue;
                    this.addBlock(isSurface, new JumpBlock(orbShell.getRandomUnit(this.field_70146_Z), this.xCoord + x, this.yCoord + y, this.zCoord - z));
                    if (x == 0) continue;
                    this.addBlock(isSurface, new JumpBlock(orbShell.getRandomUnit(this.field_70146_Z), this.xCoord - x, this.yCoord + y, this.zCoord - z));
                }
            }
        }
        if (this.blocks != null && this.blocks.size() > this.pregenSize) {
            WarpDrive.logger.warn(String.format("[EntitySphereGen] Saved %s blocks (estimated to %d)", this.blocks.size(), this.pregenSize));
        }
        LocalProfiler.stop();
    }

    private void addBlock(boolean isSurface, JumpBlock jumpBlock) {
        if (this.blocks == null) {
            return;
        }
        if (this.field_70170_p.func_180495_p(new BlockPos(jumpBlock.x, jumpBlock.y, jumpBlock.z)).func_177230_c().func_149667_c((Block)Blocks.field_150355_j)) {
            if (this.field_70170_p.field_73012_v.nextInt(50) != 1) {
                jumpBlock.block = WarpDrive.blockGas;
                jumpBlock.blockMeta = this.gasColor;
            }
            this.blocks.add(jumpBlock);
            this.isSurfaces.add(isSurface);
            return;
        }
        if (!this.replace && !this.field_70170_p.func_175623_d(new BlockPos(jumpBlock.x, jumpBlock.y, jumpBlock.z))) {
            return;
        }
        this.blocks.add(jumpBlock);
        this.isSurfaces.add(isSurface);
    }

    protected void func_70088_a() {
        this.field_70145_X = true;
    }

    private void constructionFinalizer() {
        this.radius = this.orbInstance.getTotalThickness();
        this.pregenSize = (int)Math.ceil(4.1887902047863905 * Math.pow(this.radius + 1, 3.0));
        this.blocks = new ArrayList(this.pregenSize);
        this.isSurfaces = new ArrayList(this.pregenSize);
        this.state = 0;
        this.ticksDelay = this.field_70170_p.field_73012_v.nextInt(60);
    }

    public void func_70037_a(@Nonnull NBTTagCompound tagCompound) {
        this.xCoord = tagCompound.func_74762_e("warpdrive:xCoord");
        this.yCoord = tagCompound.func_74762_e("warpdrive:yCoord");
        this.zCoord = tagCompound.func_74762_e("warpdrive:zCoord");
        this.orbInstance = new OrbInstance(tagCompound.func_74775_l("warpdrive:orbInstance"));
        this.gasColor = tagCompound.func_74762_e("warpdrive:gasColor");
        this.replace = tagCompound.func_74767_n("warpdrive:replace");
        this.constructionFinalizer();
        WarpDrive.logger.info(String.format("%s Reloaded from NBT", new Object[]{this}));
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("warpdrive:xCoord", this.xCoord);
        tagCompound.func_74768_a("warpdrive:yCoord", this.yCoord);
        tagCompound.func_74768_a("warpdrive:zCoord", this.zCoord);
        tagCompound.func_74782_a("warpdrive:orbInstance", (NBTBase)this.orbInstance.writeToNBT(new NBTTagCompound()));
        tagCompound.func_74768_a("warpdrive:gasColor", this.gasColor);
        tagCompound.func_74757_a("warpdrive:replace", this.replace);
    }

    public void func_70080_a(double x, double y, double z, float yaw, float pitch) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    public boolean shouldRenderInPass(int pass) {
        return false;
    }
}

