/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.world;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.Filler;
import cr0s.warpdrive.config.GenericSet;
import cr0s.warpdrive.config.Loot;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.InventoryWrapper;
import cr0s.warpdrive.data.JumpBlock;
import cr0s.warpdrive.data.JumpShip;
import cr0s.warpdrive.data.Transformation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenStructure {
    private final boolean corrupted;
    private final Random rand;
    private final Filler fillerHullPlain;
    private final Filler fillerHullGlass;
    private final Filler fillerSolarPanel;
    private final Filler fillerWiring;
    private final Filler fillerPropulsion;
    private final Filler fillerComputerCore;
    private final Filler fillerComputerScreen;
    private final Filler fillerComputerKeyboard;
    private final Filler fillerComputerFloppy;

    public WorldGenStructure(boolean corrupted, Random rand) {
        this.corrupted = corrupted;
        this.rand = rand;
        GenericSet<Filler> fillerSetHull_plain = WarpDriveConfig.FillerManager.getRandomSetFromGroup(rand, "hull_plain");
        if (fillerSetHull_plain == null) {
            WarpDrive.logger.warn(String.format("No FillerSet found within group %s during world generation: check your configuration", "hull_plain"));
            this.fillerHullPlain = new Filler();
            this.fillerHullPlain.block = Blocks.field_150348_b;
            this.fillerHullGlass = new Filler();
            this.fillerHullGlass.block = Blocks.field_150359_w;
        } else {
            this.fillerHullPlain = fillerSetHull_plain.getRandomUnit(rand);
            this.fillerHullGlass = this.getGenericSetWithDefault(rand, "hull_glass:" + fillerSetHull_plain.func_176610_l(), Blocks.field_150359_w, 0);
        }
        GenericSet<Filler> fillerSetSolarPanel = WarpDriveConfig.FillerManager.getRandomSetFromGroup(rand, "ship_solarPanel");
        if (fillerSetSolarPanel == null) {
            WarpDrive.logger.warn(String.format("No FillerSet found within group %s during world generation: check your configuration", "ship_solarPanel"));
            this.fillerSolarPanel = new Filler();
            this.fillerSolarPanel.block = Blocks.field_150322_A;
            this.fillerWiring = new Filler();
            this.fillerWiring.block = Blocks.field_180407_aO;
        } else {
            this.fillerSolarPanel = fillerSetSolarPanel.getRandomUnit(rand);
            this.fillerWiring = this.getGenericSetWithDefault(rand, "ship_wiring:" + fillerSetSolarPanel.func_176610_l(), Blocks.field_180407_aO, 0);
        }
        String nameFillerComputer = "ship_computerCore";
        GenericSet<Filler> fillerSetComputerCore = WarpDriveConfig.FillerManager.getRandomSetFromGroup(rand, "ship_computerCore");
        if (fillerSetComputerCore == null) {
            WarpDrive.logger.warn(String.format("No FillerSet found within group %s during world generation: check your configuration", "ship_computerCore"));
            this.fillerComputerCore = new Filler();
            this.fillerComputerCore.block = Blocks.field_150340_R;
            this.fillerComputerScreen = new Filler();
            this.fillerComputerScreen.block = Blocks.field_150410_aZ;
            this.fillerComputerKeyboard = new Filler();
            this.fillerComputerKeyboard.block = Blocks.field_150472_an;
            this.fillerComputerFloppy = new Filler();
            this.fillerComputerFloppy.block = Blocks.field_150472_an;
        } else {
            this.fillerComputerCore = fillerSetComputerCore.getRandomUnit(rand);
            this.fillerComputerScreen = this.getGenericSetWithDefault(rand, "ship_computerScreen:" + fillerSetComputerCore.func_176610_l(), Blocks.field_150410_aZ, 0);
            this.fillerComputerKeyboard = this.getGenericSetWithDefault(rand, "ship_computerKeyboard:" + fillerSetComputerCore.func_176610_l(), Blocks.field_150472_an, 0);
            this.fillerComputerFloppy = this.getGenericSetWithDefault(rand, "ship_computerFloppy:" + fillerSetComputerCore.func_176610_l(), Blocks.field_150472_an, 0);
        }
        GenericSet<Filler> fillerSetPropulsion = WarpDriveConfig.FillerManager.getRandomSetFromGroup(rand, "ship_propulsion");
        if (fillerSetPropulsion == null) {
            WarpDrive.logger.warn(String.format("No FillerSet found within group %s during world generation: check your configuration", "ship_propulsion"));
            this.fillerPropulsion = new Filler();
            this.fillerPropulsion.block = Blocks.field_150364_r;
        } else {
            this.fillerPropulsion = fillerSetPropulsion.getRandomUnit(rand);
        }
    }

    private Filler getGenericSetWithDefault(Random rand, String nameFillerKeyboard, Block block, int metadata) {
        Filler result;
        GenericSet<Filler> fillerSetKeyboard = WarpDriveConfig.FillerManager.getGenericSet(nameFillerKeyboard);
        if (fillerSetKeyboard == null) {
            WarpDrive.logger.warn(String.format("No FillerSet found within group %s during world generation: check your configuration", nameFillerKeyboard));
            result = new Filler();
            result.block = block;
            result.metadata = metadata;
        } else {
            result = fillerSetKeyboard.getRandomUnit(rand);
        }
        return result;
    }

    public void setHullPlain(World world, int x, int y, int z) {
        if (this.corrupted && this.rand.nextInt(400) == 1) {
            world.func_72885_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 17.0f, false, true);
        } else if (this.corrupted && this.rand.nextInt(10) == 1) {
            world.func_180501_a(new BlockPos(x, y, z), Blocks.field_150350_a.func_176223_P(), 2);
        } else {
            this.fillerHullPlain.setBlock(world, new BlockPos(x, y, z));
        }
    }

    public void setHullGlass(World world, int x, int y, int z) {
        if (this.corrupted && this.rand.nextInt(5) == 1) {
            world.func_180501_a(new BlockPos(x, y, z), Blocks.field_150350_a.func_176223_P(), 2);
        } else {
            this.fillerHullGlass.setBlock(world, new BlockPos(x, y, z));
        }
    }

    public void setComputerCore(World world, int x, int y, int z) {
        if (this.corrupted && this.rand.nextInt(3) == 1) {
            world.func_180501_a(new BlockPos(x, y, z), Blocks.field_150350_a.func_176223_P(), 2);
        } else {
            this.fillerComputerCore.setBlock(world, new BlockPos(x, y, z));
            this.fillInventoryWithLoot(world, this.rand, x, y, z, "ship_computerCore");
        }
    }

    public void setComputerScreen(World world, int x, int y, int z) {
        if (this.corrupted && this.rand.nextInt(3) == 1) {
            world.func_180501_a(new BlockPos(x, y, z), Blocks.field_150350_a.func_176223_P(), 2);
        } else {
            this.fillerComputerScreen.setBlock(world, new BlockPos(x, y, z));
        }
    }

    public void setComputerKeyboard(World world, int x, int y, int z) {
        if (this.corrupted && this.rand.nextInt(3) == 1) {
            world.func_180501_a(new BlockPos(x, y, z), Blocks.field_150350_a.func_176223_P(), 2);
        } else {
            this.fillerComputerKeyboard.setBlock(world, new BlockPos(x, y, z));
        }
    }

    public void setComputerFloppy(World world, int x, int y, int z) {
        if (this.corrupted && this.rand.nextInt(3) == 1) {
            world.func_180501_a(new BlockPos(x, y, z), Blocks.field_150350_a.func_176223_P(), 2);
        } else {
            this.fillerComputerFloppy.setBlock(world, new BlockPos(x, y, z));
            this.fillInventoryWithLoot(world, this.rand, x, y, z, "ship_computerFloppy");
        }
    }

    public void setSolarPanel(World world, int x, int y, int z) {
        if (this.corrupted && this.rand.nextInt(3) == 1) {
            world.func_180501_a(new BlockPos(x, y, z), Blocks.field_150350_a.func_176223_P(), 2);
        } else {
            this.fillerSolarPanel.setBlock(world, new BlockPos(x, y, z));
        }
    }

    public void setWiring(World world, int x, int y, int z) {
        if (this.corrupted && this.rand.nextInt(3) == 1) {
            world.func_180501_a(new BlockPos(x, y, z), Blocks.field_150350_a.func_176223_P(), 2);
        } else {
            this.fillerWiring.setBlock(world, new BlockPos(x, y, z));
        }
    }

    public void setPropulsion(World world, int x, int y, int z) {
        this.fillerPropulsion.setBlock(world, new BlockPos(x, y, z));
    }

    public void fillInventoryWithLoot(World world, Random rand, int x, int y, int z, String group) {
        this.fillInventoryWithLoot(world, rand, new BlockPos(x, y, z), group, 0, 3, 4, 3);
    }

    public void fillInventoryWithLoot(World world, Random rand, BlockPos blockPos, String group, int quantityMin, int quantityRandom1, int quantityRandom2, int maxRetries) {
        TileEntity tileEntity = world.func_175625_s(blockPos);
        Object inventory = InventoryWrapper.getInventory(tileEntity, null);
        if (inventory == null) {
            WarpDrive.logger.warn(String.format("Unable to fill inventory with LootSet %s %s: %s has no inventory", group, Commons.format(world, blockPos), tileEntity));
            return;
        }
        if (tileEntity.func_145837_r()) {
            WarpDrive.logger.warn(String.format("Unable to fill inventory with LootSet %s %s: %s is Invalid", group, Commons.format(world, blockPos), tileEntity));
            return;
        }
        int size = InventoryWrapper.getSize(inventory);
        int countLoots = Math.min(quantityMin + rand.nextInt(quantityRandom1) + rand.nextInt(quantityRandom2), size);
        GenericSet<Loot> lootSet = WarpDriveConfig.LootManager.getRandomSetFromGroup(rand, group);
        if (lootSet == null) {
            WarpDrive.logger.warn(String.format("Unable to fill inventory with LootSet %s %s: no LootSet found with group %s, check your configuration", group, Commons.format(world, blockPos), group));
            return;
        }
        ArrayList<Integer> indexSlots = new ArrayList<Integer>(size);
        for (int indexSlot = 0; indexSlot < size; ++indexSlot) {
            ItemStack itemStack = InventoryWrapper.getStackInSlot(inventory, indexSlot);
            if (!itemStack.func_190926_b()) continue;
            indexSlots.add(indexSlot);
        }
        Collections.shuffle(indexSlots);
        for (int i = 0; i < countLoots; ++i) {
            boolean isAdded = false;
            for (int countLootRetries = 0; countLootRetries < maxRetries; ++countLootRetries) {
                ItemStack itemStackLoot = lootSet.getRandomUnit(rand).getItemStack(rand);
                Iterator iterator = indexSlots.iterator();
                while (iterator.hasNext()) {
                    Integer indexSlot = (Integer)iterator.next();
                    if (!InventoryWrapper.getStackInSlot(inventory, indexSlot).func_190926_b()) {
                        assert (false);
                        continue;
                    }
                    if (!InventoryWrapper.isItemValid(inventory, indexSlot, itemStackLoot)) continue;
                    iterator.remove();
                    isAdded = true;
                    try {
                        InventoryWrapper.insertItem(inventory, indexSlot, itemStackLoot);
                        if (!WarpDriveConfig.LOGGING_WORLD_GENERATION) break;
                        WarpDrive.logger.debug(String.format("Filling inventory with LootSet %s %s: loot %s from %s in slot %d of inventory %s", group, Commons.format(world, blockPos), Commons.format(itemStackLoot), lootSet.getFullName(), indexSlot, inventory));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(WarpDrive.printStreamError);
                        WarpDrive.logger.error(String.format("Exception while filling inventory with LootSet %s %s: loot %s from %s in slot %d of inventory %s reported %s", group, Commons.format(world, blockPos), Commons.format(itemStackLoot), lootSet.getFullName(), indexSlot, inventory, exception.getMessage()));
                    }
                    break;
                }
                if (isAdded || indexSlots.isEmpty()) break;
            }
            if (isAdded) continue;
            WarpDrive.logger.debug(String.format("Unable to find a valid loot from LootSet %s for inventory %s in %s: check your configuration", lootSet.getFullName(), inventory, Commons.format(world, blockPos)));
        }
    }

    public void generateFromFile(World world, String filename, int targetX, int targetY, int targetZ, byte rotationSteps) {
        WarpDriveText reason = new WarpDriveText();
        JumpShip jumpShip = JumpShip.createFromFile(filename, reason);
        if (jumpShip == null) {
            WarpDrive.logger.error(String.format("%s Failed to read schematic %s: %s", this, filename, reason.toString()));
            return;
        }
        this.deployShip(world, jumpShip, targetX, targetY, targetZ, rotationSteps);
    }

    public void deployShip(World world, JumpShip jumpShip, int targetX, int targetY, int targetZ, byte rotationSteps) {
        Transformation transformation = new Transformation(jumpShip, world, targetX - jumpShip.core.func_177958_n(), targetY - jumpShip.core.func_177956_o(), targetZ - jumpShip.core.func_177952_p(), rotationSteps);
        for (int index = 0; index < jumpShip.jumpBlocks.length; ++index) {
            BlockPos targetLocation;
            Block blockAtTarget;
            JumpBlock jumpBlock = jumpShip.jumpBlocks[index];
            if (jumpBlock == null) {
                if (!WarpDriveConfig.LOGGING_BUILDING) continue;
                WarpDrive.logger.info(String.format("At index %d, skipping undefined block", index));
                continue;
            }
            if (jumpBlock.block == Blocks.field_150350_a) {
                if (!WarpDriveConfig.LOGGING_BUILDING) continue;
                WarpDrive.logger.info(String.format("At index %d, skipping air block", index));
                continue;
            }
            if (Dictionary.BLOCKS_ANCHOR.contains(jumpBlock.block)) {
                if (!WarpDriveConfig.LOGGING_BUILDING) continue;
                WarpDrive.logger.info(String.format("At index %d, skipping anchor block %s", index, jumpBlock.block));
                continue;
            }
            ++index;
            if (WarpDriveConfig.LOGGING_WORLD_GENERATION && WarpDrive.isDev) {
                WarpDrive.logger.info(String.format("At index %d, deploying %s ", index, jumpBlock));
            }
            if ((blockAtTarget = world.func_180495_p(targetLocation = transformation.apply(jumpBlock.x, jumpBlock.y, jumpBlock.z)).func_177230_c()) == Blocks.field_150350_a || Dictionary.BLOCKS_EXPANDABLE.contains(blockAtTarget)) {
                jumpBlock.deploy(null, world, transformation);
                continue;
            }
            if (!WarpDriveConfig.LOGGING_WORLD_GENERATION || !WarpDrive.isDev) continue;
            WarpDrive.logger.info(String.format("Deployment collision detected %s with %s during world generation, skipping this block...", Commons.format(world, targetX + jumpBlock.x, targetY + jumpBlock.y, targetZ + jumpBlock.z), blockAtTarget.getRegistryName()));
        }
    }
}

