/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IAirContainerItem;
import cr0s.warpdrive.api.IBreathingHelmet;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.StateAir;
import cr0s.warpdrive.data.VectorI;
import cr0s.warpdrive.event.ChunkHandler;
import cr0s.warpdrive.item.ItemEnergyWrapper;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class BreathingManager {
    private static final int AIR_BLOCK_TICKS = 20;
    private static final int AIR_DROWN_TICKS = 20;
    private static final int AIR_FIRST_BREATH_TICKS = 300;
    private static final int AIR_IC2_COMPRESSED_AIR_TICKS = 300;
    private static final int AIR_ENERGY_FOR_ELECTROLYSE = 2000;
    private static final VectorI[] vAirOffsets = new VectorI[]{new VectorI(0, 0, 0), new VectorI(0, 1, 0), new VectorI(0, 1, 1), new VectorI(0, 1, -1), new VectorI(1, 1, 0), new VectorI(1, 1, 0), new VectorI(0, 0, 1), new VectorI(0, 0, -1), new VectorI(1, 0, 0), new VectorI(1, 0, 0)};
    private static final HashMap<UUID, Integer> entity_airBlock = new HashMap();
    private static final HashMap<UUID, Integer> player_airTank = new HashMap();

    public static boolean hasAirBlock(EntityLivingBase entityLivingBase, int x, int y, int z) {
        for (VectorI vOffset : vAirOffsets) {
            VectorI vPosition = new VectorI(x + vOffset.x, y + vOffset.y, z + vOffset.z);
            Block block = entityLivingBase.field_70170_p.func_147439_a(vPosition.x, vPosition.y, vPosition.z);
            if (!BreathingManager.isAirBlock(block)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAirBlock(Block block) {
        return block == WarpDrive.blockAir || block == WarpDrive.blockAirSource || block == WarpDrive.blockAirFlow;
    }

    public static boolean onLivingJoinEvent(EntityLivingBase entityLivingBase, int x, int y, int z) {
        String idEntity = EntityList.func_75621_b((Entity)entityLivingBase);
        if (Dictionary.ENTITIES_LIVING_WITHOUT_AIR.contains(idEntity)) {
            return true;
        }
        if (BreathingManager.hasAirBlock(entityLivingBase, x, y, z)) {
            return true;
        }
        if (BreathingManager.hasValidSetup(entityLivingBase)) {
            return true;
        }
        if (WarpDriveConfig.LOGGING_BREATHING) {
            WarpDrive.logger.warn(String.format("Entity spawn denied @ %s (%d %d %d) entityId '%s'", entityLivingBase.field_70170_p.field_73011_w.func_80007_l(), x, y, z, idEntity));
        }
        return false;
    }

    public static void onLivingUpdateEvent(EntityLivingBase entityLivingBase, int x, int y, int z) {
        boolean notInVacuum;
        String idEntity = EntityList.func_75621_b((Entity)entityLivingBase);
        if (Dictionary.ENTITIES_LIVING_WITHOUT_AIR.contains(idEntity)) {
            return;
        }
        UUID uuidEntity = entityLivingBase.func_110124_au();
        VectorI vAirBlock = null;
        Block block = null;
        for (VectorI vOffset : vAirOffsets) {
            StateAir stateAir;
            VectorI vPosition = new VectorI(x + vOffset.x, y + vOffset.y, z + vOffset.z);
            block = entityLivingBase.field_70170_p.func_147439_a(vPosition.x, vPosition.y, vPosition.z);
            if (block == WarpDrive.blockAir || block == WarpDrive.blockAirSource || block == WarpDrive.blockAirFlow) {
                vAirBlock = vPosition;
                break;
            }
            if (block == Blocks.field_150350_a || (stateAir = ChunkHandler.getStateAir(entityLivingBase.field_70170_p, vPosition.x, vPosition.y, vPosition.z)) != null && stateAir.concentration <= 0) continue;
            vAirBlock = vPosition;
            break;
        }
        boolean bl = notInVacuum = vAirBlock != null;
        if (notInVacuum) {
            Integer air = entity_airBlock.get(uuidEntity);
            if (air == null) {
                entity_airBlock.put(uuidEntity, 20);
            } else if (air <= 1) {
                int metadata;
                entity_airBlock.put(uuidEntity, 20);
                if (block == WarpDrive.blockAir && (metadata = entityLivingBase.field_70170_p.func_72805_g(vAirBlock.x, vAirBlock.y, vAirBlock.z)) > 0 && metadata < 15) {
                    entityLivingBase.field_70170_p.func_72921_c(vAirBlock.x, vAirBlock.y, vAirBlock.z, metadata - 1, 2);
                }
            } else {
                entity_airBlock.put(uuidEntity, air - 1);
            }
        } else {
            Integer air = entity_airBlock.get(uuidEntity);
            if (air != null && air > 0) {
                entity_airBlock.put(uuidEntity, air - 1);
                return;
            }
            if (air == null) {
                entity_airBlock.put(uuidEntity, 300);
                return;
            }
            boolean hasValidSetup = BreathingManager.hasValidSetup(entityLivingBase);
            if (entityLivingBase instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)entityLivingBase;
                air = player_airTank.get(uuidEntity);
                boolean hasHelmet = hasValidSetup;
                if (hasValidSetup) {
                    if (air == null) {
                        player_airTank.put(uuidEntity, 300);
                    } else if (air <= 1) {
                        int ticksAir = BreathingManager.consumeAir((EntityLivingBase)player);
                        if (ticksAir > 0) {
                            player_airTank.put(uuidEntity, ticksAir);
                        } else {
                            hasHelmet = false;
                        }
                    } else {
                        player_airTank.put(uuidEntity, air - 1);
                    }
                }
                if (!hasHelmet) {
                    if (air == null) {
                        player_airTank.put(uuidEntity, 300);
                    } else if (air <= 1) {
                        player_airTank.put(uuidEntity, 20);
                        entityLivingBase.func_70097_a((DamageSource)WarpDrive.damageAsphyxia, 2.0f);
                    } else {
                        player_airTank.put(uuidEntity, air - 1);
                    }
                }
            } else if (hasValidSetup) {
                entity_airBlock.put(uuidEntity, 300);
            } else {
                entity_airBlock.put(uuidEntity, 0);
                entityLivingBase.func_70097_a((DamageSource)WarpDrive.damageAsphyxia, 2.0f);
            }
        }
    }

    private static int consumeAir(EntityLivingBase entityLivingBase) {
        Item itemChestplate;
        ItemStack itemStackChestplate;
        IAirContainerItem airContainerItem;
        int airAvailable;
        ItemStack itemStack;
        int slotIndex;
        if (WarpDriveConfig.LOGGING_BREATHING) {
            WarpDrive.logger.info("Checking inventory for air reserves...");
        }
        if (!(entityLivingBase instanceof EntityPlayerMP)) {
            return 0;
        }
        EntityPlayerMP entityPlayer = (EntityPlayerMP)entityLivingBase;
        ItemStack[] playerInventory = entityPlayer.field_71071_by.field_70462_a;
        int slotAirCanisterFound = -1;
        float fillingRatioAirCanisterFound = 0.0f;
        for (slotIndex = 0; slotIndex < playerInventory.length; ++slotIndex) {
            IAirContainerItem airContainerItem2;
            int airAvailable2;
            ItemStack itemStack2 = playerInventory[slotIndex];
            if (itemStack2 == null || !(itemStack2.func_77973_b() instanceof IAirContainerItem) || (airAvailable2 = (airContainerItem2 = (IAirContainerItem)itemStack2.func_77973_b()).getCurrentAirStorage(itemStack2)) <= 0) continue;
            float fillingRatio = (float)airAvailable2 / (float)airContainerItem2.getMaxAirStorage(itemStack2);
            fillingRatio -= (float)itemStack2.field_77994_a / 1000.0f;
            if (!(fillingRatioAirCanisterFound <= 0.0f) && !(fillingRatio < fillingRatioAirCanisterFound)) continue;
            slotAirCanisterFound = slotIndex;
            fillingRatioAirCanisterFound = fillingRatio;
        }
        if (slotAirCanisterFound >= 0 && (itemStack = playerInventory[slotAirCanisterFound]) != null && itemStack.func_77973_b() instanceof IAirContainerItem && (airAvailable = (airContainerItem = (IAirContainerItem)itemStack.func_77973_b()).getCurrentAirStorage(itemStack)) > 0) {
            if (itemStack.field_77994_a > 1) {
                --itemStack.field_77994_a;
                ItemStack itemStackToAdd = itemStack.func_77946_l();
                itemStackToAdd.field_77994_a = 1;
                if (!entityPlayer.field_71071_by.func_70441_a(itemStackToAdd = airContainerItem.consumeAir(itemStackToAdd))) {
                    EntityItem entityItem = new EntityItem(entityPlayer.field_70170_p, entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v, itemStackToAdd);
                    entityPlayer.field_70170_p.func_72838_d((Entity)entityItem);
                }
                entityPlayer.func_71120_a(entityPlayer.field_71069_bz);
            } else {
                ItemStack itemStackNew = airContainerItem.consumeAir(itemStack);
                if (itemStack != itemStackNew) {
                    playerInventory[slotAirCanisterFound] = itemStackNew;
                }
            }
            return airContainerItem.getAirTicksPerConsumption(itemStack);
        }
        if (WarpDriveConfig.IC2_compressedAir != null) {
            for (slotIndex = 0; slotIndex < playerInventory.length; ++slotIndex) {
                if (playerInventory[slotIndex] == null || !playerInventory[slotIndex].func_77969_a(WarpDriveConfig.IC2_compressedAir)) continue;
                --playerInventory[slotIndex].field_77994_a;
                if (playerInventory[slotIndex].field_77994_a <= 0) {
                    playerInventory[slotIndex] = null;
                }
                if (WarpDriveConfig.IC2_emptyCell != null) {
                    ItemStack emptyCell = new ItemStack(WarpDriveConfig.IC2_emptyCell.func_77973_b(), 1, 0);
                    if (!entityPlayer.field_71071_by.func_70441_a(emptyCell)) {
                        World world = entityPlayer.field_70170_p;
                        EntityItem entityItem = new EntityItem(world, entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v, emptyCell);
                        entityPlayer.field_70170_p.func_72838_d((Entity)entityItem);
                    }
                    entityPlayer.func_71120_a(entityPlayer.field_71069_bz);
                }
                return 300;
            }
        }
        if ((itemStackChestplate = entityLivingBase.func_71124_b(3)) != null && (itemChestplate = itemStackChestplate.func_77973_b()) == WarpDrive.itemWarpArmor[1]) {
            return BreathingManager.electrolyseIceToAir((Entity)entityLivingBase);
        }
        return 0;
    }

    public static boolean hasValidSetup(EntityLivingBase entityLivingBase) {
        ItemStack itemStackHelmet = entityLivingBase.func_71124_b(4);
        if (entityLivingBase instanceof EntityPlayer) {
            ItemStack itemStackChestplate = entityLivingBase.func_71124_b(3);
            ItemStack itemStackLeggings = entityLivingBase.func_71124_b(2);
            ItemStack itemStackBoots = entityLivingBase.func_71124_b(1);
            if (itemStackHelmet != null && itemStackChestplate != null && itemStackLeggings != null && itemStackBoots != null) {
                Item itemHelmet = itemStackHelmet.func_77973_b();
                return itemHelmet instanceof IBreathingHelmet && ((IBreathingHelmet)itemHelmet).canBreath(entityLivingBase) || Dictionary.ITEMS_BREATHING_HELMET.contains(itemHelmet);
            }
        } else if (itemStackHelmet != null) {
            Item itemHelmet = itemStackHelmet.func_77973_b();
            return itemHelmet instanceof IBreathingHelmet && ((IBreathingHelmet)itemHelmet).canBreath(entityLivingBase) || Dictionary.ITEMS_BREATHING_HELMET.contains(itemHelmet);
        }
        return false;
    }

    public static float getAirReserveRatio(EntityPlayer entityPlayer) {
        Item itemChestplate;
        ItemStack[] playerInventory = entityPlayer.field_71071_by.field_70462_a;
        boolean canElectrolyse = false;
        ItemStack itemStackChestplate = entityPlayer.func_82169_q(2);
        if (itemStackChestplate != null && (itemChestplate = itemStackChestplate.func_77973_b()) == WarpDrive.itemWarpArmor[1]) {
            canElectrolyse = true;
        }
        Item itemIce = Item.func_150898_a((Block)Blocks.field_150432_aD);
        int sumAirCapacityTicks = 0;
        int sumAirStoredTicks = 0;
        int countAirContainer = 0;
        int countIce = 0;
        int countEnergy = 0;
        ItemStack itemStackAirContainer = null;
        for (int slotIndex = 0; slotIndex < playerInventory.length; ++slotIndex) {
            ItemStack itemStack = playerInventory[slotIndex];
            if (itemStack == null) continue;
            if (itemStack.func_77973_b() instanceof IAirContainerItem) {
                ++countAirContainer;
                itemStackAirContainer = itemStack;
                IAirContainerItem airContainerItem = (IAirContainerItem)itemStack.func_77973_b();
                int airAvailable = airContainerItem.getCurrentAirStorage(itemStack);
                if (airAvailable > 0) {
                    sumAirStoredTicks += airAvailable * airContainerItem.getAirTicksPerConsumption(itemStack);
                }
                int airCapacity = airContainerItem.getMaxAirStorage(itemStack);
                sumAirCapacityTicks += airCapacity * airContainerItem.getAirTicksPerConsumption(itemStack);
                continue;
            }
            if (WarpDriveConfig.IC2_compressedAir != null && itemStack.func_77969_a(WarpDriveConfig.IC2_compressedAir)) {
                sumAirStoredTicks += 300;
                sumAirCapacityTicks += 300;
                continue;
            }
            if (WarpDriveConfig.IC2_emptyCell != null && itemStack.func_77969_a(WarpDriveConfig.IC2_emptyCell)) {
                sumAirCapacityTicks += 300;
                continue;
            }
            if (!canElectrolyse) continue;
            if (itemStack.func_77973_b() == itemIce) {
                countIce += itemStack.field_77994_a;
                continue;
            }
            if (!ItemEnergyWrapper.isEnergyContainer(itemStack) || !ItemEnergyWrapper.canOutput(itemStack) || ItemEnergyWrapper.getEnergyStored(itemStack) < 2000) continue;
            countEnergy = (int)((double)countEnergy + Math.floor(ItemEnergyWrapper.getEnergyStored(itemStack) / 2000));
        }
        if (countAirContainer >= 1 && countIce > 0 && countEnergy > 0 && itemStackAirContainer.func_77973_b() instanceof IAirContainerItem) {
            IAirContainerItem airContainerItem = (IAirContainerItem)itemStackAirContainer.func_77973_b();
            int sumElectrolyseTicks = Math.min(2, countAirContainer) * Math.min(countIce, countEnergy) * airContainerItem.getMaxAirStorage(itemStackAirContainer) * airContainerItem.getAirTicksPerConsumption(itemStackAirContainer);
            sumAirStoredTicks += sumElectrolyseTicks;
            sumAirCapacityTicks += sumElectrolyseTicks;
        }
        return sumAirCapacityTicks > 0 ? (float)sumAirStoredTicks / (float)sumAirCapacityTicks : 0.0f;
    }

    private static int electrolyseIceToAir(Entity entity) {
        if (WarpDriveConfig.LOGGING_BREATHING) {
            WarpDrive.logger.info("Checking inventory for ice electrolysing...");
        }
        if (!(entity instanceof EntityPlayerMP)) {
            return 0;
        }
        EntityPlayerMP entityPlayer = (EntityPlayerMP)entity;
        ItemStack[] playerInventory = entityPlayer.field_71071_by.field_70462_a;
        int slotIceFound = -1;
        int slotFirstEmptyAirCanisterFound = -1;
        int slotSecondEmptyAirCanisterFound = -1;
        int slotEnergyContainer = -1;
        Item itemIce = Item.func_150898_a((Block)Blocks.field_150432_aD);
        for (int slotIndex = 0; slotIndex < playerInventory.length; ++slotIndex) {
            ItemStack itemStack = playerInventory[slotIndex];
            if (itemStack == null || itemStack.field_77994_a <= 0) continue;
            if (itemStack.func_77973_b() == itemIce) {
                slotIceFound = slotIndex;
                continue;
            }
            if (itemStack.field_77994_a == 1 && itemStack.func_77973_b() instanceof IAirContainerItem) {
                IAirContainerItem airCanister = (IAirContainerItem)itemStack.func_77973_b();
                if (!airCanister.canContainAir(itemStack) || airCanister.getCurrentAirStorage(itemStack) < 0) continue;
                if (slotFirstEmptyAirCanisterFound < 0) {
                    slotFirstEmptyAirCanisterFound = slotIndex;
                    continue;
                }
                if (slotSecondEmptyAirCanisterFound >= 0) continue;
                slotSecondEmptyAirCanisterFound = slotIndex;
                if (slotIceFound < 0 || slotEnergyContainer < 0) continue;
                break;
            }
            if (slotEnergyContainer >= 0 || !ItemEnergyWrapper.isEnergyContainer(itemStack) || !ItemEnergyWrapper.canOutput(itemStack) || ItemEnergyWrapper.getEnergyStored(itemStack) < 2000) continue;
            slotEnergyContainer = slotIndex;
        }
        if (slotEnergyContainer >= 0 && slotIceFound >= 0 && slotFirstEmptyAirCanisterFound >= 0) {
            ItemStack itemStackEnergyContainer = playerInventory[slotEnergyContainer];
            if ((itemStackEnergyContainer = ItemEnergyWrapper.consume(itemStackEnergyContainer, 2000, false)) != null) {
                if (playerInventory[slotEnergyContainer].field_77994_a <= 1) {
                    playerInventory[slotEnergyContainer] = itemStackEnergyContainer;
                } else {
                    --playerInventory[slotEnergyContainer].field_77994_a;
                    if (!entityPlayer.field_71071_by.func_70441_a(itemStackEnergyContainer)) {
                        World world = entityPlayer.field_70170_p;
                        EntityItem entityItem = new EntityItem(world, entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v, itemStackEnergyContainer);
                        entityPlayer.field_70170_p.func_72838_d((Entity)entityItem);
                    }
                }
                ItemStack itemStackIce = playerInventory[slotIceFound];
                if (itemStackIce.field_77994_a > 1) {
                    --itemStackIce.field_77994_a;
                    playerInventory[slotIceFound] = itemStackIce;
                } else {
                    playerInventory[slotIceFound] = null;
                }
                ItemStack itemStackAirCanister = playerInventory[slotFirstEmptyAirCanisterFound];
                IAirContainerItem airCanister = (IAirContainerItem)itemStackAirCanister.func_77973_b();
                playerInventory[slotFirstEmptyAirCanisterFound] = airCanister.getFullAirContainer(itemStackAirCanister);
                if (slotSecondEmptyAirCanisterFound >= 0) {
                    itemStackAirCanister = playerInventory[slotSecondEmptyAirCanisterFound];
                    airCanister = (IAirContainerItem)itemStackAirCanister.func_77973_b();
                    playerInventory[slotSecondEmptyAirCanisterFound] = airCanister.getFullAirContainer(itemStackAirCanister);
                }
                entityPlayer.func_71120_a(entityPlayer.field_71069_bz);
                return airCanister.getAirTicksPerConsumption(itemStackAirCanister);
            }
        }
        return 0;
    }
}

