/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive;

import codechicken.nei.api.API;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.data.VectorI;
import cr0s.warpdrive.world.SpaceTeleporter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerSelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class Commons {
    private static final String CHAR_FORMATTING = "\u00a7";
    public static final ForgeDirection[] UP_DIRECTIONS = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST};
    public static final ForgeDirection[] HORIZONTAL_DIRECTIONS = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST};
    public static final ForgeDirection[] VERTICAL_DIRECTIONS = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN};
    private static final double BLOCK_REACH_DISTANCE = 5.0;
    private static HashMap<String, Fluid> fluidByBlockName;

    public static String updateEscapeCodes(String message) {
        return message.replace("\u00c2\u00a7", CHAR_FORMATTING).replace("\\n", "\n").replace("\u00a7r", "\u00a77").replaceAll("\u00a0", " ");
    }

    public static String removeFormatting(String message) {
        return Commons.updateEscapeCodes(message).replaceAll("(\u00a7.)", "");
    }

    private static boolean isFormatColor(char chr) {
        return chr >= '0' && chr <= '9' || chr >= 'a' && chr <= 'f' || chr >= 'A' && chr <= 'F';
    }

    private static boolean isFormatSpecial(char chr) {
        return chr >= 'k' && chr <= 'o' || chr >= 'K' && chr <= 'O' || chr == 'r' || chr == 'R';
    }

    private static String getFormatFromString(String message) {
        int indexLastChar = message.length() - 1;
        StringBuilder result = new StringBuilder();
        int indexEscapeCode = -1;
        while ((indexEscapeCode = message.indexOf(167, indexEscapeCode + 1)) != -1) {
            if (indexEscapeCode >= indexLastChar) continue;
            char chr = message.charAt(indexEscapeCode + 1);
            if (Commons.isFormatColor(chr)) {
                result = new StringBuilder(CHAR_FORMATTING + chr);
                continue;
            }
            if (!Commons.isFormatSpecial(chr)) continue;
            result.append(CHAR_FORMATTING).append(chr);
        }
        return result.toString();
    }

    public static void addChatMessage(ICommandSender commandSender, String message) {
        if (commandSender == null) {
            WarpDrive.logger.error("Unable to send message to NULL commandSender: " + message);
            return;
        }
        if (message.isEmpty()) {
            return;
        }
        String[] lines = Commons.updateEscapeCodes(message).split("\n");
        String format = "";
        for (String line : lines) {
            String formattedLine = format + line;
            commandSender.func_145747_a((IChatComponent)new ChatComponentText(formattedLine));
            format = Commons.getFormatFromString(formattedLine);
        }
    }

    public static void addTooltip(List<String> list, String tooltip) {
        String[] split;
        if (tooltip.isEmpty()) {
            return;
        }
        for (String line : split = Commons.updateEscapeCodes(tooltip).split("\n")) {
            boolean isExisting = false;
            for (String lineExisting : list) {
                if (!lineExisting.contains(line) && !line.contains(lineExisting)) continue;
                isExisting = true;
                break;
            }
            if (isExisting) continue;
            String lineRemaining = line;
            String formatNextLine = "";
            while (!lineRemaining.isEmpty()) {
                int indexToCut;
                int displayLength = 0;
                int length = lineRemaining.length();
                for (indexToCut = formatNextLine.length(); indexToCut < length && displayLength <= 38; ++indexToCut) {
                    if (lineRemaining.charAt(indexToCut) == '\u00a7' && indexToCut + 1 < length) {
                        ++indexToCut;
                        continue;
                    }
                    ++displayLength;
                }
                if (indexToCut < length) {
                    if ((indexToCut = lineRemaining.substring(0, indexToCut).lastIndexOf(32)) == -1 || indexToCut == 0) {
                        list.add(lineRemaining);
                        lineRemaining = "";
                        continue;
                    }
                    list.add(lineRemaining.substring(0, indexToCut).replaceAll("\u00a0", " "));
                    for (int index = formatNextLine.length(); index <= indexToCut; ++index) {
                        if (lineRemaining.charAt(index) != '\u00a7' || index + 1 >= indexToCut) continue;
                        formatNextLine = formatNextLine + CHAR_FORMATTING + lineRemaining.charAt(++index);
                    }
                    lineRemaining = formatNextLine + " " + lineRemaining.substring(indexToCut + 1);
                    continue;
                }
                list.add(lineRemaining.replaceAll("\u00a0", " "));
                lineRemaining = "";
            }
        }
    }

    public static Field getField(Class<?> clazz, String deobfuscatedName, String obfuscatedName) {
        Field fieldToReturn = null;
        try {
            fieldToReturn = clazz.getDeclaredField(deobfuscatedName);
        }
        catch (Exception exception1) {
            try {
                fieldToReturn = clazz.getDeclaredField(obfuscatedName);
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
                StringBuilder map = new StringBuilder();
                for (Field fieldDeclared : clazz.getDeclaredFields()) {
                    if (map.length() > 0) {
                        map.append(", ");
                    }
                    map.append(fieldDeclared.getName());
                }
                WarpDrive.logger.error(String.format("Unable to find %1$s field in %2$s class. Available fields are: %3$s", deobfuscatedName, clazz.toString(), map.toString()));
            }
        }
        if (fieldToReturn != null) {
            fieldToReturn.setAccessible(true);
        }
        return fieldToReturn;
    }

    public static String format(long value) {
        return String.format("%,d", Math.round(value));
    }

    public static String format(Object[] arguments) {
        StringBuilder result = new StringBuilder();
        if (arguments != null && arguments.length > 0) {
            for (Object argument : arguments) {
                if (result.length() > 0) {
                    result.append(", ");
                }
                if (argument instanceof String) {
                    result.append("\"").append(argument).append("\"");
                    continue;
                }
                result.append(argument);
            }
        }
        return result.toString();
    }

    public static String sanitizeFileName(String name) {
        return name.replace("/", "").replace(".", "").replace("\\", ".");
    }

    public static ItemStack copyWithSize(ItemStack itemStack, int newSize) {
        ItemStack ret = itemStack.func_77946_l();
        ret.field_77994_a = newSize;
        return ret;
    }

    public static Collection<IInventory> getConnectedInventories(TileEntity tileEntityConnection) {
        ArrayList<IInventory> result = new ArrayList<IInventory>(6);
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tileEntity = tileEntityConnection.func_145831_w().func_147438_o(tileEntityConnection.field_145851_c + side.offsetX, tileEntityConnection.field_145848_d + side.offsetY, tileEntityConnection.field_145849_e + side.offsetZ);
            if (!(tileEntity instanceof IInventory)) continue;
            result.add((IInventory)tileEntity);
            if (!(tileEntity instanceof TileEntityChest)) continue;
            TileEntityChest tileEntityChest = (TileEntityChest)tileEntity;
            tileEntityChest.func_145979_i();
            if (tileEntityChest.field_145991_k != null) {
                result.add((IInventory)tileEntityChest.field_145991_k);
                continue;
            }
            if (tileEntityChest.field_145990_j != null) {
                result.add((IInventory)tileEntityChest.field_145990_j);
                continue;
            }
            if (tileEntityChest.field_145992_i != null) {
                result.add((IInventory)tileEntityChest.field_145992_i);
                continue;
            }
            if (tileEntityChest.field_145988_l == null) continue;
            result.add((IInventory)tileEntityChest.field_145988_l);
        }
        return result;
    }

    public static Set<VectorI> getConnectedBlocks(World world, VectorI start, ForgeDirection[] directions, Set<Block> whitelist, int maxRange, VectorI ... ignore) {
        return Commons.getConnectedBlocks(world, Collections.singletonList(start), directions, whitelist, maxRange, ignore);
    }

    public static Set<VectorI> getConnectedBlocks(World world, Collection<VectorI> start, ForgeDirection[] directions, Set<Block> whitelist, int maxRange, VectorI ... ignore) {
        HashSet<VectorI> toIgnore = new HashSet<VectorI>();
        if (ignore != null) {
            toIgnore.addAll(Arrays.asList(ignore));
        }
        HashSet<VectorI> toIterate = new HashSet<VectorI>(start);
        HashSet<VectorI> iterated = new HashSet<VectorI>();
        for (int range = 0; !toIterate.isEmpty() && range < maxRange; ++range) {
            HashSet<VectorI> toIterateNext = new HashSet<VectorI>();
            for (VectorI current : toIterate) {
                if (whitelist.contains(current.getBlock_noChunkLoading((IBlockAccess)world))) {
                    iterated.add(current);
                }
                for (ForgeDirection direction : directions) {
                    VectorI next = current.clone(direction);
                    if (iterated.contains(next) || toIgnore.contains(next) || toIterate.contains(next) || toIterateNext.contains(next) || !whitelist.contains(next.getBlock_noChunkLoading((IBlockAccess)world))) continue;
                    toIterateNext.add(next);
                }
            }
            toIterate = toIterateNext;
        }
        return iterated;
    }

    public static int toInt(double d) {
        return (int)Math.round(d);
    }

    public static int toInt(Object object) {
        return Commons.toInt(Commons.toDouble(object));
    }

    public static double toDouble(Object object) {
        if (object == null) {
            return 0.0;
        }
        assert (!(object instanceof Object[]));
        return Double.parseDouble(object.toString());
    }

    public static float toFloat(Object object) {
        if (object == null) {
            return 0.0f;
        }
        assert (!(object instanceof Object[]));
        return Float.parseFloat(object.toString());
    }

    public static boolean toBool(Object object) {
        if (object == null) {
            return false;
        }
        assert (!(object instanceof Object[]));
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        String string = object.toString();
        return string.equals("true") || string.equals("1.0") || string.equals("1") || string.equals("y") || string.equals("yes");
    }

    public static int clamp(int min, int max, int value) {
        return Math.min(max, Math.max(value, min));
    }

    public static long clamp(long min, long max, long value) {
        return Math.min(max, Math.max(value, min));
    }

    public static float clamp(float min, float max, float value) {
        return Math.min(max, Math.max(value, min));
    }

    public static double clamp(double min, double max, double value) {
        return Math.min(max, Math.max(value, min));
    }

    public static float clampMantisse(float min, float max, float value) {
        return Math.min(max, Math.max(Math.abs(value), min)) * Math.signum(value == 0.0f ? 1.0f : value);
    }

    public static double clampMantisse(double min, double max, double value) {
        return Math.min(max, Math.max(Math.abs(value), min)) * Math.signum(value == 0.0 ? 1.0 : value);
    }

    public static int randomRange(Random random, int min, int max) {
        return min + (max - min > 0 ? random.nextInt(max - min + 1) : 0);
    }

    public static double randomRange(Random random, double min, double max) {
        return min + (max - min > 0.0 ? random.nextDouble() * (max - min) : 0.0);
    }

    public static double interpolate(double[] xValues, double[] yValues, double xInput) {
        if (WarpDrive.isDev) {
            assert (xValues.length == yValues.length);
            assert (xValues.length > 1);
        }
        if (xInput < xValues[0]) {
            return yValues[0];
        }
        for (int index = 0; index < xValues.length - 1; ++index) {
            if (!(xInput < xValues[index + 1])) continue;
            return Commons.interpolate(xValues[index], yValues[index], xValues[index + 1], yValues[index + 1], xInput);
        }
        return yValues[yValues.length - 1];
    }

    public static double interpolate(double xMin, double yMin, double xMax, double yMax, double x) {
        return yMin + (x - xMin) * (yMax - yMin) / (xMax - xMin);
    }

    public static ForgeDirection getHorizontalDirectionFromEntity(EntityLivingBase entityLiving) {
        if (entityLiving != null) {
            int direction = Math.round(entityLiving.field_70177_z / 90.0f) & 3;
            switch (direction) {
                default: {
                    return ForgeDirection.NORTH;
                }
                case 1: {
                    return ForgeDirection.EAST;
                }
                case 2: {
                    return ForgeDirection.SOUTH;
                }
                case 3: 
            }
            return ForgeDirection.WEST;
        }
        return ForgeDirection.NORTH;
    }

    public static int getFacingFromEntity(EntityLivingBase entityLiving) {
        if (entityLiving != null) {
            int metadata;
            if (entityLiving.field_70125_A > 65.0f) {
                metadata = 1;
            } else if (entityLiving.field_70125_A < -65.0f) {
                metadata = 0;
            } else {
                int direction = Math.round(entityLiving.field_70177_z / 90.0f) & 3;
                switch (direction) {
                    case 0: {
                        metadata = 2;
                        break;
                    }
                    case 1: {
                        metadata = 5;
                        break;
                    }
                    case 2: {
                        metadata = 3;
                        break;
                    }
                    case 3: {
                        metadata = 4;
                        break;
                    }
                    default: {
                        metadata = 2;
                    }
                }
            }
            return metadata;
        }
        return 0;
    }

    public static boolean isSafeThread() {
        String name = Thread.currentThread().getName();
        return name.equals("Server thread") || name.equals("Client thread");
    }

    public static void dumpAllThreads() {
        ThreadInfo[] threadInfos;
        StringBuilder stringBuilder = new StringBuilder();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo threadInfo : threadInfos = threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds(), 100)) {
            StackTraceElement[] stackTraceElements;
            stringBuilder.append('\"');
            stringBuilder.append(threadInfo.getThreadName());
            stringBuilder.append("\"\n\tjava.lang.Thread.State: ");
            stringBuilder.append((Object)threadInfo.getThreadState());
            for (StackTraceElement stackTraceElement : stackTraceElements = threadInfo.getStackTrace()) {
                stringBuilder.append("\n\t\tat ");
                stringBuilder.append(stackTraceElement);
            }
            stringBuilder.append("\n\n");
        }
        WarpDrive.logger.error(stringBuilder.toString());
    }

    public static void writeNBTToFile(String fileName, NBTTagCompound tagCompound) {
        if (WarpDrive.isDev) {
            WarpDrive.logger.info("writeNBTToFile " + fileName);
        }
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileOutputStream fileoutputstream = new FileOutputStream(file);
            CompressedStreamTools.func_74799_a((NBTTagCompound)tagCompound, (OutputStream)fileoutputstream);
            fileoutputstream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static NBTTagCompound readNBTFromFile(String fileName) {
        if (WarpDrive.isDev) {
            WarpDrive.logger.info("readNBTFromFile " + fileName);
        }
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                return null;
            }
            FileInputStream fileinputstream = new FileInputStream(file);
            NBTTagCompound tagCompound = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
            fileinputstream.close();
            return tagCompound;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static EntityPlayerMP[] getOnlinePlayerByNameOrSelector(ICommandSender sender, String playerNameOrSelector) {
        List onlinePlayers = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        for (EntityPlayer onlinePlayer : onlinePlayers) {
            if (!onlinePlayer.func_70005_c_().equalsIgnoreCase(playerNameOrSelector) || !(onlinePlayer instanceof EntityPlayerMP)) continue;
            return new EntityPlayerMP[]{(EntityPlayerMP)onlinePlayer};
        }
        EntityPlayerMP[] entityPlayerMPs_found = PlayerSelector.func_82380_c((ICommandSender)sender, (String)playerNameOrSelector);
        if (entityPlayerMPs_found != null && entityPlayerMPs_found.length > 0) {
            return (EntityPlayerMP[])entityPlayerMPs_found.clone();
        }
        return null;
    }

    public static EntityPlayerMP getOnlinePlayerByName(String playerName) {
        return MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(playerName);
    }

    public static int colorARGBtoInt(int alpha, int red, int green, int blue) {
        return (Commons.clamp(0, 255, alpha) << 24) + (Commons.clamp(0, 255, red) << 16) + (Commons.clamp(0, 255, green) << 8) + Commons.clamp(0, 255, blue);
    }

    @Optional.Method(modid="NotEnoughItems")
    public static void NEI_hideItemStack(ItemStack itemStack) {
        API.hideItem((ItemStack)itemStack);
    }

    public static void hideItemStack(ItemStack itemStack) {
        if (WarpDriveConfig.isNotEnoughItemsLoaded) {
            Commons.NEI_hideItemStack(itemStack);
        }
    }

    public static void moveEntity(Entity entity, World worldDestination, Vector3 v3Destination) {
        if (worldDestination != entity.field_70170_p) {
            World worldSource = entity.field_70170_p;
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            WorldServer from = server.func_71218_a(worldSource.field_73011_w.field_76574_g);
            WorldServer to = server.func_71218_a(worldDestination.field_73011_w.field_76574_g);
            SpaceTeleporter teleporter = new SpaceTeleporter(to, 0, MathHelper.func_76128_c((double)v3Destination.x), MathHelper.func_76128_c((double)v3Destination.y), MathHelper.func_76128_c((double)v3Destination.z));
            if (entity instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)entity;
                server.func_71203_ab().transferPlayerToDimension(player, worldDestination.field_73011_w.field_76574_g, (Teleporter)teleporter);
                player.func_71016_p();
            } else {
                server.func_71203_ab().transferEntityToWorld(entity, worldSource.field_73011_w.field_76574_g, from, to, (Teleporter)teleporter);
            }
        }
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            player.func_70634_a(v3Destination.x, v3Destination.y, v3Destination.z);
        } else {
            entity.func_70107_b(v3Destination.x, v3Destination.y, v3Destination.z);
        }
    }

    public static WorldServer getOrCreateWorldServer(int dimensionId) {
        WorldServer worldServer = DimensionManager.getWorld((int)dimensionId);
        if (worldServer == null) {
            try {
                MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                worldServer = server.func_71218_a(dimensionId);
            }
            catch (Exception exception) {
                WarpDrive.logger.error(String.format("%s: Failed to initialize dimension %d", exception.getMessage(), dimensionId));
                if (WarpDrive.isDev) {
                    exception.printStackTrace();
                }
                worldServer = null;
            }
        }
        return worldServer;
    }

    public static MovingObjectPosition getInteractingBlock(World world, EntityPlayer entityPlayer) {
        return Commons.getInteractingBlock(world, entityPlayer, 5.0);
    }

    public static MovingObjectPosition getInteractingBlock(World world, EntityPlayer entityPlayer, double distance) {
        Vec3 vec3Position = Vec3.func_72443_a((double)entityPlayer.field_70165_t, (double)(entityPlayer.field_70163_u + (double)entityPlayer.eyeHeight), (double)entityPlayer.field_70161_v);
        Vec3 vec3Look = entityPlayer.func_70676_i(1.0f);
        Vec3 vec3Target = vec3Position.func_72441_c(vec3Look.field_72450_a * distance, vec3Look.field_72448_b * distance, vec3Look.field_72449_c * distance);
        return world.func_147447_a(vec3Position, vec3Target, false, false, true);
    }

    public static Fluid fluid_getByBlock(Block block) {
        if (!(block instanceof BlockLiquid)) {
            WarpDrive.logger.warn(String.format("Invalid lookup for fluid block not derived from BlockLiquid %s", block));
            return null;
        }
        if (fluidByBlockName == null) {
            Map fluidsRegistry = FluidRegistry.getRegisteredFluids();
            HashMap<String, Fluid> map = new HashMap<String, Fluid>(100);
            fluidByBlockName = map;
            for (Fluid fluid : fluidsRegistry.values()) {
                Block blockFluid = fluid.getBlock();
                if (blockFluid == null) continue;
                map.put(blockFluid.func_149739_a(), fluid);
            }
            fluidByBlockName = map;
        }
        return fluidByBlockName.get(block.func_149739_a());
    }
}

