/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.api;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.eventhandler.Event;
import cr0s.warpdrive.api.Particle;
import cr0s.warpdrive.api.ParticleStack;
import java.util.Map;
import net.minecraft.item.EnumRarity;
import net.minecraftforge.common.MinecraftForge;

public class ParticleRegistry {
    private static BiMap<String, Particle> particles = HashBiMap.create();
    public static final Particle ION = new Particle("ion"){}.setColor(15073108).setRarity(EnumRarity.common).setColorIndex(0).setEntityLifespan(200).setRadiationLevel(2.0f).setExplosionStrength(0.3f);
    public static final Particle PROTON = new Particle("proton"){}.setColor(15073108).setRarity(EnumRarity.common).setColorIndex(1).setEntityLifespan(200).setRadiationLevel(4.0f).setExplosionStrength(0.5f);
    public static final Particle ANTIMATTER = new Particle("antimatter"){}.setColor(1850543).setRarity(EnumRarity.uncommon).setColorIndex(2).setEntityLifespan(60).setRadiationLevel(10.0f).setExplosionStrength(1.0f);
    public static final Particle STRANGE_MATTER = new Particle("strange_matter"){}.setColor(14827852).setRarity(EnumRarity.rare).setColorIndex(3).setEntityLifespan(40).setRadiationLevel(14.0f).setExplosionStrength(0.8f);

    private ParticleRegistry() {
    }

    public static boolean registerParticle(Particle particle) {
        if (particles.containsKey((Object)particle.getRegistryName())) {
            FMLLog.getLogger().error(String.format("Mod %s FAILED to register particle %s: it was already registered!", ParticleRegistry.getActiveModId(), particle.getRegistryName()));
            return false;
        }
        particles.put((Object)particle.getRegistryName(), (Object)particle);
        FMLLog.getLogger().info(String.format("Mod %s has registered particle %s", ParticleRegistry.getActiveModId(), particle.getRegistryName()));
        MinecraftForge.EVENT_BUS.post((Event)new ParticleRegisterEvent(particle.getRegistryName()));
        return true;
    }

    private static String getActiveModId() {
        ModContainer activeModContainer = Loader.instance().activeModContainer();
        return activeModContainer == null ? "minecraft" : activeModContainer.getModId();
    }

    public static boolean isParticleRegistered(Particle particle) {
        return particle != null && particles.containsKey((Object)particle.getRegistryName());
    }

    public static boolean isParticleRegistered(String particleRegistryName) {
        return particles.containsKey((Object)particleRegistryName);
    }

    public static Particle getParticle(String particleRegistryName) {
        return (Particle)particles.get((Object)particleRegistryName);
    }

    public static String getParticleName(Particle particle) {
        return particle.getRegistryName();
    }

    public static String getParticleName(ParticleStack stack) {
        return stack.getParticle().getRegistryName();
    }

    public static ParticleStack getParticleStack(String particleRegistryName, int amount) {
        if (!particles.containsKey((Object)particleRegistryName)) {
            return null;
        }
        return new ParticleStack(ParticleRegistry.getParticle(particleRegistryName), amount);
    }

    public static Map<String, Particle> getRegisteredParticles() {
        return ImmutableMap.copyOf(particles);
    }

    static {
        ParticleRegistry.registerParticle(ION);
        ParticleRegistry.registerParticle(PROTON);
        ParticleRegistry.registerParticle(ANTIMATTER);
        ParticleRegistry.registerParticle(STRANGE_MATTER);
    }

    public static class ParticleRegisterEvent
    extends Event {
        public final String particleRegistryName;

        public ParticleRegisterEvent(String particleRegistryName) {
            this.particleRegistryName = particleRegistryName;
        }
    }
}

