/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.api;

import cpw.mods.fml.common.FMLLog;
import cr0s.warpdrive.api.IParticleContainerItem;
import cr0s.warpdrive.api.Particle;
import cr0s.warpdrive.api.ParticleRegistry;
import cr0s.warpdrive.data.Vector3;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ParticleStack {
    private final Particle particle;
    private int amount;
    private NBTTagCompound tagCompound;

    public ParticleStack(@Nonnull Particle particle, int amount) {
        if (!ParticleRegistry.isParticleRegistered(particle)) {
            FMLLog.bigWarning((String)"Failed attempt to create a particleStack for an unregistered Particle %s (type %s)", (Object[])new Object[]{particle.getRegistryName(), particle.getClass().getName()});
            throw new IllegalArgumentException("Cannot create a particleStack from an unregistered particle");
        }
        this.amount = amount;
        this.particle = particle;
    }

    public ParticleStack(Particle particle, int amount, NBTTagCompound nbt) {
        this(particle, amount);
        if (nbt != null) {
            this.tagCompound = (NBTTagCompound)nbt.func_74737_b();
        }
    }

    public ParticleStack(ParticleStack stack, int amount) {
        this(stack.getParticle(), amount, stack.tagCompound);
    }

    public static ParticleStack loadFromNBT(NBTTagCompound tagCompound) {
        if (tagCompound == null) {
            return null;
        }
        String particleName = tagCompound.func_74779_i("name");
        if (particleName == null || ParticleRegistry.getParticle(particleName) == null) {
            return null;
        }
        ParticleStack stack = new ParticleStack(ParticleRegistry.getParticle(particleName), tagCompound.func_74762_e("amount"));
        if (tagCompound.func_74764_b("tag")) {
            stack.tagCompound = tagCompound.func_74775_l("tag");
        }
        return stack;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74778_a("name", ParticleRegistry.getParticleName(this.getParticle()));
        tagCompound.func_74768_a("amount", this.amount);
        if (this.tagCompound != null) {
            tagCompound.func_74782_a("tag", (NBTBase)this.tagCompound);
        }
        return tagCompound;
    }

    public final Particle getParticle() {
        return this.particle;
    }

    public boolean isEmpty() {
        return this.particle == null || this.amount <= 0;
    }

    public final int getAmount() {
        return this.amount;
    }

    public final void fill(int amountAdded) {
        this.amount += amountAdded;
    }

    public int getEntityLifespan() {
        if (this.particle == null) {
            return -1;
        }
        return this.particle.getEntityLifespan();
    }

    public void onWorldEffect(@Nonnull World world, @Nonnull Vector3 v3Position) {
        if (this.particle == null) {
            return;
        }
        this.particle.onWorldEffect(world, v3Position, this.amount);
    }

    public String getLocalizedName() {
        return this.getParticle().getLocalizedName();
    }

    public String getUnlocalizedName() {
        return this.getParticle().getUnlocalizedName();
    }

    public ParticleStack copy() {
        return new ParticleStack(this.getParticle(), this.amount, this.tagCompound);
    }

    public ParticleStack copy(int amount) {
        return new ParticleStack(this.getParticle(), amount, this.tagCompound);
    }

    public boolean isParticleEqual(ParticleStack other) {
        return other != null && this.getParticle() == other.getParticle() && this.isParticleStackTagEqual(other);
    }

    private boolean isParticleStackTagEqual(ParticleStack other) {
        return this.tagCompound == null ? other.tagCompound == null : other.tagCompound != null && this.tagCompound.equals((Object)other.tagCompound);
    }

    public static boolean areParticleStackTagsEqual(ParticleStack stack1, ParticleStack stack2) {
        return stack1 == null && stack2 == null || stack1 != null && stack2 != null && stack1.isParticleStackTagEqual(stack2);
    }

    public boolean containsParticle(ParticleStack other) {
        return this.isParticleEqual(other) && this.amount >= other.amount;
    }

    public boolean isParticleStackIdentical(ParticleStack other) {
        return this.isParticleEqual(other) && this.amount == other.amount;
    }

    public boolean isParticleEqual(ItemStack other) {
        if (other == null) {
            return false;
        }
        if (other.func_77973_b() instanceof IParticleContainerItem) {
            return this.isParticleEqual(((IParticleContainerItem)other.func_77973_b()).getParticleStack(other));
        }
        return false;
    }

    public final int hashCode() {
        int code = 1;
        code = 31 * code + this.getParticle().hashCode();
        code = 31 * code + this.amount;
        if (this.tagCompound != null) {
            code = 31 * code + this.tagCompound.hashCode();
        }
        return code;
    }

    public final boolean equals(Object object) {
        return object instanceof ParticleStack && this.isParticleEqual((ParticleStack)object);
    }
}

