/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block;

import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBlockBase;
import cr0s.warpdrive.api.IBlockUpdateDetector;
import cr0s.warpdrive.api.IVideoChannel;
import cr0s.warpdrive.block.TileEntityAbstractBase;
import cr0s.warpdrive.block.TileEntityAbstractEnergy;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnumComponentType;
import cr0s.warpdrive.item.ItemComponent;
import defense.api.IEMPBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import resonant.api.explosion.IExplosion;

@Optional.InterfaceList(value={@Optional.Interface(iface="defense.api.IEMPBlock", modid="DefenseTech"), @Optional.Interface(iface="resonant.api.explosion.IEMPBlock", modid="icbmclassic")})
public abstract class BlockAbstractContainer
extends BlockContainer
implements IBlockBase,
IEMPBlock,
resonant.api.explosion.IEMPBlock {
    protected boolean isRotating = false;
    protected boolean hasSubBlocks = false;
    private static boolean isInvalidEMPreported = false;

    protected BlockAbstractContainer(Material material) {
        super(material);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149647_a(WarpDrive.creativeTabWarpDrive);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof IBlockUpdateDetector) {
            ((IBlockUpdateDetector)tileEntity).onBlockUpdateDetected();
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        int metadata;
        super.func_149689_a(world, x, y, z, entityLiving, itemStack);
        if (this.isRotating && (metadata = Commons.getFacingFromEntity(entityLiving)) >= 0 && metadata <= 15) {
            world.func_72921_c(x, y, z, metadata, 3);
        }
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (itemStack.func_77942_o()) {
            NBTTagCompound tagCompound = (NBTTagCompound)itemStack.func_77978_p().func_74737_b();
            tagCompound.func_74768_a("x", x);
            tagCompound.func_74768_a("y", y);
            tagCompound.func_74768_a("z", z);
            tileEntity.func_145839_a(tagCompound);
            world.func_147471_g(x, y, z);
        }
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(world, player, x, y, z, false);
    }

    protected void func_149642_a(World world, int x, int y, int z, ItemStack itemStack) {
        if (itemStack.func_77973_b() == Item.func_150898_a((Block)this)) {
            itemStack.func_77964_b(this.func_149643_k(world, x, y, z));
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            if (tileEntity == null) {
                WarpDrive.logger.error("Missing tile entity for " + this + " at " + world + " " + x + " " + y + " " + z);
            } else if (tileEntity instanceof TileEntityAbstractBase) {
                NBTTagCompound tagCompound = new NBTTagCompound();
                ((TileEntityAbstractBase)tileEntity).writeItemDropNBT(tagCompound);
                itemStack.func_77982_d(tagCompound);
            }
        }
        world.func_147468_f(x, y, z);
        super.func_149642_a(world, x, y, z, itemStack);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer entityPlayer) {
        ItemStack itemStack = super.getPickBlock(target, world, x, y, z, entityPlayer);
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        NBTTagCompound tagCompound = new NBTTagCompound();
        if (tileEntity instanceof TileEntityAbstractBase) {
            ((TileEntityAbstractBase)tileEntity).writeItemDropNBT(tagCompound);
            itemStack.func_77982_d(tagCompound);
        }
        return itemStack;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        if (this.isRotating) {
            world.func_72921_c(x, y, z, axis.ordinal(), 3);
            return true;
        }
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        super.func_149695_a(world, x, y, z, block);
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof IBlockUpdateDetector) {
            ((IBlockUpdateDetector)tileEntity).onBlockUpdateDetected();
        }
    }

    @Optional.Method(modid="DefenseTech")
    public void onEMP(World world, int x, int y, int z, defense.api.IExplosion explosiveEMP) {
        if (WarpDriveConfig.LOGGING_WEAPON) {
            WarpDrive.logger.info(String.format("EMP received @ %s (%d %d %d) from %s with energy %d and radius %.1f", world.field_73011_w.func_80007_l(), x, y, z, explosiveEMP, explosiveEMP.getEnergy(), Float.valueOf(explosiveEMP.getRadius())));
        }
        if (explosiveEMP.getRadius() == 60.0f) {
            this.onEMP(world, x, y, z, 0.02f);
        } else if (explosiveEMP.getRadius() == 50.0f) {
            this.onEMP(world, x, y, z, 0.7f);
        } else {
            if (!isInvalidEMPreported) {
                isInvalidEMPreported = true;
                WarpDrive.logger.warn(String.format("EMP received @ %s (%d %d %d) from %s with energy %d and unsupported radius %.1f", world.field_73011_w.func_80007_l(), x, y, z, explosiveEMP, explosiveEMP.getEnergy(), Float.valueOf(explosiveEMP.getRadius())));
                Commons.dumpAllThreads();
            }
            this.onEMP(world, x, y, z, 0.02f);
        }
    }

    @Optional.Method(modid="icbmclassic")
    public void onEMP(World world, int x, int y, int z, IExplosion explosiveEMP) {
        if (WarpDriveConfig.LOGGING_WEAPON) {
            WarpDrive.logger.info(String.format("EMP received @ %s (%d %d %d) from %s with energy %d and radius %.1f", world.field_73011_w.func_80007_l(), x, y, z, explosiveEMP, explosiveEMP.getEnergy(), Float.valueOf(explosiveEMP.getRadius())));
        }
        if (explosiveEMP.getRadius() == 60.0f) {
            this.onEMP(world, x, y, z, 0.02f);
        } else if (explosiveEMP.getRadius() == 50.0f) {
            this.onEMP(world, x, y, z, 0.7f);
        } else {
            if (!isInvalidEMPreported) {
                isInvalidEMPreported = true;
                WarpDrive.logger.warn(String.format("EMP received @ %s (%d %d %d) from %s with energy %d and unsupported radius %.1f", world.field_73011_w.func_80007_l(), x, y, z, explosiveEMP, explosiveEMP.getEnergy(), Float.valueOf(explosiveEMP.getRadius())));
                Commons.dumpAllThreads();
            }
            this.onEMP(world, x, y, z, 0.02f);
        }
    }

    public void onEMP(World world, int x, int y, int z, float efficiency) {
        TileEntityAbstractEnergy tileEntityAbstractEnergy;
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityAbstractEnergy && (tileEntityAbstractEnergy = (TileEntityAbstractEnergy)tileEntity).energy_getMaxStorage() > 0) {
            tileEntityAbstractEnergy.energy_consume(Math.round((float)tileEntityAbstractEnergy.energy_getEnergyStored() * efficiency), false);
        }
    }

    @Override
    public byte getTier(ItemStack itemStack) {
        return 1;
    }

    @Override
    public EnumRarity getRarity(ItemStack itemStack, EnumRarity rarity) {
        switch (this.getTier(itemStack)) {
            case 0: {
                return EnumRarity.epic;
            }
            case 1: {
                return EnumRarity.common;
            }
            case 2: {
                return EnumRarity.uncommon;
            }
            case 3: {
                return EnumRarity.rare;
            }
        }
        return rarity;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!(tileEntity instanceof TileEntityAbstractBase)) {
            return false;
        }
        TileEntityAbstractBase tileEntityAbstractBase = (TileEntityAbstractBase)tileEntity;
        boolean hasVideoChannel = tileEntity instanceof IVideoChannel;
        ItemStack itemStackHeld = entityPlayer.func_70694_bm();
        if (world.field_72995_K && !hasVideoChannel) {
            return false;
        }
        EnumComponentType enumComponentType = null;
        if (itemStackHeld != null && itemStackHeld.func_77973_b() instanceof ItemComponent) {
            enumComponentType = EnumComponentType.get(itemStackHeld.func_77960_j());
        }
        if (!world.field_72995_K && entityPlayer.func_70093_af()) {
            if (tileEntityAbstractBase.isUpgradeable() && (itemStackHeld == null || enumComponentType != null)) {
                if (itemStackHeld == null || !tileEntityAbstractBase.hasUpgrade(enumComponentType)) {
                    enumComponentType = (EnumComponentType)tileEntityAbstractBase.getFirstUpgradeOfType(EnumComponentType.class, null);
                }
                if (enumComponentType == null) {
                    Commons.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.upgrade.result.no_upgrade_to_dismount", (Object[])new Object[0]));
                    return true;
                }
                if (!entityPlayer.field_71075_bZ.field_75098_d) {
                    ItemStack itemStackDrop = ItemComponent.getItemStackNoCache(enumComponentType, 1);
                    EntityItem entityItem = new EntityItem(world, entityPlayer.field_70165_t, entityPlayer.field_70163_u + 0.5, entityPlayer.field_70161_v, itemStackDrop);
                    entityItem.field_145804_b = 0;
                    world.func_72838_d((Entity)entityItem);
                }
                tileEntityAbstractBase.dismountUpgrade(enumComponentType);
                Commons.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.upgrade.result.dismounted", (Object[])new Object[]{enumComponentType.name()}));
                return false;
            }
        } else {
            if (!entityPlayer.func_70093_af() && itemStackHeld == null) {
                Commons.addChatMessage((ICommandSender)entityPlayer, tileEntityAbstractBase.getStatus());
                return true;
            }
            if (!world.field_72995_K && tileEntityAbstractBase.isUpgradeable() && enumComponentType != null) {
                if (tileEntityAbstractBase.getUpgradeMaxCount(enumComponentType) <= 0) {
                    Commons.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.upgrade.result.invalid_upgrade", (Object[])new Object[0]));
                    return true;
                }
                if (!tileEntityAbstractBase.canUpgrade(enumComponentType)) {
                    Commons.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.upgrade.result.too_many_upgrades", (Object[])new Object[]{tileEntityAbstractBase.getUpgradeMaxCount(enumComponentType)}));
                    return true;
                }
                if (!entityPlayer.field_71075_bZ.field_75098_d) {
                    if (itemStackHeld.field_77994_a < 1) {
                        Commons.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.upgrade.result.not_enough_upgrades", (Object[])new Object[0]));
                        return true;
                    }
                    --itemStackHeld.field_77994_a;
                }
                tileEntityAbstractBase.mountUpgrade(enumComponentType);
                Commons.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.upgrade.result.mounted", (Object[])new Object[]{enumComponentType.name()}));
            }
        }
        return false;
    }
}

