/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.TileEntityAbstractEnergy;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.event.ChunkLoadingHandler;
import java.util.ArrayList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraftforge.common.ForgeChunkManager;

public abstract class TileEntityAbstractChunkLoading
extends TileEntityAbstractEnergy {
    protected ChunkCoordIntPair chunkMin = null;
    protected ChunkCoordIntPair chunkMax = null;
    private ForgeChunkManager.Ticket ticket = null;
    private boolean isRefreshNeeded = true;
    protected boolean areChunksLoaded = false;

    @Override
    protected void onFirstUpdateTick() {
        super.onFirstUpdateTick();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.chunkMin == null || this.chunkMax == null) {
            WarpDrive.logger.warn(this + " No chunk coordinates defined, assuming current chunk");
            this.chunkMin = this.field_145850_b.func_72938_d(this.field_145851_c, this.field_145849_e).func_76632_l();
            this.chunkMax = this.field_145850_b.func_72938_d(this.field_145851_c, this.field_145849_e).func_76632_l();
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.isRefreshNeeded || this.shouldChunkLoad() != this.areChunksLoaded) {
            this.refreshLoading(this.isRefreshNeeded);
            this.isRefreshNeeded = false;
        }
    }

    public abstract boolean shouldChunkLoad();

    public void refreshChunkLoading() {
        this.isRefreshNeeded = true;
    }

    private void refreshLoading(boolean force) {
        boolean shouldChunkLoad = this.shouldChunkLoad();
        if (shouldChunkLoad) {
            if (this.ticket == null) {
                this.chunkloading_giveTicket(ChunkLoadingHandler.forgeTicket_requestNormal(this.field_145850_b, this));
            } else if (force) {
                ChunkLoadingHandler.forgeTicket_clearChunks(this.ticket);
            }
            if (!this.areChunksLoaded || force) {
                int ticketSize = this.ticket.getMaxChunkListDepth();
                ArrayList<ChunkCoordIntPair> chunksToLoad = this.getChunksToLoad();
                if (chunksToLoad.size() > ticketSize) {
                    WarpDrive.logger.error(String.format("Too many chunk requested for loading @ %s (%d %d %d)", this.field_145850_b.field_73011_w.func_80007_l(), this.field_145851_c, this.field_145848_d, this.field_145849_e));
                    return;
                }
                for (ChunkCoordIntPair chunk : chunksToLoad) {
                    ChunkLoadingHandler.forgeTicket_addChunks(this.ticket, chunk);
                }
                this.areChunksLoaded = true;
            }
        } else if (this.ticket != null) {
            ChunkLoadingHandler.forgeTicket_release(this.ticket);
            this.ticket = null;
            this.areChunksLoaded = false;
        }
    }

    public void chunkloading_giveTicket(ForgeChunkManager.Ticket ticket) {
        if (this.ticket != null) {
            ChunkLoadingHandler.forgeTicket_release(this.ticket);
            this.ticket = null;
        }
        this.ticket = ticket;
    }

    public int chunkloading_getArea() {
        return (this.chunkMax.field_77276_a - this.chunkMin.field_77276_a + 1) * (this.chunkMax.field_77275_b - this.chunkMin.field_77275_b + 1);
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        if (this.chunkMin == null) {
            this.chunkMin = this.field_145850_b.func_72938_d(this.field_145851_c, this.field_145849_e).func_76632_l();
        }
        if (this.chunkMax == null) {
            this.chunkMax = this.field_145850_b.func_72938_d(this.field_145851_c, this.field_145849_e).func_76632_l();
        }
        tagCompound.func_74768_a("minChunkX", this.chunkMin.field_77276_a);
        tagCompound.func_74768_a("minChunkZ", this.chunkMin.field_77275_b);
        tagCompound.func_74768_a("maxChunkX", this.chunkMax.field_77276_a);
        tagCompound.func_74768_a("maxChunkZ", this.chunkMax.field_77275_b);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        if (tagCompound.func_74764_b("minChunkX")) {
            int xMin = tagCompound.func_74762_e("minChunkX");
            int zMin = tagCompound.func_74762_e("minChunkZ");
            this.chunkMin = new ChunkCoordIntPair(xMin, zMin);
            int xMax = tagCompound.func_74762_e("maxChunkX");
            int zMax = tagCompound.func_74762_e("maxChunkZ");
            this.chunkMax = new ChunkCoordIntPair(xMax, zMax);
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.ticket != null) {
            ChunkLoadingHandler.forgeTicket_release(this.ticket);
            this.ticket = null;
        }
    }

    public ArrayList<ChunkCoordIntPair> getChunksToLoad() {
        if (!this.shouldChunkLoad()) {
            return null;
        }
        assert (this.chunkMin.field_77276_a <= this.chunkMax.field_77276_a);
        assert (this.chunkMin.field_77275_b <= this.chunkMax.field_77275_b);
        int count = this.chunkloading_getArea();
        if (WarpDriveConfig.LOGGING_CHUNK_LOADING) {
            WarpDrive.logger.info(String.format("Collecting %d chunks to be loaded @ %s from %s to %s", count, this.field_145850_b.field_73011_w.func_80007_l(), this.chunkMin, this.chunkMax));
        }
        ArrayList<ChunkCoordIntPair> chunkCoords = new ArrayList<ChunkCoordIntPair>(count);
        for (int x = this.chunkMin.field_77276_a; x <= this.chunkMax.field_77276_a; ++x) {
            for (int z = this.chunkMin.field_77275_b; z <= this.chunkMax.field_77275_b; ++z) {
                chunkCoords.add(new ChunkCoordIntPair(x, z));
            }
        }
        return chunkCoords;
    }
}

