/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.computer.IInterfaced;
import cr0s.warpdrive.block.TileEntityAbstractBase;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.VectorI;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import li.cil.oc.api.Network;
import li.cil.oc.api.fs.FileSystem;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Component;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.Environment", modid="OpenComputers"), @Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft")})
public abstract class TileEntityAbstractInterfaced
extends TileEntityAbstractBase
implements IPeripheral,
Environment,
IInterfaced {
    protected String peripheralName = null;
    private String[] methodsArray = new String[0];
    public static final String COMPUTER_ERROR_TAG = "!ERROR!";
    private volatile ManagedEnvironment OC_fileSystem = null;
    private volatile boolean CC_hasResource = false;
    private volatile boolean OC_hasResource = false;
    protected volatile List<String> CC_scripts = null;
    protected boolean OC_enable = true;
    protected Node OC_node = null;
    protected boolean OC_addedToNetwork = false;
    protected final HashMap<Integer, IComputerAccess> connectedComputers = new HashMap();

    public TileEntityAbstractInterfaced() {
        this.addMethods(new String[]{"interfaced", "position", "version"});
    }

    protected void addMethods(String[] methodsToAdd) {
        if (this.methodsArray == null) {
            this.methodsArray = methodsToAdd;
        } else {
            int currentLength = this.methodsArray.length;
            this.methodsArray = Arrays.copyOf(this.methodsArray, this.methodsArray.length + methodsToAdd.length);
            String[] stringArray = methodsToAdd;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String method;
                this.methodsArray[currentLength] = method = stringArray[i];
                ++currentLength;
            }
        }
    }

    protected String getMethodName(int methodIndex) {
        return this.methodsArray[methodIndex];
    }

    protected String getMethodName(int methodIndex, Object[] arguments) {
        String methodName = this.methodsArray[methodIndex];
        if (WarpDrive.isDev && WarpDriveConfig.LOGGING_LUA) {
            WarpDrive.logger.info(String.format("LUA call to %s.%s(%s)", this.peripheralName, methodName, Commons.format(arguments)));
        }
        return methodName;
    }

    private boolean assetExist(String resourcePath) {
        URL url = this.getClass().getResource(resourcePath);
        return url != null;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (WarpDriveConfig.isOpenComputersLoaded && !this.OC_addedToNetwork && this.OC_enable) {
            this.OC_addedToNetwork = true;
            Network.joinOrCreateNetwork((TileEntity)this);
        }
    }

    public void func_145829_t() {
        if (WarpDriveConfig.isComputerCraftLoaded) {
            String CC_path = "/assets/" + "WarpDrive".toLowerCase() + "/lua.ComputerCraft/" + this.peripheralName;
            this.CC_hasResource = this.assetExist(CC_path);
        }
        if (WarpDriveConfig.isOpenComputersLoaded && this.OC_node == null) {
            this.OC_constructor();
        }
        super.func_145829_t();
    }

    public void func_145843_s() {
        if (WarpDriveConfig.isOpenComputersLoaded && this.OC_node != null) {
            this.OC_node.remove();
            this.OC_node = null;
        }
        super.func_145843_s();
    }

    public void onChunkUnload() {
        if (WarpDriveConfig.isOpenComputersLoaded && this.OC_node != null) {
            this.OC_node.remove();
            this.OC_node = null;
        }
        super.onChunkUnload();
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        if (WarpDriveConfig.isOpenComputersLoaded && FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            if (this.OC_node == null) {
                this.OC_constructor();
            }
            if (this.OC_node != null && this.OC_node.host() == this) {
                this.OC_node.load(tagCompound.func_74775_l("oc:node"));
            } else if (tagCompound.func_74764_b("oc:node")) {
                WarpDrive.logger.error(this + " OC node failed to construct or wrong host, ignoring NBT node data read...");
            }
            if (this.OC_fileSystem != null && this.OC_fileSystem.node() != null) {
                this.OC_fileSystem.node().load(tagCompound.func_74775_l("oc:fs"));
            } else if (this.OC_hasResource) {
                WarpDrive.logger.error(this + " OC filesystem failed to construct or wrong node, ignoring NBT filesystem data read...");
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        if (WarpDriveConfig.isOpenComputersLoaded) {
            if (this.OC_node != null && this.OC_node.host() == this) {
                NBTTagCompound nbtNode = new NBTTagCompound();
                this.OC_node.save(nbtNode);
                tagCompound.func_74782_a("oc:node", (NBTBase)nbtNode);
            }
            if (this.OC_fileSystem != null && this.OC_fileSystem.node() != null) {
                NBTTagCompound nbtFileSystem = new NBTTagCompound();
                this.OC_fileSystem.node().save(nbtFileSystem);
                tagCompound.func_74782_a("oc:fs", (NBTBase)nbtFileSystem);
            }
        }
    }

    @Override
    public NBTTagCompound writeItemDropNBT(NBTTagCompound tagCompound) {
        tagCompound = super.writeItemDropNBT(tagCompound);
        tagCompound.func_82580_o("oc:node");
        tagCompound.func_82580_o("oc:fs");
        return tagCompound;
    }

    public int hashCode() {
        return (((super.hashCode() + (this.field_145850_b == null ? 0 : this.field_145850_b.field_73011_w.field_76574_g) << 4) + this.field_145851_c << 4) + this.field_145848_d << 4) + this.field_145849_e;
    }

    @Optional.Method(modid="OpenComputers")
    protected Object[] argumentsOCtoCC(Arguments args) {
        Object[] arguments = new Object[args.count()];
        int index = 0;
        for (Object arg : args) {
            arguments[index] = args.isString(index) ? args.checkString(index) : arg;
            ++index;
        }
        return arguments;
    }

    @Override
    public Object[] interfaced() {
        return new String[]{"I'm a WarpDrive computer interfaced tile entity."};
    }

    @Override
    public Object[] position() {
        return new Object[]{this.field_145851_c, this.field_145848_d, this.field_145849_e, "?", this.field_145851_c, this.field_145848_d, this.field_145849_e};
    }

    @Override
    public Object[] version() {
        if (WarpDriveConfig.LOGGING_LUA) {
            WarpDrive.logger.info("Version is 1.7.10-1.4.2.- isDev " + WarpDrive.isDev);
        }
        String[] strings = "1.7.10-1.4.2.-".split("-");
        strings = WarpDrive.isDev ? strings[strings.length - 2].split("\\.") : strings[strings.length - 1].split("\\.");
        ArrayList<Integer> integers = new ArrayList<Integer>(strings.length);
        for (String string : strings) {
            integers.add(Integer.parseInt(string));
        }
        return integers.toArray();
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return this.peripheralName;
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return this.methodsArray;
    }

    protected VectorI computer_getVectorI(VectorI vDefault, Object[] arguments) {
        try {
            if (arguments.length == 3) {
                int x = Commons.toInt(arguments[0]);
                int y = Commons.toInt(arguments[1]);
                int z = Commons.toInt(arguments[2]);
                return new VectorI(x, y, z);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return vDefault;
    }

    protected UUID computer_getUUID(UUID uuidDefault, Object[] arguments) {
        try {
            if (arguments.length == 1 && arguments[0] != null) {
                if (arguments[0] instanceof UUID) {
                    return (UUID)arguments[0];
                }
                if (arguments[0] instanceof String) {
                    return UUID.fromString((String)arguments[0]);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return uuidDefault;
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        String methodName;
        switch (methodName = this.getMethodName(method)) {
            case "interfaced": {
                return this.interfaced();
            }
            case "position": {
                return this.position();
            }
            case "version": {
                return this.version();
            }
        }
        return null;
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
        int id = computer.getID();
        this.connectedComputers.put(id, computer);
        if (this.CC_hasResource && WarpDriveConfig.G_LUA_SCRIPTS != 0) {
            try {
                String modid = "WarpDrive".toLowerCase();
                String folderPeripheral = this.peripheralName.replace(modid, modid + "/");
                computer.mount("/" + modid, ComputerCraftAPI.createResourceMount(WarpDrive.class, (String)modid, (String)"lua.ComputerCraft/common"));
                computer.mount("/" + folderPeripheral, ComputerCraftAPI.createResourceMount(WarpDrive.class, (String)modid, (String)("lua.ComputerCraft/" + this.peripheralName)));
                computer.mount("/warpupdater", ComputerCraftAPI.createResourceMount(WarpDrive.class, (String)modid, (String)"lua.ComputerCraft/common/updater"));
                if (WarpDriveConfig.G_LUA_SCRIPTS == 2) {
                    for (String script : this.CC_scripts) {
                        computer.mount("/" + script, ComputerCraftAPI.createResourceMount(WarpDrive.class, (String)modid, (String)("lua.ComputerCraft/" + this.peripheralName + "/" + script)));
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                WarpDrive.logger.error(String.format("Failed to mount ComputerCraft scripts for %s @ %s (%d %d %d), isFirstTick %s", this.peripheralName, this.field_145850_b == null ? "~NULL~" : this.field_145850_b.field_73011_w.func_80007_l(), this.field_145851_c, this.field_145848_d, this.field_145849_e, this.isFirstTick()));
            }
        }
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
        int id = computer.getID();
        this.connectedComputers.remove(id);
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return other.hashCode() == this.hashCode();
    }

    protected void sendEvent(String eventName, Object ... arguments) {
        if (WarpDriveConfig.LOGGING_LUA) {
            WarpDrive.logger.info(this + " Sending event '" + eventName + "'");
        }
        if (WarpDriveConfig.isComputerCraftLoaded) {
            for (Map.Entry<Integer, IComputerAccess> integerIComputerAccessEntry : this.connectedComputers.entrySet()) {
                IComputerAccess comp = integerIComputerAccessEntry.getValue();
                comp.queueEvent(eventName, arguments);
            }
        }
        if (WarpDriveConfig.isOpenComputersLoaded && this.OC_node != null && this.OC_node.network() != null) {
            if (arguments == null || arguments.length == 0) {
                this.OC_node.sendToReachable("computer.signal", new Object[]{eventName});
            } else {
                Object[] eventWithArguments = new Object[arguments.length + 1];
                eventWithArguments[0] = eventName;
                int index = 1;
                Object[] objectArray = arguments;
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    Object object;
                    eventWithArguments[index] = object = objectArray[i];
                    ++index;
                }
                this.OC_node.sendToReachable("computer.signal", eventWithArguments);
            }
        }
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] position(Context context, Arguments arguments) {
        return this.position();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] version(Context context, Arguments arguments) {
        return this.version();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] interfaced(Context context, Arguments arguments) {
        return this.interfaced();
    }

    @Optional.Method(modid="OpenComputers")
    private void OC_constructor() {
        assert (this.OC_node == null);
        String OC_path = "/assets/" + "WarpDrive".toLowerCase() + "/lua.OpenComputers/" + this.peripheralName;
        this.OC_hasResource = this.assetExist(OC_path);
        this.OC_node = Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.peripheralName).create();
        if (this.OC_node != null && this.OC_hasResource && WarpDriveConfig.G_LUA_SCRIPTS != 0) {
            this.OC_fileSystem = li.cil.oc.api.FileSystem.asManagedEnvironment((FileSystem)li.cil.oc.api.FileSystem.fromClass(this.getClass(), (String)"WarpDrive".toLowerCase(), (String)("lua.OpenComputers/" + this.peripheralName)), (String)this.peripheralName);
            ((Component)this.OC_fileSystem.node()).setVisibility(Visibility.Network);
        }
    }

    @Optional.Method(modid="OpenComputers")
    public Node node() {
        return this.OC_node;
    }

    @Optional.Method(modid="OpenComputers")
    public void onConnect(Node node) {
        if (node.host() instanceof Context && this.OC_fileSystem != null) {
            node.connect(this.OC_fileSystem.node());
        }
    }

    @Optional.Method(modid="OpenComputers")
    public void onDisconnect(Node node) {
        if (this.OC_fileSystem != null) {
            if (node.host() instanceof Context) {
                node.disconnect(this.OC_fileSystem.node());
            } else if (node == this.OC_node) {
                this.OC_fileSystem.node().remove();
            }
        }
    }

    @Optional.Method(modid="OpenComputers")
    public void onMessage(Message message) {
    }
}

