/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.atomic;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.atomic.BlockAbstractAccelerator;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.network.PacketHandler;
import java.util.Random;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockChiller
extends BlockAbstractAccelerator {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;
    private static final float BOUNDING_TOLERANCE = 0.05f;

    public BlockChiller(byte tier) {
        super(tier);
        this.func_149663_c("warpdrive.atomic.chiller" + tier);
        this.func_149658_d("warpdrive:atomic/chiller" + tier);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.icons = new IIcon[2];
        this.icons[0] = iconRegister.func_94245_a(this.func_149641_N() + "-off");
        this.icons[1] = iconRegister.func_94245_a(this.func_149641_N() + "-on");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return this.icons[metadata % 2];
    }

    public int func_149692_a(int metadata) {
        return 0;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return AxisAlignedBB.func_72330_a((double)((float)x + 0.05f), (double)((float)y + 0.05f), (double)((float)z + 0.05f), (double)((float)(x + 1) - 0.05f), (double)((float)(y + 1) - 0.05f), (double)((float)(z + 1) - 0.05f));
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        super.func_149670_a(world, x, y, z, entity);
        if (world.field_72995_K) {
            return;
        }
        this.onEntityEffect(world, x, y, z, entity);
    }

    public void func_149724_b(World world, int x, int y, int z, Entity entity) {
        super.func_149724_b(world, x, y, z, entity);
        if (world.field_72995_K) {
            return;
        }
        this.onEntityEffect(world, x, y, z, entity);
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer entityPlayer) {
        super.func_149699_a(world, x, y, z, entityPlayer);
        if (world.field_72995_K) {
            return;
        }
        this.onEntityEffect(world, x, y, z, (Entity)entityPlayer);
    }

    private void onEntityEffect(World world, int x, int y, int z, Entity entity) {
        if (entity.field_70128_L || !(entity instanceof EntityLivingBase)) {
            return;
        }
        if (world.func_72805_g(x, y, z) == 0) {
            return;
        }
        if (!entity.func_70045_F()) {
            entity.func_70015_d(1);
        }
        entity.func_70097_a((DamageSource)WarpDrive.damageWarm, (float)(1 + this.tier));
        Vector3 v3Entity = new Vector3(entity);
        Vector3 v3Chiller = new Vector3((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        Vector3 v3Direction = new Vector3(entity).subtract(v3Chiller).normalize();
        v3Chiller.translateFactor(v3Direction, 0.6);
        v3Entity.translateFactor(v3Direction, -0.6);
        v3Direction.scale(0.2);
        PacketHandler.sendSpawnParticlePacket(world, "snowshovel", (byte)5, v3Entity, v3Direction, 0.9f + 0.1f * world.field_73012_v.nextFloat(), 0.35f + 0.25f * world.field_73012_v.nextFloat(), 0.3f + 0.15f * world.field_73012_v.nextFloat(), 0.0f, 0.0f, 0.0f, 32);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata == 0) {
            return;
        }
        int countNearby = 17 - (world.func_147439_a(x - 1, y, z) == this ? 1 : 0) - (world.func_147439_a(x + 1, y, z) == this ? 1 : 0) - (world.func_147439_a(x, y, z - 1) == this ? 1 : 0) - (world.func_147439_a(x, y, z + 1) == this ? 1 : 0) - (world.func_147439_a(x - 2, y, z) == this ? 1 : 0) - (world.func_147439_a(x + 2, y, z) == this ? 1 : 0) - (world.func_147439_a(x, y, z - 2) == this ? 1 : 0) - (world.func_147439_a(x, y, z + 2) == this ? 1 : 0) - (world.func_147439_a(x - 1, y + 2, z) == this ? 1 : 0) - (world.func_147439_a(x + 1, y + 2, z) == this ? 1 : 0) - (world.func_147439_a(x, y + 2, z - 1) == this ? 1 : 0) - (world.func_147439_a(x, y + 2, z + 1) == this ? 1 : 0) - (world.func_147439_a(x - 1, y - 2, z) == this ? 1 : 0) - (world.func_147439_a(x + 1, y - 2, z) == this ? 1 : 0) - (world.func_147439_a(x, y - 2, z - 1) == this ? 1 : 0) - (world.func_147439_a(x, y - 2, z + 1) == this ? 1 : 0);
        if (world.field_73012_v.nextInt(17) < countNearby) {
            world.func_72980_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "warpdrive:chiller", metadata == 1 ? 1.0f : 0.15f, 1.0f, true);
        }
        if (world.field_73012_v.nextInt(8) != 1) {
            double dOffset = 0.0625;
            for (int l = 0; l < 6; ++l) {
                double dX = (float)x + random.nextFloat();
                double dY = (float)y + random.nextFloat();
                double dZ = (float)z + random.nextFloat();
                boolean isValidSide = false;
                if (l == 0 && !world.func_147439_a(x, y + 1, z).func_149662_c()) {
                    dY = (double)(y + 1) + 0.0625;
                    isValidSide = true;
                }
                if (l == 1 && !world.func_147439_a(x, y - 1, z).func_149662_c()) {
                    dY = (double)y - 0.0625;
                    isValidSide = true;
                }
                if (l == 2 && !world.func_147439_a(x, y, z + 1).func_149662_c()) {
                    dZ = (double)(z + 1) + 0.0625;
                    isValidSide = true;
                }
                if (l == 3 && !world.func_147439_a(x, y, z - 1).func_149662_c()) {
                    dZ = (double)z - 0.0625;
                    isValidSide = true;
                }
                if (l == 4 && !world.func_147439_a(x + 1, y, z).func_149662_c()) {
                    dX = (double)(x + 1) + 0.0625;
                    isValidSide = true;
                }
                if (l == 5 && !world.func_147439_a(x - 1, y, z).func_149662_c()) {
                    dX = (double)x - 0.0625;
                    isValidSide = true;
                }
                if (!isValidSide) continue;
                world.func_72869_a("reddust", dX, dY, dZ, 0.0, 0.0, 0.0);
            }
        }
    }
}

