/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.atomic;

import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IControlChannel;
import cr0s.warpdrive.block.TileEntityAbstractInterfaced;
import cr0s.warpdrive.config.WarpDriveConfig;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.StatCollector;

public class TileEntityAcceleratorControlPoint
extends TileEntityAbstractInterfaced
implements IControlChannel {
    private boolean isEnabled = true;
    private int controlChannel = -1;
    private static final int UPDATE_INTERVAL_TICKS = 20;
    private int updateTicks;

    public TileEntityAcceleratorControlPoint() {
        this.peripheralName = "warpdriveAcceleratorControlPoint";
        this.addMethods(new String[]{"enable", "state", "controlChannel"});
    }

    @Override
    protected void onFirstUpdateTick() {
        super.onFirstUpdateTick();
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        --this.updateTicks;
        if (this.updateTicks <= 0) {
            this.updateTicks = 20;
            this.updateMetadata(this.controlChannel == -1 || !this.isEnabled ? 0 : 1);
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
    }

    @Override
    public int getControlChannel() {
        return this.controlChannel;
    }

    @Override
    public void setControlChannel(int controlChannel) {
        if (this.controlChannel != controlChannel) {
            this.controlChannel = controlChannel;
            if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                WarpDrive.logger.info(this + " Accelerator control point controlChannel channel set to " + controlChannel);
            }
            this.func_70296_d();
        }
    }

    private String getControlChannelStatus() {
        if (this.controlChannel == -1) {
            return StatCollector.func_74837_a((String)"warpdrive.control_channel.status_line.undefined", (Object[])new Object[0]);
        }
        if (this.controlChannel < 0 || this.controlChannel > 0xFFFFFFF) {
            return StatCollector.func_74837_a((String)"warpdrive.control_channel.status_line.invalid", (Object[])new Object[]{this.controlChannel});
        }
        return StatCollector.func_74837_a((String)"warpdrive.control_channel.status_line.valid", (Object[])new Object[]{this.controlChannel});
    }

    @Override
    public String getStatus() {
        return super.getStatus() + this.getControlChannelStatus();
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.isEnabled = !tagCompound.func_74764_b("isEnabled") || tagCompound.func_74767_n("isEnabled");
        this.controlChannel = tagCompound.func_74762_e("controlChannel");
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74757_a("isEnabled", this.isEnabled);
        tagCompound.func_74768_a("controlChannel", this.controlChannel);
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tagCompound);
    }

    public void onDataPacket(NetworkManager networkManager, S35PacketUpdateTileEntity packet) {
        NBTTagCompound tagCompound = packet.func_148857_g();
        this.func_145839_a(tagCompound);
    }

    public boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        WarpDrive.starMap.onBlockUpdated(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), this.func_145832_p());
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] enable(Context context, Arguments arguments) {
        return this.enable(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] controlChannel(Context context, Arguments arguments) {
        if (arguments.count() == 1) {
            this.setControlChannel(arguments.checkInteger(0));
        }
        return new Integer[]{this.controlChannel};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] state(Context context, Arguments arguments) {
        return this.state();
    }

    public Object[] enable(Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            boolean enable;
            try {
                enable = Commons.toBool(arguments[0]);
            }
            catch (Exception exception) {
                if (WarpDriveConfig.LOGGING_LUA) {
                    WarpDrive.logger.error(this + " LUA error on enable(): Boolean expected for 1st argument " + arguments[0]);
                }
                return new Object[]{this.isEnabled};
            }
            this.setIsEnabled(enable);
        }
        return new Object[]{this.isEnabled};
    }

    private Object[] state() {
        String status = this.getStatusHeaderInPureText();
        return new Object[]{status, this.isEnabled, this.controlChannel};
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        String methodName = this.getMethodName(method);
        try {
            switch (methodName) {
                case "enable": {
                    return this.enable(arguments);
                }
                case "controlChannel": {
                    if (arguments.length == 1 && arguments[0] != null) {
                        this.setControlChannel(Commons.toInt(arguments[0]));
                    }
                    return new Integer[]{this.controlChannel};
                }
                case "state": {
                    return this.state();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new String[]{exception.getMessage()};
        }
        return super.callMethod(computer, context, method, arguments);
    }
}

