/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.breathing;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.api.IAirContainerItem;
import cr0s.warpdrive.block.BlockAbstractContainer;
import cr0s.warpdrive.block.breathing.TileEntityAirGenerator;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockAirGenerator
extends BlockAbstractContainer {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconBuffer;
    private static final int ICON_INACTIVE_SIDE = 0;
    private static final int ICON_BOTTOM = 1;
    private static final int ICON_SIDE_ACTIVATED = 2;

    public BlockAirGenerator() {
        super(Material.field_151573_f);
        this.func_149663_c("warpdrive.breathing.air_generator");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.iconBuffer = new IIcon[3];
        this.iconBuffer[0] = iconRegister.func_94245_a("warpdrive:breathing/air_generator-side_inactive");
        this.iconBuffer[1] = iconRegister.func_94245_a("warpdrive:breathing/air_generator-connection");
        this.iconBuffer[2] = iconRegister.func_94245_a("warpdrive:breathing/air_generator-side_active");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        int metadata = blockAccess.func_72805_g(x, y, z);
        if (metadata == 0) {
            return this.iconBuffer[0];
        }
        if (metadata == 1) {
            return this.iconBuffer[2];
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return this.iconBuffer[2];
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityAirGenerator();
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return false;
        }
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityAirGenerator) {
            IAirContainerItem airCanister;
            TileEntityAirGenerator airGenerator = (TileEntityAirGenerator)tileEntity;
            ItemStack itemStackHeld = entityPlayer.func_70694_bm();
            if (itemStackHeld == null) {
                Commons.addChatMessage((ICommandSender)entityPlayer, airGenerator.getStatus());
                return true;
            }
            Item itemHeld = itemStackHeld.func_77973_b();
            if (itemHeld instanceof IAirContainerItem && (airCanister = (IAirContainerItem)itemHeld).canContainAir(itemStackHeld) && airGenerator.energy_consume(WarpDriveConfig.BREATHING_ENERGY_PER_CANISTER, true)) {
                entityPlayer.field_71071_by.func_70298_a(entityPlayer.field_71071_by.field_70461_c, 1);
                ItemStack toAdd = airCanister.getFullAirContainer(itemStackHeld);
                if (toAdd != null) {
                    if (!entityPlayer.field_71071_by.func_70441_a(toAdd)) {
                        EntityItem entityItem = new EntityItem(entityPlayer.field_70170_p, entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v, toAdd);
                        entityPlayer.field_70170_p.func_72838_d((Entity)entityItem);
                    }
                    ((EntityPlayerMP)entityPlayer).func_71120_a(entityPlayer.field_71069_bz);
                    airGenerator.energy_consume(WarpDriveConfig.BREATHING_ENERGY_PER_CANISTER, false);
                }
            }
        }
        return false;
    }
}

