/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.detection;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.BlockAbstractContainer;
import cr0s.warpdrive.block.detection.TileEntityMonitor;
import cr0s.warpdrive.data.CameraRegistryItem;
import cr0s.warpdrive.render.ClientCameraHandler;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMonitor
extends BlockAbstractContainer {
    @SideOnly(value=Side.CLIENT)
    private IIcon iconFront;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconSide;

    public BlockMonitor() {
        super(Material.field_151573_f);
        this.isRotating = true;
        this.func_149663_c("warpdrive.detection.monitor");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.iconFront = iconRegister.func_94245_a("warpdrive:detection/monitor-front");
        this.iconSide = iconRegister.func_94245_a("warpdrive:detection/monitor-side");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        int metadata = blockAccess.func_72805_g(x, y, z);
        return side == metadata ? this.iconFront : this.iconSide;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return side == 3 ? this.iconFront : this.iconSide;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityMonitor();
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        if (!world.field_72995_K) {
            return false;
        }
        if (entityPlayer.func_70694_bm() == null && (tileEntity = world.func_147438_o(x, y, z)) instanceof TileEntityMonitor) {
            int videoChannel = ((TileEntityMonitor)tileEntity).getVideoChannel();
            if (videoChannel < 0 || videoChannel > 0xFFFFFFF) {
                Commons.addChatMessage((ICommandSender)entityPlayer, ((TileEntityMonitor)tileEntity).getStatus());
                return true;
            }
            CameraRegistryItem camera = WarpDrive.cameras.getCameraByVideoChannel(world, videoChannel);
            if (camera == null || entityPlayer.func_70093_af()) {
                Commons.addChatMessage((ICommandSender)entityPlayer, ((TileEntityMonitor)tileEntity).getStatus());
                return true;
            }
            Commons.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.monitor.viewing_camera", (Object[])new Object[]{videoChannel, camera.position.field_151329_a, camera.position.field_151327_b, camera.position.field_151328_c}));
            ClientCameraHandler.setupViewpoint(camera.type, entityPlayer, entityPlayer.field_70177_z, entityPlayer.field_70125_A, x, y, z, (Block)this, camera.position.field_151329_a, camera.position.field_151327_b, camera.position.field_151328_c, world.func_147439_a(camera.position.field_151329_a, camera.position.field_151327_b, camera.position.field_151328_c));
        }
        return false;
    }
}

