/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.detection;

import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.TileEntityAbstractEnergy;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CelestialObject;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.data.RadarEcho;
import cr0s.warpdrive.data.StarMapRegistry;
import cr0s.warpdrive.data.Vector3;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.ArrayList;
import java.util.Arrays;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityRadar
extends TileEntityAbstractEnergy {
    private ArrayList<RadarEcho> results;
    private int radius = 0;
    private int scanningRadius = 0;
    private int scanningDuration_ticks = 0;
    private int scanning_ticks = 0;

    public TileEntityRadar() {
        this.peripheralName = "warpdriveRadar";
        this.addMethods(new String[]{"radius", "getEnergyRequired", "start", "getScanDuration", "getResults", "getResultsCount", "getResult"});
        this.CC_scripts = Arrays.asList("scan", "ping");
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        try {
            if (this.func_145832_p() == 2) {
                ++this.scanning_ticks;
                if (this.scanning_ticks > this.scanningDuration_ticks) {
                    this.results = WarpDrive.starMap.getRadarEchos(this, this.scanningRadius);
                    if (WarpDriveConfig.LOGGING_RADAR) {
                        WarpDrive.logger.info(this + " Scan found " + this.results.size() + " results in " + this.scanningRadius + " radius...");
                    }
                    this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, 3);
                    this.scanning_ticks = 0;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
    }

    private int calculateEnergyRequired(int parRadius) {
        return (int)Math.round(Math.max((double)WarpDriveConfig.RADAR_SCAN_MIN_ENERGY_COST, WarpDriveConfig.RADAR_SCAN_ENERGY_COST_FACTORS[0] + WarpDriveConfig.RADAR_SCAN_ENERGY_COST_FACTORS[1] * (double)parRadius + WarpDriveConfig.RADAR_SCAN_ENERGY_COST_FACTORS[2] * (double)parRadius * (double)parRadius + WarpDriveConfig.RADAR_SCAN_ENERGY_COST_FACTORS[3] * (double)parRadius * (double)parRadius * (double)parRadius));
    }

    private int calculateScanDuration(int parRadius) {
        return (int)Math.round(20.0 * Math.max((double)WarpDriveConfig.RADAR_SCAN_MIN_DELAY_SECONDS, WarpDriveConfig.RADAR_SCAN_DELAY_FACTORS_SECONDS[0] + WarpDriveConfig.RADAR_SCAN_DELAY_FACTORS_SECONDS[1] * (double)parRadius + WarpDriveConfig.RADAR_SCAN_DELAY_FACTORS_SECONDS[2] * (double)parRadius * (double)parRadius + WarpDriveConfig.RADAR_SCAN_DELAY_FACTORS_SECONDS[3] * (double)parRadius * (double)parRadius * (double)parRadius));
    }

    @Override
    public Object[] position() {
        CelestialObject celestialObject = CelestialObjectManager.get(this.field_145850_b, this.field_145851_c, this.field_145849_e);
        if (celestialObject != null) {
            Vector3 vec3Position = StarMapRegistry.getUniversalCoordinates(celestialObject, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return new Object[]{this.field_145851_c, this.field_145848_d, this.field_145849_e, celestialObject.getDisplayName(), vec3Position.x, vec3Position.y, vec3Position.z};
        }
        String name = this.field_145850_b.field_73011_w.func_80007_l();
        if (name == null || name.isEmpty()) {
            name = "DIM" + this.field_145850_b.field_73011_w.field_76574_g;
        }
        return new Object[]{this.field_145851_c, this.field_145848_d, this.field_145849_e, name, this.field_145851_c, this.field_145848_d, this.field_145849_e};
    }

    private Object[] radius(Object[] arguments) {
        if (arguments.length == 1 && this.func_145832_p() != 2) {
            int newRadius;
            try {
                newRadius = Commons.toInt(arguments[0]);
            }
            catch (Exception exception) {
                return new Integer[]{this.radius};
            }
            this.radius = Commons.clamp(0, 10000, newRadius);
        }
        return new Integer[]{this.radius};
    }

    private Object[] getEnergyRequired(Object[] arguments) {
        try {
            if (arguments.length == 1 && arguments[0] != null) {
                return new Object[]{this.calculateEnergyRequired(Commons.toInt(arguments[0]))};
            }
        }
        catch (Exception exception) {
            return new Integer[]{-1};
        }
        return new Integer[]{-1};
    }

    private Object[] getScanDuration(Object[] arguments) {
        try {
            if (arguments.length == 1 && arguments[0] != null) {
                return new Object[]{0.05 * (double)this.calculateScanDuration(Commons.toInt(arguments[0]))};
            }
        }
        catch (Exception exception) {
            return new Integer[]{-1};
        }
        return new Integer[]{-1};
    }

    private Object[] start() {
        this.results = null;
        if (this.radius <= 0 || this.radius > 10000) {
            this.radius = 0;
            return new Object[]{false, "Invalid radius"};
        }
        int energyRequired = this.calculateEnergyRequired(this.radius);
        if (!this.energy_consume(energyRequired, false)) {
            return new Object[]{false, "Insufficient energy"};
        }
        this.scanningRadius = this.radius;
        this.scanningDuration_ticks = this.calculateScanDuration(this.radius);
        this.scanning_ticks = 0;
        if (this.func_145832_p() != 2) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 2, 3);
        }
        if (WarpDriveConfig.LOGGING_RADAR) {
            WarpDrive.logger.info(this + "Starting scan over radius " + this.scanningRadius + " for " + energyRequired + " EU, results expected in " + this.scanningDuration_ticks + " ticks");
        }
        return new Object[]{true};
    }

    private Object[] getResults() {
        if (this.results == null) {
            return null;
        }
        Object[] objectResults = new Object[this.results.size()];
        int index = 0;
        for (RadarEcho radarEcho : this.results) {
            objectResults[index++] = new Object[]{radarEcho.type, radarEcho.name == null ? "" : radarEcho.name, radarEcho.x, radarEcho.y, radarEcho.z, radarEcho.mass};
        }
        return objectResults;
    }

    private Object[] getResultsCount() {
        if (this.results != null) {
            return new Integer[]{this.results.size()};
        }
        return new Integer[]{-1};
    }

    private Object[] getResult(Object[] arguments) {
        if (arguments.length == 1 && this.results != null) {
            RadarEcho radarEcho;
            int index;
            try {
                index = Commons.toInt(arguments[0]);
            }
            catch (Exception exception) {
                return new Object[]{false, "!ERROR!", null, 0, 0, 0};
            }
            if (index >= 0 && index < this.results.size() && (radarEcho = this.results.get(index)) != null) {
                return new Object[]{true, radarEcho.type, radarEcho.name == null ? "" : radarEcho.name, radarEcho.x, radarEcho.y, radarEcho.z, radarEcho.mass};
            }
        }
        return new Object[]{false, "!ERROR!", null, 0, 0, 0};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] radius(Context context, Arguments arguments) {
        return this.radius(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getEnergyRequired(Context context, Arguments arguments) {
        return this.getEnergyRequired(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getScanDuration(Context context, Arguments arguments) {
        return this.getScanDuration(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] start(Context context, Arguments arguments) {
        return this.start();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getResults(Context context, Arguments arguments) {
        return this.getResults();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getResultsCount(Context context, Arguments arguments) {
        return this.getResultsCount();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getResult(Context context, Arguments arguments) {
        return this.getResult(this.argumentsOCtoCC(arguments));
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
        super.attach(computer);
        if (this.func_145832_p() == 0) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, 3);
        }
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
        super.detach(computer);
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        String methodName;
        switch (methodName = this.getMethodName(method)) {
            case "radius": {
                return this.radius(arguments);
            }
            case "getEnergyRequired": {
                return this.getEnergyRequired(arguments);
            }
            case "getScanDuration": {
                return this.getScanDuration(arguments);
            }
            case "start": {
                return this.start();
            }
            case "getResults": {
                return this.getResults();
            }
            case "getResultsCount": {
                return this.getResultsCount();
            }
            case "getResult": {
                return this.getResult(arguments);
            }
        }
        return super.callMethod(computer, context, method, arguments);
    }

    @Override
    public int energy_getMaxStorage() {
        return WarpDriveConfig.RADAR_MAX_ENERGY_STORED;
    }

    @Override
    public boolean energy_canInput(ForgeDirection from) {
        return true;
    }
}

