/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.energy;

import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.computer.IEnanReactorLaser;
import cr0s.warpdrive.block.TileEntityAbstractLaser;
import cr0s.warpdrive.block.energy.TileEntityEnanReactorCore;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnumReactorFace;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.network.PacketHandler;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityEnanReactorLaser
extends TileEntityAbstractLaser
implements IEnanReactorLaser {
    private EnumReactorFace reactorFace = EnumReactorFace.UNKNOWN;
    private int energyStabilizationRequest = 0;
    private Vector3 vLaser;
    private Vector3 vReactorCore;
    private WeakReference<TileEntityEnanReactorCore> weakReactorCore;

    public TileEntityEnanReactorLaser() {
        this.addMethods(new String[]{"hasReactor", "side", "stabilize"});
        this.peripheralName = "warpdriveEnanReactorLaser";
        this.laserMedium_maxCount = 1;
        this.laserMedium_directionsValid = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN};
        this.updateInterval_ticks = WarpDriveConfig.ENAN_REACTOR_UPDATE_INTERVAL_TICKS;
    }

    @Override
    protected void onFirstUpdateTick() {
        super.onFirstUpdateTick();
        TileEntityEnanReactorCore reactorCore = this.getReactorCore();
        if (reactorCore == null) {
            for (EnumReactorFace reactorFace : EnumReactorFace.values()) {
                TileEntity tileEntity;
                if (reactorFace.indexStability < 0 || !((tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c - reactorFace.x, this.field_145848_d - reactorFace.y, this.field_145849_e - reactorFace.z)) instanceof TileEntityEnanReactorCore)) continue;
                ((TileEntityEnanReactorCore)tileEntity).onBlockUpdateDetected();
            }
        }
        this.vLaser = new Vector3(this).translate(0.5);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.energyStabilizationRequest > 0) {
            this.doStabilize(this.energyStabilizationRequest);
            this.energyStabilizationRequest = 0;
        }
    }

    @Nonnull
    public EnumReactorFace getReactorFace() {
        return this.reactorFace != null ? this.reactorFace : EnumReactorFace.UNKNOWN;
    }

    public void setReactorFace(@Nonnull EnumReactorFace reactorFace, TileEntityEnanReactorCore reactorCore) {
        this.reactorFace = reactorFace;
        this.weakReactorCore = reactorCore != null && reactorFace != EnumReactorFace.UNKNOWN ? new WeakReference<TileEntityEnanReactorCore>(reactorCore) : null;
        this.updateMetadata();
        if (reactorCore != null) {
            this.vReactorCore = new Vector3(reactorCore).translate(0.5);
        }
    }

    private TileEntityEnanReactorCore getReactorCore() {
        TileEntity tileEntity;
        TileEntityEnanReactorCore reactorCore;
        if (this.reactorFace == EnumReactorFace.UNKNOWN) {
            return null;
        }
        TileEntityEnanReactorCore tileEntityEnanReactorCore = reactorCore = this.weakReactorCore != null ? (TileEntityEnanReactorCore)this.weakReactorCore.get() : null;
        if (reactorCore == null && (tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c - this.reactorFace.facing.func_82601_c(), this.field_145848_d - this.reactorFace.facing.func_96559_d(), this.field_145849_e - this.reactorFace.facing.func_82599_e())) instanceof TileEntityEnanReactorCore) {
            reactorCore = (TileEntityEnanReactorCore)tileEntity;
            this.weakReactorCore = new WeakReference<TileEntityEnanReactorCore>(reactorCore);
        }
        return reactorCore;
    }

    private void updateMetadata() {
        int metadata = 0;
        if (this.reactorFace != null && this.reactorFace.propertyLaser != null) {
            metadata = 8 + this.reactorFace.propertyLaser.ordinal();
        }
        if (this.func_145832_p() != metadata) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, metadata, 3);
        }
    }

    @Override
    public void onBlockUpdateDetected() {
        super.onBlockUpdateDetected();
        TileEntityEnanReactorCore reactorCore = this.getReactorCore();
        if (reactorCore != null) {
            reactorCore.onBlockUpdateDetected();
        }
    }

    boolean stabilize(int energy) {
        if (energy <= 0) {
            return false;
        }
        if (this.laserMedium_direction == ForgeDirection.UNKNOWN) {
            return false;
        }
        this.energyStabilizationRequest = energy;
        return true;
    }

    private void doStabilize(int energy) {
        if (energy <= 0) {
            return;
        }
        if (this.laserMedium_direction == ForgeDirection.UNKNOWN) {
            return;
        }
        TileEntityEnanReactorCore reactorCore = this.getReactorCore();
        if (reactorCore == null) {
            return;
        }
        if (this.laserMedium_consumeExactly(energy, false)) {
            if (WarpDriveConfig.LOGGING_ENERGY && WarpDriveConfig.LOGGING_LUA) {
                WarpDrive.logger.info("ReactorLaser on " + this.reactorFace + " side sending " + energy);
            }
            reactorCore.decreaseInstability(this.reactorFace, energy);
            PacketHandler.sendBeamPacket(this.field_145850_b, this.vLaser, this.vReactorCore, 0.1f, 0.2f, 1.0f, 25, 50, 100);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("reactorFace", this.reactorFace.ordinal());
        tagCompound.func_74768_a("energyStabilizationRequest", this.energyStabilizationRequest);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.reactorFace = EnumReactorFace.get(tagCompound.func_74762_e("reactorFace"));
        this.energyStabilizationRequest = tagCompound.func_74762_e("energyStabilizationRequest");
    }

    @Override
    public Object[] hasReactor() {
        return new Object[]{this.reactorFace != EnumReactorFace.UNKNOWN};
    }

    @Override
    public Object[] stabilize(Object[] arguments) {
        int energy;
        if (arguments.length != 1) {
            return new Object[]{false, "Invalid number of arguments"};
        }
        try {
            energy = Commons.toInt(arguments[0]);
        }
        catch (Exception exception) {
            if (WarpDriveConfig.LOGGING_LUA) {
                WarpDrive.logger.error(this + " LUA error on stabilize(): Integer expected for 1st argument " + arguments[0]);
            }
            return new Object[]{false, "Invalid integer"};
        }
        return new Object[]{this.stabilize(energy)};
    }

    @Override
    public Object[] side() {
        return new Object[]{this.reactorFace.indexStability, this.reactorFace.tier.getName(), this.reactorFace.getName()};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] hasReactor(Context context, Arguments arguments) {
        return this.hasReactor();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] stabilize(Context context, Arguments arguments) {
        return this.stabilize(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] side(Context context, Arguments arguments) {
        return this.side();
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        String methodName;
        switch (methodName = this.getMethodName(method)) {
            case "hasReactor": {
                return this.hasReactor();
            }
            case "stabilize": {
                return this.stabilize(arguments);
            }
            case "side": {
                return this.side();
            }
        }
        return super.callMethod(computer, context, method, arguments);
    }
}

