/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.energy;

import cr0s.warpdrive.block.TileEntityAbstractEnergy;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnumComponentType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityEnergyBank
extends TileEntityAbstractEnergy {
    static final byte MODE_DISABLED = 0;
    static final byte MODE_INPUT = 1;
    static final byte MODE_OUTPUT = 2;
    private static final byte[] MODE_DEFAULT_SIDES = new byte[]{1, 1, 2, 2, 2, 2};
    private byte tier = (byte)-1;
    private byte[] modeSide = (byte[])MODE_DEFAULT_SIDES.clone();

    public TileEntityEnergyBank() {
        this(1);
    }

    public TileEntityEnergyBank(byte tier) {
        this.tier = tier;
        this.peripheralName = "warpdriveEnergyBank";
        this.setUpgradeMaxCount(EnumComponentType.SUPERCONDUCTOR, WarpDriveConfig.ENERGY_BANK_EFFICIENCY_PER_UPGRADE.length - 1);
    }

    @Override
    protected void onFirstUpdateTick() {
        if (this.tier == 0) {
            this.IC2_sinkTier = Integer.MAX_VALUE;
            this.IC2_sourceTier = 20;
        } else {
            this.IC2_sinkTier = WarpDriveConfig.ENERGY_BANK_IC2_TIER[this.tier - 1];
            this.IC2_sourceTier = WarpDriveConfig.ENERGY_BANK_IC2_TIER[this.tier - 1];
        }
        super.onFirstUpdateTick();
    }

    private double getEfficiency() {
        int upgradeCount = this.getValidUpgradeCount(EnumComponentType.SUPERCONDUCTOR);
        return WarpDriveConfig.ENERGY_BANK_EFFICIENCY_PER_UPGRADE[upgradeCount];
    }

    @Override
    public int energy_getEnergyStored() {
        if (this.tier == 0) {
            return WarpDriveConfig.ENERGY_BANK_MAX_ENERGY_STORED[2] / 2;
        }
        return super.energy_getEnergyStored();
    }

    @Override
    public int energy_getPotentialOutput() {
        if (this.tier == 0) {
            return 0x3FFFFFFF;
        }
        return (int)Math.round(Math.min((double)this.energy_getEnergyStored() * this.getEfficiency(), (double)WarpDriveConfig.ENERGY_BANK_TRANSFER_PER_TICK[this.tier - 1]));
    }

    @Override
    public int energy_getMaxStorage() {
        if (this.tier == 0) {
            return WarpDriveConfig.ENERGY_BANK_MAX_ENERGY_STORED[2];
        }
        return WarpDriveConfig.ENERGY_BANK_MAX_ENERGY_STORED[this.tier - 1];
    }

    @Override
    public boolean energy_consume(long amount_internal, boolean simulate) {
        if (this.tier == 0) {
            return true;
        }
        int amountWithLoss = (int)Math.round((double)amount_internal / this.getEfficiency());
        if (this.energy_getEnergyStored() >= amountWithLoss) {
            if (!simulate) {
                super.energy_consume(amountWithLoss);
            }
            return true;
        }
        return false;
    }

    @Override
    public void energy_consume(long amount_internal) {
        if (this.tier == 0) {
            return;
        }
        int amountWithLoss = (int)Math.round(amount_internal > 0L ? (double)amount_internal / this.getEfficiency() : (double)amount_internal * this.getEfficiency());
        super.energy_consume(amountWithLoss);
    }

    @Override
    public boolean energy_canInput(ForgeDirection from) {
        return this.modeSide[from.ordinal()] == 1;
    }

    @Override
    public boolean energy_canOutput(ForgeDirection to) {
        return this.modeSide[to.ordinal()] == 2;
    }

    byte getTier() {
        return this.tier;
    }

    byte getMode(EnumFacing facing) {
        return this.modeSide[facing.ordinal()];
    }

    void setMode(EnumFacing facing, byte mode) {
        this.modeSide[facing.ordinal()] = (byte)(mode % 3);
        this.func_70296_d();
        this.energy_resetConnections(facing);
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74774_a("tier", this.tier);
        tagCompound.func_74773_a("modeSide", this.modeSide);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.tier = tagCompound.func_74771_c("tier");
        this.modeSide = tagCompound.func_74770_j("modeSide");
        if (this.modeSide == null || this.modeSide.length != 6) {
            this.modeSide = (byte[])MODE_DEFAULT_SIDES.clone();
        }
    }

    @Override
    public NBTTagCompound writeItemDropNBT(NBTTagCompound tagCompound) {
        tagCompound = super.writeItemDropNBT(tagCompound);
        return tagCompound;
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tagCompound);
    }

    public void onDataPacket(NetworkManager networkManager, S35PacketUpdateTileEntity packet) {
        NBTTagCompound tagCompound = packet.func_148857_g();
        this.func_145839_a(tagCompound);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public String toString() {
        return String.format("%s @ %s (%d %d %d) %8d", this.getClass().getSimpleName(), this.field_145850_b == null ? "~NULL~" : this.field_145850_b.field_73011_w.func_80007_l(), this.field_145851_c, this.field_145848_d, this.field_145849_e, this.energy_getEnergyStored());
    }
}

